/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IModifyTimeProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.cache.PromptUtils;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.db.archive.UnmodifiableArchiveDataException;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ca.ISignOperateService;
import kd.bos.entity.dynplugin.EntityDynamicProxyPluginFactory;
import kd.bos.entity.dynplugin.KingScriptEntityDynamicProxyPlugin;
import kd.bos.entity.dynplugin.KingScriptEntityDynamicProxyPluginFactory;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.operate.IEntityOperateService;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.IOperationTask;
import kd.bos.entity.operate.KDOpAsynExecutorException;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.operate.OperateProgress;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.bizrule.OpBizRuleTypeLoader;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDAfterExecuteOperationException;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.IOperationServicePlugIn;
import kd.bos.entity.plugin.OperationServicePlugInProxy;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeforeSaveAuditLogArg;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.plugin.args.ValidatePrefixArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.PermissionValidateContext;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.facade.FacadeResult;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.EntityModifyInfo;
import kd.bos.log.api.IBizModifyDirtyManager;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.mservice.svc.attach.IAttachmentFieldModelProxy;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.service.attachment.IAttachmentOperateService;
import kd.bos.service.image.IImageOperateService;
import kd.bos.service.operation.Audit;
import kd.bos.service.operation.MsOperationFacade;
import kd.bos.service.operation.OpBizRuleServicePluginProxy;
import kd.bos.service.operation.OperateProgressImpl;
import kd.bos.service.operation.OperateProgressProxy;
import kd.bos.service.operation.Save;
import kd.bos.service.operation.Submit;
import kd.bos.service.operation.validate.BillExistsValidator;
import kd.bos.service.operation.validate.DataMutexResult;
import kd.bos.service.operation.validate.FunctionPermValidator;
import kd.bos.service.operation.validate.MutexValidator;
import kd.bos.service.operation.validate.SpecialDataPermValidator;
import kd.bos.service.operation.validate.ValidationService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.utils.DbTypeConverter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class EntityOperateService
implements IEntityOperateService {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-operation";
    private static final String EXCUTE_IDS = "excute(ids)";
    private static final String SPAN_TYPE_NAME = "opservice";
    private static final String SPAN_TYPE_MSTASK = "optask";
    private static final String VALIDATE = "validate()";
    private static final String VALID_ATIONS = "validations";
    private static Log log = LogFactory.getLog(EntityOperateService.class);
    protected MsOperationFacade facade = null;
    private static final String BILL_PARAM_OP_EXECUTE_LOG = "opexecutelog";
    protected String operationKey;
    private DynamicObject[] dataEntities;
    private boolean invokeByIds = false;
    private ExtendedDataEntitySet extendDataEntitySet;
    private List<DynamicObject> _successDataEntities = null;
    private OperationResult operationResult;
    protected int _entityListStartIndex = 0;
    protected MainEntityType billEntityType;
    private OperationServicePlugInProxy plugInProxy;
    protected MainEntityType subEntityType;
    protected Map<String, Object> operateMetaMap;
    private List<IOperationTask> operationTasks;
    protected OpBizRuleServicePluginProxy opBizRuleService;
    protected OperateProgress operateProgress;
    private OperateLog operateLog;
    private OperateProgressProxy progressProxy;
    private long startTime = TimeServiceHelper.now().getTime();
    private OperationContext operationContext;
    private InitOperationArgs initOperationArgs;
    private OperateOption option;
    private FunctionManage funcLib;
    private ValidationService validationService;
    private static ISignOperateService signOperateService;
    private Boolean strictValidation;
    private IBizModifyDirtyManager bizModifyDirtyManager = null;
    private Boolean writeDetailLog = null;

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public String getOpName() {
        String operationName = this.operationKey;
        if (this.operateMetaMap == null || !this.operateMetaMap.containsKey("name")) {
            return operationName;
        }
        Map opName = (Map)this.operateMetaMap.get("name");
        if (opName.containsKey(Lang.get().toString())) {
            operationName = (String)opName.get(Lang.get().toString());
        } else {
            Object zh_cn = opName.get("zh_CN");
            if (zh_cn != null) {
                operationName = (String)zh_cn;
            }
        }
        return operationName;
    }

    private String getLogOpName() {
        String operationName = this.operationKey;
        if (this.operateMetaMap == null || !this.operateMetaMap.containsKey("name")) {
            return operationName;
        }
        Map opName = (Map)this.operateMetaMap.get("name");
        if (opName == null) {
            return operationName;
        }
        Object zh_cn = opName.get("zh_CN");
        if (StringUtils.isNotBlank(zh_cn)) {
            operationName = String.valueOf(zh_cn);
        }
        return operationName;
    }

    public OperateOption getOption() {
        return this.option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    public OperationServicePlugInProxy getPlugInProxy() {
        return this.plugInProxy;
    }

    public OperateLog getOperateLog() {
        if (this.operateLog == null) {
            DynamicObject billParamObj = ParameterReader.getBillParameter((String)this.billEntityType.getName());
            boolean opExecuteLog = false;
            if (billParamObj != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)BILL_PARAM_OP_EXECUTE_LOG)) {
                opExecuteLog = billParamObj.getBoolean(BILL_PARAM_OP_EXECUTE_LOG);
            }
            if (this.getIgnoreOperateLogFormIds().contains(this.billEntityType.getName())) {
                opExecuteLog = false;
            }
            this.operateLog = OperateLog.get((boolean)opExecuteLog);
        }
        return this.operateLog;
    }

    private Set<String> getIgnoreOperateLogFormIds() {
        HashSet<String> set = new HashSet<String>();
        set.add("bos_user");
        return set;
    }

    protected void setDataEntities(DynamicObject[] dataEntities) {
        this.dataEntities = dataEntities;
        this.extendDataEntitySet = new ExtendedDataEntitySet();
        if (this.dataEntities != null && this.dataEntities.length > 0) {
            this.extendDataEntitySet.Parse(dataEntities, (MainEntityType)dataEntities[0].getDataEntityType());
        }
    }

    protected List<DynamicObject> getSuccessDataEntities() {
        return this._successDataEntities;
    }

    protected void setSuccessDataEntities(List<DynamicObject> dataEntities) {
        this._successDataEntities = dataEntities;
    }

    public ExtendedDataEntitySet getExtendDataEntitySet() {
        return this.extendDataEntitySet;
    }

    public OperationResult getOperationResult() {
        return this.operationResult;
    }

    protected MainEntityType getBillEntityType() {
        return this.billEntityType;
    }

    protected Boolean getStrictValidation() {
        if (this.strictValidation == null) {
            this.strictValidation = Boolean.valueOf(this.getOption().getVariableValue("strictvalidation", String.valueOf(false)));
        }
        return this.strictValidation;
    }

    public void initialize(MainEntityType entityType, String operationKey, DynamicObject[] dataEntities) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"initialize");){
            this.billEntityType = entityType;
            this.operationKey = operationKey;
            this.facade = new MsOperationFacade();
            this.progressProxy = new OperateProgressProxy(entityType.getName(), operationKey, this.option);
            this.operateProgress = new OperateProgressImpl(this.progressProxy);
            String bills = "null";
            if (dataEntities != null) {
                bills = String.format("%s[%s bills]", dataEntities[0].getPkValue(), dataEntities.length);
            }
            this.getOperateLog().important(String.format("EntityOperateService.initialize(%s, %s, %s)", entityType.getName(), operationKey, bills));
            this.getOperateLog().beginMothed("initialize()", null);
            this.getOperateLog().info(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u64cd\u4f5c\u53d8\u91cf", (String)"EntityOperateService_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            this.setDataEntities(dataEntities);
            if (dataEntities == null) {
                this.invokeByIds = true;
            } else {
                this.invokeByIds = false;
                if (dataEntities.length > 0) {
                    this.getOperateLog().Info(dataEntities[0]);
                }
            }
            this.operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)entityType.getName(), (String)operationKey);
            if (span.isRealtime()) {
                span.addLocaleTag("operateMeta", this.operateMetaMap);
            }
            this.operationResult = this.createOperationResult();
            if (dataEntities != null) {
                this.operationResult.setBillCount(dataEntities.length);
            }
            this.operationContext = new OperationContext();
            this.operationContext.setOperationKey(operationKey);
            this.operationContext.setEntityTypeId(entityType.getName());
            this.operationContext.setDataEntities(dataEntities);
            this.operationContext.setOperateLog(this.getOperateLog());
            this._successDataEntities = new ArrayList<DynamicObject>();
            List<Map<String, Object>> plugins = this.getPlugins((List)this.operateMetaMap.get("plugins"));
            this.registerKingScriptDynamicPlugin(plugins);
            this.plugInProxy = new OperationServicePlugInProxy(plugins);
            this.plugInProxy.setContext(this.billEntityType, this.operateMetaMap, this.option);
            this.plugInProxy.setProgress(this.operateProgress);
            this.plugInProxy.setOperateLog(this.getOperateLog());
            if (this.getOperateLog().isWriteLog()) {
                this.getPlugInProxy().printPluginList();
            }
            this.opBizRuleService = new OpBizRuleServicePluginProxy(new ArrayList<Map<String, Object>>());
            this.opBizRuleService.setProgress(this.operateProgress);
            this.opBizRuleService.setOperateLog(this.getOperateLog());
            this.opBizRuleService.createOpBizRuleAction(this.billEntityType, this.operateMetaMap, this.option);
            this.getOperateLog().beginMothed("fireInitialize()", null);
            this.initOperationArgs = new InitOperationArgs();
            this.plugInProxy.fireInitialize(this.initOperationArgs);
            this.opBizRuleService.fireInitialize(this.initOperationArgs);
            this.getOperateLog().endMothed("fireInitialize()", null);
            this.operationTasks = this.getOperationTask();
            this.bizModifyDirtyManager = null;
            this.facade.afterInitialize(this, (IDataEntityType)this.billEntityType, this.operateMetaMap, this.getOption());
            this.getOperateLog().endMothed("initialize()", null);
        }
    }

    private List<Map<String, Object>> getPlugins(List<Map<String, Object>> plugins) {
        ArrayList<Map<String, Object>> pluginList = new ArrayList<Map<String, Object>>(10);
        if (plugins != null) {
            pluginList.addAll(plugins);
        }
        pluginList.add(EntityDynamicProxyPluginFactory.getProxyPlugin((String)"4"));
        return pluginList;
    }

    private void registerKingScriptDynamicPlugin(List<Map<String, Object>> plugins) {
        KingScriptEntityDynamicProxyPlugin proxyPlugin = KingScriptEntityDynamicProxyPluginFactory.create((KingScriptEntityDynamicProxyPluginFactory.PluginObject)KingScriptEntityDynamicProxyPluginFactory.PluginObject.createOperatePluginProxy(plugins, (String)this.operationContext.getEntityTypeId(), (String)this.operationContext.getOperationKey()));
        proxyPlugin.register();
    }

    private Map<String, Object> makeSaveOp(String entityId) {
        String opKey;
        List operates = EntityMetadataCache.getDataEntityOperate((String)entityId);
        ArrayList<String> saveOp = new ArrayList<String>();
        for (Map operate : operates) {
            Object opType = operate.get("type");
            if (!"save".equals(opType)) continue;
            saveOp.add((String)operate.get("key"));
        }
        if (saveOp.size() == 1 && StringUtils.isNotBlank((CharSequence)(opKey = (String)saveOp.get(0)))) {
            return EntityMetadataCache.getDataEntityOperate((String)entityId, (String)opKey);
        }
        return null;
    }

    protected OperationResult getSubOpResult(Map<String, Object> operateMetaMap, String entityNumber, Object[] ids) {
        return null;
    }

    protected OperationResult getSubOpResult(Map<String, Object> operateMetaMap, DynamicObject[] dataEntities) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperationResult excute(DynamicObject[] dataEntities) throws Exception {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"excute(dataEntities)", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            this.getOperateLog().beginMothed("execute(dataEntities)", null);
            boolean subOpNotNull = false;
            OperationResult subOpResult = null;
            this.dataEntities = dataEntities;
            RefObject result = new RefObject();
            boolean isExcuteByIds = this.getOption().tryGetVariableValue("isExcuteByIds", result);
            if (!isExcuteByIds) {
                subOpResult = this.getSubOpResult(this.operateMetaMap, dataEntities);
                boolean bl = subOpNotNull = subOpResult != null;
                if (subOpNotNull) {
                    List successPkIds = subOpResult.getSuccessPkIds();
                    if (CollectionUtils.isEmpty((Collection)successPkIds)) {
                        OperationResult operationResult = subOpResult;
                        return operationResult;
                    }
                    DynamicObject[] successDataEntities = new DynamicObject[successPkIds.size()];
                    int i = 0;
                    for (DynamicObject dataEntity : dataEntities) {
                        Object pkValue = dataEntity.getPkValue();
                        if (!successPkIds.contains(pkValue)) continue;
                        successDataEntities[i] = dataEntity;
                        ++i;
                    }
                    this.dataEntities = successDataEntities;
                    dataEntities = successDataEntities;
                }
            }
            this.setSplitPageFlag(dataEntities);
            this.progressProxy.setInit(false);
            try {
                if (this.getOption().containsVariable("routeKey")) {
                    this.doExecuteByRoute();
                } else {
                    this.doExcete();
                }
                this.writeLogWithoutError(this.operationResult);
            }
            catch (UnmodifiableArchiveDataException exp) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f52\u6863\u5e93\u4e0d\u5141\u8bb8\u64cd\u4f5c\u6570\u636e\uff0c\u8bf7\u5230\u8868\u5355\u5217\u8868\u5207\u6362\u67e5\u8be2\u5e93\u4e3a\u5f53\u671f\u3002", (String)"EntityOperateService_20", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            }
            catch (RuntimeException exp) {
                span.addLocaleTag("billEntityType", (Object)this.billEntityType);
                span.addLocaleTag("opKey", (Object)this.operationKey);
                span.addLocaleTag("opClass", (Object)this.getClass().getName());
                span.addLocaleTag("opMeta", this.operateMetaMap);
                span.addLocaleTag("option", (Object)this.option);
                span.addLocaleTag("dataEntities", (Object)this.dataEntities);
                span.error((Throwable)exp);
                throw exp;
            }
            finally {
                try (EntityTraceSpan span1 = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"release");){
                    this.release();
                }
                this.getOperateLog().beginMothed("fireReturnOperation()", null);
                ReturnOperationArgs args = new ReturnOperationArgs((IOperationResult)this.operationResult);
                this.plugInProxy.fireReturnOperation(args);
                this.opBizRuleService.fireReturnOperation(args);
                this.getOperateLog().endMothed("fireReturnOperation()", null);
                this.getOperateLog().endMothed("execute(dataEntities)", null);
                this.getOperateLog().finish(this.billEntityType.getName(), this.operationKey, this.getClass().getSimpleName(), this.getOperationResult());
                if (!this.getOperateLog().isWriteLog()) {
                    log.info(this.buildOpResultLog(dataEntities, this.operationResult));
                }
            }
            this.getOperateLog().info(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u675f\uff0c\u51c6\u5907\u8fd4\u56de", (String)"EntityOperateService_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            if (subOpNotNull) {
                this.operationResult.mergeSubOpResult(subOpResult);
            }
            OperationResult operationResult = this.operationResult;
            return operationResult;
        }
    }

    private void doExecuteByRoute() throws Exception {
        try (ArchiveRoute mr = ArchiveRoute.mapRoute((String)this.getOption().getVariableValue("routeKey", ""), (String)this.getOption().getVariableValue("ArchiveKey", ""));){
            this.doExcete();
        }
        catch (KDOpAsynExecutorException exp) {
            this.getOperateLog().info("EntityOperateService.excute: KDOpAsynExecutorException");
            this.getOperationResult().setSponsor(exp.getSponsor());
            this.getOperationResult().setInteractionContext(exp.getInteractionContext());
        }
    }

    protected void release() {
        this.releaseIntentLock();
        this.releaseDataMutex();
        this.facade.afterRelease();
    }

    private void releaseDataMutex() {
        this.getOperateLog().info(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6bd5\uff0c\u91ca\u653e\u7f51\u63a7", (String)"EntityOperateService_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
        this.getOperateLog().beginMothed("releaseDataMutex()", null);
        MutexValidator.batchRelease(this.billEntityType.getName(), this.operationKey, this.operationContext);
        this.getOperateLog().endMothed("releaseDataMutex()", null);
    }

    private Object[] requireDataMutex(Object[] ids) {
        Object dataMutexResult;
        Map<String, DataMutexResult> dataMutexResults = MutexValidator.batchRequire(this.billEntityType.getName(), this.operationKey, ids, this.operationContext, this.getOption());
        if (dataMutexResults == null || dataMutexResults.isEmpty()) {
            return ids;
        }
        ArrayList<Object> passIds = new ArrayList<Object>(ids.length);
        ArrayList<Object> failIds = new ArrayList<Object>(ids.length);
        int dbType = this.billEntityType.getPrimaryKey().getDbType();
        for (Object id : ids) {
            if (id == null) continue;
            String string = String.valueOf(id);
            dataMutexResult = dataMutexResults.get(string);
            if (dataMutexResult == null || ((DataMutexResult)dataMutexResult).isSuccess()) {
                passIds.add(id);
                continue;
            }
            failIds.add(DbTypeConverter.safeConvert((int)dbType, (Object)id));
        }
        if (!failIds.isEmpty()) {
            HashMap<Object, String> billNos = new HashMap<Object, String>(failIds.size());
            String billNoFldKey = "";
            String pkFldKey = "";
            if (this.billEntityType instanceof BillEntityType) {
                billNoFldKey = ((BillEntityType)this.billEntityType).getBillNo();
                pkFldKey = this.billEntityType.getPrimaryKey().getName();
            }
            if (StringUtils.isNotBlank((CharSequence)pkFldKey) && StringUtils.isNotBlank((CharSequence)billNoFldKey)) {
                QFilter[] filters = new QFilter[]{new QFilter(this.billEntityType.getPrimaryKey().getName(), "in", failIds)};
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)this.billEntityType.getName(), (String)(pkFldKey + "," + billNoFldKey), (QFilter[])filters);
                for (DynamicObject obj : dynamicObjectCollection) {
                    Object id = obj.get(pkFldKey);
                    String billNo = obj.getString(billNoFldKey);
                    billNos.put(id, billNo);
                }
            }
            for (Object e : failIds) {
                dataMutexResult = dataMutexResults.get(String.valueOf(e));
                if (dataMutexResult == null) continue;
                String billNo = (String)billNos.get(e);
                String msg = "";
                if (StringUtils.isNotBlank((CharSequence)billNo)) {
                    msg = msg + billNo + "\uff1a";
                }
                msg = msg + ((DataMutexResult)dataMutexResult).getMessage();
                this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", e, 0, 0, "datamutex", this.getOpName(), msg, ErrorLevel.FatalError));
            }
        }
        return passIds.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult excute(Object[] ids) throws Exception {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)EXCUTE_IDS, (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            this.setProgressTip(ResManager.loadKDString((String)"\u8bfb\u53d6\u5355\u636e", (String)"EntityOperateService_3", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            this.getOperateLog().beginMothed(EXCUTE_IDS, null);
            this.operationResult.setBillCount(ids.length);
            Object[] exeIds = this.requireDataMutex(ids);
            if (ids.length > 0 && exeIds.length == 0) {
                this.getOperateLog().endMothed(EXCUTE_IDS, "EntityOperateService.excute(ids): data mutex failed, return");
                OperationResult operationResult = this.operationResult;
                return operationResult;
            }
            try {
                ArrayList<String> fieldKeys = new ArrayList<String>();
                try (EntityTraceSpan span1 = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"preparePropertys");){
                    this.preparePropertys(fieldKeys);
                    this.preparePropertys(exeIds, fieldKeys);
                    this.getOperateLog().beginMothed("firePreparePropertys()", null);
                    PreparePropertysEventArgs args = new PreparePropertysEventArgs();
                    args.setFieldKeys(fieldKeys);
                    args.setIds(ids);
                    this.plugInProxy.firePreparePropertys(args);
                    this.opBizRuleService.firePreparePropertys(args);
                    this.getOperateLog().endMothed("firePreparePropertys()", null);
                }
                this.subEntityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)this.billEntityType.getName(), fieldKeys);
                DynamicObject[] objs = BusinessDataReader.load((Object[])exeIds, (DynamicObjectType)this.subEntityType, (Boolean)Boolean.TRUE);
                if (this.getOperateLog().isWriteLog()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("EntityOperateService.excute(ids[");
                    for (int i = 0; i < exeIds.length && i <= 5; ++i) {
                        if (i >= 5) {
                            sb.append("... total ").append(exeIds.length).append(" bills");
                            break;
                        }
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(String.valueOf(exeIds[i]));
                    }
                    sb.append("]): ");
                    sb.append("get ").append(objs == null ? "0" : String.valueOf(objs.length)).append(" bills, ");
                    sb.append("fields: ").append(String.join((CharSequence)",", new HashSet<String>(fieldKeys)));
                    this.getOperateLog().endMothed(EXCUTE_IDS, sb.toString());
                }
                if (objs == null || objs.length == 0) {
                    this.getOperateLog().endMothed(EXCUTE_IDS, "EntityOperateService.excute(ids): load bill failed, return");
                    throw new KDBizException(BosErrorCode.operationFailed, new Object[]{ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"EntityOperateService_19", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0])});
                }
                if (span.isRealtime()) {
                    span.addLocaleTag("dataEntities", (Object)objs);
                }
                this.setDataEntities(objs);
                this.operationContext.setDataEntities(this.dataEntities);
                this.getOption().setVariableValue("isExcuteByIds", "true");
                this.excute(this.dataEntities);
            }
            finally {
                this.release();
            }
            this.notExistRecords(exeIds, this.dataEntities);
            OperationResult operationResult = this.operationResult;
            return operationResult;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doExcete() throws Exception {
        try (EntityTraceSpan span1 = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"doExcete", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            FacadeResult beforeResult = this.facade.beforeDoExecute(this, this.operateMetaMap, this.getOption(), this.getOperateLog(), this.dataEntities, this.getBillEntityType(), this.subEntityType, this.invokeByIds, this.operationResult, this.operationKey);
            if (beforeResult != null && beforeResult.isSuccess()) {
                switch (beforeResult.getCode()) {
                    case 6: {
                        return;
                    }
                }
            }
            String log_MothedName = "doExcete()";
            this.getOperateLog().beginMothed(log_MothedName, "EntityOperateService.doExcete() begin.");
            if (this._successDataEntities != null) {
                this._successDataEntities.clear();
            }
            if (this.subEntityType == null) {
                this.subEntityType = this.billEntityType;
            }
            this.plugInProxy.setSubEntityType((EntityType)this.subEntityType);
            this.opBizRuleService.setSubEntityType((EntityType)this.subEntityType);
            this.getOperateLog().beginMothed("fireInitializeOperationResult()", null);
            this.plugInProxy.fireInitializeOperationResult(this.operationResult);
            this.opBizRuleService.fireInitializeOperationResult(this.operationResult);
            this.getOperateLog().endMothed("fireInitializeOperationResult()", null);
            this.getOperateLog().info(ResManager.loadKDString((String)"\u6267\u884c\u6821\u9a8c\u5668", (String)"EntityOperateService_5", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            ArrayList<ExtendedDataEntity> validExtendedDataRows = new ArrayList<ExtendedDataEntity>();
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"validate", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
                if (!this.validate(validExtendedDataRows)) {
                    this.getOperateLog().endMothed(log_MothedName, "EntityOperateService.doExcete(): validate = false, return");
                    return;
                }
                if (Boolean.parseBoolean(this.getOption().getVariableValue("onlyvalidate", "false"))) {
                    this.getOperateLog().endMothed(log_MothedName, "EntityOperateService.doExcete(): onlyvalidate = false, return");
                    return;
                }
            }
            this.getOperateLog().info(ResManager.loadKDString((String)"\u6821\u9a8c\u5b8c\u6bd5\uff0c\u5f00\u59cb\u5199\u5e93\u4e4b\u524d\u7684\u6570\u636e\u51c6\u5907", (String)"EntityOperateService_6", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            this.getOperateLog().beginMothed("fireBeforeExecuteOperationTransaction()", null);
            BeforeOperationArgs e = new BeforeOperationArgs(this.operationKey, validExtendedDataRows);
            this.fireBeforeExecuteOperationTransaction(e);
            this.getOperateLog().endMothed("fireBeforeExecuteOperationTransaction()", null);
            if (e.cancel) {
                this.operationResult.setSuccess(false);
                if (StringUtils.isNotBlank((CharSequence)e.getCancelMessage())) {
                    this.operationResult.setMessage(e.getCancelMessage());
                } else if (StringUtils.isBlank((CharSequence)this.operationResult.getMessage())) {
                    this.operationResult.setMessage(ResManager.loadKDString((String)"\u672a\u77e5\u63d2\u4ef6\u5728BeforeExecuteOperationTransaction\u4e8b\u4ef6\u4e2d\uff0c\u53d6\u6d88\u4e86\u64cd\u4f5c", (String)"EntityOperateService_7", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
                }
                this.getOperateLog().endMothed(log_MothedName, String.format("EntityOperateService.doExcete(): %s set cancel, return", StringUtils.isBlank((CharSequence)e.getCancelPlugName()) ? "plug" : e.getCancelPlugName()));
                return;
            }
            DynamicObject[] successObjs = this.getSuccessObjs(e.getValidExtDataEntities());
            FacadeResult result = this.facade.doExecute(this, this.getOption(), this.getOperateLog(), this.dataEntities, this.getBillEntityType(), this.invokeByIds, this.operationResult, this.operationKey);
            if (result != null && result.isSuccess()) {
                switch (result.getCode()) {
                    case 6: {
                        return;
                    }
                }
            }
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"beforeCallOperationTransaction");){
                this.beforeCallOperationTransaction(successObjs);
            }
            if (!this.cancelWriteLog()) {
                this.getBizModifyDirtyManager().init((DynamicObjectType)this.subEntityType, successObjs, this.operationKey);
            }
            span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"callOperationTransaction", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());
            var10_23 = null;
            try {
                this.callOperationTransaction(successObjs);
            }
            catch (Throwable throwable) {
                var10_23 = throwable;
                throw throwable;
            }
            finally {
                if (span != null) {
                    if (var10_23 != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable) {
                            var10_23.addSuppressed(throwable);
                        }
                    } else {
                        span.close();
                    }
                }
            }
            span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"afterCallOperationTransaction", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());
            var10_23 = null;
            try {
                this.afterCallOperationTransaction(successObjs);
            }
            catch (Throwable throwable) {
                var10_23 = throwable;
                throw throwable;
            }
            finally {
                if (span != null) {
                    if (var10_23 != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable) {
                            var10_23.addSuppressed(throwable);
                        }
                    } else {
                        span.close();
                    }
                }
            }
            this.getOperateLog().info(ResManager.loadKDString((String)"\u4e8b\u52a1\u7ed3\u675f\uff0c\u5f00\u59cb\u6267\u884c\u63d2\u4ef6 AfterExecuteOperationTransaction \u4e8b\u4ef6", (String)"EntityOperateService_8", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            this.getOperateLog().beginMothed("fireAfterExecuteOperationTransaction()", null);
            AfterOperationArgs ea = new AfterOperationArgs(this.operationKey, validExtendedDataRows);
            successObjs = new DynamicObject[this._successDataEntities.size()];
            ea.setDataEntities(this._successDataEntities.toArray(successObjs));
            try {
                this.opBizRuleService.fireAfterExecuteOperationTransaction(ea);
                this.plugInProxy.fireAfterExecuteOperationTransaction(ea);
            }
            catch (RuntimeException ex) {
                if (!"true".equals(this.getOption().getVariableValue("bos.catch_after_execute_operation_transaction_exception", "false"))) throw ex;
                throw new KDAfterExecuteOperationException(BosErrorCode.operationFailed, "", ex);
            }
            this.getOperateLog().endMothed("fireAfterExecuteOperationTransaction()", null);
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"callOperationTask", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
                this.callOperationTask(successObjs);
            }
            this.getOperateLog().endMothed(log_MothedName, null);
            return;
        }
    }

    private String collectUnSignData(DynamicObject[] successObjs, Map<Object, Object> clearTexts) {
        StringBuilder sb = new StringBuilder();
        Set<Object> signKeys = clearTexts.keySet();
        for (DynamicObject obj : successObjs) {
            Object pkId = obj.getPkValue();
            if (signKeys.contains(pkId)) continue;
            sb.append("id:").append(pkId).append(ResManager.loadKDString((String)"   error:\u6240\u5728\u7ec4\u7ec7\u4e0d\u5728\u53d7\u63a7\u8303\u56f4\uff01   ", (String)"EntityOperateService_10", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
        }
        return sb.toString();
    }

    protected boolean validate(List<ExtendedDataEntity> validExtendedDataRows) {
        String log_MothedName = "validate(validExtendedDataRows)";
        this.getOperateLog().beginMothed(log_MothedName, null);
        try {
            if (!this.validate()) {
                this.writeLogWithoutError(this.operationResult);
                this.getOperateLog().endMothed(log_MothedName, null);
                return false;
            }
            this.addValidExtendedDataRows(validExtendedDataRows);
            if (validExtendedDataRows.isEmpty()) {
                this.getOperateLog().endMothed(log_MothedName, "EntityOperateService.validate: no pass bills. return false");
                return false;
            }
        }
        catch (KDInteractionException ex) {
            if (Boolean.parseBoolean(this.getOption().getVariableValue("ignoreinteraction", String.valueOf(false)))) {
                throw ex;
            }
            this.getOperationResult().setSuccess(false);
            this.getOperationResult().setSponsor(ex.getSponsor());
            this.getOperationResult().setInteractionContext(ex.getInteractionContext());
            this.getOperationResult().setCancelWriteLog(true);
            this.getOperateLog().endMothed(log_MothedName, "EntityOperateService.validate: KDInteractionException");
            return false;
        }
        this.getOperateLog().endMothed(log_MothedName, null);
        return true;
    }

    protected boolean validate() {
        this.getOperateLog().beginMothed(VALIDATE, null);
        ValidateResultCollection resultCollection = this.tryValidate();
        boolean ignoreInteraction = Boolean.parseBoolean(this.option.getVariableValue("ignoreinteraction", String.valueOf(false)));
        boolean ignoreWarn = Boolean.parseBoolean(this.option.getVariableValue("ignorewarn", String.valueOf(false)));
        if (ignoreInteraction || ignoreWarn) {
            for (ValidateResult validateResult : resultCollection.getValidateErrors()) {
                if (validateResult.getFeedbackCusOpData() != null) {
                    this.operationResult.getCustomData().putAll(validateResult.getFeedbackCusOpData());
                }
                for (int i = validateResult.getAllErrorInfo().size() - 1; i >= 0; --i) {
                    OperateErrorInfo errorInfo = (OperateErrorInfo)validateResult.getAllErrorInfo().get(i);
                    if (errorInfo.getLevel() != ErrorLevel.Warning) continue;
                    validateResult.getAllErrorInfo().remove(i);
                }
            }
        } else {
            for (ValidateResult result : resultCollection.getValidateErrors()) {
                if (result.getFeedbackCusOpData() == null) continue;
                this.operationResult.getCustomData().putAll(result.getFeedbackCusOpData());
            }
        }
        if (resultCollection.errorSize(true) > 0) {
            this.operationResult.setValidateResult(resultCollection);
            this.operationResult.setSuccess(false);
            this.operationResult.setMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"EntityOperateService_11", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            for (ValidateResult validateResult : resultCollection.getValidateErrors()) {
                this.operationResult.addPromptField(validateResult.getPromptField());
                validateResult.getPromptField().clear();
            }
            if (this.getStrictValidation().booleanValue()) {
                this.getOperateLog().endMothed(VALIDATE, "EntityOperateService.validate: isStrictValidation, return false");
                return false;
            }
        }
        if (!ignoreInteraction && !ignoreWarn) {
            int warnInfoCount = 0;
            List allOpInfo = this.operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo info : allOpInfo) {
                OperateErrorInfo errorInfo;
                if (!(info instanceof OperateErrorInfo) || (errorInfo = (OperateErrorInfo)info).getLevel() != ErrorLevel.Warning) continue;
                ++warnInfoCount;
            }
            if (warnInfoCount > 0 && warnInfoCount == allOpInfo.size()) {
                this.getOperateLog().endMothed(VALIDATE, "EntityOperateService.validate: all is warn messages, return false");
                return false;
            }
        }
        this.getOperateLog().endMothed(VALIDATE, null);
        return true;
    }

    protected void addValidExtendedDataRows(List<ExtendedDataEntity> validExtendedDataRows) {
        if (this.operationResult.getValidateResult().errorSize() == this.dataEntities.length) {
            return;
        }
        String headEntityKey = this.billEntityType.getName();
        for (ExtendedDataEntity dataRow : this.extendDataEntitySet.FindByEntityKey(headEntityKey)) {
            int dataIndex = dataRow.getDataEntityIndex();
            if (this.operationResult.getValidateResult().getErrorDataIndexs().contains(dataIndex)) continue;
            validExtendedDataRows.add(dataRow);
        }
    }

    protected DynamicObject[] getSuccessObjs(List<ExtendedDataEntity> validExtendedDataRows) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(validExtendedDataRows.size());
        for (ExtendedDataEntity row : validExtendedDataRows) {
            list.add(row.getDataEntity());
        }
        DynamicObject[] successObjs = new DynamicObject[list.size()];
        successObjs = list.toArray(successObjs);
        return successObjs;
    }

    protected void beforeCallOperationTransaction(DynamicObject[] objs) {
        this.facade.beforeCallOperationTransaction(this, objs);
    }

    protected void commit(DynamicObject[] objs) {
        this.facade.afterCommit(this, objs);
        this.getOperateLog().info("TX.commit " + this.getBillEntityType().getName() + "." + this.operationKey);
    }

    protected void afterCallOperationTransaction(DynamicObject[] objs) {
        this.facade.afterCallOperationTransaction(this, objs);
    }

    /*
     * Exception decompiling
     */
    protected void callOperationTransaction(DynamicObject[] objs) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void rollback(DynamicObject[] objs, Exception ex) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"rollback");){
            this.getOperateLog().beginMothed("rollback()", null);
            this.getOperateLog().beginMothed("fireRollbackOperation()", null);
            RollbackOperationArgs args = new RollbackOperationArgs(objs);
            this.opBizRuleService.fireRollbackOperation(args);
            this.plugInProxy.fireRollbackOperation(args);
            this.getOperateLog().endMothed("fireRollbackOperation()", null);
            this.facade.afterRollback(this, objs, ex);
            this.getOperateLog().endMothed("rollback()", null);
        }
    }

    protected DynamicObject[] callOperation(DynamicObject[] objs) {
        this.getOperateLog().beginMothed("callOperation(objs)", "EntityOperateService.callOperation() begin.");
        DynamicObject[] successObjs = objs;
        this.getOperateLog().beginMothed("fireBeginOperationTransaction()", null);
        BeginOperationTransactionArgs be = new BeginOperationTransactionArgs(this.operationKey, objs);
        be.CancelFormService = false;
        be.cancelOperation = false;
        this.plugInProxy.fireBeginOperationTransaction(be);
        this.opBizRuleService.fireBeginOperationTransaction(be);
        this.getOperateLog().endMothed("fireBeginOperationTransaction()", null);
        successObjs = be.getDataEntities();
        if (!be.cancelOperation && successObjs.length > 0) {
            this.beforeInvokeFormBusiness(successObjs);
        }
        if (!be.CancelFormService && successObjs.length > 0) {
            this.invokeFormBusiness(successObjs, 0);
        }
        if (!be.cancelOperation && successObjs.length > 0) {
            this.getOperateLog().info(ResManager.loadKDString((String)"\u5f00\u59cb\u5199\u5165\u6570\u636e\u5e93", (String)"EntityOperateService_13", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            this.getOperateLog().beginMothed("executeOperate()", "EntityOperateService.executeOperate() begin.");
            this.getOperateLog().Info(successObjs[0]);
            this.facade.beforeExecuteOperate(this, objs);
            this.executeOperate(successObjs);
            this.facade.afterExecuteOperate(this, objs);
            this.getOperateLog().endMothed("executeOperate()", "EntityOperateService.executeOperate() end.");
        }
        if (!be.CancelFormService && successObjs.length > 0) {
            this.invokeFormBusiness(successObjs, 1);
        }
        this.getOperateLog().info(ResManager.loadKDString((String)"\u5199\u5e93\u5b8c\u6bd5\uff0c\u51c6\u5907\u63d0\u4ea4\u4e8b\u52a1", (String)"EntityOperateService_14", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
        this.getOperateLog().beginMothed("fireEndOperationTransaction()", null);
        EndOperationTransactionArgs ae = new EndOperationTransactionArgs(this.operationKey, successObjs);
        this.opBizRuleService.fireEndOperationTransaction(ae);
        this.plugInProxy.fireEndOperationTransaction(ae);
        this.getOperateLog().endMothed("fireEndOperationTransaction()", null);
        this.facade.callOperation(this, this.billEntityType, successObjs, this.getOperateLog(), this.getOption(), this.operationKey);
        this.getOperateLog().endMothed("callOperation(objs)", null);
        return successObjs;
    }

    protected abstract void executeOperate(DynamicObject[] var1);

    @Deprecated
    protected void beforeInvokeFormBusiness(DynamicObject[] dataEntities) {
    }

    @Deprecated
    protected void invokeFormBusiness(DynamicObject[] objs, int iActionPoint) {
    }

    protected void preparePropertys(List<String> fieldKeys) {
        String billNoFieldKey;
        this.getOperateLog().beginMothed("preparePropertys(fieldKeys)", null);
        if (this.billEntityType instanceof BasedataEntityType) {
            String numberKey = ((BasedataEntityType)this.billEntityType).getNumberProperty();
            String nameKey = ((BasedataEntityType)this.billEntityType).getNameProperty();
            if (StringUtils.isNotBlank((CharSequence)numberKey)) {
                fieldKeys.add(numberKey);
            }
            if (StringUtils.isNotBlank((CharSequence)nameKey)) {
                fieldKeys.add(nameKey);
            }
        } else if (this.billEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(billNoFieldKey = ((BillEntityType)this.billEntityType).getBillNo()))) {
            fieldKeys.add(billNoFieldKey);
        }
        ValidationService localValidationService = this.getValidationService();
        if (!localValidationService.getValidators().isEmpty()) {
            List validationMeta = (List)this.operateMetaMap.get(VALID_ATIONS);
            for (AbstractValidator validator : localValidationService.getValidators()) {
                ValidateContext validateContext = validator instanceof FunctionPermValidator || validator instanceof SpecialDataPermValidator ? this.createPermissionEntityValidateContext(validationMeta) : this.createValidateContext(validationMeta);
                validator.setValidateContext(validateContext);
                fieldKeys.addAll(validator.preparePropertys());
            }
        }
        for (IOperationServicePlugIn plugIn : this.opBizRuleService.getPlugIns()) {
            AbstractOpBizRuleAction opBizRuleAction;
            if (!(plugIn instanceof AbstractOpBizRuleAction) || (opBizRuleAction = (AbstractOpBizRuleAction)plugIn).getBizRule() == null || !StringUtils.isNotBlank((CharSequence)opBizRuleAction.getBizRule().getPrecondition())) continue;
            this.getReferenceFields(opBizRuleAction.getBizRule().getPrecondition(), fieldKeys);
        }
        HashMap parameter = (HashMap)this.operateMetaMap.get("parameter");
        if (parameter != null) {
            String statusKey = (String)parameter.get("statusProp");
            String statusVal = (String)parameter.get("value");
            IDataEntityProperty statusProperty = this.billEntityType.findProperty(statusKey);
            if (statusProperty != null) {
                Object itemPro;
                fieldKeys.add(statusKey);
                if (statusProperty instanceof BillStatusProp && StringUtils.isNotBlank((CharSequence)statusVal) && (itemPro = ((BillStatusProp)statusProperty).getStatusItem(statusVal)) != null) {
                    if (StringUtils.isNotBlank((CharSequence)itemPro.getOperationerKey())) {
                        fieldKeys.add(itemPro.getOperationerKey());
                    }
                    if (StringUtils.isNotBlank((CharSequence)itemPro.getOperationDateKey())) {
                        fieldKeys.add(itemPro.getOperationDateKey());
                    }
                }
            }
        }
        BaseDataServiceHelper bdHelper = new BaseDataServiceHelper();
        String mainOrgProName = BaseDataServiceHelper.getVerifyOrgPropertyName((String)this.getBillEntityType().getName(), (String)this.operationKey);
        if (mainOrgProName == null || mainOrgProName.trim().length() == 0) {
            mainOrgProName = this.getBillEntityType().getMainOrg();
        }
        if (mainOrgProName != null) {
            fieldKeys.add(mainOrgProName);
        }
        this.facade.afterPreparePropertysFirst(this, this.operateMetaMap, this.subEntityType, this.billEntityType.getName(), 0L, this.getOption(), this.billEntityType, fieldKeys);
        ArrayList<String> itemClassTypeFieldKeys = new ArrayList<String>();
        for (String fieldKey : fieldKeys) {
            IDataEntityProperty prop = this.getBillEntityType().findProperty(fieldKey);
            if (!(prop instanceof ItemClassProp)) continue;
            ItemClassProp itemClassProp = (ItemClassProp)prop;
            itemClassTypeFieldKeys.add(itemClassProp.getTypePropName());
        }
        fieldKeys.addAll(itemClassTypeFieldKeys);
        Map entityMap = this.billEntityType.getAllEntities();
        for (Map.Entry entry : entityMap.entrySet()) {
            IModifyTimeProperty modifyTimeProperty;
            EntityType type = (EntityType)entry.getValue();
            for (Map.Entry it : type.getFields().entrySet()) {
                IDataEntityProperty dtprop = (IDataEntityProperty)it.getValue();
                if (!(dtprop instanceof ModifierProp)) continue;
                fieldKeys.add(dtprop.getName());
                break;
            }
            if ((modifyTimeProperty = type.getModifyTimeProperty()) == null) continue;
            fieldKeys.add(modifyTimeProperty.getName());
        }
        this.getOperateLog().endMothed("preparePropertys(fieldKeys)", null);
    }

    protected void preparePropertys(Object[] ids, List<String> fieldKeys) {
        this.facade.afterPreparePropertys(this, ids, fieldKeys);
    }

    protected OperationResult createOperationResult() {
        Object logEnable;
        OperationResult result = new OperationResult();
        if (this.dataEntities != null) {
            result.setBillCount(this.dataEntities.length);
        }
        boolean logEnableFlag = (logEnable = this.operateMetaMap.get("logEnable")) == null || (Boolean)logEnable != false;
        result.setCancelWriteLog(!logEnableFlag);
        return result;
    }

    protected boolean cancelWriteLog() {
        if (this.operateMetaMap == null) {
            return false;
        }
        Object logEnable = this.operateMetaMap.get("logEnable");
        boolean logEnableFlag = logEnable == null || (Boolean)logEnable != false;
        return !logEnableFlag;
    }

    protected ValidateResultCollection tryValidate() {
        this.getOperateLog().beginMothed("tryValidate()", "EntityOperateService.tryValidate() begin.");
        List validationMeta = (List)this.operateMetaMap.get(VALID_ATIONS);
        ValidateContext validateContext = this.createValidateContext(validationMeta);
        ValidationService localValidationService = this.getValidationService();
        localValidationService.setPermessionEntityValidateContext(this.createPermissionEntityValidateContext(validationMeta));
        Map<Object, String> billNos = this.buildBillNoMaps();
        this.operationResult.getBillNos().putAll(billNos);
        this.getOperateLog().endMothed("tryValidate()", null);
        return localValidationService.validate(validateContext);
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        String entityKey = this.billEntityType.getName();
        String operateName = this.getOpName();
        String operateType = (String)this.operateMetaMap.get("type");
        SpecialDataPermValidator specDataPermValidator = new SpecialDataPermValidator();
        specDataPermValidator.setEntityKey(entityKey);
        specDataPermValidator.setOperateKey(this.operationKey);
        specDataPermValidator.setOperationName(operateName);
        specDataPermValidator.setOperateType(operateType);
        validators.add(specDataPermValidator);
        FunctionPermValidator funPermValidator = new FunctionPermValidator();
        funPermValidator.setEntityKey(entityKey);
        funPermValidator.setOperateKey(this.operationKey);
        funPermValidator.setOperationName(operateName);
        funPermValidator.setOperateType(operateType);
        validators.add(funPermValidator);
        MutexValidator mutexValidator = new MutexValidator();
        mutexValidator.setOperationCtx(this.getOperationContext());
        mutexValidator.setEntityKey(entityKey);
        mutexValidator.setOperationName(operateName);
        mutexValidator.setOperateKey(this.operationKey);
        mutexValidator.setOperateType(operateType);
        validators.add(mutexValidator);
        if (!this.invokeByIds) {
            BillExistsValidator billExistsValidator = new BillExistsValidator();
            billExistsValidator.setEntityKey(entityKey);
            billExistsValidator.setOperationName(operateName);
            billExistsValidator.setOperateKey(this.operationKey);
            billExistsValidator.setOperateType(operateType);
            validators.add(billExistsValidator);
        }
        this.facade.addDefaultValidator(validators, this.billEntityType, this.operateMetaMap, this.operationKey, this, this.getOperateLog());
        IAttachmentFieldModelProxy attachmentFieldModelProxy = (IAttachmentFieldModelProxy)ServiceFactory.getService(IAttachmentFieldModelProxy.class);
        AbstractValidator attValidator = (AbstractValidator)attachmentFieldModelProxy.newTempAttTimeOutValidator();
        attValidator.setEntityKey(entityKey);
        attValidator.setOperationName(operateName);
        attValidator.setOperateKey(this.operationKey);
        attValidator.setOperateType(operateType);
        validators.add(attValidator);
    }

    private ValidationService getValidationService() {
        if (this.validationService == null) {
            List validationMeta = (List)this.operateMetaMap.get(VALID_ATIONS);
            String operateType = (String)this.operateMetaMap.get("type");
            String operateName = this.getOpName();
            this.validationService = this.createValidationService();
            this.validationService.setOperateLog(this.getOperateLog());
            ArrayList<AbstractValidator> validators = new ArrayList<AbstractValidator>();
            this.addDefaultValidator(validators);
            List<AbstractValidator> opValidators = this.validationService.buildValidators(validationMeta, operateType, this.operationKey, operateName);
            validators.addAll(opValidators);
            this.getOperateLog().beginMothed("fireOnAddValidators", null);
            AddValidatorsEventArgs args = new AddValidatorsEventArgs(this.dataEntities, validators);
            this.opBizRuleService.fireOnAddValidators(args);
            this.plugInProxy.fireOnAddValidators(args);
            this.getOperateLog().endMothed("fireOnAddValidators", null);
            this.validationService.addAllValidator(args.getValidators());
        }
        return this.validationService;
    }

    private ValidateContext createPermissionEntityValidateContext(List<Map<String, Object>> validationMeta) {
        ValidateContext validateContext;
        String permessionEntityId = this.getOption().getVariableValue("permissionentityid", "");
        if (StringUtils.isNotBlank((CharSequence)permessionEntityId)) {
            validateContext = new PermissionValidateContext(validationMeta, permessionEntityId, this.operationKey, this.extendDataEntitySet);
            this.initValidateContext(validateContext);
        } else {
            validateContext = this.createValidateContext(validationMeta);
        }
        return validateContext;
    }

    private void initValidateContext(ValidateContext validateContext) {
        validateContext.setOperateMetaMap(this.operateMetaMap);
        validateContext.setOption(this.getOption());
        validateContext.setOperateProgress(this.operateProgress);
        validateContext.setFuncLib(this.getFuncLib());
        String operateType = (String)this.operateMetaMap.get("type");
        String operateName = this.getOpName();
        validateContext.setOperateType(operateType);
        validateContext.setOperateName(operateName);
        ArrayList validations = (ArrayList)this.operateMetaMap.get(VALID_ATIONS);
        for (Map validation : validations) {
            Object skipMustInput;
            if (!((Boolean)validation.get("enabled")).booleanValue() || !"MustInput".equals((String)validation.get("ruleType")) || (skipMustInput = validation.get("skipMustInput")) == null || ((Boolean)skipMustInput).booleanValue()) continue;
            validateContext.setCheckMustInput(true);
        }
    }

    private ValidateContext createValidateContext(List<Map<String, Object>> validationMeta) {
        ValidateContext validateContext = new ValidateContext(validationMeta, this.billEntityType.getName(), this.operationKey, this.extendDataEntitySet);
        validateContext.setBillEntityType(this.billEntityType);
        validateContext.setSubEntityType(this.subEntityType);
        validateContext.setDataEntityLength(this.getOperationResult().getBillCount());
        if (this.dataEntities != null && this.dataEntities.length > 0) {
            ValidatePrefixArgs validatePrefixArgs = new ValidatePrefixArgs();
            this.plugInProxy.fireValidatePrefix(validatePrefixArgs);
            this.opBizRuleService.fireValidatePrefix(validatePrefixArgs);
            String validatePrefix = validatePrefixArgs.getPropName();
            validateContext.setValidatePrefix(validatePrefix);
        }
        this.initValidateContext(validateContext);
        return validateContext;
    }

    protected ValidationService createValidationService() {
        return new ValidationService(this.operationContext.getEntityTypeId());
    }

    private void fireBeforeExecuteOperationTransaction(BeforeOperationArgs beforeArgs) {
        try {
            this.plugInProxy.fireBeforeExecuteOperationTransaction(beforeArgs);
            this.opBizRuleService.fireBeforeExecuteOperationTransaction(beforeArgs);
        }
        catch (KDInteractionException ex) {
            if (Boolean.parseBoolean(this.getOption().getVariableValue("ignoreinteraction", String.valueOf(false)))) {
                throw ex;
            }
            this.getOperationResult().setSuccess(false);
            this.getOperationResult().setSponsor(ex.getSponsor());
            this.getOperationResult().setInteractionContext(ex.getInteractionContext());
            this.getOperationResult().setCancelWriteLog(true);
            beforeArgs.cancel = true;
        }
    }

    private void callOperationTask(DynamicObject[] objs) {
        for (IOperationTask operationTask : this.operationTasks) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSTASK, (String)(operationTask.getClass().getSimpleName() + "#execute"));
            Throwable throwable = null;
            try {
                this.getOperateLog().beginMothed("Task." + operationTask.getClass().getSimpleName() + ".execute()", null);
                operationTask.execute(this.getOperationContext(), objs, this.getOperationResult());
                this.getOperateLog().endMothed("Task." + operationTask.getClass().getSimpleName() + ".execute()", null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private List<IOperationTask> getOperationTask() {
        Map taskDefs = OpBizRuleTypeLoader.loadOperationTask();
        ArrayList<IOperationTask> list = new ArrayList<IOperationTask>();
        if (taskDefs != null) {
            try {
                for (Map.Entry taskDef : taskDefs.entrySet()) {
                    Class cls = TypesContainer.getOrRegister((String)((String)taskDef.getValue()));
                    IOperationTask task = (IOperationTask)TypesContainer.createInstance((Class)cls);
                    list.add(task);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        return list;
    }

    private void notExistRecords(Object[] ids, DynamicObject[] objs) {
        if (objs.length < ids.length) {
            HashSet<String> objIds = new HashSet<String>(objs.length);
            for (DynamicObject obj : objs) {
                objIds.add(String.valueOf(obj.getPkValue()));
            }
            HashMap<String, Object> notExistIdMap = new HashMap<String, Object>(ids.length);
            for (Object id : ids) {
                String idString = String.valueOf(id);
                if (StringUtils.isBlank((CharSequence)idString) || StringUtils.equals((CharSequence)"0", (CharSequence)idString) || objIds.contains(idString)) continue;
                notExistIdMap.put(idString, id);
            }
            if (!notExistIdMap.isEmpty()) {
                String message = String.format(ResManager.loadKDString((String)"\u6709%s\u6761\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"EntityOperateService_21", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), notExistIdMap.size());
                this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", (Object)"", 0, 0, "notExistRecords", "", message, ErrorLevel.Error));
                this.operationResult.removeSuccessPkIds(new ArrayList(notExistIdMap.values()));
                this.getOperateLog().info("not exist ids:" + String.join((CharSequence)",", notExistIdMap.keySet()));
            }
        }
    }

    private void getReferenceFields(String preCondition, List<String> fieldKeys) {
        if (StringUtils.isNotBlank((CharSequence)preCondition)) {
            String[] keyList;
            for (String p : keyList = CalcExprParser.getExprVariables((String)preCondition)) {
                if (fieldKeys.contains(p)) continue;
                fieldKeys.add(p);
            }
        }
    }

    private ICodeRuleService getCodeRuleService() {
        return (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
    }

    @Deprecated
    protected void recycleNumber(DynamicObject obj) {
    }

    protected void recycleNumber(DynamicObject[] objs) {
        if (objs == null || objs.length == 0) {
            return;
        }
        if (!(this.billEntityType instanceof BillEntityType)) {
            return;
        }
        String billNoField = ((BillEntityType)this.billEntityType).getBillNo();
        if (StringUtils.isBlank((CharSequence)billNoField)) {
            return;
        }
        this.getOperateLog().beginMothed("recycleNumber()", null);
        ArrayList<String> billNos = new ArrayList<String>();
        ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objs) {
            String billNo = obj.getString(billNoField);
            if (!StringUtils.isNotBlank((CharSequence)billNo)) continue;
            billNos.add(billNo);
            objList.add(obj);
        }
        if (!billNos.isEmpty()) {
            ICodeRuleService codeRuleService = this.getCodeRuleService();
            codeRuleService.recycleBatchNumber(this.billEntityType.getName(), objList.toArray(new DynamicObject[0]), null, billNos.toArray(new String[0]));
        }
        this.getOperateLog().endMothed("recycleNumber()", null);
    }

    protected FunctionManage getFuncLib() {
        if (this.funcLib == null) {
            this.funcLib = FunctionManage.get();
        }
        return this.funcLib;
    }

    protected void persistAttachments(DynamicObject[] successObjs) {
        this.getOperateLog().beginMothed("persistAttachments()", null);
        IAttachmentOperateService attService = (IAttachmentOperateService)ServiceFactory.getService(IAttachmentOperateService.class);
        attService.persistAttachments(this.getOption(), successObjs);
        this.getOperateLog().endMothed("persistAttachments()", null);
    }

    protected void deletePictures(DynamicObject[] successObjs) {
        this.getOperateLog().beginMothed("removeImage()", null);
        IImageOperateService attService = (IImageOperateService)ServiceFactory.getService(IImageOperateService.class);
        attService.removeImage(this.getOption(), successObjs);
        this.getOperateLog().endMothed("removeImage()", null);
    }

    private void writeLogWithoutError(OperationResult opResult) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"writeLogWithoutError");){
            this.writeLog(opResult);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    protected void writeLog(OperationResult opResult) {
        if (opResult.isCancelWriteLog()) {
            return;
        }
        if ("api".equals(RequestContext.get().getClient()) && !this.checkApiLogOpen() && !"true".equalsIgnoreCase(this.option.getVariableValue("needlog", "false"))) {
            return;
        }
        if (!this.isNeedApplog() && !this.isNeedAuditlog()) {
            return;
        }
        this.getOperateLog().beginMothed("writeLog()", null);
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        ArrayList<OpLogAppInfo> appLogInfoList = new ArrayList<OpLogAppInfo>(10);
        ArrayList<AppLogInfo> aduitLogList = new ArrayList<AppLogInfo>(10);
        IDataEntityProperty billNoProp = null;
        MainOrgProp mainOrgProp = null;
        ISimpleProperty pkProp = this.subEntityType.getPrimaryKey();
        IDataEntityProperty keyFieldProp = null;
        if (this.subEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this.subEntityType;
            if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                billNoProp = this.subEntityType.findProperty(bdType.getNumberProperty());
            }
            mainOrgProp = bdType.getMainOrgProperty();
            if (StringUtils.isNotBlank((CharSequence)bdType.getBillKeyField())) {
                keyFieldProp = this.subEntityType.findProperty(bdType.getBillKeyField());
            }
        } else if (this.subEntityType instanceof BillEntityType) {
            billNoProp = this.subEntityType.findProperty(((BillEntityType)this.subEntityType).getBillNo());
            mainOrgProp = ((BillEntityType)this.subEntityType).getMainOrgProperty();
            keyFieldProp = this.subEntityType.findProperty(((BillEntityType)this.subEntityType).getBillKeyField());
        }
        boolean isNeedAuditLog = this.isNeedAuditlog() && !this.disableLog(this.getBizAppId());
        boolean logDetail = this.wirteDetailLog();
        for (DynamicObject successObj : this._successDataEntities) {
            AppLogInfo newInfo;
            MultiLangEnumBridge opDesc;
            Object value;
            String billNo = billNoProp == null ? "" : (String)billNoProp.getValue((Object)successObj);
            String keyCaption = billNoProp == null ? "" : billNoProp.getDisplayName().toString();
            String keyMsg = billNo;
            if (keyFieldProp != null) {
                keyMsg = (String)keyFieldProp.getValue((Object)successObj);
                keyCaption = keyFieldProp.getDisplayName().toString();
            }
            Long mainOrgId = 0L;
            if (mainOrgProp != null && (value = mainOrgProp.getValue((Object)successObj)) instanceof DynamicObject) {
                DynamicObject mainOrg = (DynamicObject)value;
                mainOrgId = (Long)mainOrg.getPkValue();
            }
            String[] opDescArgs = new String[]{};
            if (logDetail && StringUtils.isNotBlank((CharSequence)keyMsg)) {
                opDesc = new MultiLangEnumBridge("%1$s\uff1a%2$s\uff0c%3$s\u6210\u529f", "EntityOperateService_17", BOS_MSERVICE_OPERATION);
                opDescArgs = new String[]{keyCaption, keyMsg, this.getOpName()};
            } else if (logDetail) {
                opDesc = new MultiLangEnumBridge("%s\u6210\u529f", "EntityOperateService_16", BOS_MSERVICE_OPERATION);
                opDescArgs = new String[]{this.getOpName()};
            } else {
                opDesc = new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f", "EntityOperateService_22", BOS_MSERVICE_OPERATION);
            }
            OpLogAppInfo logInfo = this.buildLogInfo(mainOrgId, opDesc, opDescArgs);
            logInfo.setStatus("1");
            if (StringUtils.isNotBlank((CharSequence)billNo)) {
                logInfo.setModifyBillNo(billNo);
                logInfo.setKeyWord(billNo);
            } else {
                Object pkValue = successObj.getPkValue();
                logInfo.setModifyBillNo(pkValue == null ? "" : pkValue.toString());
                logInfo.setKeyWord(pkValue == null ? "" : pkValue.toString());
            }
            MultiLangEnumBridge opLogName = this.getOpLogName(successObj);
            if (opLogName != null) {
                logInfo.setOpName(this.operationKey, opLogName);
            } else if (Lang.get() == Lang.zh_CN) {
                logInfo.setOpName(this.getLogOperateName(successObj));
            }
            if (this.isNeedApplog()) {
                appLogInfoList.add(logInfo);
            }
            if (!isNeedAuditLog || (newInfo = this.writeAuditLog(opResult, (AppLogInfo)logInfo, successObj, pkProp)) == null) continue;
            aduitLogList.add(newInfo);
        }
        if (!appLogInfoList.isEmpty()) {
            logService.addBatchLog(appLogInfoList);
        }
        if (!aduitLogList.isEmpty()) {
            LogORM logOrm = LogORM.create();
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            Long userId = RequestContext.get().getCurrUserId();
            String userName = RequestContext.get().getUserName();
            for (AppLogInfo info : aduitLogList) {
                this.doAduitLog(info, list, userId, userName);
            }
            logOrm.insert(list);
        }
        List errorInfos = opResult.getAllErrorOrValidateInfo();
        appLogInfoList = new ArrayList(10);
        if (this.isNeedApplog() && !errorInfos.isEmpty()) {
            ExtendedDataEntity[] billDataEntitys = this.extendDataEntitySet.FindByEntityKey(this.subEntityType.getName());
            HashMap<Integer, DynamicObject> dataIndexMap = new HashMap<Integer, DynamicObject>(billDataEntitys.length);
            HashMap<Object, DynamicObject> dataPkMap = new HashMap<Object, DynamicObject>(billDataEntitys.length);
            for (ExtendedDataEntity dataEntity : billDataEntitys) {
                dataIndexMap.put(dataEntity.getDataEntityIndex(), dataEntity.getDataEntity());
                if (dataEntity.getBillPkId() == null) continue;
                dataPkMap.put(dataEntity.getBillPkId(), dataEntity.getDataEntity());
            }
            for (IOperateInfo errorInfo : errorInfos) {
                Long mainOrgId = 0L;
                String billNo = null;
                if ((mainOrgProp != null || billNoProp != null) && errorInfo instanceof OperateErrorInfo) {
                    DynamicObject billObj = null;
                    if (errorInfo.getPkValue() != null) {
                        billObj = (DynamicObject)dataPkMap.get(errorInfo.getPkValue());
                    }
                    if (billObj == null && errorInfo instanceof ValidationErrorInfo) {
                        int dataIndex = ((ValidationErrorInfo)errorInfo).getDataEntityIndex();
                        billObj = (DynamicObject)dataIndexMap.get(dataIndex);
                    }
                    if (billObj != null) {
                        Object value;
                        if (mainOrgProp != null && (value = mainOrgProp.getValue((Object)billObj)) instanceof DynamicObject) {
                            DynamicObject mainOrg = (DynamicObject)value;
                            mainOrgId = (Long)mainOrg.getPkValue();
                        }
                        if (billNoProp != null) {
                            Object billNoValue = billNoProp.getValue((Object)billObj);
                            billNo = billNoValue == null ? null : billNoValue.toString();
                        }
                    }
                }
                OpLogAppInfo logInfo = logDetail ? this.buildLogInfo(mainOrgId, new MultiLangEnumBridge("%s", "EntityOperateService_26", BOS_MSERVICE_OPERATION), errorInfo.getMessage()) : this.buildLogInfo(mainOrgId, new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25", "EntityOperateService_24", BOS_MSERVICE_OPERATION), new String[0]);
                logInfo.setStatus("0");
                if (StringUtils.isNotBlank(billNo)) {
                    logInfo.setModifyBillNo(billNo);
                } else if (errorInfo.getPkValue() != null) {
                    logInfo.setModifyBillNo(String.valueOf(errorInfo.getPkValue()));
                }
                appLogInfoList.add(logInfo);
            }
            if (!appLogInfoList.isEmpty()) {
                logService.addBatchLog(appLogInfoList);
            }
        }
        opResult.setCancelWriteLog(true);
        this.getOperateLog().endMothed("writeLog()", null);
    }

    private String getBizAppId() {
        String orginAppNum;
        AppInfo appInfo;
        String appId = "";
        String appNumber = this.getOption().getVariableValue("appnumber", "");
        if (StringUtils.isBlank((CharSequence)appNumber)) {
            String string = appNumber = StringUtils.isNotBlank((CharSequence)this.subEntityType.getBizAppNumber()) ? this.subEntityType.getBizAppNumber() : this.subEntityType.getAppId();
        }
        if (!StringUtils.equals((CharSequence)"bos", (CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfoByNumber((String)appNumber))) {
            appId = appInfo.getId();
        }
        if (StringUtils.isEmpty((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)(orginAppNum = MetadataDao.getAppNumberByEntityNumber((String)this.billEntityType.getName())))) {
            appId = AppReader.getAppIdByNumber((String)orginAppNum);
        }
        return appId != null ? appId : "";
    }

    private void doAduitLog(AppLogInfo logInfo, List<DynamicObject> list, Long userId, String userName) {
        if (StringUtils.isBlank((CharSequence)logInfo.getModifyBillID()) || StringUtils.isBlank((CharSequence)logInfo.getModifyContent())) {
            return;
        }
        log.info("begin to process aduit log");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_aduit_log_new");
        DynamicObject obj = new DynamicObject((DynamicObjectType)type);
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"number,name,username");
        String opusername = null;
        if (user != null) {
            userName = this.getUserName(user);
            opusername = user.getString("username");
        }
        obj.set("username", (Object)userName);
        obj.set("opname", (Object)logInfo.getOpName());
        obj.set("opdesc", (Object)logInfo.getOpDescription());
        obj.set("opdate", (Object)TimeServiceHelper.now());
        obj.set("modifybillid", (Object)logInfo.getModifyBillID());
        obj.set("modifybillno", (Object)logInfo.getModifyBillNo());
        obj.set("modifyfields", (Object)logInfo.getModifyFields());
        obj.set("modifycontent", (Object)logInfo.getModifyContent());
        obj.set("modifycontent_tag", (Object)logInfo.getModifyContentTag());
        MainEntityType entityType = EntityMetadataCache.getDataEntityTypeNoCache((String)logInfo.getBizObjID());
        obj.set("bizobjname", (Object)entityType.getDisplayName().toString());
        obj.set("bizobjnumber", (Object)logInfo.getBizObjID());
        obj.set("clienttype", (Object)logInfo.getClientType());
        obj.set("clientip", (Object)logInfo.getClientIP());
        obj.set("opusername", (Object)opusername);
        obj.set("userid", (Object)String.valueOf(userId));
        obj.set("bizappid", (Object)logInfo.getBizAppID());
        String bizappname = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)logInfo.getBizAppID())) {
                ILocaleString bizappName;
                DynamicObject dObj = BizAppServiceHelp.getBizAppByID((String)logInfo.getBizAppID());
                if (null != dObj && (bizappName = dObj.getLocaleString("name")) != null) {
                    bizappname = bizappName.toString();
                }
                if (bizappname == null) {
                    bizappname = ResManager.loadKDString((String)"\u5e94\u7528\u540d\u4e0d\u5b58\u5728", (String)"LogConsumer_4", (String)"bos-mservice-log", (Object[])new Object[0]);
                }
            } else {
                bizappname = ResManager.loadKDString((String)"\u7a7a\u5e94\u7528", (String)"LogConsumer_5", (String)"bos-mservice-log", (Object[])new Object[0]);
            }
            obj.set("bizappname", (Object)bizappname);
        }
        catch (Exception localException) {
            log.debug("localException {}", (Object)localException);
        }
        list.add(obj);
    }

    private String getUserName(DynamicObject user) {
        String number = user.get("number") == null ? "" : user.get("number").toString();
        String name = user.get("name") == null ? "" : user.get("name").toString();
        return (number + " " + name).trim();
    }

    private AppLogInfo writeAuditLog(OperationResult opResult, AppLogInfo oldLogInfo, DynamicObject successObj, ISimpleProperty pkProp) {
        if (opResult.isSuccess() && pkProp != null && pkProp.getValue((Object)successObj) != null) {
            Object pkVal = pkProp.getValue((Object)successObj);
            String pkValStr = pkVal.toString();
            CharSequence[] modifyFieldsInMonitor = this.getBizModifyDirtyManager().getModifyFieldsFullNameInMonitor(pkValStr);
            if (modifyFieldsInMonitor.length > 0 || modifyFieldsInMonitor.length == 0 && "delete".equals(this.operationKey)) {
                AppLogInfo logInfo = new AppLogInfo();
                logInfo.setBizAppID(oldLogInfo.getBizAppID());
                logInfo.setBizObjID(oldLogInfo.getBizObjID());
                logInfo.setClientType(oldLogInfo.getClientType());
                logInfo.setModifyBillNo(oldLogInfo.getModifyBillNo());
                logInfo.setClientIP(oldLogInfo.getClientIP());
                String modifyFields = String.join((CharSequence)",", modifyFieldsInMonitor);
                if (!StringUtils.isBlank((CharSequence)modifyFields)) {
                    modifyFields = "," + modifyFields + ",";
                }
                if (modifyFields.length() > 1020) {
                    modifyFields = modifyFields.substring(0, 1020);
                }
                logInfo.setModifyFields(modifyFields);
                EntityModifyInfo entityModifyInfo = this.getBizModifyDirtyManager().getEntityModifyInfo(pkValStr);
                BeforeSaveAuditLogArg beforeSaveAuditLog = new BeforeSaveAuditLogArg(entityModifyInfo);
                this.plugInProxy.fireBeforeSaveAuditLog(beforeSaveAuditLog);
                this.opBizRuleService.fireBeforeSaveAuditLog(beforeSaveAuditLog);
                this.getBizModifyDirtyManager().buildContent(pkValStr, entityModifyInfo);
                this.getBizModifyDirtyManager().getModifyContent(pkValStr);
                Tuple modifyContent = this.getBizModifyDirtyManager().getModifyContent(pkValStr);
                if (modifyContent != null) {
                    String summaryContent = (String)modifyContent.item1;
                    if (summaryContent != null && summaryContent.length() > 510) {
                        summaryContent = summaryContent.substring(0, 507) + "...";
                    }
                    logInfo.setModifyContent(summaryContent);
                    logInfo.setModifyContentTag((String)modifyContent.item2);
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)modifyContent.item2))) {
                        logInfo.setModifyBillID(pkValStr + this.getBizModifyDirtyManager().getModifyFlag(pkValStr));
                    }
                }
                if (StringUtils.isBlank((CharSequence)logInfo.getModifyBillNo())) {
                    logInfo.setModifyBillNo(pkValStr);
                }
                logInfo.setOpName(this.operationKey);
                logInfo.setOpDescription(this.getOpName());
                return logInfo;
            }
        }
        return null;
    }

    private boolean disableLog(String bizAppID) {
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        Set<String> extendAppIds = this.getExtendAppIds(disabledAppIds);
        disabledAppIds.addAll(extendAppIds);
        if (!disabledAppIds.isEmpty() && disabledAppIds.contains(bizAppID)) {
            log.info("\u5f53\u524d\u64cd\u4f5c\u8868\u5355\uff1a{}\u6240\u5c5e\u5e94\u7528\u5df2\u88ab\u7981\u7528\uff0c\u56e0\u6b64\u5bf9\u6b64\u64cd\u4f5c\u53d1\u751f\u53d8\u5316\u4e0d\u8bb0\u5f55\u81f3\u5ba1\u6838\u65e5\u5fd7\u3002", (Object)this.subEntityType.getName());
            return true;
        }
        return false;
    }

    private Set<String> getExtendAppIds(Set<String> bizAppId) {
        String selectFields = "id";
        QFilter[] filters = new QFilter[]{new QFilter("masterid", "in", bizAppId)};
        Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)selectFields, (QFilter[])filters);
        HashSet<String> extendAppIds = new HashSet<String>();
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects.values()) {
                String id = dynamicObject.getString("id");
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                extendAppIds.add(id);
            }
        }
        return extendAppIds;
    }

    private Map<Object, String> buildBillNoMaps() {
        IDataEntityProperty billNoProp = null;
        if (this.subEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this.subEntityType;
            if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                billNoProp = this.subEntityType.findProperty(bdType.getNumberProperty());
            }
        } else if (this.subEntityType instanceof BillEntityType) {
            billNoProp = this.subEntityType.findProperty(((BillEntityType)this.subEntityType).getBillNo());
        }
        HashMap<Object, String> billNos = new HashMap<Object, String>();
        if (billNoProp == null) {
            return billNos;
        }
        for (DynamicObject billObj : this.dataEntities) {
            Object pkValue = billObj.getPkValue();
            if (pkValue == null) continue;
            String billNo = (String)billNoProp.getValue((Object)billObj);
            billNos.put(pkValue, billNo);
        }
        return billNos;
    }

    @Deprecated
    protected AppLogInfo buildLogInfo(String msg, Long orgId) {
        OpLogAppInfo logInfo = this.buildOpLogInfo(orgId);
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    protected OpLogAppInfo buildLogInfo(Long orgId, MultiLangEnumBridge bridge, String ... args) {
        OpLogAppInfo opLogAppInfo;
        if (this.wirteDetailLog()) {
            String desc = PromptUtils.format((String)bridge.loadKDString(), (Object[])args);
            opLogAppInfo = this.buildOpLogInfo(orgId, desc);
        } else {
            opLogAppInfo = this.buildOpLogInfo(orgId);
            opLogAppInfo.setOpDesc(bridge, args);
        }
        return opLogAppInfo;
    }

    @Deprecated
    protected OpLogAppInfo buildOpLogInfo(Long orgId, String msg) {
        OpLogAppInfo opLogAppInfo = this.buildOpLogInfo(orgId);
        opLogAppInfo.setOpDescription(msg);
        return opLogAppInfo;
    }

    private OpLogAppInfo buildOpLogInfo(Long orgId) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String appId = this.getBizAppId();
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(this.subEntityType.getName());
        if (orgId != null && Long.compare(0L, orgId) != 0) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(this.operationKey, this.getLogOpName());
        return logInfo;
    }

    private boolean wirteDetailLog() {
        if (this.writeDetailLog != null) {
            return this.writeDetailLog;
        }
        try {
            AppParam param = new AppParam();
            param.setAppId("83bfebc800003dac");
            param.setViewType("15");
            param.setOrgId(Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
            Map devParams = ParameterReader.loadSystemParameterFromCache((AppParam)param);
            this.writeDetailLog = devParams.get("operation_log_detail") != null && Boolean.parseBoolean(String.valueOf(devParams.get("operation_log_detail"))) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.writeDetailLog = false;
        }
        return this.writeDetailLog;
    }

    private String buildOpResultLog(DynamicObject[] objs, OperationResult opResult) {
        int i;
        int count = 5;
        StringBuilder sb = new StringBuilder();
        sb.append("EntityOperateService.excute(");
        sb.append(this.billEntityType.getName()).append(",");
        sb.append(this.operationKey).append(",");
        sb.append("[");
        if (objs != null) {
            for (i = 0; i < objs.length && i <= count; ++i) {
                if (objs[i] == null) continue;
                if (i >= count) {
                    sb.append("... total ").append(objs.length).append(" bills");
                    break;
                }
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(String.valueOf(objs[i].getPkValue()));
            }
        }
        sb.append("]),").append("\r\n");
        sb.append("cost ").append(String.valueOf(TimeServiceHelper.now().getTime() - this.startTime)).append(" ms,").append("\r\n");
        if (opResult == null) {
            sb.append("result = null");
        } else {
            sb.append("successIds = ");
            if (opResult.getSuccessPkIds() == null || opResult.getSuccessPkIds().isEmpty()) {
                sb.append("null, ");
            } else {
                for (i = 0; i < opResult.getSuccessPkIds().size() && i <= count; ++i) {
                    if (i >= count) {
                        sb.append("... total ").append(opResult.getSuccessPkIds().size()).append(" bills");
                        break;
                    }
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(String.valueOf(opResult.getSuccessPkIds().get(i)));
                }
            }
            sb.append("\r\n");
            sb.append("Msg:").append(opResult.getMessage()).append("\r\n");
            List errInfos = opResult.getAllErrorOrValidateInfo();
            if (errInfos.isEmpty()) {
                sb.append("ErrorInfo = null").append("\r\n");
            } else if (errInfos.size() == 1) {
                sb.append("ErrorInfo_0 = ").append(((IOperateInfo)errInfos.get(0)).getMessage()).append("\r\n");
            } else {
                sb.append("ErrorInfos = ").append(errInfos.size()).append(" rows: ").append("\r\n");
                for (int i2 = 0; i2 < 10 && i2 < errInfos.size(); ++i2) {
                    sb.append("ErrorInfo_").append(i2 + 1).append(": ").append(((IOperateInfo)errInfos.get(i2)).getMessage()).append("\r\n");
                }
            }
        }
        return sb.toString();
    }

    private boolean signVerify(DynamicObject[] outSuccessObjs) {
        return this.getSignOperateService().signVerify(this.operationKey, this.billEntityType, this.getOperationResult(), this.getOption(), outSuccessObjs);
    }

    @Deprecated
    protected OperationResult showBigDataProgressForm(Object[] ids, DynamicObject[] dataEntities) {
        if (this.isBigDataNewThreadExecuter() && this.isSplitPage(dataEntities)) {
            InteractionContext interactionContext = new InteractionContext();
            interactionContext.setCustShowFormId("bos_bigdataopexecuter");
            interactionContext.getCustShowParameter().put("entitynumber", this.billEntityType.getName());
            interactionContext.getCustShowParameter().put("opkey", this.operationKey);
            interactionContext.getCustShowParameter().put("pkids", StringUtils.join((Object[])ids, (String)","));
            interactionContext.getCustShowParameter().put("operateoption", SerializationUtils.toJsonString((Object)this.getOption().getVariables()));
            OperationResult opResult = this.createOperationResult();
            opResult.setSponsor("OpBigDataExecute");
            opResult.setInteractionContext(interactionContext);
            return opResult;
        }
        return null;
    }

    @Deprecated
    protected boolean isBigDataNewThreadExecuter() {
        return Boolean.parseBoolean(this.getOption().getVariableValue("bos_bigdata_newthread", String.valueOf(false)));
    }

    protected void setSplitPageFlag(DynamicObject[] dataEntities) {
        boolean splitPage = this.isSplitPage(dataEntities);
        this.plugInProxy.setSplitPage(splitPage);
        this.opBizRuleService.setSplitPage(splitPage);
        this.getValidationService().setSplitPage(splitPage);
    }

    protected boolean isSplitPage(DynamicObject[] dataEntities) {
        return false;
    }

    protected void setProgressTip(String tip) {
        this.progressProxy.feedbackMainProgress(tip);
    }

    protected IBizModifyDirtyManager getBizModifyDirtyManager() {
        if (this.bizModifyDirtyManager == null) {
            this.bizModifyDirtyManager = (IBizModifyDirtyManager)TypesContainer.createInstance((String)"kd.bos.mservice.bizlog.BizModifyDirtyManager");
        }
        return this.bizModifyDirtyManager;
    }

    private void releaseIntentLock() {
        String isOpenIntentLocks;
        OperateOption option = this.getOption();
        if (option != null && option.containsVariable("isOpenIntentLocks") && Boolean.parseBoolean(isOpenIntentLocks = option.getVariableValue("isOpenIntentLocks", "false")) && (this instanceof Submit || this instanceof Save || this instanceof Audit)) {
            this.doReleaseIntentLock();
        }
    }

    private void doReleaseIntentLock() {
        this.getOperateLog().beginMothed("releaseIntentLock()", null);
        try (DataMutex dataMutex = DataMutex.create();){
            HashMap entityMap = new HashMap(16);
            HashSet<String> objIdSet = new HashSet<String>(16);
            String entityTypeId = this.operationContext.getEntityTypeId();
            DynamicObject[] dataEntities = this.operationContext.getDataEntities();
            if (dataEntities != null) {
                for (DynamicObject dataEntity : dataEntities) {
                    Object pkValue = dataEntity.getPkValue();
                    if (!StringUtils.isNotBlank((Object)pkValue)) continue;
                    objIdSet.add(String.valueOf(pkValue));
                }
                entityMap.put(entityTypeId, objIdSet);
                dataMutex.batchReleaseIntent(Arrays.asList(entityMap));
            }
        }
        catch (IOException e) {
            log.error("\u91ca\u653e\u610f\u5411\u9501\u51fa\u9519,error: %s", (Object)e.getMessage());
        }
        this.getOperateLog().endMothed("releaseIntentLock()", null);
    }

    private boolean checkApiLogOpen() {
        boolean open = true;
        try {
            AppParam appParam = new AppParam();
            appParam.setAppId("W3NF+MX967M");
            appParam.setViewType("15");
            long rootOrgId = ((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId();
            appParam.setOrgId(Long.valueOf(rootOrgId));
            appParam.setActBookId(Long.valueOf(0L));
            Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            if (paramMap != null) {
                String result = paramMap.getOrDefault("kapiloglevel", null);
                open = "opLog".equals(result);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return open;
    }

    private ISignOperateService getSignOperateService() {
        if (signOperateService == null) {
            signOperateService = (ISignOperateService)TypesContainer.createInstance((String)"kd.bos.ca.operate.SignOperateService");
        }
        return signOperateService;
    }

    @Deprecated
    protected String getLogOperateName(DynamicObject dynamicObject) {
        return this.getOpName();
    }

    protected MultiLangEnumBridge getOpLogName(DynamicObject dynamicObject) {
        return null;
    }

    private boolean isNeedApplog() {
        boolean isNeedLog = true;
        OperateOption option = this.getOption();
        if (!"true".equalsIgnoreCase(option.getVariableValue("needlog", "false")) && (StringUtils.isBlank((CharSequence)RequestContext.get().getTenantId()) || SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"difftableclose", (Boolean)Boolean.TRUE).booleanValue() && !"MA".equals(RequestContext.get().getOperationType()))) {
            isNeedLog = false;
        }
        return isNeedLog;
    }

    private boolean isNeedAuditlog() {
        boolean isNeedLog = true;
        OperateOption option = this.getOption();
        if (!"true".equalsIgnoreCase(option.getVariableValue("needlog", "false")) && (StringUtils.isBlank((CharSequence)RequestContext.get().getTenantId()) || SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"auditlog.onlylogma", (Boolean)Boolean.TRUE).booleanValue() && !"MA".equals(RequestContext.get().getOperationType()))) {
            isNeedLog = false;
        }
        return isNeedLog;
    }
}

