/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.KDOpAsynExecutorException;
import kd.bos.entity.operate.OperateProgressCache;
import kd.bos.entity.operate.interaction.InteractionContext;

class OperateProgressProxy {
    private String entityNumber;
    private String opKey;
    private OperateOption operateOption;
    private boolean init = true;
    private boolean beginTrans = false;
    private String mainDesc;

    public OperateProgressProxy(String entityNumber, String opKey, OperateOption operateOption) {
        this.entityNumber = entityNumber;
        this.opKey = opKey;
        this.operateOption = operateOption;
    }

    private boolean isSupportAysn() {
        return Boolean.parseBoolean(this.operateOption.getVariableValue("bos_support_bigdata_aysn", String.valueOf(false))) && !Boolean.parseBoolean(this.operateOption.getVariableValue("bos_is_auto_batch_exe_op", String.valueOf(false)));
    }

    protected boolean isAysnThread() {
        return Boolean.parseBoolean(this.operateOption.getVariableValue("bos_bigdata_aysn", String.valueOf(false)));
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public boolean isBeginTrans() {
        return this.beginTrans;
    }

    public void setBeginTrans(boolean beginTrans) {
        this.beginTrans = beginTrans;
    }

    public void feedbackMainProgress(String desc) {
        this.mainDesc = desc;
        this.setProgressTipCache(desc);
    }

    public void swithToAsyn() {
        if (this.isInit()) {
            return;
        }
        if (this.isBeginTrans()) {
            return;
        }
        if (!this.isSupportAysn()) {
            return;
        }
        if (this.isAysnThread()) {
            return;
        }
        InteractionContext interactionContext = new InteractionContext();
        interactionContext.setCustShowFormId("bos_bigdataopexecuter");
        interactionContext.getCustShowParameter().put("entitynumber", this.entityNumber);
        interactionContext.getCustShowParameter().put("opkey", this.opKey);
        interactionContext.getCustShowParameter().put("operateoption", SerializationUtils.toJsonString((Object)this.operateOption.getVariables()));
        throw new KDOpAsynExecutorException("bos_bigdata_aysn", interactionContext);
    }

    public void feedbackProgress(String desc) {
        if (StringUtils.isBlank((CharSequence)desc)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.mainDesc)) {
            this.setProgressTipCache(desc);
        } else {
            this.setProgressTipCache(this.mainDesc + ": " + desc);
        }
    }

    private void setProgressTipCache(String desc) {
        String taskId = this.operateOption.getVariableValue("bos_op_taskid", "");
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        OperateProgressCache.setProgressTip((String)taskId, (String)desc);
    }
}

