/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.bizrule.asyncbizrule;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.bizrule.asyncbizrule.AbstractAsyncMService;
import kd.bos.entity.operate.bizrule.asyncbizrule.AsyncOpBizRuleServiceMsgInfo;
import kd.bos.entity.operate.bizrule.asyncbizrule.AsyncServiceParam;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.AsyncOpBizRuleActionService;
import kd.bos.service.operation.bizrule.asyncbizrule.AsyncServicePublishHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AsyncOpBizRuleActionServiceImpl
implements AsyncOpBizRuleActionService {
    private static final String ASYNC_STATUS = "asyncstatus";
    private static final String SPAN_TYPE_NAME = "asyncopbizrule";

    public String setAsyncLogID(String serviceMessageInfoSer) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"AsyncOpBizRuleActionServiceImpl.setAsyncLogID");){
            AsyncOpBizRuleServiceMsgInfo msgInfo = (AsyncOpBizRuleServiceMsgInfo)SerializationUtils.deSerializeFromBase64((String)serviceMessageInfoSer);
            try (TXHandle h = TX.requiresNew();){
                try {
                    this.setAsyncLogID(msgInfo);
                }
                catch (Throwable e1) {
                    h.markRollback();
                    throw e1;
                }
            }
            String string = serviceMessageInfoSer = SerializationUtils.serializeToBase64((Object)msgInfo);
            return string;
        }
    }

    public void publishMsg(String serviceMessageInfoSer) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"AsyncOpBizRuleActionServiceImpl.publishMsg");){
            AsyncOpBizRuleServiceMsgInfo msgInfo = (AsyncOpBizRuleServiceMsgInfo)SerializationUtils.deSerializeFromBase64((String)serviceMessageInfoSer);
            AsyncServicePublishHelper.publishMsg(msgInfo);
        }
    }

    public void execute(String serviceMessageInfoSer, String asyncParamSer) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"AsyncOpBizRuleActionServiceImpl.execute");){
            AsyncOpBizRuleServiceMsgInfo msgInfo = (AsyncOpBizRuleServiceMsgInfo)SerializationUtils.deSerializeFromBase64((String)serviceMessageInfoSer);
            AsyncServiceParam asyncParam = (AsyncServiceParam)SerializationUtils.deSerializeFromBase64((String)asyncParamSer);
            AbstractAsyncMService asyncMService = this.createAsyncMService(msgInfo, asyncParam);
            try (EntityTraceSpan span2 = EntityTracer.create((String)SPAN_TYPE_NAME, (String)(asyncMService.getClass().getName() + ".execute"));){
                asyncMService.execute();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void setAsyncLogID(AsyncOpBizRuleServiceMsgInfo msgInfo) {
        DynamicObject[] logDycs;
        ArrayList<String> asycBillIds = new ArrayList<String>(msgInfo.getAsycParams().size());
        for (AsyncServiceParam asycParam : msgInfo.getAsycParams()) {
            asycBillIds.add(asycParam.getBillID().toString());
        }
        QFilter logFilter = new QFilter("billid", "in", asycBillIds);
        logFilter.and("entity", "=", (Object)msgInfo.getEntity());
        logFilter.and("operator", "=", (Object)msgInfo.getOperator());
        logFilter.and("oprulekey", "=", (Object)msgInfo.getOpRuleKey());
        HashMap<String, DynamicObject> billLogMap = new HashMap<String, DynamicObject>(msgInfo.getAsycParams().size());
        for (DynamicObject logDyc : logDycs = BusinessDataServiceHelper.load((String)"bos_log_asyncop", (String)"id,billid,success,consume", (QFilter[])new QFilter[]{logFilter})) {
            billLogMap.put(logDyc.getString("billid"), logDyc);
        }
        ArrayList<DynamicObject> newLogDycs = new ArrayList<DynamicObject>(msgInfo.getAsycParams().size() - billLogMap.size());
        for (AsyncServiceParam asycParam : msgInfo.getAsycParams()) {
            DynamicObject logDyc;
            logDyc = (DynamicObject)billLogMap.get(asycParam.getBillID().toString());
            Long logID = 0L;
            if (logDyc != null) {
                logID = (Long)logDyc.getPkValue();
            }
            if (logID == null || logID.equals(0L)) {
                logID = DB.genLongId((String)"bos_log_asyncop");
                DynamicObject newLogDyc = this.createLogDyc(msgInfo, asycParam);
                newLogDyc.set("id", (Object)logID);
                newLogDycs.add(newLogDyc);
                asycParam.setLogID(logID);
                continue;
            }
            asycParam.setLogID(logID);
            logDyc.set("success", (Object)Boolean.FALSE);
            logDyc.set("consume", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])newLogDycs.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])logDycs);
    }

    private DynamicObject createLogDyc(AsyncOpBizRuleServiceMsgInfo msgInfo, AsyncServiceParam param) {
        DynamicObject logDyc = BusinessDataServiceHelper.newDynamicObject((String)"bos_log_asyncop");
        logDyc.set("entity", (Object)msgInfo.getEntity());
        logDyc.set("billid", (Object)param.getBillID().toString());
        logDyc.set("billno", (Object)param.getBillNo());
        logDyc.set("exetime", (Object)new Date());
        logDyc.set("operator", (Object)msgInfo.getOperator());
        logDyc.set("operatorname", (Object)msgInfo.getOperatorName());
        logDyc.set("oprulekey", (Object)msgInfo.getOpRuleKey());
        logDyc.set("oprulename", (Object)msgInfo.getOpRuleName());
        logDyc.set("org", (Object)param.getOrgID());
        logDyc.set("success", (Object)Boolean.FALSE);
        logDyc.set("consume", (Object)Boolean.FALSE);
        return logDyc;
    }

    private AbstractAsyncMService createAsyncMService(AsyncOpBizRuleServiceMsgInfo msgInfo, AsyncServiceParam param) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> asyncMServiceClass = Class.forName(msgInfo.getServiceClassName());
        AbstractAsyncMService asyncMService = (AbstractAsyncMService)asyncMServiceClass.newInstance();
        asyncMService.setBillID(param.getBillID());
        asyncMService.setCustomParamMap(param.getServiceParam());
        asyncMService.setOperateOption(msgInfo.getOperateOption());
        return asyncMService;
    }
}

