/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.bizrule.asyncbizrule;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.bizrule.asyncbizrule.AsyncOpBizRuleServiceMsgInfo;
import kd.bos.entity.operate.bizrule.asyncbizrule.AsyncServiceParam;
import kd.bos.entity.operate.bizrule.asyncbizrule.enums.AsyncStatusEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AsyncServiceMsgConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(AsyncServiceMsgConsumer.class);
    private static final String ASYNC_STATUS = "asyncstatus";
    private static final String SPAN_TYPE_NAME = "asyncopbizrule";
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-operation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"AsyncServiceMsgConsumer.onMessage");){
            AsyncOpBizRuleServiceMsgInfo msgInfo = (AsyncOpBizRuleServiceMsgInfo)message;
            logger.info("kd.bos.service.operation.bizrule.asyncbizrule.AsyncServiceMsgConsumer.onMessage-\u5f00\u59cb\u6d88\u8d39\u6d88\u606f,\u6d88\u606f\u5bf9\u8c61\u4e3a\uff1a" + msgInfo + new Date());
            List params = msgInfo.getAsycParams();
            for (AsyncServiceParam param : params) {
                DLock dlock = DLock.create((String)(msgInfo.getEntity() + param.getBillNo()), (String)ResManager.loadKDString((String)"\u5f02\u6b65\u670d\u52a1\u5355\u636e\u5206\u5e03\u5f0f\u9501", (String)"AsyncServiceMsgConsumer_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
                Throwable throwable = null;
                try {
                    dlock.lock();
                    this.invokeAsyncService(msgInfo, param);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dlock == null) continue;
                    if (throwable != null) {
                        try {
                            dlock.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dlock.close();
                }
            }
            logger.info("kd.bos.service.operation.bizrule.asyncbizrule.AsyncServiceMsgConsumer.onMessage-\u5b8c\u6210\u6d88\u8d39\u6d88\u606f" + new Date());
        }
        catch (Exception e) {
            logger.info("kd.bos.service.operation.bizrule.asyncbizrule.AsyncServiceMsgConsumer.onMessage-\u6d88\u606f\u6d88\u8d39\u5f02\u5e38" + e.getMessage() + new Date());
        }
        finally {
            acker.ack(messageId);
        }
    }

    private void invokeAsyncService(AsyncOpBizRuleServiceMsgInfo msgInfo, AsyncServiceParam param) {
        DynamicObject logDyc = null;
        try (TXHandle h = TX.requiresNew();){
            try {
                logDyc = this.startLog(param);
                try (TXHandle h1 = TX.requiresNew();){
                    try {
                        logger.info("\u5f00\u59cb\u6267\u884c\uff1a" + msgInfo.getServiceClassName() + ".execute(), \u6267\u884c\u5f00\u59cb\u65f6\u95f4\uff1a" + new Date());
                        long start = System.currentTimeMillis();
                        String serviceMessageInfoSer = SerializationUtils.serializeToBase64((Object)msgInfo);
                        String asyncParamSer = SerializationUtils.serializeToBase64((Object)param);
                        DispatchServiceHelper.invokeBOSService((String)msgInfo.getAppId(), (String)"AsyncOpBizRuleActionService", (String)"execute", (Object[])new Object[]{serviceMessageInfoSer, asyncParamSer});
                        long end = System.currentTimeMillis();
                        logger.info("\u5b8c\u6210\u6267\u884c\uff1a" + msgInfo.getServiceClassName() + ".execute(), \u6267\u884c\u7ed3\u675f\u65f6\u95f4\uff1a" + new Date() + "\uff0c\u5171\u8017\u65f6\uff1a" + (end - start) + "ms");
                    }
                    catch (Exception e) {
                        logger.error("kd.bos.service.operation.bizrule.asyncbizrule.AsyncServiceMsgConsumer.invokeAsyncService-\u6d88\u606f\u6d88\u8d39\u6267\u884c\u5f02\u5e38", (Throwable)e);
                        this.recordErrorLog(logDyc, this.getErrorMsg(e), msgInfo, param);
                        h1.markRollback();
                    }
                }
                if (logDyc.getBoolean("success")) {
                    this.setBillAsyncFinished(msgInfo, param, logDyc.getPkValue());
                }
            }
            catch (Exception e) {
                this.recordErrorLog(logDyc, this.getErrorMsg(e), msgInfo, param);
                h.markRollback();
                logger.info("kd.bos.service.operation.bizrule.asyncbizrule.AsyncServiceMsgConsumer.invokeAsyncService-\u6d88\u606f\u6d88\u8d39\u5f02\u5e38" + e.getMessage() + new Date());
                logger.error((Throwable)e);
            }
        }
        if (logDyc != null) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logDyc});
        }
    }

    private void setBillAsyncFinished(AsyncOpBizRuleServiceMsgInfo msgInfo, AsyncServiceParam param, Object logID) {
        QFilter logf = new QFilter("entity", "=", (Object)msgInfo.getEntity());
        logf.and(new QFilter("billid", "=", (Object)param.getBillID().toString()));
        logf.and(new QFilter("operator", "=", (Object)msgInfo.getOperator()));
        logf.and(new QFilter("success", "=", (Object)Boolean.FALSE));
        logf.and(new QFilter("id", "<>", logID));
        boolean hasFailLog = QueryServiceHelper.exists((String)"bos_log_asyncop", (QFilter[])logf.toArray());
        if (!hasFailLog) {
            DynamicObject[] billDycs;
            for (DynamicObject billDyc : billDycs = BusinessDataServiceHelper.load((String)msgInfo.getEntity(), (String)ASYNC_STATUS, (QFilter[])new QFilter[]{new QFilter("id", "=", param.getBillID())})) {
                billDyc.set(ASYNC_STATUS, (Object)AsyncStatusEnum.FINISHED.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])billDycs);
        }
    }

    private Map<String, Object> getMserviceParamMap(AsyncOpBizRuleServiceMsgInfo msgInfo, AsyncServiceParam param) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("appid", msgInfo.getAppId());
        paramMap.put("serviceclassname", msgInfo.getServiceClassName());
        paramMap.put("serviceparam", param.getServiceParam());
        paramMap.put("operateoption", msgInfo.getOperateOption());
        return paramMap;
    }

    private DynamicObject startLog(AsyncServiceParam param) {
        Object[] selects = new String[]{"success", "consume", "param", "log", "exetime", "user", "param_tag", "log_tag"};
        DynamicObject logDyc = BusinessDataServiceHelper.loadSingle((Object)param.getLogID(), (String)"bos_log_asyncop", (String)StringUtils.join((Object[])selects, (char)','));
        logDyc.set("success", (Object)Boolean.TRUE);
        logDyc.set("consume", (Object)Boolean.TRUE);
        logDyc.set("exetime", (Object)new Date());
        logDyc.set("param_tag", (Object)"");
        logDyc.set("log_tag", (Object)"");
        logDyc.set("user", (Object)RequestContext.get().getUserId());
        return logDyc;
    }

    private void recordErrorLog(DynamicObject logDyc, String errorMsg, AsyncOpBizRuleServiceMsgInfo msgInfo, AsyncServiceParam param) {
        Map<String, Object> paramMap = this.getMserviceParamMap(msgInfo, param);
        String paramMapSer = SerializationUtils.serializeToBase64(paramMap);
        logDyc.set("param_tag", (Object)paramMapSer);
        logDyc.set("success", (Object)Boolean.FALSE);
        logDyc.set("log_tag", (Object)errorMsg);
    }

    private String getErrorMsg(Exception exception) {
        return exception.getMessage();
    }
}

