/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.bizrule.asyncbizrule;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.bizrule.asyncbizrule.AsyncOpBizRuleServiceMsgInfo;
import kd.bos.entity.operate.bizrule.asyncbizrule.AsyncServiceParam;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.service.operation.bizrule.asyncbizrule.AsyncServicePublishHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AsyncServiceReExcuteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entity");
        e.getFieldKeys().add("billid");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("operator");
        e.getFieldKeys().add("operatorname");
        e.getFieldKeys().add("oprulename");
        e.getFieldKeys().add("oprulekey");
        e.getFieldKeys().add("param_tag");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("consume");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] logDycs = e.getDataEntities();
        if (logDycs == null || logDycs.length < 1) {
            return;
        }
        this.reExcuteMService(logDycs);
    }

    private void reExcuteMService(DynamicObject[] logDycs) {
        ArrayList<AsyncOpBizRuleServiceMsgInfo> msgInfoList = new ArrayList<AsyncOpBizRuleServiceMsgInfo>(logDycs.length);
        for (DynamicObject logDyc : logDycs) {
            String operator = logDyc.getString("operator");
            String operatorName = logDyc.getString("operatorname");
            DynamicObject entityDyc = logDyc.getDynamicObject("entity");
            String formId = entityDyc == null ? "" : entityDyc.getString("number");
            String opRuleName = logDyc.getString("oprulename");
            String opRuleKey = logDyc.getString("oprulekey");
            String billIdStr = logDyc.getString("billid");
            Object billId = this.getBillID(billIdStr, formId);
            String paramMapSer = logDyc.getString("param_tag");
            Map paramMap = (Map)SerializationUtils.deSerializeFromBase64((String)paramMapSer);
            AsyncOpBizRuleServiceMsgInfo serviceMessageInfo = new AsyncOpBizRuleServiceMsgInfo(operator, operatorName, opRuleKey, opRuleName, formId);
            serviceMessageInfo.setReExecByLog(Boolean.TRUE);
            String appId = (String)paramMap.get("appid");
            String serviceName = (String)paramMap.get("serviceclassname");
            Map customParamMap = (Map)paramMap.get("serviceparam");
            OperateOption asyncOperateOption = (OperateOption)paramMap.get("operateoption");
            serviceMessageInfo.setAppId(appId);
            serviceMessageInfo.setServiceClassName(serviceName);
            serviceMessageInfo.setOperateOption(asyncOperateOption);
            AsyncServiceParam serviceParam = new AsyncServiceParam();
            serviceParam.setBillID(billId);
            serviceParam.setBillNo(logDyc.getString("billno"));
            serviceParam.setOrgID(((Long)logDyc.getDynamicObject("org").getPkValue()).longValue());
            serviceParam.setLogID((Long)logDyc.getPkValue());
            serviceParam.setServiceParam(customParamMap);
            serviceMessageInfo.getAsycParams().add(serviceParam);
            msgInfoList.add(serviceMessageInfo);
            logDyc.set("consume", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])logDycs);
        for (AsyncOpBizRuleServiceMsgInfo msgInfo : msgInfoList) {
            AsyncServicePublishHelper.publishMsg(msgInfo);
        }
    }

    private Object getBillID(String billIdStr, String formId) {
        if (StringUtils.isEmpty((CharSequence)formId)) {
            return billIdStr;
        }
        int idType = EntityMetadataCache.getDataEntityType((String)formId).getPrimaryKey().getDbType();
        Object billId = idType == -5 ? Long.valueOf(billIdStr) : (idType == 4 ? Integer.valueOf(billIdStr) : billIdStr);
        return billId;
    }
}

