/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.DifferentialControlInfo;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.FieldPos;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.entity.validate.RequiredValidator;
import kd.bos.entity.validate.ValidPromtType;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.servicehelper.BillTypeDifferentialHelper;

public class BillTypeRequiredValidator
extends AbstractValidator {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-operation";
    private Map<Long, Map<String, Map<String, IDataEntityProperty>>> mustInputFlds = null;

    public String getEntityKey() {
        return this.validateContext.getBillEntityType().getName();
    }

    public Set<String> preparePropertys() {
        Map<Long, Map<String, Map<String, IDataEntityProperty>>> flds = this.getMustInputFlds();
        if (flds == null || flds.isEmpty()) {
            return super.preparePropertys();
        }
        HashSet<String> fldKeys = new HashSet<String>();
        for (Map.Entry<Long, Map<String, Map<String, IDataEntityProperty>>> billType : flds.entrySet()) {
            for (Map.Entry<String, Map<String, IDataEntityProperty>> entity : billType.getValue().entrySet()) {
                for (Map.Entry<String, IDataEntityProperty> prop : entity.getValue().entrySet()) {
                    fldKeys.add(prop.getValue().getName());
                }
            }
        }
        return fldKeys;
    }

    public void validate() {
        if (!this.validateContext.isCheckMustInput()) {
            return;
        }
        Map<Long, Map<String, Map<String, IDataEntityProperty>>> allFlds = this.getMustInputFlds();
        if (allFlds == null || allFlds.isEmpty()) {
            return;
        }
        BillEntityType mainType = (BillEntityType)this.validateContext.getBillEntityType();
        for (ExtendedDataEntity headDataEntity : this.dataEntities) {
            this.validateSingleBill(mainType, allFlds, headDataEntity);
        }
    }

    private void validateSingleBill(BillEntityType mainType, Map<Long, Map<String, Map<String, IDataEntityProperty>>> allFlds, ExtendedDataEntity headDataEntity) {
        DynamicObject billTypeObj = (DynamicObject)headDataEntity.getValue(mainType.getBillType());
        if (billTypeObj == null) {
            return;
        }
        Long billTypeId = (Long)billTypeObj.getPkValue();
        if (!allFlds.containsKey(billTypeId)) {
            return;
        }
        Map<String, Map<String, IDataEntityProperty>> entityFlds = allFlds.get(billTypeId);
        for (Map.Entry<String, Map<String, IDataEntityProperty>> entity : entityFlds.entrySet()) {
            ExtendedDataEntity[] entityRows;
            for (ExtendedDataEntity entityRow : entityRows = this.validateContext.getExtendedDataEntitySet().FindByEntityKey(entity.getKey())) {
                if (entityRow.getDataEntityIndex() != headDataEntity.getDataEntityIndex()) continue;
                for (Map.Entry<String, IDataEntityProperty> prop : entity.getValue().entrySet()) {
                    this.validateFldValue(entityRow, prop.getValue());
                }
            }
        }
    }

    private void validateFldValue(ExtendedDataEntity dataEntity, IDataEntityProperty prop) {
        Object basedataValue;
        if (!(prop instanceof IValidatorHanlder)) {
            return;
        }
        Object fldValue = null;
        fldValue = prop instanceof BasedataProp || prop instanceof RefBillProp ? ((basedataValue = dataEntity.getValue(prop.getName())) != null ? ((DynamicObject)basedataValue).getPkValue() : null) : dataEntity.getValue(prop.getName());
        if (prop instanceof MuliLangTextProp) {
            List mustInputLang = this.validateContext.getMustInputLang();
            if (fldValue != null) {
                ArrayList<String> mustInputLan = new ArrayList<String>(5);
                for (String lan : mustInputLang) {
                    String valuelan = (String)((ILocaleString)fldValue).get((Object)lan);
                    if (!StringUtils.isBlank((CharSequence)valuelan) || mustInputLan.contains(lan)) continue;
                    mustInputLan.add(lan);
                }
                if (!mustInputLan.isEmpty()) {
                    this.addMessage(dataEntity, this.buildErrMessage(dataEntity, prop, mustInputLan), this.getErrorLevl());
                    return;
                }
            }
        }
        if (((IValidatorHanlder)prop).getValueComparator().compareValue(fldValue)) {
            String content = this.buildErrMessage(dataEntity, prop);
            this.addMessage(dataEntity, content, this.getErrorLevl());
        }
    }

    private Map<Long, Map<String, Map<String, IDataEntityProperty>>> getMustInputFlds() {
        if (this.mustInputFlds != null) {
            return this.mustInputFlds;
        }
        if (this.validateContext == null || this.validateContext.getBillEntityType() == null) {
            return null;
        }
        MainEntityType mainType = this.validateContext.getBillEntityType();
        if (!(mainType instanceof BillEntityType)) {
            return null;
        }
        this.mustInputFlds = new HashMap<Long, Map<String, Map<String, IDataEntityProperty>>>(16);
        if (StringUtils.isBlank((CharSequence)((BillEntityType)mainType).getBillType())) {
            return this.mustInputFlds;
        }
        String showscene = this.getOption().getVariableValue("showscene", "");
        boolean isMob = false;
        if (StringUtils.isNotBlank((CharSequence)showscene) && "mob".equals(showscene)) {
            isMob = true;
        }
        Map<Object, List<DifferentialControlInfo>> map = this.getDifferentialControlInfosFromCache(mainType, isMob);
        for (Map.Entry<Object, List<DifferentialControlInfo>> item : map.entrySet()) {
            this.mustInputFlds.put((Long)item.getKey(), new HashMap());
            for (DifferentialControlInfo control : item.getValue()) {
                IDataEntityProperty prop;
                if (!Boolean.TRUE.equals(control.isMustInput()) || (prop = mainType.findProperty(StringUtils.isBlank((CharSequence)control.getEntityFieldKey()) ? control.getFieldKey() : control.getEntityFieldKey())) == null) continue;
                List fldValidators = new ArrayList(0);
                if (prop instanceof IValidatorHanlder) {
                    fldValidators = ((IValidatorHanlder)prop).getValidators();
                }
                boolean mustInput = false;
                for (AbstractValidator v : fldValidators) {
                    if (!(v instanceof RequiredValidator)) continue;
                    mustInput = true;
                    break;
                }
                if (mustInput) continue;
                if (!this.mustInputFlds.get(item.getKey()).containsKey(prop.getParent().getName())) {
                    this.mustInputFlds.get(item.getKey()).put(prop.getParent().getName(), new HashMap());
                }
                this.mustInputFlds.get(item.getKey()).get(prop.getParent().getName()).put(prop.getName(), prop);
            }
        }
        return this.mustInputFlds;
    }

    protected Map<Object, List<DifferentialControlInfo>> getDifferentialControlInfosFromCache(MainEntityType mainType) {
        return this.getDifferentialControlInfosFromCache(mainType, false);
    }

    protected Map<Object, List<DifferentialControlInfo>> getDifferentialControlInfosFromCache(MainEntityType mainType, boolean isMob) {
        return BillTypeDifferentialHelper.getRuntimeDiffControlInfosFromCache((String)mainType.getName(), (boolean)isMob);
    }

    protected String buildErrMessage(ExtendedDataEntity extDataEntity, IDataEntityProperty prop) {
        String fieldName;
        LocaleString propDisplayName = prop.getDisplayName();
        String string = fieldName = propDisplayName == null ? prop.getName() : propDisplayName.toString();
        if (prop.getParent() instanceof EntryType) {
            EntryType entryType = (EntryType)prop.getParent();
            if (prop instanceof SubEntryProp) {
                String entryName = entryType.getParent().getDisplayName().toString();
                String subEntryName = entryType.getDisplayName().toString();
                return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\u201c%3$s\u201d\u3002", (String)"BillTypeRequiredValidator_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), entryType.getDisplayName().toString(), extDataEntity.getRowIndex() + 1, fieldName);
            }
            return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\u201c%3$s\u201d\u5b57\u6bb5\u3002", (String)"BillTypeRequiredValidator_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), entryType.getDisplayName().toString(), extDataEntity.getRowIndex() + 1, fieldName);
        }
        return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"BillTypeRequiredValidator_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), fieldName);
    }

    protected String buildErrMessage(ExtendedDataEntity extDataEntity, IDataEntityProperty prop, List<String> langBillParams) {
        String errorMsg;
        String fieldName;
        String promptLang = ValidateContext.switchLang(langBillParams);
        LocaleString propDisplayName = prop.getDisplayName();
        String string = fieldName = propDisplayName == null ? prop.getName() : propDisplayName.toString();
        if (prop.getParent() instanceof EntryType) {
            EntryType entryType = (EntryType)prop.getParent();
            if (prop instanceof SubEntryProp) {
                String entryName = entryType.getParent().getDisplayName().toString();
                String subEntryName = entryType.getDisplayName().toString();
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\u201c%3$s\u201d\u7684\u201c%4$s\u201d\u503c\u3002", (String)"BillTypeRequiredValidator_3", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), entryType.getDisplayName().toString(), extDataEntity.getRowIndex() + 1, fieldName, promptLang);
            } else {
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\u201c%3$s\u201d\u5b57\u6bb5\u7684\u201c%4$s\u201d\u503c\u3002", (String)"BillTypeRequiredValidator_4", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), entryType.getDisplayName().toString(), extDataEntity.getRowIndex() + 1, fieldName, promptLang);
                String fieldTips = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u503c\u3002", (String)"BillTypeRequiredValidator_5", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), fieldName, promptLang);
                FieldPos fieldPos = new FieldPos(entryType.getName(), extDataEntity.getRowIndex(), prop.getName(), fieldTips, ValidPromtType.NOT_NULL.getType(), this.getValidatorId());
                fieldPos.setFullMsg(errorMsg);
                this.addPromptInfo(fieldPos);
            }
        } else {
            errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u503c\u3002", (String)"BillTypeRequiredValidator_5", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), fieldName, promptLang);
            this.addPromptInfo(new FieldPos(prop.getName(), errorMsg, ValidPromtType.NOT_NULL.getType(), this.getValidatorId()));
        }
        return errorMsg;
    }
}

