/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.GroupFieldsUniqueValidateResult;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.entity.validate.IValueComparator;
import kd.bos.service.operation.validate.GrpFieldsUniqueValidator;
import kd.bos.service.operation.validate.ICheckSampleMasterId;
import kd.bos.service.operation.validate.ICheckSampleOrgID;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MasterIdUniqueValidator
extends GrpFieldsUniqueValidator {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-operation";
    private BasedataEntityType mainType;
    private List<String> fields = null;
    private MasterBasedataProp masteridProp = null;
    private BasedataEntityType refMasterBDType = null;
    private ICheckSampleMasterId checkSampleMasterId = null;
    private ICheckSampleOrgID checkSampleOrgID = null;
    private String errMsg_MustInput = "";
    private String errMsg_SampleMasterId = ResManager.loadKDString((String)"\u53ea\u80fd\u5f15\u7528\u539f\u59cb\u521b\u5efa\u7684\u4e3b\u8d44\u6599\uff0c\u4e0d\u80fd\u5f15\u7528\u5206\u914d\u540e\u7684\u4e2a\u6027\u5316\u6570\u636e", (String)"MasterIdUniqueValidator_0", (String)"bos-mservice-operation", (Object[])new Object[0]);

    public BasedataEntityType getMainType() {
        return this.mainType;
    }

    public void setMainType(BasedataEntityType mainType) {
        this.mainType = mainType;
    }

    public ErrorLevel getErrorLevl() {
        return ErrorLevel.FatalError;
    }

    @Override
    protected boolean isIgnoreDB() {
        return false;
    }

    @Override
    protected boolean isIgnoreBlank() {
        return true;
    }

    @Override
    protected LocaleString getValidateDesc() {
        return new LocaleString(ResManager.loadKDString((String)"\u4e3b\u6570\u636e\u5185\u7801\u91cd\u590d\u6027\u6821\u9a8c", (String)"MasterIdUniqueValidator_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
    }

    @Override
    protected List<String> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
            this.fields.add(this.mainType.getMasteridPropName());
            if (StringUtils.isNotBlank((CharSequence)this.mainType.getMainOrg())) {
                this.fields.add(this.mainType.getMainOrg());
            }
        }
        return this.fields;
    }

    @Override
    public void initializeConfiguration() {
        super.initializeConfiguration();
        IDataEntityProperty prop = this.mainType.findProperty(this.mainType.getMasteridPropName());
        if (prop instanceof MasterBasedataProp) {
            this.masteridProp = (MasterBasedataProp)prop;
            this.refMasterBDType = this.buildSubRefMasterBDType();
            this.errMsg_MustInput = String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c%s\u201d", (String)"MasterIdUniqueValidator_3", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), this.masteridProp.getDisplayName().toString());
            this.checkSampleMasterId = ICheckSampleMasterId.get(this.refMasterBDType);
            this.checkSampleOrgID = ICheckSampleOrgID.get(this.mainType, this.refMasterBDType);
        }
    }

    @Override
    public void validate() {
        super.validate();
        this.validateMasterid();
    }

    @Override
    protected boolean checkAData() {
        return true;
    }

    private void validateMasterid() {
        IValueComparator valueComparator;
        if (this.masteridProp == null) {
            return;
        }
        IDataEntityProperty refidProp = this.masteridProp.getRefIdProp();
        IValueComparator iValueComparator = valueComparator = this.masteridProp instanceof IValidatorHanlder ? this.masteridProp.getValueComparator() : null;
        if (valueComparator == null) {
            return;
        }
        boolean reloadMasterObj = false;
        if (StringUtils.isNotBlank((CharSequence)this.refMasterBDType.getMasteridPropName()) && !this.masteridProp.getComplexType().getProperties().containsKey((Object)this.refMasterBDType.getMasteridPropName())) {
            reloadMasterObj = true;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (dataEntity.getDataEntity().getDataEntityState().getFromDatabase()) continue;
            DynamicObject masterObj = (DynamicObject)this.masteridProp.getValue((Object)dataEntity.getDataEntity());
            Object masterid = refidProp.getValue((Object)dataEntity.getDataEntity());
            if (valueComparator.compareValue(masterid) || masterObj == null) {
                ((GroupFieldsUniqueValidateResult)this.validateResult).setShowUniqueResult(false);
                this.addMessage(dataEntity, this.errMsg_MustInput);
                continue;
            }
            if (reloadMasterObj) {
                masterObj = BusinessDataServiceHelper.loadSingleFromCache((Object)masterid, (DynamicObjectType)this.refMasterBDType);
            }
            if (this.checkSampleMasterId.validate(masterObj)) continue;
            this.addMessage(dataEntity, this.errMsg_SampleMasterId);
        }
    }

    private BasedataEntityType buildSubRefMasterBDType() {
        BasedataEntityType refBDType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)this.masteridProp.getBaseEntityId());
        ArrayList<String> refFields = new ArrayList<String>();
        refFields.add("id");
        if (StringUtils.isNotBlank((CharSequence)refBDType.getMainOrg())) {
            refFields.add(refBDType.getMainOrg());
        }
        if (refBDType.getMasteridType() != 0 && StringUtils.isNotBlank((CharSequence)refBDType.getMasteridPropName())) {
            refFields.add(refBDType.getMasteridPropName());
        }
        BasedataEntityType bdType = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)this.masteridProp.getBaseEntityId(), refFields);
        return bdType;
    }
}

