/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.entity.validate.RequiredValidator;
import kd.bos.entity.validate.ScopeValidator;
import kd.bos.entity.validate.SingleFieldValidator;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.service.ServiceFactory;
import kd.bos.service.operation.validate.BillLayoutRequiredValidator;
import kd.bos.service.operation.validate.BillTypeRequiredValidator;
import kd.bos.service.operation.validate.ValidationService;

public class MustInputValidator
extends AbstractValidator {
    static final String PARAM_SKIP_MUST_INPUT = "SkipMustInput";
    static final String PARAM_SKIP_TEXT_LENGTH = "SkipTextLength";
    static final String PARAM_SKIP_DATA_SCAPE = "SkipDataScape";
    private boolean fromEdit = true;
    private Boolean skipMustInput;
    private Boolean skipTextLength;
    private Boolean skipDataScape;

    private boolean isSkipBillNoValidator() {
        return this.getOption() != null && Boolean.parseBoolean(this.getOption().getVariableValue("skipbillnovalidator", String.valueOf(false)));
    }

    private boolean isSkipMustInput() {
        if (this.skipMustInput == null) {
            Object param_SkipMustInput = this.getValidation().get(PARAM_SKIP_MUST_INPUT);
            this.skipMustInput = StringUtils.isBlank(param_SkipMustInput) ? Boolean.valueOf(false) : Boolean.valueOf(param_SkipMustInput.toString());
        }
        return this.skipMustInput;
    }

    private boolean isSkipTextLength() {
        if (this.skipTextLength == null) {
            Object param_skipTextLength = this.getValidation().get(PARAM_SKIP_TEXT_LENGTH);
            this.skipTextLength = StringUtils.isBlank(param_skipTextLength) ? Boolean.valueOf(false) : Boolean.valueOf(param_skipTextLength.toString());
        }
        return this.skipTextLength;
    }

    private boolean isSkipDataScape() {
        if (this.skipDataScape == null) {
            Object param_skipDataScape = this.getValidation().get(PARAM_SKIP_DATA_SCAPE);
            this.skipDataScape = StringUtils.isBlank(param_skipDataScape) ? Boolean.valueOf(false) : Boolean.valueOf(param_skipDataScape.toString());
        }
        return this.skipDataScape;
    }

    private boolean isCheckPoint(AbstractValidator validator) {
        if (!(validator instanceof SingleFieldValidator)) {
            return true;
        }
        SingleFieldValidator fieldValidator = (SingleFieldValidator)validator;
        if (this.isSkipMustInput() && fieldValidator instanceof RequiredValidator) {
            return false;
        }
        if (this.isSkipTextLength() && fieldValidator instanceof ScopeValidator && fieldValidator.getvProperty() instanceof TextProp) {
            return false;
        }
        if (this.isSkipDataScape() && fieldValidator instanceof ScopeValidator && fieldValidator.getvProperty() instanceof DecimalProp) {
            return false;
        }
        return this.fromEdit || (fieldValidator.getCheckPoint() & 2) == 2;
    }

    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        this.fromEdit = false;
        if (this.validateContext != null && this.validateContext.getBillEntityType() != null) {
            MainEntityType mainType = this.getValidateContext().getBillEntityType();
            List<AbstractValidator> requiredValidators = this.buildFieldDefaultValidators((IDataEntityType)mainType);
            if (LayoutControlInfo.isBillTypeLayout()) {
                BillTypeRequiredValidator billTypeRequiredValidator = new BillTypeRequiredValidator();
                requiredValidators.add(billTypeRequiredValidator);
            } else {
                BillLayoutRequiredValidator layoutValidator = new BillLayoutRequiredValidator();
                requiredValidators.add(layoutValidator);
            }
            for (AbstractValidator v : requiredValidators) {
                v.setValidateContext(this.validateContext);
                Set fieldKeys = v.preparePropertys();
                set.addAll(fieldKeys);
            }
        }
        return set;
    }

    public void validate() {
        MainEntityType subMainType = this.validateContext.getSubEntityType();
        List<AbstractValidator> requiredValidators = this.buildFieldDefaultValidators((IDataEntityType)subMainType);
        if (LayoutControlInfo.isBillTypeLayout()) {
            BillTypeRequiredValidator billTypeRequiredValidator = new BillTypeRequiredValidator();
            requiredValidators.add(billTypeRequiredValidator);
        } else {
            BillLayoutRequiredValidator layoutValidator = new BillLayoutRequiredValidator();
            requiredValidators.add(layoutValidator);
        }
        for (AbstractValidator v : requiredValidators) {
            ValidationService.setValidateContext(this.getValidateContext(), v);
            if (v.getDataEntities() == null || v.getDataEntities().length == 0) continue;
            v.validate();
            ValidateResult res = v.getValidateResult();
            if (res.isSuccess()) continue;
            for (OperateErrorInfo operateInfo : res.getAllErrorInfo()) {
                this.validateResult.addErrorInfo(operateInfo);
            }
            this.validateResult.addPromptField(res.getPromptField());
            res.getPromptField().clear();
        }
    }

    private List<AbstractValidator> buildFieldDefaultValidators(IDataEntityType entityType) {
        ArrayList<AbstractValidator> defaultValidators = new ArrayList<AbstractValidator>();
        String billNoPropName = this.getValidateContext().getBillEntityType() instanceof BillEntityType ? ((BillEntityType)this.getValidateContext().getBillEntityType()).getBillNo() : null;
        for (IDataEntityProperty prop : entityType.getProperties()) {
            if (prop instanceof IValidatorHanlder) {
                IValidatorHanlder validatorHanlder = (IValidatorHanlder)prop;
                List validators = validatorHanlder.getValidators();
                for (AbstractValidator validator : validators) {
                    ICodeRuleService codeRuleService;
                    List rules;
                    if (!this.isCheckPoint(validator) || validator instanceof RequiredValidator && StringUtils.equals((CharSequence)billNoPropName, (CharSequence)prop.getName()) && this.isSkipBillNoValidator() && !(rules = (codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class)).getAllCodeRuleByEntity(this.getValidateContext().getBillEntityType().getName())).isEmpty()) continue;
                    validator.setEntityKey(entityType.getName());
                    validator.setOperateKey(this.validateContext.getOperateKey());
                    validator.setOperateType(this.validateContext.getOperateType());
                    validator.setOperationName(this.validateContext.getOperateName());
                    validator.setValidation(this.getValidation());
                    validator.setErrorLevel(this.getErrorLevl());
                    defaultValidators.add(validator);
                }
            }
            if (!(prop instanceof EntryProp)) continue;
            IDataEntityType refItemType = ((ICollectionProperty)prop).getItemType();
            defaultValidators.addAll(this.buildFieldDefaultValidators(refItemType));
        }
        return defaultValidators;
    }
}

