/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.ObjLongConsumer;
import kd.bos.base.parameter.ParameterService;
import kd.bos.bill.BillShowParameter;
import kd.bos.ca.ICAConfigService;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.entity.gray.MetaGrayInfo;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.FormConfigParam;
import kd.bos.exception.ErrorPageCode;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.instance.Instance;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mc.webclient.WebClientFiles;
import kd.bos.metagray.MetaGrayService;
import kd.bos.mvc.ListenTimerElapsedCache;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.cache.RootPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.permission.api.PermissionService;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionKeys;
import kd.bos.session.SessionQuery;
import kd.bos.tenant.TenantInfo;
import kd.bos.url.UrlService;
import kd.bos.util.HttpClientUtils;
import kd.bos.utils.DbTypeConverter;
import kd.bos.utils.LogPrintUtil;
import kd.bos.utils.SecurityTypeEnum;
import kd.bos.utils.TabLayoutUtil;

public class FormConfigFactory {
    private static final Log log = LogFactory.getLog((String)"FormView");
    private static final String SPAN_TYPE_NAME = "configfactory";
    private static final String CANCEL = "cancel";
    private static final String ERRORCODE = "errorCode";
    private static final String CANCEL_MESSAGE = "cancelMessage";
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private static final String IS_USER_GUIDE = "isUserGuide";
    private static final String FORM_PAGECACHE = "form-pagecache";
    private static final String SPECIALDATARULEDISABLE = "specialDataRuleDisable.on";
    private static final String PERM_IGNORE_CHECKAPP = "PERM_IGNORE_CHECKAPP";
    public static final String ConvPageCacheKey_ConvertOperationResult = "ConvertOperationResult";
    private static final String ICONFONT_ = "_iconfont_";
    private static final String MC_ICONFONT_DATA_ = "_mcIconfontData_";
    private static final String _TABLAYOUT = "_tablayout";
    private static final String MINOR_VERSION = "minorVersion";
    private static final int TABLAYOUT_CACHE_TIMEOUT = 36000;
    private static ICAConfigService caConfigService;
    private static DistributeSessionlessCache iconfontcache;
    private static Map<String, String> tableStyleColumnMap;

    public static Map<String, Object> createConfig(Map<String, Object> openParameter) {
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
        return FormConfigFactory.createConfig(showParameter);
    }

    public static Map<String, Object> createConfig(FormShowParameter showParameter) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"createConfig");){
            String appId = showParameter.getServiceAppId();
            if (StringUtils.isBlank((CharSequence)appId) && AppGroupUtils.isGrayGroup()) {
                appId = showParameter.getAppId();
            }
            appId = FormConfigFactory.getAppId(appId, showParameter);
            if (AppGroupUtils.isOutLog()) {
                try {
                    StringBuilder sb = new StringBuilder();
                    StackTraceElement[] stes = Thread.currentThread().getStackTrace();
                    int size = stes.length > 50 ? 50 : stes.length;
                    for (int i = 1; i < size; ++i) {
                        sb.append("\n\tat ").append(stes[i]);
                    }
                    log.info("traceId:{}, appid:{}, showParameter.getAppId:{}, showParameter.formId:{}, stack:{}", new Object[]{RequestContext.get().getTraceId(), appId, showParameter.getAppId(), showParameter.getFormId(), sb.toString()});
                }
                catch (Exception e) {
                    log.error("FormConfigFactory.createConfig log error.");
                }
            }
            Map map = (Map)DispatchServiceHelper.invokeBOSService((String)(appId == null ? "bos" : appId), (String)"FormService", (String)"createConfig", (Object[])new Object[]{showParameter});
            PageCache pageCache = new PageCache(showParameter.getPageId());
            SessionManager.getCurrent().putPageCacheInMemory(pageCache);
            Map map2 = map;
            return map2;
        }
    }

    public static Map<String, Object> createConfigInCurrentAppService(FormShowParameter showParameter) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"createConfigInCurrentAppService");){
            Boolean ls = (Boolean)showParameter.getCustomParam("_noloadsetting_");
            Map<String, Object> setting = ls != null && ls != false ? new HashMap<String, Object>() : FormConfigFactory.getSetting(showParameter);
            Map ret = showParameter.createClientConfig(setting);
            if (ret.get(CANCEL) != null) {
                Map map = ret;
                return map;
            }
            ret.put("setting", setting);
            FormConfigFactory.checkProductModelRight(showParameter, ret);
            FormConfigFactory.checkShowFormRight(showParameter, ret);
            if (ret.get(CANCEL) != null) {
                Map map = ret;
                return map;
            }
            ret.put("licenseType", LicenseServiceHelper.getLicenseType());
            FormConfigFactory.setUserGuide(showParameter, ret);
            if (showParameter.getPageId().equals(showParameter.getRootPageId())) {
                ret.putAll(FormConfigFactory.createRootPageConfigInfo());
                ret.put("showTrayMenu", !"home_page".equalsIgnoreCase(showParameter.getFormId().trim()));
            }
            IPageCache cache = SessionManager.getCurrent().getPageCache(showParameter.getPageId());
            if ("pc_main_console".equalsIgnoreCase(showParameter.getFormId().trim()) || "home_page".equalsIgnoreCase(showParameter.getFormId().trim())) {
                SessionManager.getCurrent().putMainPageId(showParameter.getRootPageId(), showParameter.getPageId());
            }
            if (showParameter.isListentimerElapsed() && !showParameter.getPageId().equals(showParameter.getRootPageId())) {
                ListenTimerElapsedCache.addTimerElapsedListener(showParameter.getRootPageId(), showParameter.getPageId());
            }
            RootPageCache.addPageId(showParameter.getRootPageId(), showParameter.getPageId());
            RootPageCache.addPageIdWithPid(showParameter.getRootPageId(), showParameter.getParentPageId(), showParameter.getPageId());
            showParameter.setCacheExpireTime(System.currentTimeMillis());
            cache.put(FormShowParameter.class.getSimpleName(), showParameter.toString());
            cache.saveChanges();
            Object previewLang = showParameter.getCustomParam("formConfigShowLang");
            ret.put("lang", previewLang == null ? RequestContext.get().getLang().toString() : previewLang.toString());
            if (StringUtils.isNotBlank((CharSequence)showParameter.getShareId())) {
                ret.put("allFormStatus", "view");
            }
            FormConfigFactory.updateTabLayout(ret);
            Map map = ret;
            return map;
        }
    }

    public static Map<String, Object> createRootPageConfigInfo() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"createRootPageConfigInfo");){
            Map<String, Object> tableStyleMap;
            Map<String, String> iconfontMap;
            HashMap<String, Object> ret = new HashMap<String, Object>(30);
            Long userID = 0L;
            String userIDStr = RequestContext.get().getUserId();
            try {
                userID = Long.parseLong(userIDStr);
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
            Map result = UserServiceHelper.getUserThemeNumAndVer((Long)userID);
            ret.put("themeNum", result.get("themeNum"));
            ret.put("themeName", result.get("themeName"));
            ret.put("themeVer", result.get("themeVer"));
            AppCache.get((String)"bos").put("theme" + userID, (Object)SerializationUtils.toJsonString((Object)result));
            ret.put("themeInfo", UserServiceHelper.getUserThemeNumAndVerNew((Long)userID));
            ret.put("showTrayMenu", !ParameterService.isSupportNewPortal());
            RequestContext rc = RequestContext.get();
            TenantInfo tenantInfo = AccountUtils.getTenantByid((String)rc.getTenantId());
            Account accountInfo = AccountUtils.getAccountById((String)rc.getAccountId());
            ret.put("userId", rc.getUserId());
            ret.put("userOpenId", rc.getUserOpenId());
            ret.put("eid", FormConfigFactory.getCurrentUserEid());
            ret.put("tenantId", tenantInfo.getId());
            ret.put("tenantName", tenantInfo.getName());
            ret.put("instanceNumber", tenantInfo.getInstanceNumber());
            ret.put("joinImprovement", tenantInfo.isJoinImprovement());
            ret.put("cookieName", SessionKeys.getGlobalCookieSessionkey((String)tenantInfo.getId(), (String)accountInfo.getAccountId()));
            ret.put("accountId", rc.getAccountId());
            ret.put("accountName", accountInfo.getAccountName());
            FormConfigParam configParam = SystemParamServiceHelper.getConfig();
            ret.put("sysParam", configParam);
            Map<String, Object> configParams = FormConfigFactory.loadDevpotalParam();
            Object durationConfig = configParams.get("showtipduration");
            if (durationConfig instanceof Integer) {
                int duration = (Integer)durationConfig * 1000;
                ret.put("notificationDuration", duration);
            }
            ret.put("langSetting", FormConfigFactory.getLangSetting());
            ret.put("domainUrl", UrlService.getDomainContextUrl());
            boolean enableHotkey = Boolean.parseBoolean(System.getProperty("ide.globalhotkeys.enable", "true"));
            if (!enableHotkey) {
                ret.put("enableGlobalHotkeys", enableHotkey);
            }
            if (!CollectionUtils.isEmpty(iconfontMap = FormConfigFactory.getIconfontInfoMap())) {
                ret.put("iconfont", iconfontMap);
            }
            if (!CollectionUtils.isEmpty(tableStyleMap = FormConfigFactory.getTableStyleMap())) {
                ret.put("tableSetting", tableStyleMap);
            }
            ret.putAll(FormConfigFactory.getCaConfig());
            HashMap<String, Object> hashMap = ret;
            return hashMap;
        }
    }

    private static Map<String, Object> loadDevpotalParam() {
        AppParam param = new AppParam();
        param.setAppId("83bfebc800003dac");
        param.setViewType("15");
        param.setOrgId(Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param);
    }

    private static Map<String, Object> getTableStyleMap() {
        try {
            Object tableallenable;
            Long userId = RequestContext.get().getCurrUserId();
            QFilter filter = new QFilter("userid", "=", (Object)userId);
            DynamicObject userConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user_params_config", (QFilter[])new QFilter[]{filter});
            if (userConfig != null && (tableallenable = userConfig.get("tableallenable")) != null && "true".equals(tableallenable.toString())) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                tableStyleColumnMap.forEach((key, param) -> {
                    Object value = userConfig.get(key);
                    if (value != null && StringUtils.isNotEmpty((CharSequence)value.toString())) {
                        map.put((String)param, value);
                    }
                });
                return map;
            }
        }
        catch (Exception e) {
            log.error("getTableStyleMap error", (Throwable)e);
        }
        return null;
    }

    private static Map<String, Object> getCaConfig() {
        if (caConfigService == null) {
            try {
                caConfigService = (ICAConfigService)TypesContainer.getOrRegisterSingletonInstance((String)"kd.bos.ca.CAConfigServiceImpl");
            }
            catch (Exception e) {
                log.error("CA\u53c2\u6570\u83b7\u53d6\u5931\u8d25", (Throwable)e);
                return new HashMap<String, Object>();
            }
        }
        return caConfigService.getCaConfig();
    }

    private static Map<String, String> getIconfontInfoMap() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"getIconfontInfoMap");){
            String iconfontData;
            RequestContext rc;
            HashMap<String, String> map;
            block23: {
                map = new HashMap<String, String>(2);
                rc = RequestContext.get();
                iconfontData = FormConfigFactory.getMcIconfontData(rc.getTenantId(), "_tenant_iconfont_config_files_");
                if (span.isRealtime()) {
                    span.addTag("iconfontInfo", iconfontData);
                }
                if (!StringUtils.isBlank((CharSequence)iconfontData) && !"null".equals(iconfontData)) break block23;
                Map<String, String> map2 = null;
                return map2;
            }
            try {
                String cssUrl;
                String json;
                List dataList = (List)SerializationUtils.fromJsonString((String)iconfontData, List.class);
                Map dataMap = (Map)dataList.get(0);
                String time = (String)dataMap.get("time");
                String dir = (String)dataMap.get("dir");
                if (dir != null && !dir.endsWith("/")) {
                    dir = dir + dir + "/";
                }
                String beforeTime = "";
                Map iconfontMapCache = new HashMap();
                String iconfontStr = (String)iconfontcache.get(FormConfigFactory.getIconFontKey(ICONFONT_));
                if (iconfontStr != null) {
                    iconfontMapCache = (Map)SerializationUtils.fromJsonString((String)iconfontStr, Map.class);
                    beforeTime = (String)iconfontMapCache.get("iconfontTime");
                }
                if (StringUtils.isNotBlank((CharSequence)beforeTime) && beforeTime.equals(time)) {
                    json = (String)iconfontMapCache.get("iconfontJson");
                    cssUrl = (String)iconfontMapCache.get("iconfontCss");
                } else {
                    cssUrl = "./isv/" + FormConfigFactory.getISVFromWebClientFiles() + "/iconfont/" + dir + "iconfont.css?v=" + time;
                    String jsonUrl = "isv/" + FormConfigFactory.getISVFromWebClientFiles() + "/iconfont/" + dir + "iconfont.json?v=" + time;
                    json = HttpClientUtils.get((String)(rc.getClientFullContextPath() + jsonUrl));
                    HashMap<String, String> iconfontMap = new HashMap<String, String>();
                    iconfontMap.put("iconfontTime", time);
                    iconfontMap.put("iconfontJson", json);
                    iconfontMap.put("iconfontCss", cssUrl);
                    iconfontcache.put(FormConfigFactory.getIconFontKey(ICONFONT_), (Object)SerializationUtils.toJsonString(iconfontMap), Integer.MAX_VALUE);
                }
                map.put("iconfontCssUrl", cssUrl);
                map.put("iconfontJson", json);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5b57\u4f53\u56fe\u6807\u51fa\u9519", (Throwable)e);
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getMcIconfontData(String tenantId, String key) throws Exception {
        String iconFont = FormConfigFactory.getIconFontKey(MC_ICONFONT_DATA_);
        String iconfontData = (String)iconfontcache.get(iconFont);
        if (!StringUtils.isEmpty((CharSequence)iconfontData)) return iconfontData;
        Class<FormConfigFactory> clazz = FormConfigFactory.class;
        synchronized (FormConfigFactory.class) {
            iconfontData = LoginMCService.create().getMCData(tenantId, key);
            if (StringUtils.isEmpty((CharSequence)iconfontData)) {
                iconfontData = "null";
            }
            iconfontcache.put(iconFont, (Object)iconfontData, 8, TimeUnit.HOURS);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return iconfontData;
        }
    }

    private static String getIconFontKey(String key) {
        return Instance.getClusterName() + key + RequestContext.get().getTenantId();
    }

    private static String getISVFromWebClientFiles() {
        String isv = "kingdee";
        RequestContext context = RequestContext.get();
        if (context != null) {
            LoginMCService loginMCService = LoginMCService.create();
            try {
                WebClientFiles clientFiles = loginMCService.getWebClientFiles(context.getTenantId(), "_tenant_iconfont_config_files_");
                if (clientFiles != null) {
                    isv = clientFiles.getIsv();
                }
            }
            catch (Exception var4) {
                log.error("\u83b7\u53d6ISV\u5931\u8d25", (Throwable)var4);
            }
        }
        return isv;
    }

    private static Map<String, Object> getLangSetting() {
        HashMap<String, Object> langSetting = new HashMap<String, Object>(16);
        ArrayList langInfo = new ArrayList(10);
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List langs = service.getMultiLangEnabledLang();
        langSetting.put("defaultLang", "zh_CN");
        for (EnabledLang lang : langs) {
            HashMap<String, String> cn = new HashMap<String, String>(16);
            cn.put("code", lang.getNumber());
            cn.put("no", lang.getLangCode());
            cn.put("name", lang.getName());
            if (lang.getIsDefault().booleanValue()) {
                langSetting.put("defaultLang", lang.getNumber());
            }
            langInfo.add(cn);
        }
        langSetting.put("langInfo", langInfo);
        return langSetting;
    }

    private static void checkShowFormRight(FormShowParameter showParameter, Map<String, Object> ret) {
        if (!showParameter.isHasRight() && ret.get(CANCEL) == null) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            FormConfigFactory.checkShowFormRightByUserID(showParameter, ret, userId);
        }
    }

    public static void checkShowFormRightByUserID(FormShowParameter showParameter, Map<String, Object> ret, long userId) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"checkShowFormRightByUserID");){
            boolean exists;
            BillShowParameter billParam;
            String entityId;
            MainEntityType entityType;
            int dbType;
            MetaGrayService mgs;
            List list;
            String bizAppId;
            String permItem = showParameter.getPermissionItemId();
            String entityTypeId = FormConfigFactory.getEntityTypeId(showParameter);
            String appId = showParameter.getCheckRightAppId();
            boolean orginalAppIdIsEmpty = false;
            if (StringUtils.isBlank((CharSequence)appId)) {
                orginalAppIdIsEmpty = true;
                FormConfig fc = FormMetadataCache.getFormConfig((String)entityTypeId);
                bizAppId = StringUtils.isBlank((CharSequence)fc.getBizAppNumber()) ? BizAppServiceHelp.getAppIdByFormNum((String)entityTypeId) : BizAppServiceHelp.getAppIdByAppNumber((String)fc.getBizAppNumber());
            } else {
                bizAppId = AppMetadataCache.getAppInfo((String)appId).getId();
            }
            span.addTag("entityTypeId", entityTypeId);
            span.addTag("bizAppId", bizAppId);
            span.addTag("permItem", permItem);
            PermissionControlType permControlType = EntityMetadataCache.getPermissionControlType((String)entityTypeId);
            if (userId == -1L && permControlType != null && permControlType.isAnonymousUserControl()) {
                return;
            }
            Map map = GrayStrategy.getUserAppGroup((String)RequestContext.get().getUserId(), (String)RequestContext.get().getAccountId());
            String appgroup = (String)map.get(appId);
            if (appgroup != null && !CollectionUtils.isEmpty((Collection)(list = (mgs = new MetaGrayService()).getGrayInfoByGroup(appgroup)))) {
                for (MetaGrayInfo mg : list) {
                    if (!entityTypeId.equals(mg.getNumber())) continue;
                    return;
                }
            }
            boolean hasPerm = false;
            if (orginalAppIdIsEmpty || showParameter.getCustomParam(PERM_IGNORE_CHECKAPP) != null && ((Boolean)showParameter.getCustomParam(PERM_IGNORE_CHECKAPP)).booleanValue()) {
                HashSet<String> pPermItems = new HashSet<String>(1);
                pPermItems.add(permItem);
                Map resultMap = PermissionServiceHelper.checkMultiPermItemInfos((long)userId, (String)entityTypeId, pPermItems, (boolean)false);
                if (!CollectionUtils.isEmpty((Map)resultMap)) {
                    hasPerm = (Boolean)resultMap.get(permItem);
                }
            } else {
                hasPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)bizAppId, (String)entityTypeId, (String)permItem);
            }
            if (!hasPerm) {
                ret.put(CANCEL, Boolean.TRUE);
                ret.put(ERRORCODE, ErrorPageCode.ERROR_403);
                ret.put(CANCEL_MESSAGE, FormConfigFactory.getPermForbidMessage(permItem, entityTypeId, bizAppId));
                return;
            }
            Object pkId = null;
            if (showParameter instanceof BillShowParameter && (pkId = DbTypeConverter.safeConvert((int)(dbType = (entityType = EntityMetadataCache.getDataEntityType((String)(entityId = (billParam = (BillShowParameter)showParameter).getFormConfig().getEntityTypeId()))).getPrimaryKey().getDbType()), (Object)billParam.getPkId())) != null && !(exists = QueryServiceHelper.exists((String)entityTypeId, (Object)pkId))) {
                pkId = null;
            }
            if (pkId != null) {
                QFilter[] qfilters = new QFilter[]{new QFilter("id", "=", pkId)};
                PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                hasPerm = permissionService.matchDataRule(userId, bizAppId, entityTypeId, permItem, qfilters);
                if (!hasPerm) {
                    ret.put(CANCEL, Boolean.TRUE);
                    ret.put(ERRORCODE, ErrorPageCode.ERROR_403);
                    ret.put(CANCEL_MESSAGE, FormConfigFactory.getDataPermForbidMessage(permItem, entityTypeId));
                    return;
                }
                boolean specialDataRuleDisable = Boolean.parseBoolean(System.getProperty(SPECIALDATARULEDISABLE, "false"));
                if (specialDataRuleDisable && !(hasPerm = FormConfigFactory.matchSpecialDataRule(permItem, entityTypeId, bizAppId, pkId, permissionService))) {
                    ret.put(CANCEL, Boolean.TRUE);
                    ret.put(ERRORCODE, ErrorPageCode.ERROR_403);
                    ret.put(CANCEL_MESSAGE, FormConfigFactory.getSpecialDataPermForbidMessage(permItem, entityTypeId));
                    return;
                }
            }
        }
    }

    public static void cancelShowFormDataRights(List<Long> userIds) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"cancelShowFormDataRights");){
            ArrayList list = new ArrayList();
            FormConfigFactory.visitAllPage(userIds, (o, u) -> {
                if (o instanceof ListShowParameter) {
                    list.add(o);
                    o.setCancelDataRight(true);
                }
            });
            log.info("\u3010cancelShowFormDataRights\u3011 total FormShowParameter: useIds count {}, \u3010cancelShowFormDataRights\u3011 total FormShowParameter {}", (Object)userIds.size(), (Object)list.size());
        }
    }

    public static void cancelShowFormDataRightsByAllUser(List<Map<String, String>> entityIds) {
        List<Long> userIds = FormConfigFactory.getAllUserIds();
        FormConfigFactory.cancelShowFormDataRights(userIds, entityIds);
    }

    public static void cancelShowFormDataRights(List<Long> userIds, List<Map<String, String>> entityIds) {
        if (CollectionUtils.isEmpty(entityIds)) {
            return;
        }
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"cancelShowFormDataRights");){
            HashSet<String> set = new HashSet<String>(entityIds.size());
            for (Map<String, String> entityId : entityIds) {
                for (Map.Entry<String, String> keyValue : entityId.entrySet()) {
                    String key = keyValue.getKey() + "|" + keyValue.getValue();
                    set.add(key);
                }
            }
            ArrayList list = new ArrayList();
            FormConfigFactory.visitAllPage(userIds, (o, u) -> {
                if (o instanceof ListShowParameter) {
                    FormConfig fc;
                    String entityId = FormConfigFactory.getEntityTypeId(o);
                    String appId = o.getCheckRightAppId();
                    String bizAppId = StringUtils.isBlank((CharSequence)appId) ? (StringUtils.isBlank((CharSequence)(fc = FormMetadataCache.getFormConfig((String)entityId)).getBizAppNumber()) ? BizAppServiceHelp.getAppIdByFormNum((String)entityId) : BizAppServiceHelp.getAppIdByAppNumber((String)fc.getBizAppNumber())) : AppMetadataCache.getAppInfo((String)appId).getId();
                    String key = bizAppId + "|" + entityId;
                    if (set.contains(key)) {
                        list.add(o);
                        o.setCancelDataRight(true);
                    }
                }
            });
            log.info("\u3010cancelShowFormDataRights\u3011 total FormShowParameter: useIds count " + userIds.size() + " entityids count " + entityIds.size() + "\u3010cancelShowFormDataRights\u3011 total FormShowParameter:" + list.size());
        }
    }

    public static void cancelShowFormRights(List<Long> userIds) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"cancelShowFormRights");){
            ArrayList list = new ArrayList();
            FormConfigFactory.visitAllPage(userIds, (formShowParameter, userId) -> {
                list.add(formShowParameter);
                if (formShowParameter.getCancelRight() == 0) {
                    formShowParameter.setCancelRight(1);
                }
            });
            log.info("\u3010cancelShowFormRights\u3011 total FormShowParameter:" + list.size());
        }
    }

    private static void visitAllPage(List<Long> userIds, ObjLongConsumer<FormShowParameter> consumer) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        log.info("\u3010visitAllPage\u3011 user count:" + userIds.size() + " user[0]=" + userIds.get(0));
        Map<Long, List<SessionInfo>> mapUserSession = FormConfigFactory.getAllUserSession();
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(FORM_PAGECACHE, new DistributeCacheHAPolicy(true, true));
        String accountId = CacheKeyUtil.getAcctId();
        for (Long userId : userIds) {
            if (!mapUserSession.containsKey(userId)) continue;
            for (SessionInfo sessionInfo : mapUserSession.get(userId)) {
                List<String> rootPageList = RootPageCache.getRootPageIds(sessionInfo.getGloableSessionId());
                for (String rootPage : rootPageList) {
                    List<String> pageIds = null;
                    try {
                        pageIds = RootPageCache.getPageIds(rootPage);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    for (String pageId : pageIds) {
                        String formShowParamterKey;
                        String regionKey = accountId + ".pagecache." + pageId;
                        String parameter = (String)cache.get(regionKey, formShowParamterKey = FormShowParameter.class.getSimpleName());
                        if (!StringUtils.isNotBlank((CharSequence)parameter)) continue;
                        FormShowParameter formShowParameter = FormShowParameter.fromJsonString((String)parameter);
                        formShowParameter.endInit();
                        if (!StringUtils.isNotEmpty((CharSequence)formShowParameter.getPermissionItemId())) continue;
                        consumer.accept(formShowParameter, userId);
                        cache.put(regionKey, formShowParamterKey, FormShowParameter.toJsonString((FormShowParameter)formShowParameter), CacheKeyUtil.getPageCacheKeyTimeout(), TimeUnit.SECONDS);
                    }
                }
            }
        }
    }

    private static Map<Long, List<SessionInfo>> getAllUserSession() {
        List sessionIds = SessionQuery.getUserSessions((String)RequestContext.get().getAccountId());
        HashMap<Long, List<SessionInfo>> mapUserSession = new HashMap<Long, List<SessionInfo>>();
        for (SessionInfo sessionInfo : sessionIds) {
            List<SessionInfo> list;
            Long userId = Long.parseLong(sessionInfo.getUserId());
            if (!mapUserSession.containsKey(userId)) {
                list = new ArrayList();
                mapUserSession.put(userId, list);
            } else {
                list = (List)mapUserSession.get(userId);
            }
            list.add(sessionInfo);
        }
        return mapUserSession;
    }

    private static List<Long> getAllUserIds() {
        List sessionIds = SessionQuery.getUserSessions((String)RequestContext.get().getAccountId());
        HashSet<Long> userIdSet = new HashSet<Long>(128);
        for (SessionInfo sessionInfo : sessionIds) {
            Long userId = Long.parseLong(sessionInfo.getUserId());
            userIdSet.add(userId);
        }
        return new ArrayList<Long>(userIdSet);
    }

    private static boolean checkEntityMaxData(String entityTypeId) {
        boolean ifMaxData = false;
        String tableName = EntityMetadataCache.getDataEntityType((String)entityTypeId).getAlias();
        if (StringUtils.isNotEmpty((CharSequence)tableName)) {
            return LicenseServiceHelper.checkEntityMaxData((String)entityTypeId);
        }
        return ifMaxData;
    }

    private static String getEntityTypeId(FormShowParameter showParameter) {
        String formId;
        String entityTypeId = null;
        entityTypeId = showParameter instanceof ListShowParameter ? (StringUtils.isBlank((CharSequence)(formId = ((ListShowParameter)showParameter).getBillFormId())) ? showParameter.getFormId() : FormMetadataCache.getFormConfig((String)formId).getEntityTypeId()) : (showParameter instanceof BillShowParameter || showParameter instanceof MobileFormShowParameter ? showParameter.getFormConfig().getEntityTypeId() : showParameter.getFormId());
        return entityTypeId;
    }

    private static String getPermItemNameById(String permItemId) {
        DynamicObject permitem = null;
        try {
            permitem = BusinessDataServiceHelper.loadSingleFromCache((Object)permItemId, (String)"perm_permitem", (String)"name");
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        if (null == permitem) {
            return "";
        }
        ILocaleString nameLs = permitem.getLocaleString("name");
        if (nameLs != null) {
            return nameLs.getLocaleValue();
        }
        return "";
    }

    private static String getPermForbidMessage(String permItem, String formId, String bizAppId) {
        FormConfig config = FormMetadataCache.getFormConfig((String)formId);
        String formName = config.getCaption().toString();
        String permForbid = "";
        MultiLangEnumBridge opName = null;
        String opKey = "";
        if ("47156aff000000ac".equals(permItem)) {
            permForbid = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FormConfigFactory_6", (String)BOS_FORM_MVC, (Object[])new Object[0]), formName);
            opName = new MultiLangEnumBridge("\u65b0\u589e", "FormConfigFactory_9", BOS_FORM_MVC);
            opKey = "new";
        } else if ("4715a0df000000ac".equals(permItem)) {
            permForbid = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FormConfigFactory_7", (String)BOS_FORM_MVC, (Object[])new Object[0]), formName);
            opName = new MultiLangEnumBridge("\u4fee\u6539", "FormConfigFactory_10", BOS_FORM_MVC);
            opKey = "modify";
        } else {
            String permItemName = FormConfigFactory.getPermItemNameById(permItem);
            permForbid = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FormConfigFactory_8", (String)BOS_FORM_MVC, (Object[])new Object[0]), formName, permItemName);
            opName = new MultiLangEnumBridge("\u67e5\u8be2", "FormConfigFactory_11", BOS_FORM_MVC);
            opKey = "query";
        }
        LogPrintUtil.writeLog((SecurityTypeEnum)SecurityTypeEnum.OVERPERMISSION, (AppLogInfo)FormConfigFactory.buildLogInfo(permForbid, 0L, bizAppId, formId, opKey, opName, "0"));
        return permForbid;
    }

    private static AppLogInfo buildLogInfo(String msg, Long orgId, String bizAppId, String entityId, String opKey, MultiLangEnumBridge opName, String status) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        logInfo.setBizAppID(bizAppId);
        logInfo.setBizObjID(entityId);
        if (orgId != null && Long.compare(0L, orgId) != 0) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opKey, opName);
        logInfo.setOpDescription(msg);
        logInfo.setStatus(status);
        return logInfo;
    }

    private static String getDataPermForbidMessage(String permItem, String formId) {
        FormConfig config = FormMetadataCache.getFormConfig((String)formId);
        String formName = config.getCaption().toString();
        String permForbid = "";
        String operateName = "";
        operateName = "47156aff000000ac".equals(permItem) ? ResManager.loadKDString((String)"\u65b0\u589e", (String)"FormConfigFactory_9", (String)BOS_FORM_MVC, (Object[])new Object[0]) : ("4715a0df000000ac".equals(permItem) ? ResManager.loadKDString((String)"\u4fee\u6539", (String)"FormConfigFactory_10", (String)BOS_FORM_MVC, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u67e5\u8be2", (String)"FormConfigFactory_11", (String)BOS_FORM_MVC, (Object[])new Object[0]));
        permForbid = String.format(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\u3002\u60a8\u6ca1\u6709[%1$s][%2$s]\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FormConfigFactory_12", (String)BOS_FORM_MVC, (Object[])new Object[0]), operateName, formName);
        return permForbid;
    }

    private static boolean matchSpecialDataRule(String permItem, String entityTypeId, String bizAppId, Object pkId, PermissionService permissionService) {
        QFilter specialDataPermFilter;
        StringBuilder sbNotMatchTips = new StringBuilder();
        String operationKey = "view";
        if ("4715a0df000000ac".equals(permItem)) {
            operationKey = "modify";
        }
        if ((specialDataPermFilter = permissionService.getOperationRuleFilter(bizAppId, entityTypeId, operationKey, sbNotMatchTips)) != null) {
            ArrayList<QFilter> allFilterList = new ArrayList<QFilter>();
            allFilterList.add(specialDataPermFilter);
            allFilterList.add(new QFilter("id", "=", pkId));
            return QueryServiceHelper.exists((String)entityTypeId, (QFilter[])allFilterList.toArray(new QFilter[0]));
        }
        return true;
    }

    private static String getSpecialDataPermForbidMessage(String permItem, String formId) {
        FormConfig config = FormMetadataCache.getFormConfig((String)formId);
        String formName = config.getCaption().toString();
        String permForbid = "";
        String operateName = "";
        operateName = "4715a0df000000ac".equals(permItem) ? ResManager.loadKDString((String)"\u4fee\u6539", (String)"FormConfigFactory_10", (String)BOS_FORM_MVC, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u67e5\u8be2", (String)"FormConfigFactory_11", (String)BOS_FORM_MVC, (Object[])new Object[0]);
        permForbid = String.format(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\u3002\u60a8\u6ca1\u6709[%1$s][%2$s]\u7684\u7279\u6b8a\u6570\u636e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FormConfigFactory_13", (String)BOS_FORM_MVC, (Object[])new Object[0]), operateName, formName);
        return permForbid;
    }

    private static void setUserGuide(FormShowParameter showParameter, Map<String, Object> ret) {
        String userGuide = showParameter.getFormConfig().getUserGuide();
        if (userGuide == null) {
            return;
        }
        String guideSetting = FormConfigFactory.getSetting(userGuide + ".guidesetting");
        if (StringUtils.isBlank((CharSequence)guideSetting)) {
            ret.put(IS_USER_GUIDE, Boolean.TRUE);
            ret.put("userGuide", userGuide);
            return;
        }
        Map setMap = (Map)SerializationUtils.fromJsonString((String)guideSetting, Map.class);
        if (!setMap.get("formId").toString().equals(showParameter.getFormId())) {
            ret.put(IS_USER_GUIDE, Boolean.TRUE);
            ret.put("userGuide", userGuide);
        } else {
            ret.put(IS_USER_GUIDE, Boolean.FALSE);
        }
    }

    private static Map<String, Object> getSetting(FormShowParameter showParameter) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String formSetting = UserConfigServiceHelper.getSetting((long)userId, (String)showParameter.getSettingKey());
        String F7Setting = UserConfigServiceHelper.getSetting((long)userId, (String)FormConfigFactory.getF7SettingKey(showParameter));
        if (StringUtils.isBlank((CharSequence)formSetting) && StringUtils.isBlank((CharSequence)F7Setting)) {
            return null;
        }
        HashMap<String, Object> settingMap = new HashMap<String, Object>();
        if (!StringUtils.isBlank((CharSequence)formSetting)) {
            Map formMap = (Map)SerializationUtils.fromJsonString((String)formSetting, Map.class);
            settingMap.putAll(formMap);
        }
        if (!StringUtils.isBlank((CharSequence)F7Setting)) {
            Map baseDataMap = (Map)SerializationUtils.fromJsonString((String)F7Setting, Map.class);
            settingMap.putAll(baseDataMap);
        }
        return settingMap;
    }

    private static String getF7SettingKey(FormShowParameter showParameter) {
        String formId = showParameter.getFormId();
        String settingKey = formId + "F7Setting";
        return settingKey;
    }

    private static String getSetting(String key) {
        return UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)key);
    }

    private static String getCurrentUserEid() {
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(RequestContext.get().getUserId()), (String)"bos_user", (String)"eid");
        if (userObj == null) {
            return "";
        }
        return userObj.getString("eid");
    }

    private static void putConfigCSRFToken(Map<String, Object> ret) {
        String kdCsrfToken = kd.bos.session.SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
        if (kd.bos.util.StringUtils.isNotEmpty((String)kdCsrfToken)) {
            ret.put("kd-csrf-token", kdCsrfToken);
        }
    }

    private static void checkProductModelRight(FormShowParameter showParameter, Map<String, Object> ret) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"checkProductModelRight");){
            ProductSettingService productSettingService;
            List formBlackList;
            FormConfig fc;
            String entityTypeId = FormConfigFactory.getEntityTypeId(showParameter);
            String appId = showParameter.getCheckRightAppId();
            String permItem = showParameter.getPermissionItemId();
            String bizAppId = StringUtils.isBlank((CharSequence)appId) ? (StringUtils.isBlank((CharSequence)(fc = FormMetadataCache.getFormConfig((String)entityTypeId)).getBizAppNumber()) ? BizAppServiceHelp.getAppIdByFormNum((String)entityTypeId) : BizAppServiceHelp.getAppIdByAppNumber((String)fc.getBizAppNumber())) : AppMetadataCache.getAppInfo((String)appId).getId();
            if (span.isRealtime()) {
                span.addTag("formId", entityTypeId);
                span.addTag("bizAppId", bizAppId);
                span.addTag("permItem", permItem);
            }
            if ((formBlackList = (productSettingService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class)).getFormBlackList()) != null && !formBlackList.isEmpty() && StringUtils.isNotBlank((CharSequence)entityTypeId) && formBlackList.contains(entityTypeId)) {
                ret.put(CANCEL, Boolean.TRUE);
                ret.put(ERRORCODE, ErrorPageCode.ERROR_403);
                ret.put(CANCEL_MESSAGE, FormConfigFactory.getProductModelForbidMessage(permItem, entityTypeId, bizAppId));
            }
        }
    }

    private static String getProductModelForbidMessage(String permItem, String formId, String bizAppId) {
        String productModelMsg = ResManager.loadKDString((String)"\u8bbf\u95ee\u9875\u9762\u5931\u8d25\uff0c\u5f53\u524d\u7248\u672c\u4e0d\u652f\u6301\u8be5\u529f\u80fd\uff0c\u8bf7\u66f4\u6362\u4ea7\u54c1\u6a21\u5f0f\u3002", (String)"FormConfigFactory_0", (String)BOS_FORM_MVC, (Object[])new Object[0]);
        MultiLangEnumBridge opName = null;
        String opKey = "";
        if ("47156aff000000ac".equals(permItem)) {
            opName = new MultiLangEnumBridge("\u65b0\u589e", "FormConfigFactory_9", BOS_FORM_MVC);
            opKey = "new";
        } else if ("4715a0df000000ac".equals(permItem)) {
            opName = new MultiLangEnumBridge("\u4fee\u6539", "FormConfigFactory_10", BOS_FORM_MVC);
            opKey = "modify";
        } else {
            opName = new MultiLangEnumBridge("\u67e5\u8be2", "FormConfigFactory_11", BOS_FORM_MVC);
            opKey = "query";
        }
        LogPrintUtil.writeLog((SecurityTypeEnum)SecurityTypeEnum.OVERPERMISSION, (AppLogInfo)FormConfigFactory.buildLogInfo(productModelMsg, 0L, bizAppId, formId, opKey, opName, "0"));
        return productModelMsg;
    }

    private static String getAppId(String appId, FormShowParameter showParameter) {
        if (appId == null || "bos".equals(appId)) {
            String bizAppNumber;
            FormConfig formConfig = showParameter.getFormConfig();
            String formId = showParameter.getFormId();
            if (formConfig == null) {
                String billFormId;
                if (showParameter instanceof ListShowParameter && StringUtils.isNotBlank((CharSequence)(billFormId = ((ListShowParameter)showParameter).getBillFormId()))) {
                    formId = billFormId;
                }
                if (StringUtils.isNotBlank((CharSequence)formId)) {
                    formConfig = FormMetadataCache.getFormConfig((String)formId);
                }
            }
            String string = bizAppNumber = formConfig == null ? "" : formConfig.getBizAppNumber();
            if (StringUtils.isNotBlank((CharSequence)bizAppNumber)) {
                appId = String.format("%s.%s", "bos", bizAppNumber);
            }
        }
        return appId;
    }

    private static void updateTabLayout(Map<String, Object> ret) {
        String formId = (String)ret.get("formId");
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        try {
            String tabLayoutKey = FormConfigFactory.getTabLayoutKey();
            if (!iconfontcache.contains(tabLayoutKey)) {
                if (ret.get(MINOR_VERSION) != null) {
                    HashMap<String, String> mapVal = new HashMap<String, String>(1);
                    mapVal.put(formId, String.valueOf(Boolean.TRUE));
                    iconfontcache.put(tabLayoutKey, mapVal, 36000);
                }
                return;
            }
            List cacheVal = iconfontcache.get(tabLayoutKey, new String[]{formId});
            if (cacheVal == null || cacheVal.isEmpty() || cacheVal.get(0) == null) {
                return;
            }
            if (!TabLayoutUtil.enable() && Boolean.parseBoolean((String)cacheVal.get(0))) {
                ret.put(MINOR_VERSION, System.currentTimeMillis());
                HashMap<String, String> mapVal = new HashMap<String, String>(1);
                mapVal.put(formId, String.valueOf(Boolean.FALSE));
                iconfontcache.put(tabLayoutKey, mapVal, 36000);
            }
        }
        catch (Throwable ignored) {
            log.error(ignored);
        }
    }

    private static String getTabLayoutKey() {
        return Instance.getClusterName() + "_" + RequestContext.get().getTenantId() + "_" + RequestContext.get().getAccountId() + _TABLAYOUT;
    }

    static {
        iconfontcache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ICONFONT", new DistributeCacheHAPolicy(true, true));
        tableStyleColumnMap = new HashMap<String, String>();
        tableStyleColumnMap.put("tableisgridstriped", "isGridStriped");
        tableStyleColumnMap.put("tablevertical", "verticalBordered");
        tableStyleColumnMap.put("tabledisplaymode", "columnResizeMode");
        tableStyleColumnMap.put("tablerowhigh", "rowHeightMode");
    }
}

