/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.bill;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.DifferentialControlInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IDefValueProvider;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillDefValueProvider;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.bill.BillTypeDefValueProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BillTypeDifferentialHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BillTypeApHelper {
    private static final String SPAN_TYPE_BILLTYPE = "billtype";
    private static final String SPAN_TYPE_BILLLAYOUT = "billlayout";
    private static final String BILLTYPE_CURID = "BILLTYPE:CURID";
    private static final String FORMID_BILLTYPE = "bos_billtype";
    private static final String SELECT_ORG_ID = "SELECT_ORG_ID";
    private static Log log = LogFactory.getLog(BillTypeApHelper.class);
    private static BillTypeApHelper instance = new BillTypeApHelper();
    private static final String BILLTYPE_POLICY = "billtype_policy";

    private BillTypeApHelper() {
    }

    public static BillTypeApHelper getInstance() {
        return instance;
    }

    public static Long getDefaultBillTypeId(String formId) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_BILLTYPE, (String)"BillTypeApHelper.getDefaultBillTypeId");){
            span.addTag("formId", formId);
            QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("enable", "=", (Object)Boolean.TRUE), new QFilter("status", "=", (Object)"C"), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
            Map objs = BusinessDataServiceHelper.loadFromCache((String)FORMID_BILLTYPE, (String)"id", (QFilter[])filters);
            if (objs == null || objs.isEmpty()) {
                Long l = null;
                return l;
            }
            Long l = (Long)((DynamicObject)objs.values().iterator().next()).getPkValue();
            return l;
        }
    }

    public static Map<String, Object> getBillTypeDefValue(Long billTypeId) {
        return BillTypeApHelper.getBillTypeDefValue(billTypeId, false);
    }

    public static Map<String, Object> getBillTypeDefValue(Long billTypeId, boolean isMob) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_BILLTYPE, (String)"BillTypeApHelper.getBillTypeDefValue");){
            DynamicObjectCollection mobFldctlentry;
            span.addTag("billTypeId", String.valueOf(billTypeId));
            HashMap<String, String> defValueMap = new HashMap<String, String>();
            Object[] pkIds = new Long[]{billTypeId};
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)FORMID_BILLTYPE);
            Map dataFromCache = BusinessDataReader.loadFromCache((Object[])pkIds, (DynamicObjectType)dt);
            DynamicObject billTypeObj = (DynamicObject)dataFromCache.get(billTypeId);
            if (billTypeObj == null) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u65e0\u6cd5\u67e5\u51fa\u6570\u636e id:%s", (String)"BillTypeApHelper_0", (String)"bos-form-mvc", (Object[])new Object[0]), billTypeId.toString());
                throw new KDException(new ErrorCode("BillTypeApHelper_01", errMsg), new Object[0]);
            }
            DynamicObjectCollection fldctlentry = billTypeObj.getDynamicObjectCollection("fieldcontrolentry");
            String prefixStr = "";
            if (isMob && !CollectionUtils.isEmpty((Collection)(mobFldctlentry = billTypeObj.getDynamicObjectCollection("mob_fieldcontrolentry")))) {
                fldctlentry = mobFldctlentry;
                prefixStr = "mob_";
            }
            for (DynamicObject fldctlRow : fldctlentry) {
                String key;
                String string = key = StringUtils.isBlank((CharSequence)fldctlRow.getString(prefixStr + "entityfieldkey")) ? fldctlRow.getString(prefixStr + "fieldkey") : fldctlRow.getString(prefixStr + "entityfieldkey");
                if (!StringUtils.isNotBlank((CharSequence)fldctlRow.getString(prefixStr + "defaultvalue"))) continue;
                defValueMap.put(key, fldctlRow.getString(prefixStr + "defaultvalue"));
            }
            HashMap<String, String> hashMap = defValueMap;
            return hashMap;
        }
    }

    public static void updateViewByBillType(DynamicObject billTypeObj, BillOperationStatus billStatus, IFormView view) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_BILLLAYOUT, (String)"BillTypeApHelper.updateViewByBillType", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            boolean isChangeBillType;
            IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
            String lastBillTypeId = pageCache.get(BILLTYPE_CURID);
            if (billTypeObj == null && StringUtils.isBlank((CharSequence)lastBillTypeId)) {
                return;
            }
            boolean isMob = view instanceof IMobileView;
            if (billTypeObj == null && StringUtils.isNotBlank((CharSequence)lastBillTypeId)) {
                List lastDiffInfos = StringUtils.isBlank((CharSequence)lastBillTypeId) ? null : BillTypeDifferentialHelper.getRuntimeDiffControlInfos((String)view.getEntityId(), (Long)Long.parseLong(lastBillTypeId), (boolean)isMob);
                BillTypeApHelper.resetBillTypeControl(lastDiffInfos, view);
                return;
            }
            if (billTypeObj == null) {
                return;
            }
            long billtypeId = (Long)billTypeObj.getPkValue();
            boolean bl = isChangeBillType = StringUtils.isNotBlank((CharSequence)lastBillTypeId) && !Objects.equals(String.valueOf(billtypeId), lastBillTypeId);
            if (isChangeBillType) {
                List lastDiffInfos = StringUtils.isBlank((CharSequence)lastBillTypeId) ? null : BillTypeDifferentialHelper.getRuntimeDiffControlInfos((String)view.getEntityId(), (Long)Long.parseLong(lastBillTypeId), (boolean)isMob);
                BillTypeApHelper.recoveryBillTypeControl(lastDiffInfos, billStatus, view);
                view.getPageCache().remove("fieldViByBillType");
            }
            List diffInfos = BillTypeDifferentialHelper.getRuntimeDiffControlInfos((String)view.getEntityId(), (Long)billtypeId, (boolean)isMob);
            pageCache.put(BILLTYPE_CURID, String.valueOf(billtypeId));
            if (diffInfos != null) {
                HashMap<String, Boolean> visibleMap = new HashMap<String, Boolean>(diffInfos.size());
                for (DifferentialControlInfo diffInfo : diffInfos) {
                    HashMap<String, Integer> paramMap;
                    Control control;
                    FieldEdit fieldEdit = (FieldEdit)view.getControl(diffInfo.getFieldKey());
                    if (fieldEdit == null) continue;
                    if (diffInfo.isMustInput() != null) {
                        if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryControlKey())) {
                            EntryGrid grid = (EntryGrid)view.getControl(fieldEdit.getEntryControlKey());
                            grid.setMustInput(diffInfo.getFieldKey(), diffInfo.isMustInput().booleanValue());
                        } else {
                            fieldEdit.setMustInput(diffInfo.isMustInput().booleanValue());
                        }
                    }
                    if (diffInfo.isVisible(billStatus.name()) != null) {
                        if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryControlKey())) {
                            control = view.getControl(fieldEdit.getEntryControlKey());
                            if (control instanceof CardEntry) {
                                paramMap = new HashMap<String, Integer>(1);
                                paramMap.put("vi", diffInfo.getVisibleValueInner());
                                view.updateControlMetadata(fieldEdit.getKey(), paramMap);
                            } else {
                                fieldEdit.setVisible(BILLTYPE_POLICY, diffInfo.isVisible(billStatus.name()).booleanValue());
                            }
                        } else {
                            fieldEdit.setVisible(BILLTYPE_POLICY, diffInfo.isVisible(billStatus.name()).booleanValue());
                        }
                        visibleMap.put(fieldEdit.getKey(), diffInfo.isVisible(billStatus.name()) != null && diffInfo.isVisible(billStatus.name()) != false);
                    }
                    if (diffInfo.isLock(billStatus.name()) == null) continue;
                    if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryControlKey())) {
                        control = view.getControl(fieldEdit.getEntryControlKey());
                        if (control instanceof CardEntry) {
                            paramMap = new HashMap(1);
                            paramMap.put("l", diffInfo.getLockValue());
                            view.updateControlMetadata(fieldEdit.getKey(), paramMap);
                            continue;
                        }
                        fieldEdit.setEnable(BILLTYPE_POLICY, diffInfo.isLock(billStatus.name()) == false, -1);
                        continue;
                    }
                    fieldEdit.setEnable(BILLTYPE_POLICY, diffInfo.isLock(billStatus.name()) == false, -1);
                }
                view.getPageCache().put("fieldViByBillType", SerializationUtils.toJsonString(visibleMap));
            }
        }
    }

    private static void resetBillTypeControl(List<DifferentialControlInfo> beforeCtlInfos, IFormView view) {
        if (LayoutControlInfo.isBillTypeLayout() && beforeCtlInfos != null) {
            for (DifferentialControlInfo diffInfo : beforeCtlInfos) {
                FieldEdit fieldEdit = (FieldEdit)view.getControl(diffInfo.getFieldKey());
                if (fieldEdit == null) continue;
                if (diffInfo.isMustInput() != null) {
                    if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryControlKey())) {
                        EntryGrid grid = (EntryGrid)view.getControl(fieldEdit.getEntryControlKey());
                        grid.setMustInput(diffInfo.getFieldKey(), false);
                    } else {
                        fieldEdit.setMustInput(false);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryControlKey())) {
                    Control control = view.getControl(fieldEdit.getEntryControlKey());
                    if (control instanceof CardEntry) {
                        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(1);
                        paramMap.put("vi", fieldEdit.getVisibleIntegerVal());
                        view.updateControlMetadata(fieldEdit.getKey(), paramMap);
                        paramMap = new HashMap(1);
                        paramMap.put("l", fieldEdit.getLockIntegerVal());
                        view.updateControlMetadata(fieldEdit.getKey(), paramMap);
                        continue;
                    }
                    fieldEdit.setVisible(BILLTYPE_POLICY, true);
                    fieldEdit.setEnable(BILLTYPE_POLICY, true, -1);
                    continue;
                }
                fieldEdit.setVisible(BILLTYPE_POLICY, true);
                fieldEdit.setEnable(BILLTYPE_POLICY, true, -1);
            }
        }
    }

    private static void recoveryBillTypeControl(List<DifferentialControlInfo> beforeCtlInfos, BillOperationStatus billStatus, IFormView view) {
        if (LayoutControlInfo.isBillTypeLayout() && beforeCtlInfos != null) {
            for (DifferentialControlInfo diffInfo : beforeCtlInfos) {
                HashMap<String, Integer> paramMap;
                Control control;
                FieldEdit fieldEdit = (FieldEdit)view.getControl(diffInfo.getFieldKey());
                if (fieldEdit == null) continue;
                if (diffInfo.isMustInput() != null) {
                    if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryControlKey())) {
                        EntryGrid grid = (EntryGrid)view.getControl(fieldEdit.getEntryControlKey());
                        grid.setMustInput(diffInfo.getFieldKey(), false);
                    } else {
                        fieldEdit.setMustInput(false);
                    }
                }
                if (diffInfo.isVisible(billStatus.name()) != null && diffInfo.isVisible(billStatus.name()).equals(Boolean.FALSE)) {
                    if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryControlKey())) {
                        control = view.getControl(fieldEdit.getEntryControlKey());
                        if (control instanceof CardEntry) {
                            paramMap = new HashMap<String, Integer>(1);
                            paramMap.put("vi", fieldEdit.getVisibleIntegerVal());
                            view.updateControlMetadata(fieldEdit.getKey(), paramMap);
                        } else {
                            fieldEdit.setVisible(BILLTYPE_POLICY, true);
                        }
                    } else {
                        fieldEdit.setVisible(BILLTYPE_POLICY, true);
                    }
                }
                if (diffInfo.isLock(billStatus.name()) == null || !diffInfo.isLock(billStatus.name()).equals(Boolean.TRUE)) continue;
                if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryControlKey())) {
                    control = view.getControl(fieldEdit.getEntryControlKey());
                    if (control instanceof CardEntry) {
                        paramMap = new HashMap(1);
                        paramMap.put("l", fieldEdit.getLockIntegerVal());
                        view.updateControlMetadata(fieldEdit.getKey(), paramMap);
                        continue;
                    }
                    fieldEdit.setEnable(BILLTYPE_POLICY, true, -1);
                    continue;
                }
                fieldEdit.setEnable(BILLTYPE_POLICY, true, -1);
            }
        }
    }

    public static void reloadDataModelByBillType(DynamicObject billTypeObj, IBillView view) {
        BillTypeApHelper.reloadDataModelByBillType(billTypeObj, view, true);
    }

    public static void reloadDataModelByBillType(DynamicObject billTypeObj, IBillView view, boolean isBillTypeLayout) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_BILLTYPE, (String)"BillTypeApHelper.reloadDataModelByBillType");){
            BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
            BillModel model = (BillModel)((Object)view.getService(IDataModel.class));
            model.beginInit();
            String selectOrgId = (String)billShowParameter.getCustomParam(SELECT_ORG_ID);
            if (selectOrgId != null) {
                model.putContextVariable(SELECT_ORG_ID, selectOrgId);
            }
            String billTypeId = billTypeObj.getPkValue().toString();
            billShowParameter.setBillTypeId(billTypeId);
            if (isBillTypeLayout) {
                view.addService(IDefValueProvider.class, (Object)new BillTypeDefValueProvider((IFormView)view, (Long)billTypeObj.getPkValue()));
            } else {
                view.addService(IDefValueProvider.class, (Object)new BillDefValueProvider((IFormView)view, billShowParameter.getLayoutSchemeId()));
            }
            view.cacheFormShowParameter();
            if (StringUtils.isNotBlank((CharSequence)billTypeId)) {
                model.putContextVariable("DEFAULT_BILLTYPE_ID", billTypeId);
            }
            if (!Boolean.TRUE.equals(model.getContextVariable("IGNORE_RELOADDATAMODEL"))) {
                Object id = null;
                MainOrgProp mainOrgProperty = ((BillEntityType)model.getDataEntityType()).getMainOrgProperty();
                if (mainOrgProperty != null && (id = model.getValue(mainOrgProperty.getName())) != null) {
                    model.putContextVariable(SELECT_ORG_ID, String.valueOf(((DynamicObject)id).getPkValue()));
                }
                model.createNewData();
            }
            model.endInit();
        }
    }
}

