/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCacheLimitFlow;
import kd.bos.mvc.cache.PageCacheLimiterService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class PageCache
implements IPageCache {
    private static final Log log = LogFactory.getLog(PageCache.class);
    private static final String LOG_PAGE_KEYS = "pageId:{}, key:{}";
    private static final String LOG_PAGE = "pageId:{}";
    private static final String SPAN_TYPE_PAGECACHE = "pagecache";
    private static final String TAG_PAGEID = "pageId";
    private static final String TAG_KEY = "key";
    private static final String TAG_VAL = "val";
    private static final String TAG_VALUES = "values";
    private String pageId;
    private String regionKey;
    private Map<String, String> cacheMap = new HashMap<String, String>(16);
    private Set<String> changeSet = new HashSet<String>();
    private Set<String> removedKeys = new HashSet<String>();
    private boolean batchSave;
    private AtomicInteger suspendCounter = new AtomicInteger(0);
    private AtomicInteger changedCounter = new AtomicInteger(0);
    private PageCacheLimitFlow pageCacheLimitFlow = new PageCacheLimitFlow();
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
    private static DistributeSessionlessCache cacheBO = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache-bigobject", new DistributeCacheHAPolicy(true, true));

    public PageCache(String pageId, boolean batchSave) {
        this(pageId);
        this.batchSave = batchSave;
    }

    public PageCache(String pageId) {
        this.pageId = pageId;
        IPageCache lp = SessionManager.getCurrent().getPageCacheInMemory(pageId);
        if (lp != null) {
            lp.saveChanges();
        }
        this.regionKey = CacheKeyUtil.getAcctId() + ".pagecache." + this.pageId;
        this.restore();
        SessionManager.getCurrent().putPageCacheInMemory(this);
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getSessionId() {
        RequestContext context = RequestContext.get();
        String sessionId = context.getGlobalSessionId();
        return sessionId;
    }

    public static boolean existView(String pageId) {
        String regionKey = CacheKeyUtil.getAcctId() + ".pagecache." + pageId;
        return cache.contains(regionKey);
    }

    @KSMethod
    public void put(String keyName, String value) {
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"put", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addTag(TAG_PAGEID, this.regionKey);
                span.addTag(TAG_KEY, keyName);
                span.addTag(TAG_VAL, value);
            }
        }
        if (value == null) {
            this.remove(keyName);
        } else if (!value.equals(this.cacheMap.get(keyName))) {
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put(keyName, value);
            PageCacheLimiterService.limitSize(map);
            this.pageCacheLimitFlow.execeedCacheLimitControl(map);
            this.commitCache(keyName, value);
            this.cacheMap.put(keyName, value);
            this.pageCacheLimitFlow.addPageCacheSize(value.length());
            this.changeSet.add(keyName);
            this.removedKeys.remove(keyName);
        }
    }

    @KSMethod
    public void put(Map<String, String> values) {
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"put", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addTag(TAG_PAGEID, this.regionKey);
                span.addLocaleTag(TAG_VALUES, values);
            }
        }
        PageCacheLimiterService.limitSize(values);
        this.pageCacheLimitFlow.execeedCacheLimitControl(values);
        this.batchCommitCache(values);
        this.cacheMap.putAll(values);
        this.pageCacheLimitFlow.addPageCacheSize(values);
        this.changeSet.addAll(values.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitCache(String keyName, String value) {
        if (!this.batchSave && !this.isSuspendCommit()) {
            try (EntityTraceSpan span = null;){
                if (EntityTracer.isRealtime()) {
                    span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"commitCache", (EntityTraceHint)new EntityTraceHint(false));
                    span.addTag(TAG_PAGEID, this.regionKey);
                    span.addTag(TAG_KEY, keyName);
                    span.addLocaleTag(TAG_VAL, (Object)value);
                }
                cache.put(this.regionKey, keyName, value, CacheKeyUtil.getPageCacheKeyTimeout(), TimeUnit.SECONDS);
            }
        } else {
            this.recordChangeCount();
        }
    }

    private void commitRemove(String keyName) {
        if (!this.batchSave && !this.isSuspendCommit()) {
            try (EntityTraceSpan span = null;){
                if (EntityTracer.isRealtime()) {
                    span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"commitRemove", (EntityTraceHint)new EntityTraceHint(false));
                    span.addTag(TAG_PAGEID, this.regionKey);
                    span.addTag(TAG_KEY, keyName);
                }
                cache.remove(this.regionKey, keyName);
            }
        } else {
            this.recordChangeCount();
        }
    }

    private void batchCommitCache(Map<String, String> values) {
        if (!this.batchSave && !this.isSuspendCommit()) {
            try (EntityTraceSpan span = null;){
                if (EntityTracer.isRealtime()) {
                    span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"batchCommitCache", (EntityTraceHint)new EntityTraceHint(false));
                    span.addTag(TAG_PAGEID, this.regionKey);
                    span.addLocaleTag(TAG_VALUES, values);
                }
                cache.put(this.regionKey, values, CacheKeyUtil.getPageCacheKeyTimeout(), TimeUnit.SECONDS);
            }
        } else {
            this.recordChangeCount();
        }
    }

    @KSMethod
    public String get(String keyName) {
        String v = this.cacheMap.get(keyName);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"get", (EntityTraceHint)new EntityTraceHint(false));){
                span.addTag(TAG_PAGEID, this.regionKey);
                span.addTag(TAG_KEY, keyName);
                span.addTag(TAG_VAL, v);
            }
        }
        return v;
    }

    @KSMethod
    public void remove(String keyName) {
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"remove", (EntityTraceHint)new EntityTraceHint(false));){
                span.addTag(TAG_PAGEID, this.regionKey);
                span.addTag(TAG_KEY, keyName);
            }
        }
        this.commitRemove(keyName);
        String remove = this.cacheMap.remove(keyName);
        if (remove != null) {
            this.pageCacheLimitFlow.subPageCacheSize(remove.length());
        }
        this.changeSet.remove(keyName);
        this.removedKeys.add(keyName);
    }

    @KSMethod
    public void batchRemove(List<String> keyNames) {
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"batchRemove");){
                span.addTag(TAG_PAGEID, this.regionKey);
                span.addLocaleTag(TAG_KEY, keyNames);
            }
        }
        if (keyNames != null && !keyNames.isEmpty()) {
            this.batchCommitRemove(keyNames);
            this.removeEntries(keyNames);
            this.changeSet.removeAll(keyNames);
            this.removedKeys.addAll(keyNames);
        }
    }

    private void removeEntries(List<String> removeKeys) {
        Iterator<String> iterator = this.cacheMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!removeKeys.contains(key)) continue;
            iterator.remove();
            String remove = this.cacheMap.remove(key);
            if (remove == null) continue;
            this.pageCacheLimitFlow.subPageCacheSize(remove.length());
        }
    }

    private void batchCommitRemove(List<String> keyNames) {
        if (!this.batchSave && !this.isSuspendCommit()) {
            try (EntityTraceSpan span = null;){
                if (EntityTracer.isRealtime()) {
                    span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"batchCommitRemove", (EntityTraceHint)new EntityTraceHint(false));
                    span.addTag(TAG_PAGEID, this.regionKey);
                    span.addLocaleTag(TAG_KEY, keyNames);
                }
                cache.remove(this.regionKey, keyNames.toArray(new String[keyNames.size()]));
            }
        } else {
            this.recordChangeCount();
        }
    }

    private void restore() {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"restore", (EntityTraceHint)new EntityTraceHint(false));
                span.addTag(TAG_PAGEID, this.regionKey);
                span.addLocaleTag(TAG_VALUES, this.cacheMap);
            }
            this.cacheMap = cache.getAll(this.regionKey);
            this.pageCacheLimitFlow.setPageCacheSize(0);
            this.pageCacheLimitFlow.addPageCacheSize(this.cacheMap);
            log.info("pageId:{}, result:{}", (Object)this.regionKey, this.cacheMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChanges() {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"saveChanges", (EntityTraceHint)new EntityTraceHint(false));
                span.addTag(TAG_PAGEID, this.regionKey);
            }
            if (!this.changeSet.isEmpty()) {
                HashMap<String, String> changes = new HashMap<String, String>(16);
                for (String key : this.changeSet) {
                    String val = this.cacheMap.get(key);
                    if (val == null && EntityTracer.isRealtime()) {
                        KDBizException e = new KDBizException("cacheMap exsit null key\u3002");
                        HashMap<String, Object> tags = new HashMap<String, Object>(3);
                        tags.put("cacheMap", this.cacheMap);
                        tags.put("changeSet", this.changeSet);
                        tags.put(TAG_KEY, key);
                        EntityTracer.throwException((String)this.getClass().getSimpleName(), (String)"saveChanges", null, (Throwable)e, tags);
                        throw e;
                    }
                    changes.put(key, val);
                }
                cache.put(this.regionKey, changes, CacheKeyUtil.getPageCacheKeyTimeout());
                this.changeSet.clear();
                if (span != null) {
                    span.addLocaleTag("changes", changes);
                }
            }
            if (!this.removedKeys.isEmpty()) {
                String[] keys = this.removedKeys.toArray(new String[0]);
                cache.remove(this.regionKey, keys);
                this.removedKeys.clear();
                if (span != null) {
                    span.addLocaleTag("remove", (Object)keys);
                }
            }
            this.resetChangeCount();
        }
    }

    public void release() {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"release", (EntityTraceHint)new EntityTraceHint(false));
                span.addTag(TAG_PAGEID, this.regionKey);
            }
            cache.remove(this.regionKey);
            cacheBO.remove(this.regionKey + ".bo");
            this.cacheMap = null;
            this.pageCacheLimitFlow.setPageCacheSize(0);
            log.info(LOG_PAGE, (Object)this.regionKey);
        }
    }

    public void expireAfter(int timeout) {
        cache.expireAfter(this.regionKey, timeout);
    }

    public Map<String, String> getAll() {
        if (this.cacheMap == null) {
            try (EntityTraceSpan span = null;){
                if (EntityTracer.isRealtime()) {
                    span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"getAll", (EntityTraceHint)new EntityTraceHint(false));
                }
                this.cacheMap = cache.getAll(this.regionKey);
                this.pageCacheLimitFlow.setPageCacheSize(0);
                this.pageCacheLimitFlow.addPageCacheSize(this.cacheMap);
                if (span != null) {
                    span.addTag(TAG_PAGEID, this.regionKey);
                    span.addLocaleTag(TAG_VALUES, this.cacheMap);
                }
            }
        }
        return this.cacheMap;
    }

    public String getBigObject(String keyName) {
        log.info(LOG_PAGE_KEYS, (Object)this.regionKey, (Object)keyName);
        return (String)cacheBO.get(this.regionKey + ".bo", keyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBigObject(String keyName, String value) {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"putBigObject");
                span.addTag(TAG_PAGEID, this.regionKey);
                span.addTag(TAG_KEY, keyName);
                span.addTag("val.length", String.valueOf(StringUtils.length((CharSequence)value)));
                span.addTag(TAG_VAL, value);
            }
            if (value == null) {
                this.removeBigObject(keyName);
            } else {
                PageCacheLimiterService.limitBigObjSize(value.length());
                cacheBO.put(this.regionKey + ".bo", keyName, value, CacheKeyUtil.getPageCacheKeyTimeout(), TimeUnit.SECONDS);
                log.info(LOG_PAGE_KEYS, (Object)this.regionKey, (Object)keyName);
            }
        }
    }

    public void removeBigObject(String keyName) {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"removeBigObject");
                span.addTag(TAG_PAGEID, this.regionKey);
                span.addTag(TAG_KEY, keyName);
            }
            cacheBO.remove(this.regionKey + ".bo", keyName);
            log.info(LOG_PAGE_KEYS, (Object)this.regionKey, (Object)keyName);
        }
    }

    public boolean isSuspendCommit() {
        return this.suspendCounter.get() > 0;
    }

    public void suspendCommit() {
        this.suspendCounter.getAndIncrement();
    }

    public void resumeCommit() {
        this.suspendCounter.getAndDecrement();
        if (this.isChange() && !this.batchSave) {
            this.saveChanges();
        }
    }

    private void recordChangeCount() {
        this.changedCounter.getAndIncrement();
    }

    private void resetChangeCount() {
        this.changedCounter.set(0);
    }

    private boolean isChange() {
        return this.changedCounter.get() > 0;
    }
}

