/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.cache;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

class PageCacheLimitFlow {
    private static final Log log = LogFactory.getLog(PageCacheLimitFlow.class);
    private static int pageCacheLimitSize = 0;
    private static String pagecache_size = "pagecache.size";
    private static int pageCacheSingleLimitSize = 0;
    private static String pagecache_single_size = "pagecache.singlesize";
    private static String exceedLimitOutType;
    private static String pagecache_exceedlimit_outtype;
    private int pageCacheSize = 0;

    public PageCacheLimitFlow() {
        if (exceedLimitOutType == null && StringUtils.isNotBlank((CharSequence)RequestContext.get().getTenantId())) {
            String size;
            String singleSize = SystemPropertyUtils.getProptyByTenant((String)pagecache_single_size, (String)RequestContext.get().getTenantId());
            if (StringUtils.isNotBlank((CharSequence)singleSize)) {
                pageCacheSingleLimitSize = Integer.parseInt(singleSize);
            }
            if (StringUtils.isNotBlank((CharSequence)(size = SystemPropertyUtils.getProptyByTenant((String)pagecache_size, (String)RequestContext.get().getTenantId())))) {
                pageCacheLimitSize = Integer.parseInt(size);
            }
            if ((exceedLimitOutType = SystemPropertyUtils.getProptyByTenant((String)pagecache_exceedlimit_outtype, (String)RequestContext.get().getTenantId())) == null) {
                exceedLimitOutType = "";
            }
        }
    }

    public void execeedCacheLimitControl(Map<String, String> values) {
        if (values == null) {
            return;
        }
        if (this.isPageCacheSingleLimit() || this.isPageCacheLimit()) {
            int cacheSize = 0;
            for (Map.Entry<String, String> entry : values.entrySet()) {
                int length = 0;
                if (entry.getValue() != null) {
                    length = entry.getValue().length();
                }
                if (this.isPageCacheSingleLimit() && length > pageCacheSingleLimitSize) {
                    this.outError(String.format("PageCache put %s size(%s) exceed single limit(%s).", entry.getKey(), length * 2, pageCacheSingleLimitSize));
                } else if (this.isPageCacheSingleLimit() && length > 0x1900000) {
                    log.info("PageCache put {} value(size:{}) > 50M.", (Object)entry.getKey(), (Object)(length * 2));
                }
                cacheSize += length;
            }
            if (this.isPageCacheLimit() && this.getPageCacheSize() + cacheSize > pageCacheLimitSize) {
                this.outError(String.format("PageCache putsize(%s) exceed max memory limit(%s).", this.getPageCacheSize() + cacheSize, pageCacheLimitSize));
            }
        }
    }

    private int getPageCacheSize() {
        return this.pageCacheSize;
    }

    public void addPageCacheSize(int length) {
        if (this.isPageCacheLimit()) {
            this.pageCacheSize += length;
        }
    }

    public void addPageCacheSize(Map<String, String> values) {
        if (this.isPageCacheLimit()) {
            for (String value : values.values()) {
                this.pageCacheSize += value.length();
            }
        }
    }

    public void subPageCacheSize(int length) {
        if (this.isPageCacheLimit()) {
            this.pageCacheSize -= length;
        }
    }

    public void setPageCacheSize(int pageCacheSize) {
        this.pageCacheSize = pageCacheSize;
    }

    private void outError(String msg) {
        if ("log".equals(exceedLimitOutType)) {
            log.error(msg);
        } else if ("stack".equals(exceedLimitOutType)) {
            this.writeStackLog(msg);
        } else {
            if ("exception".equals(exceedLimitOutType)) {
                throw new RuntimeException(msg);
            }
            log.info(msg);
        }
    }

    private boolean isPageCacheSingleLimit() {
        return pageCacheSingleLimitSize != 0;
    }

    boolean isPageCacheLimit() {
        return pageCacheLimitSize != 0;
    }

    private void writeStackLog(String msg) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        int size = stes.length > 20 ? 20 : stes.length;
        for (int i = 1; i < size; ++i) {
            sb.append("\tat ").append(stes[i]);
        }
        log.error("{}, stacktrace:\n{}", (Object)msg, (Object)sb.toString());
    }

    static {
        pagecache_exceedlimit_outtype = "pagecache.exceedlimit.outtype";
        ConfigurationUtil.observeChange((String)pagecache_single_size, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                String tenantId = RequestContext.get().getTenantId();
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    pageCacheSingleLimitSize = Integer.parseInt(SystemPropertyUtils.getProptyByTenant((String)pagecache_single_size, (String)tenantId));
                }
            }
        });
        ConfigurationUtil.observeChange((String)pagecache_size, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                String tenantId = RequestContext.get().getTenantId();
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    pageCacheLimitSize = Integer.parseInt(SystemPropertyUtils.getProptyByTenant((String)pagecache_size, (String)tenantId));
                }
            }
        });
        ConfigurationUtil.observeChange((String)pagecache_exceedlimit_outtype, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                String tenantId = RequestContext.get().getTenantId();
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    exceedLimitOutType = SystemPropertyUtils.getProptyByTenant((String)pagecache_exceedlimit_outtype, (String)tenantId);
                }
            }
        });
    }
}

