/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.cache;

import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.IFormController;
import kd.bos.servicehelper.DispatchServiceHelper;

public class RootPageCache {
    private static final String PAGEID_PARENT = ".pageid-parent.";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
    private static Log log = LogFactory.getLog(RootPageCache.class);
    private static final String ROOT = ".root.";
    private static final String DELAYCLEAR = ".delayclear.";
    private static final String LOG_ROOT = "rootPageId: {}";
    private static final String LOG_ROOT_PAGE = "rootPageId: {}, pageId: {}";
    private static final String SPAN_TYPE_PAGECACHE = "pagecache";

    public static void addPageId(String rootPageId, String pageId) {
        String rootPageKey;
        if (StringUtils.isBlank((CharSequence)rootPageId) || pageId.startsWith("root") && rootPageId.equals(pageId)) {
            rootPageKey = RootPageCache.getSessionKey();
            cache.put(rootPageKey, pageId, Long.valueOf(System.currentTimeMillis()).toString(), CacheKeyUtil.getPageCacheKeyTimeout());
        } else {
            rootPageKey = CacheKeyUtil.getAcctId() + ROOT + rootPageId;
            cache.put(rootPageKey, pageId, Long.valueOf(System.currentTimeMillis()).toString(), CacheKeyUtil.getPageCacheKeyTimeout());
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"Root.addPageId", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addTag("cache.type", rootPageKey);
                span.addTag("rootPageId", rootPageId);
                span.addTag("pageId", pageId);
            }
        }
        log.info(LOG_ROOT_PAGE, (Object)rootPageId, (Object)pageId);
    }

    private static String getSessionKey() {
        return RootPageCache.getSessionKey(RequestContext.get().getGlobalSessionId());
    }

    private static String getSessionKey(String sessionId) {
        return "session." + sessionId;
    }

    public static void addDelayClearPageId(String rootPageId) {
        String rootPageKey = CacheKeyUtil.getAcctId() + DELAYCLEAR + RequestContext.get().getGlobalSessionId();
        cache.put(rootPageKey, rootPageId, (Object)Long.valueOf(System.currentTimeMillis()).toString());
        log.info(LOG_ROOT, (Object)rootPageId);
    }

    public static void removeDelayClearPageId(String rootPageId) {
        log.info(LOG_ROOT, (Object)rootPageId);
        String rootPageKey = CacheKeyUtil.getAcctId() + DELAYCLEAR + RequestContext.get().getGlobalSessionId();
        cache.remove(rootPageKey, rootPageId);
    }

    public static boolean isExistDelayClearPageId(String rootPageId) {
        String rootPageKey = CacheKeyUtil.getAcctId() + DELAYCLEAR + RequestContext.get().getGlobalSessionId();
        String v = (String)cache.get(rootPageKey, rootPageId);
        return v != null;
    }

    public static void removePageId(String rootPageId, String pageId) {
        log.info(LOG_ROOT_PAGE, (Object)rootPageId, (Object)pageId);
        if (StringUtils.isBlank((CharSequence)rootPageId) || pageId.startsWith("root") && rootPageId.equals(pageId)) {
            String rootPageKey = RootPageCache.getSessionKey();
            cache.remove(rootPageKey, pageId);
            rootPageKey = CacheKeyUtil.getAcctId() + ROOT + pageId;
            cache.remove(rootPageKey);
            rootPageKey = CacheKeyUtil.getAcctId() + PAGEID_PARENT + pageId;
            cache.remove(rootPageKey);
        } else {
            String rootPageKey = CacheKeyUtil.getAcctId() + ROOT + rootPageId;
            cache.remove(rootPageKey, pageId);
            rootPageKey = CacheKeyUtil.getAcctId() + PAGEID_PARENT + rootPageId;
            cache.remove(rootPageKey, pageId);
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"Root.removePageId", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addTag("rootPageId", rootPageId);
                span.addTag("pageId", pageId);
            }
        }
    }

    public static void addPageIdWithPid(String rootPageId, String parentPageId, String pageId) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"Root.addPageIdWithPid");){
            span.addTag("rootPageId", rootPageId);
            span.addTag("parentPageId", parentPageId);
            span.addTag("pageId", pageId);
            if (StringUtils.isNotBlank((CharSequence)rootPageId) && StringUtils.isNotBlank((CharSequence)parentPageId) && StringUtils.isNotBlank((CharSequence)pageId) && (!pageId.startsWith("root") || !rootPageId.equals(pageId))) {
                String rootPageKey = CacheKeyUtil.getAcctId() + PAGEID_PARENT + rootPageId;
                cache.put(rootPageKey, pageId, parentPageId, CacheKeyUtil.getPageCacheKeyTimeout());
            }
        }
    }

    public static List<String> getPageIds(String rootPageId) {
        String rootPageKey = CacheKeyUtil.getAcctId() + ROOT + rootPageId;
        return cache.getKeys(rootPageKey);
    }

    public static Map<String, String> getPageIdsWithPid(String rootPageId) {
        String parentPageKey = CacheKeyUtil.getAcctId() + PAGEID_PARENT + rootPageId;
        return cache.getAll(parentPageKey);
    }

    public static List<String> getRootPageIds() {
        String rootPageKey = RootPageCache.getSessionKey();
        return cache.getKeys(rootPageKey);
    }

    public static List<String> getRootPageIds(String sessionId) {
        String rootPageKey = RootPageCache.getSessionKey(sessionId);
        return cache.getKeys(rootPageKey);
    }

    public static void clearSessionPageCache(String sessionId) {
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"Root.clearSessionPageCache", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addTag("sessionId", sessionId);
            }
        }
        log.info("clearSessionPageCache");
        for (String rootPageId : RootPageCache.getRootPageIds(sessionId)) {
            RootPageCache.clearRootCahe(rootPageId);
        }
    }

    public static void clearRootCahe(String rootPageId) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"Root.clearRootCahe", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addLocaleTag("rootPageId", (Object)rootPageId);
            log.info(LOG_ROOT, (Object)rootPageId);
            List<String> pageIds = RootPageCache.getPageIds(rootPageId);
            if (pageIds != null) {
                for (String pageId : pageIds) {
                    RootPageCache.clearCurrentPageCache(pageId);
                }
            }
            RootPageCache.clearCurrentPageCache(rootPageId);
            RootPageCache.removePageId(rootPageId, rootPageId);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static void clearRootChildrenCahe(String rootPageId) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"Root.clearRootChildrenCahe", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addLocaleTag("rootPageId", (Object)rootPageId);
            log.info(LOG_ROOT, (Object)rootPageId);
            List<String> pageIds = RootPageCache.getPageIds(rootPageId);
            for (String pageId : pageIds) {
                RootPageCache.clearCurrentPageCache(pageId);
                RootPageCache.removePageId(rootPageId, pageId);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static void clearPageCache(String pageId) {
        FormController srv;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PAGECACHE, (String)"Root.clearPageCache", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addTag("pageId", pageId);
            }
        }
        log.info("pageId: {}", (Object)pageId);
        SessionManager.getCurrent().addReleasePage(pageId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view != null && (srv = (FormController)view.getService(IFormController.class)) != null) {
            srv.releaseDataMutex();
            srv.release(null);
        }
    }

    private static void clearCurrentPageCache(String pageId) {
        log.info("pageId: {}", (Object)pageId);
        FormShowParameter formShowParameter = SessionManager.getCurrent().getFormShowParameter(pageId);
        if (formShowParameter != null) {
            String appId = formShowParameter.getServiceAppId();
            DispatchServiceHelper.invokeBOSService((String)appId, (String)"FormService", (String)"releaseRootChildrenPage", (Object[])new Object[]{pageId});
        }
    }

    public static void refeshChildPageCacheExpire(String rootPageId) {
        List<String> pageIds = RootPageCache.getPageIds(rootPageId);
        if (pageIds != null) {
            for (String pageId : pageIds) {
                try {
                    IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
                    if (view == null) continue;
                    IDataModel model = (IDataModel)view.getService(IDataModel.class);
                    model.cacheExpireAfter(CacheKeyUtil.getPageCacheKeyTimeout());
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        String rootPageKey = RootPageCache.getSessionKey();
        cache.expireAfter(rootPageKey, CacheKeyUtil.getPageCacheKeyTimeout());
        rootPageKey = CacheKeyUtil.getAcctId() + ROOT + rootPageId;
        cache.expireAfter(rootPageKey, CacheKeyUtil.getPageCacheKeyTimeout());
    }
}

