/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.cache;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.util.ConfigurationUtil;

public class TempShowParamCache {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
    private static String timeOutKey = "mvc.aysnformparam.timeout";
    private static int keepTime = Integer.getInteger(timeOutKey, 20);

    public static String put(FormShowParameter fsp) {
        String id = TempShowParamCache.createId(fsp);
        cache.put(TempShowParamCache.getCacheKey(id), (Object)fsp.toString(), keepTime);
        return id;
    }

    public static FormShowParameter get(String id) {
        String data = (String)cache.get(TempShowParamCache.getCacheKey(id));
        if (data == null) {
            return null;
        }
        return FormShowParameter.fromJsonString((String)data);
    }

    public static void remove(String id) {
        cache.remove(id);
    }

    private static String createId(FormShowParameter fsp) {
        return kd.bos.util.StringUtils.randomWord((int)20);
    }

    private static String getCacheKey(String id) {
        RequestContext rs = RequestContext.get();
        return String.format("%s.%s.%s", "tempshowparam", rs.getAccountId(), id);
    }

    static {
        ConfigurationUtil.observeChange((String)timeOutKey, (key, value) -> {
            if (StringUtils.isNotBlank((Object)value)) {
                keepTime = Integer.parseInt(value.toString());
            }
        });
    }
}

