/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.entity.IColumn;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.report.ReportColumn;
import kd.bos.lang.Lang;
import kd.bos.mvc.export.GridExcelExporter;
import kd.bos.mvc.export.RptBoolColExcelExporter;
import kd.bos.mvc.export.RptColExcelExporter;
import kd.bos.mvc.export.RptComboColExporter;
import kd.bos.mvc.export.RptDateColExcelExporter;
import kd.bos.mvc.export.RptDecimalColExcelExporter;
import kd.bos.mvc.export.RptFlexColExcelExporter;
import kd.bos.mvc.export.RptTimeColExcelExporter;
import org.apache.poi.ss.usermodel.CellStyle;

class ColExcelExporter {
    private IColumn column;
    protected CellStyle cellStyle;
    protected int indexOldStyle = 0;

    public ColExcelExporter(IColumn column) {
        this.column = column;
    }

    public Object getValue(DynamicObject rowData, NumberFormatProvider numberFormatProvider) {
        this.cellStyle = null;
        this.indexOldStyle = 0;
        return this.column.getValue(rowData, numberFormatProvider);
    }

    public IColumn getColumn() {
        return this.column;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public int getIndexOldStyle() {
        return this.indexOldStyle;
    }

    public static ColExcelExporter create(IColumn column, GridExcelExporter gridExcelExporter) {
        if (column instanceof ReportColumn) {
            ReportColumn reportCol = (ReportColumn)column;
            RptColExcelExporter colExcelExporter = null;
            if (reportCol.getFieldProperty() instanceof ComboProp) {
                colExcelExporter = new RptComboColExporter(column);
            } else if (reportCol.getFieldProperty() instanceof FlexProp) {
                colExcelExporter = new RptFlexColExcelExporter(column);
                ((RptFlexColExcelExporter)colExcelExporter).setFormatContext(gridExcelExporter.getFormatContext());
            } else {
                colExcelExporter = reportCol.getFieldProperty() instanceof DecimalProp ? new RptDecimalColExcelExporter(column) : (reportCol.getFieldProperty() instanceof DateTimeProp ? new RptDateColExcelExporter(column) : (reportCol.getFieldProperty() instanceof TimeProp ? new RptTimeColExcelExporter(column) : (reportCol.getFieldProperty() instanceof BooleanProp ? new RptBoolColExcelExporter(column) : new RptColExcelExporter(column))));
            }
            colExcelExporter.setWb(gridExcelExporter.getWb());
            reportCol.setDesensitized(PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)reportCol.getFieldProperty(), (String)Lang.get().toString(), (String)"EXPORT"));
            return colExcelExporter;
        }
        return new ColExcelExporter(column);
    }
}

