/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.IBaseColumn;
import kd.bos.entity.IColumn;
import kd.bos.entity.IColumnGroup;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.RowCellStyle;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.FlexColumnDesc;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.export.IExporter;
import kd.bos.form.field.format.FieldFormatContext;
import kd.bos.form.field.format.FlexValueFormatter;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ColExcelExporter;
import kd.bos.mvc.export.MergeExcelCell;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.param.constant.UserParaType;
import kd.bos.report.ReportList;
import kd.bos.report.events.MergeColumnRule;
import kd.bos.report.flex.FlexColumnSplitService;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class GridExcelExporter<T extends IBaseColumn>
implements IExporter<T> {
    private static final Log log = LogFactory.getLog(GridExcelExporter.class);
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private static final String CELLSTYLE_ALIGN_DEFAULT = "default";
    private static final int MAX_SEARCH_CONDITION_LENGTH = 10000;
    private XSSFCellStyle headColumnStyle = null;
    private CellStyle commonStyle = null;
    private List<SXSSFRow> headRows = new ArrayList<SXSSFRow>();
    private int colIndex = 0;
    private int rowIndex = 0;
    private List<IColumn> columns;
    private List<ColExcelExporter> colExporters;
    private String caption;
    private String searchCondition;
    private Map<String, Boolean> map = new HashMap<String, Boolean>();
    private List<RowCellStyle> rowCellStyles = new ArrayList<RowCellStyle>();
    private Map<Integer, Integer> rowStyleMap = new HashMap<Integer, Integer>();
    private List<MergeColumnRule> mergeColumnRules;
    private boolean isShowZero = true;
    private SXSSFWorkbook wb;
    private SXSSFSheet sheet;
    private int loopTimes;
    private int size;
    private int filterRows = 0;
    private FieldFormatContext formatContext;
    private ReportList reportList;
    private FlexColumnSplitService flexColumnSplitService;
    private String sheetName = "sheet1";
    Map<String, Object> flexValues = new HashMap<String, Object>();
    Map<String, CellStyle> mapCellStyle = new HashMap<String, CellStyle>();
    Map<String, FlexValueFormatter> flexFormaterMap = new HashMap<String, FlexValueFormatter>();
    private CellStyle newCellStyle = null;
    private Map<String, CellStyle> styleMap = new HashMap<String, CellStyle>();
    private boolean flag = true;
    private Map<String, CellStyle> decimalStyles = new HashMap<String, CellStyle>();
    private Map<String, CellStyle> textStyles = new HashMap<String, CellStyle>();
    private Map<String, CellStyle> formulaStyles = new HashMap<String, CellStyle>();
    private Map<String, String> keyCaptionMap = new HashMap<String, String>();

    private List<RowCellStyle> getRowCellStyles() {
        return this.rowCellStyles;
    }

    private Map getRowStyleMap() {
        return this.rowStyleMap;
    }

    public Map<String, Boolean> getMap() {
        return this.map;
    }

    public void setMap(Map<String, Boolean> map) {
        this.map = map;
    }

    public void setMergeColumnRules(List<MergeColumnRule> mergeColumnRules) {
        if (!CollectionUtils.isEmpty(mergeColumnRules)) {
            this.mergeColumnRules = mergeColumnRules;
            for (MergeColumnRule rule : mergeColumnRules) {
                rule.init();
            }
        }
    }

    public String getSearchCondition() {
        return this.searchCondition;
    }

    private String getSearchConditionByLength() {
        if (this.searchCondition.length() > 10000) {
            String condition = this.searchCondition.substring(0, 10000);
            return condition + "...";
        }
        return this.searchCondition;
    }

    public void setSearchCondition(String searchCondition) {
        this.searchCondition = searchCondition;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setReportList(ReportList reportList) {
        this.reportList = reportList;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String export(List<T> columns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        return this.export(columns, data, numberFormatProvider, new ArrayList<RowCellStyle>());
    }

    /*
     * WARNING - void declaration
     */
    public String export(List<T> columns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider, List<RowCellStyle> rowCellStyles) {
        void var8_13;
        DynamicObject parameter;
        if (data == null) {
            return null;
        }
        if (columns == null || columns.isEmpty()) {
            return null;
        }
        if (this.reportList != null) {
            this.flexColumnSplitService = this.reportList.getFlexColumnSplitService();
        }
        int in = -1;
        for (int i = 0; i < columns.size(); ++i) {
            Object reportColumn;
            if (!(columns.get(i) instanceof ReportColumn) || !"fseq".equals((reportColumn = (ReportColumn)columns.get(i)).getFieldKey())) continue;
            in = i;
            break;
        }
        if (in != -1 && in != 0) {
            ReportColumn reportColumn = (ReportColumn)columns.get(in);
            columns.remove(in);
            columns.add(0, reportColumn);
        }
        if (StringUtils.isBlank((CharSequence)this.sheetName)) {
            this.sheetName = "sheet1";
        }
        if (this.getLoopTimes() == 0) {
            this.sheet = this.wb.getSheet(this.sheetName);
            this.colIndex = 0;
            this.headRows = new ArrayList<SXSSFRow>();
            this.createSearchCondition(this.wb, this.sheet, columns);
            this.createHeadColumn(this.wb, this.sheet, columns, 0);
        }
        this.rowCellStyles = rowCellStyles;
        int index = 0;
        for (RowCellStyle rowCellStyle : rowCellStyles) {
            int row = rowCellStyle.getRow();
            this.rowStyleMap.put(row, index);
            ++index;
        }
        ArrayList<IColumn> cols = new ArrayList<IColumn>();
        this.toReportColumns(columns, cols);
        if (this.formatContext == null) {
            this.formatContext = new FieldFormatContext((MainEntityType)null, this.getColumnDesc(cols), data);
            this.formatContext.setForExport(true);
            this.formatContext.setPerPageSize(data.size());
        } else {
            this.formatContext.setPerPageSize(data.size());
            this.formatContext.setPageData(data);
        }
        for (FlexValueFormatter value : this.flexFormaterMap.values()) {
            value.setBaseKeyMapFlexProperties(null);
        }
        String string = this.reportList.getView().getPageCache().get("isshowzero_weiling");
        if (string == null && (parameter = ParameterReader.getUserOptionParameter((Long)RequestContext.get().getCurrUserId(), (String)this.reportList.getView().getFormShowParameter().getFormId(), (String)"bos_gridoptiontpl", (UserParaType)UserParaType.GRID, (String)this.reportList.getKey())) != null && parameter.containsProperty("isshowzero")) {
            String string2 = parameter.getString("isshowzero");
        }
        if (StringUtils.isNotEmpty((CharSequence)var8_13) && !Boolean.parseBoolean((String)var8_13)) {
            this.isShowZero = false;
        }
        this.createBodyColumn(this.wb, this.sheet, cols, data, numberFormatProvider);
        if (this.getLoopTimes() == 0) {
            this.adjustColumnWidth(this.sheet, cols);
            this.mergeTableHead(this.sheet);
            this.renameTableHeadCells(this.sheet);
        }
        return null;
    }

    public void endExport() {
        if (!CollectionUtils.isEmpty(this.mergeColumnRules)) {
            for (MergeColumnRule rule : this.mergeColumnRules) {
                rule.end(this.rowIndex, this.sheet);
            }
        }
    }

    protected int createRptHead(XSSFWorkbook wb, XSSFSheet sheet) {
        return 0;
    }

    protected int createBodyColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<IColumn> cols, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        SXSSFRow row = null;
        int rowIndex = this.headRows.size() + this.getLoopTimes() * this.getSize() + this.filterRows;
        this.createColExcelExporters(cols);
        for (DynamicObject rowData : data) {
            row = sheet.createRow(rowIndex++);
            this.flexValues = new HashMap<String, Object>();
            this.setRowData(wb, row, rowData, cols, numberFormatProvider);
        }
        this.rowIndex = rowIndex;
        return rowIndex;
    }

    private void createColExcelExporters(List<IColumn> cols) {
        this.colExporters = new ArrayList<ColExcelExporter>(cols.size());
        this.columns = new ArrayList<IColumn>(cols.size());
        for (IColumn col : cols) {
            ColExcelExporter colExporter = ColExcelExporter.create(col, this);
            this.colExporters.add(colExporter);
            this.columns.add(col);
        }
    }

    private void toReportColumns(List<T> acols, List<IColumn> cols) {
        for (IBaseColumn acol : acols) {
            if (!this.isValidColumn(acol)) continue;
            if (acol instanceof IColumn) {
                cols.add((IColumn)acol);
                continue;
            }
            if (!(acol instanceof IColumnGroup)) continue;
            List children = ((IColumnGroup)acol).getChildren();
            this.toReportColumns(children, cols);
        }
    }

    protected void setRowData(SXSSFWorkbook wb, SXSSFRow row, DynamicObject rowData, List<IColumn> columns, NumberFormatProvider numberFormatProvider) {
        SXSSFCell cell = null;
        SXSSFCell cell1 = null;
        int cellIndex = 0;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            String fieldKey;
            Boolean customVisiable;
            IColumn col = columns.get(i);
            if (col.isHide() || col.isPicture() || (customVisiable = this.map.get(fieldKey = col.getFieldKey())) != null && customVisiable.booleanValue() || this.isExportSeqColumn(fieldKey)) continue;
            cell = row.createCell(cellIndex);
            this.setCellValueAndStyle(wb, col, cell, rowData, numberFormatProvider);
            ++cellIndex;
        }
        if (!CollectionUtils.isEmpty(this.mergeColumnRules)) {
            for (int j = 0; j < this.mergeColumnRules.size(); ++j) {
                MergeColumnRule mergeColumnRule = this.mergeColumnRules.get(j);
                List mergeColumns = mergeColumnRule.getMergeColumns();
                int cellIndex1 = 0;
                int size2 = columns.size();
                for (int i = 0; i < size2; ++i) {
                    String fieldKey = columns.get(i).getFieldKey();
                    if (mergeColumns.contains(fieldKey)) {
                        cell1 = row.createCell(cellIndex1);
                        this.setCellValueAndStyle(wb, columns.get(i), cell1, rowData, numberFormatProvider);
                        int rowIndex = cell1.getRowIndex();
                        mergeColumnRule.setBlank(this.sheet, rowIndex, cell1.getColumnIndex());
                    }
                    ++cellIndex1;
                }
            }
        }
    }

    private boolean isExportSeqColumn(String key) {
        if (this.reportList == null || StringUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        return !this.reportList.isShowSeq() && "fseq".equals(key);
    }

    private boolean isExportSeqColumn(IColumn col) {
        if (this.reportList == null || col == null) {
            return false;
        }
        return !this.reportList.isShowSeq() && "fseq".equals(col.getFieldKey());
    }

    protected void setCellValueAndStyle(SXSSFWorkbook wb, IColumn col, SXSSFCell cell, DynamicObject rowData, NumberFormatProvider numberFormatProvider) {
        int seq;
        Integer listIndex;
        byte[] bytes;
        ReportColumn reportColumn;
        Object value;
        XSSFCellStyle cellStyle = null;
        HashMap<String, Integer> indexOldStyleMap = new HashMap<String, Integer>();
        if (this.flexColumnSplitService != null && this.flexColumnSplitService.getFlexBaseFieldKeyMap().containsKey(col.getFieldKey())) {
            value = this.getSplitColumnValue(col, rowData);
        } else {
            Tuple<Object, CellStyle> tuple = this.getCommonReportColumnValue(col, rowData, numberFormatProvider, indexOldStyleMap);
            value = tuple.item1;
            cellStyle = (XSSFCellStyle)tuple.item2;
        }
        int indexOldStyle = indexOldStyleMap.get("indexOldStyle") == null ? 0 : (Integer)indexOldStyleMap.get("indexOldStyle");
        byte[] colorRgb = new byte[]{-1, -1, -1};
        if (cellStyle == null && col instanceof ReportColumn) {
            reportColumn = (ReportColumn)col;
            String color = "";
            if (reportColumn.getStyle() != null && StringUtils.isNotEmpty((CharSequence)reportColumn.getStyle().getBackColor())) {
                color = reportColumn.getStyle().getBackColor();
            }
            cellStyle = (XSSFCellStyle)this.getTextStyle(wb, CELLSTYLE_ALIGN_DEFAULT, color, colorRgb);
            indexOldStyle = 4;
        }
        if (col instanceof ReportColumn && (reportColumn = (ReportColumn)col).getStyle() != null && StringUtils.isNotEmpty((CharSequence)reportColumn.getStyle().getBackColor()) && (bytes = this.hexToByteArray(reportColumn.getStyle().getBackColor())).length == 4) {
            colorRgb[0] = bytes[1];
            colorRgb[1] = bytes[2];
            colorRgb[2] = bytes[3];
            cellStyle.setFillForegroundColor(new XSSFColor(colorRgb));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setHidden(false);
        }
        if (value != null && !this.isShowZero && value instanceof Number) {
            value = col.getValue(rowData, numberFormatProvider);
        }
        if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value == null) {
            cell.setCellValue((String)null);
        } else {
            if (value.toString().length() >= Short.MAX_VALUE) {
                this.reportList.getView().getPageCache().put("cellDataSizeIsOver", "true");
                throw new KDException(BosErrorCode.paramError, new Object[0]);
            }
            cell.setCellValue(value.toString());
        }
        cell.setCellStyle((CellStyle)cellStyle);
        if (this.flag && !this.rowStyleMap.isEmpty() && (listIndex = this.rowStyleMap.get(seq = rowData.getInt("fseq"))) != null) {
            String style = new StringBuffer().append(this.rowCellStyles.get(listIndex).getForeGroundColor()).append(this.rowCellStyles.get(listIndex).getFondColor()).append(indexOldStyle).toString();
            this.setCellStyle(wb, style, seq, (CellStyle)cellStyle, cell);
        }
        this.addMergedRegion(col, value, cell);
    }

    private Object getSplitColumnValue(IColumn col, DynamicObject rowData) {
        Object value;
        if (this.flexValues.size() > 0) {
            value = this.flexValues.get(col.getFieldKey());
        } else {
            String flexFieldKey = this.flexColumnSplitService.getFlexFieldKey(col.getFieldKey());
            FlexProp flexProp = (FlexProp)this.flexColumnSplitService.getEntityType().getProperty(flexFieldKey);
            FlexValueFormatter flexFormatter = this.flexFormaterMap.get(col.getFieldKey());
            if (flexFormatter == null) {
                flexFormatter = new FlexValueFormatter(this.formatContext, col.getFieldKey());
                this.flexFormaterMap.put(col.getFieldKey(), flexFormatter);
            }
            if (this.flexValues.size() == 0) {
                this.flexValues.put("hasLoadFlexValue", true);
            }
            this.flexValues = this.flexColumnSplitService.getSplitFlexFieldValue(flexProp, flexFormatter, rowData);
            value = this.flexValues.get(col.getFieldKey());
        }
        return value;
    }

    private Tuple<Object, CellStyle> getCommonReportColumnValue(IColumn col, DynamicObject rowData, NumberFormatProvider numberFormatProvider, Map<String, Integer> map) {
        int index;
        ColExcelExporter colExporter = null;
        if (this.columns != null && (index = this.columns.indexOf(col)) >= 0 && this.colExporters.size() > index) {
            colExporter = this.colExporters.get(index);
        }
        if (colExporter == null) {
            colExporter = ColExcelExporter.create(col, this);
        }
        Object value = colExporter.getValue(rowData, numberFormatProvider);
        CellStyle cellStyle = colExporter.getCellStyle();
        int indexOldStyle = colExporter.getIndexOldStyle();
        map.put("indexOldStyle", indexOldStyle);
        return new Tuple(value, (Object)cellStyle);
    }

    private void setCellStyle(SXSSFWorkbook wb, String style, int seq, CellStyle cellStyle, SXSSFCell cell) {
        this.newCellStyle = this.styleMap.get(style);
        if (StringUtils.isBlank((Object)this.newCellStyle)) {
            Short fillForegroundColor;
            this.newCellStyle = wb.createCellStyle();
            this.newCellStyle.cloneStyleFrom(cellStyle);
            int listIndex = this.rowStyleMap.get(seq);
            Short fondColor = this.rowCellStyles.get(listIndex).getFondColor();
            if (StringUtils.isNotBlank((Object)fondColor)) {
                Font font = wb.createFont();
                font.setColor(fondColor.shortValue());
                this.newCellStyle.setFont(font);
            }
            if (StringUtils.isNotBlank((Object)(fillForegroundColor = this.rowCellStyles.get(listIndex).getForeGroundColor()))) {
                this.newCellStyle.setFillForegroundColor(fillForegroundColor.shortValue());
                this.newCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            this.styleMap.put(style, this.newCellStyle);
            if (this.styleMap.size() > 3900) {
                this.flag = false;
            }
        }
        cell.setCellStyle(this.newCellStyle);
    }

    private boolean isDecimalTooBig(String decimalStr) {
        int j;
        int i = decimalStr.lastIndexOf(46);
        if (i >= 0) {
            for (j = decimalStr.length() - 1; j > i && decimalStr.charAt(j) == '0'; --j) {
            }
        }
        if (decimalStr.startsWith("-")) {
            --j;
        }
        return j > 15;
    }

    private int getDecimalPrecision(DynamicObject dr, DecimalProp prop) {
        int minimumFractionDigits = prop.getScale();
        if (prop.getControlPropName() != null && prop instanceof QtyProp) {
            IDataEntityType dt = prop.getParent();
            DynamicObject unit = null;
            if (dt instanceof SubEntryType) {
                try {
                    unit = (DynamicObject)dr.get(dt.getParent().getName() + "." + dt.getName() + "." + prop.getControlPropName());
                }
                catch (OrmException e) {
                    try {
                        unit = (DynamicObject)dr.get(dt.getParent().getName() + "." + prop.getControlPropName());
                    }
                    catch (OrmException e2) {
                        unit = (DynamicObject)dr.get(prop.getControlPropName());
                    }
                }
            } else if (dt instanceof EntryType) {
                try {
                    unit = (DynamicObject)dr.get(dt.getName() + "." + prop.getControlPropName());
                }
                catch (OrmException e) {
                    unit = (DynamicObject)dr.get(prop.getControlPropName());
                }
            } else {
                try {
                    unit = (DynamicObject)dr.get(prop.getControlPropName());
                }
                catch (OrmException e) {
                    unit = null;
                }
            }
            if (unit != null) {
                try {
                    minimumFractionDigits = unit.getInt("precision");
                }
                catch (KDException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return minimumFractionDigits;
    }

    private int getAmountPrecision(DynamicObject dr, AmountProp prop) {
        String precisionField = "amtprecision";
        if (prop instanceof PriceProp) {
            precisionField = "priceprecision";
        }
        int minimumFractionDigits = prop.getScale();
        minimumFractionDigits = prop instanceof PriceProp ? Integer.parseInt(String.valueOf(FmtInfoUtils.getMainCurrencyFmt().get("pp"))) : Integer.parseInt(String.valueOf(FmtInfoUtils.getMainCurrencyFmt().get("ap")));
        if (prop.getControlPropName() != null) {
            IDataEntityType dt = prop.getParent();
            DynamicObject currency = null;
            if (dt instanceof SubEntryType) {
                try {
                    currency = (DynamicObject)dr.get(dt.getParent().getName() + "." + dt.getName() + "." + prop.getControlPropName());
                }
                catch (OrmException e) {
                    try {
                        currency = (DynamicObject)dr.get(dt.getParent().getName() + "." + prop.getControlPropName());
                    }
                    catch (OrmException e2) {
                        currency = (DynamicObject)dr.get(prop.getControlPropName());
                    }
                }
            } else if (dt instanceof EntryType) {
                try {
                    currency = (DynamicObject)dr.get(dt.getName() + "." + prop.getControlPropName());
                }
                catch (OrmException e) {
                    currency = (DynamicObject)dr.get(prop.getControlPropName());
                }
            } else {
                try {
                    currency = (DynamicObject)dr.get(prop.getControlPropName());
                }
                catch (KDException e) {
                    currency = null;
                }
            }
            if (currency != null) {
                try {
                    minimumFractionDigits = currency.getInt(precisionField);
                }
                catch (KDException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return minimumFractionDigits;
    }

    private boolean checkIsNumric(String str) {
        return str.matches("-?[0-9]+.?[0-9]*");
    }

    private static void setCommonStyle(CellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
    }

    private CellStyle getCommonStyle(SXSSFWorkbook wb) {
        if (this.commonStyle == null) {
            this.commonStyle = wb.createCellStyle();
            GridExcelExporter.setCommonStyle(this.commonStyle);
        }
        return this.commonStyle;
    }

    private CellStyle getTextStyle(SXSSFWorkbook wb, String align, String color, byte[] colorRgb) {
        byte[] bytes;
        String style = "TEXT_" + align + color;
        XSSFCellStyle cs = (XSSFCellStyle)this.textStyles.get(style);
        if (StringUtils.isNotEmpty((CharSequence)color) && (bytes = this.hexToByteArray(color)).length == 4) {
            colorRgb[0] = bytes[1];
            colorRgb[1] = bytes[2];
            colorRgb[2] = bytes[3];
        }
        if (cs == null) {
            cs = wb.getXSSFWorkbook().createCellStyle();
            GridExcelExporter.setCommonStyle((CellStyle)cs);
            cs.setDataFormat(wb.createDataFormat().getFormat("@"));
            cs.setAlignment(this.getAlignment(align));
            cs.setFillForegroundColor(new XSSFColor(colorRgb));
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.textStyles.put(style, (CellStyle)cs);
        }
        return cs;
    }

    private CellStyle getDecimalStyle(SXSSFWorkbook wb, int precision, String align) {
        CellStyle style = null;
        style = this.decimalStyles.get(precision + " " + align);
        if (style == null) {
            String format = "_(#,##0.00_);_(-#,##0.00_)";
            format = format.replaceAll("\\.00", precision > 0 ? String.format(".%0" + precision + "d", 0) : "");
            style = wb.createCellStyle();
            GridExcelExporter.setCommonStyle(style);
            style.setDataFormat(wb.createDataFormat().getFormat(format));
            style.setAlignment(this.getAlignment(align));
            this.decimalStyles.put(precision + " " + align, style);
        }
        return style;
    }

    private CellStyle getFormulaStyle(SXSSFWorkbook wb, String align) {
        String style = "FORMULA_" + align;
        CellStyle cs = this.formulaStyles.get(style);
        if (cs == null) {
            cs = wb.createCellStyle();
            GridExcelExporter.setCommonStyle(cs);
            cs.setDataFormat((short)0);
            cs.setAlignment(this.getAlignment(align));
            this.formulaStyles.put(style, cs);
        }
        return cs;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    protected void setCellNumberValue(XSSFCell cell, Number value) {
        if (value == null || value.doubleValue() == 0.0) {
            cell.setCellValue((RichTextString)new XSSFRichTextString(""));
        } else {
            cell.setCellValue(value.doubleValue());
        }
    }

    private void createSearchCondition(SXSSFWorkbook wb, SXSSFSheet sheet, List<T> columns) {
        ArrayList cols = new ArrayList();
        this.addReportColumn(columns, cols);
        SXSSFRow row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        for (int i = 0; i < cols.size(); ++i) {
            SXSSFCell cell = row.createCell(i);
            cell.setCellValue(this.getCaption());
            cell.setCellStyle(GridExcelExporter.createTitleCellStyle(wb));
        }
        if (cols.size() > 1) {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, cols.size() - 1));
        }
        if (!StringUtils.isBlank((CharSequence)this.getSearchCondition())) {
            SXSSFRow row1 = sheet.createRow(1);
            for (int i = 0; i < cols.size(); ++i) {
                SXSSFCell cell1 = row1.createCell(i);
                cell1.setCellValue(this.getSearchConditionByLength());
                cell1.setCellStyle(GridExcelExporter.createConditionCellStyle(wb));
            }
            if (cols.size() > 1) {
                sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, cols.size() - 1));
            }
            this.filterRows = 2;
        } else {
            this.filterRows = 1;
        }
    }

    private static CellStyle createTitleCellStyle(SXSSFWorkbook wb) {
        CellStyle cellStyle = wb.createCellStyle();
        GridExcelExporter.setCommonStyle(cellStyle);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setWrapText(true);
        Font headerFont1 = wb.createFont();
        headerFont1.setBold(true);
        cellStyle.setFont(headerFont1);
        return cellStyle;
    }

    private static CellStyle createConditionCellStyle(SXSSFWorkbook wb) {
        CellStyle cellStyle = wb.createCellStyle();
        GridExcelExporter.setCommonStyle(cellStyle);
        cellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setWrapText(true);
        Font headerFont1 = wb.createFont();
        headerFont1.setColor(IndexedColors.BLUE.index);
        cellStyle.setFont(headerFont1);
        return cellStyle;
    }

    private void addReportColumn(List<T> columns, List<T> cols) {
        for (IBaseColumn col : columns) {
            if (!this.isValidColumn(col)) continue;
            if (this.isColumnGroup(col)) {
                List children = ((IColumnGroup)col).getChildren();
                this.addReportColumn(children, cols);
                continue;
            }
            cols.add(col);
        }
    }

    private boolean isValidColumn(T col) {
        ReportColumnGroup rc;
        boolean validColumn = true;
        if (col instanceof ReportColumn) {
            ReportColumn rc2 = (ReportColumn)col;
            if (rc2.isHide() || rc2.isPicture() || this.map.containsKey(rc2.getFieldKey()) && this.map.get(rc2.getFieldKey()).booleanValue() || this.isExportSeqColumn((IColumn)col)) {
                validColumn = false;
            }
        } else if (col instanceof ReportColumnGroup && this.map.containsKey((rc = (ReportColumnGroup)col).getFieldKey()) && this.map.get(rc.getFieldKey()).booleanValue()) {
            validColumn = false;
        }
        return validColumn;
    }

    private void createHeadColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<T> columns, int rowIndex) {
        for (IBaseColumn col : columns) {
            SXSSFRow row;
            if (!this.isValidColumn(col)) continue;
            if (rowIndex >= this.headRows.size()) {
                row = sheet.createRow(rowIndex + this.filterRows);
                this.headRows.add(row);
            } else {
                row = this.headRows.get(rowIndex);
            }
            this.setTempCell(sheet, rowIndex);
            SXSSFCell cell = row.createCell(this.colIndex);
            LocaleString caption = col.getCaption();
            String fieldKey = "";
            String color = "";
            if (col instanceof ReportColumnGroup) {
                fieldKey = ((ReportColumnGroup)col).getFieldKey();
                color = ((ReportColumnGroup)col).getTableHeaderCellBackColor();
            } else if (col instanceof ReportColumn) {
                fieldKey = ((ReportColumn)col).getFieldKey();
                color = ((ReportColumn)col).getTableHeaderCellBackColor();
            }
            this.keyCaptionMap.put(fieldKey, caption == null ? "" : caption.toString());
            cell.setCellValue((RichTextString)new XSSFRichTextString(fieldKey));
            cell.setCellType(CellType.STRING);
            cell.setCellStyle(this.getHeadColumnStyle(wb, color));
            if (this.isColumnGroup(col) && !((ReportColumnGroup)col).isMerge()) {
                List children = ((IColumnGroup)col).getChildren();
                this.createHeadColumn(wb, sheet, children, rowIndex + 1);
                continue;
            }
            if (this.isColumnGroup(col) && ((ReportColumnGroup)col).isMerge()) {
                List children = ((IColumnGroup)col).getChildren();
                this.createHeadColumn(wb, sheet, children, rowIndex);
                continue;
            }
            int r = rowIndex;
            while (r < this.headRows.size() - 1) {
                row = this.headRows.get(++r);
                this.copyCell(sheet.getRow(r - 1 + this.filterRows).getCell(this.colIndex), row.createCell(this.colIndex));
            }
            ++this.colIndex;
        }
    }

    private void setTempCell(SXSSFSheet sheet, int rowIndex) {
        SXSSFRow row = sheet.getRow(rowIndex + this.filterRows);
        this.setTempCell(sheet, row, rowIndex, this.colIndex - 1);
        for (int i = 0; i < rowIndex; ++i) {
            SXSSFRow r = this.headRows.get(i);
            SXSSFCell cell = r.getCell(this.colIndex);
            if (cell != null) continue;
            this.copyCell(r.getCell(this.colIndex - 1), r.createCell(this.colIndex));
        }
    }

    private void setTempCell(SXSSFSheet sheet, SXSSFRow row, int rowIndex, int colIndex) {
        if (rowIndex == 0 || colIndex < 0) {
            return;
        }
        SXSSFCell cell = row.getCell(colIndex);
        if (cell == null && colIndex >= 0) {
            this.copyCell(sheet.getRow(this.filterRows + rowIndex - 1).getCell(colIndex), row.createCell(colIndex));
            if (colIndex > 0) {
                this.setTempCell(sheet, row, rowIndex, colIndex - 1);
            }
        }
    }

    private boolean isColumnGroup(T col) {
        return col instanceof IColumnGroup;
    }

    private void copyCell(SXSSFCell cell, SXSSFCell newCell) {
        newCell.setCellValue(cell.getStringCellValue());
        newCell.setCellType(cell.getCellType());
        newCell.setCellStyle(cell.getCellStyle());
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb, String color) {
        this.headColumnStyle = wb.getXSSFWorkbook().createCellStyle();
        GridExcelExporter.setCommonStyle((CellStyle)this.headColumnStyle);
        byte[] colorRgb = new byte[]{-48, -48, -48};
        if (StringUtils.isNotEmpty((CharSequence)color)) {
            byte[] bytes = this.hexToByteArray(color);
            if (bytes.length == 4) {
                colorRgb[0] = bytes[1];
                colorRgb[1] = bytes[2];
                colorRgb[2] = bytes[3];
            }
            this.headColumnStyle.setFillForegroundColor(new XSSFColor(colorRgb));
        } else {
            this.headColumnStyle.setFillForegroundColor(new XSSFColor(colorRgb));
        }
        this.headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        this.headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.headColumnStyle.setHidden(false);
        return this.headColumnStyle;
    }

    private byte[] hexToByteArray(String hex) {
        if (!hex.startsWith("#") || hex.length() != 7 && hex.length() != 4) {
            return new byte[0];
        }
        char[] charArr = hex.toCharArray();
        for (int i = 1; i < charArr.length; ++i) {
            if (charArr[i] >= '0' && charArr[i] <= '9' || charArr[i] >= 'a' && charArr[i] <= 'f' || charArr[i] >= 'A' && charArr[i] <= 'F') continue;
            return new byte[0];
        }
        if (hex.length() == 4) {
            char[] chars = hex.toCharArray();
            StringBuilder sb = new StringBuilder();
            sb.append("#");
            for (int i = 1; i < chars.length; ++i) {
                sb.append(chars[i]).append(chars[i]);
            }
            hex = sb.toString();
        }
        hex = hex.toUpperCase().replace("#", "");
        int color = Integer.parseInt(hex, 16);
        byte[] bytes = new byte[]{(byte)(color >> 24), (byte)(color >> 16), (byte)(color >> 8), (byte)color};
        return bytes;
    }

    private void adjustColumnWidth(SXSSFSheet sheet, List<IColumn> cols) {
        int index = 0;
        for (IColumn col : cols) {
            if (col.isHide() || col.isPicture() || this.isExportSeqColumn(col)) continue;
            if (col.getWidth() != null) {
                String width = (String)col.getWidth().getDefaultItem();
                if (!StringUtils.isEmpty((CharSequence)width)) {
                    int w;
                    if (width.endsWith("px")) {
                        if (!StringUtils.isEmpty((CharSequence)(width = width.substring(0, width.length() - 2)))) {
                            w = Integer.parseInt(width.trim());
                            if (w * 40 > 65280) {
                                sheet.setColumnWidth(index, 6000);
                            } else {
                                sheet.setColumnWidth(index, w * 40);
                            }
                        }
                    } else if (this.IsIntNumber(width)) {
                        w = Integer.parseInt(width.trim());
                        if (w * 40 > 65280) {
                            sheet.setColumnWidth(index, 6000);
                        } else {
                            sheet.setColumnWidth(index, w * 40);
                        }
                    }
                }
            } else if (col.getCaption() != null && col.getCaption().getLocaleValue() != null) {
                int w = col.getCaption().getLocaleValue().getBytes().length;
                if (w * 2 * 160 > 65280) {
                    sheet.setColumnWidth(index, 6000);
                } else {
                    sheet.setColumnWidth(index, w * 2 * 160);
                }
            } else {
                sheet.setColumnWidth(index, 1600);
            }
            ++index;
        }
    }

    private boolean match(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    private boolean IsIntNumber(String str) {
        String regex = "^\\+?[1-9][0-9]*$";
        return this.match(regex, str);
    }

    private void mergeTableHead(SXSSFSheet sheet) {
        MergeExcelCell[][] cells = this.getTableHeadCells(sheet);
        int rowCount = cells.length;
        if (rowCount == 0) {
            throw new KDException(BosErrorCode.reportHeadEmpty, new Object[0]);
        }
        int colCount = cells[0].length;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                MergeExcelCell rowCell;
                MergeExcelCell colCell;
                int col;
                int row = i + 1;
                MergeExcelCell firstCell = cells[i][j];
                firstCell.setMerged(true);
                boolean colMerge = false;
                for (col = j + 1; col < colCount && !(colCell = cells[i][col]).isMerged() && firstCell.getValue().equals(colCell.getValue()); ++col) {
                    if (i == 0) {
                        colCell.setMerged(true);
                        colMerge = true;
                    }
                    if (i <= 0 || !cells[i - 1][j].getValue().equals(cells[i - 1][col].getValue()) || !cells[i - 1][j].isMerged() || !cells[i - 1][col].isMerged()) continue;
                    colCell.setMerged(true);
                    colMerge = true;
                }
                boolean rowMerge = false;
                while (row < rowCount && !(rowCell = cells[row][j]).isMerged() && firstCell.getValue().equals(rowCell.getValue())) {
                    rowCell.setMerged(true);
                    rowMerge = true;
                    ++row;
                }
                if (!colMerge && !rowMerge) continue;
                CellRangeAddress rang = new CellRangeAddress(i + this.filterRows, row + this.filterRows - 1, j, col - 1);
                sheet.addMergedRegion(rang);
            }
        }
    }

    private MergeExcelCell[][] getTableHeadCells(SXSSFSheet sheet) {
        int headRowSize = this.headRows.size();
        MergeExcelCell[][] cells = new MergeExcelCell[headRowSize][this.colIndex];
        for (int i = 0; i < headRowSize; ++i) {
            SXSSFRow row = sheet.getRow(i + this.filterRows);
            for (int j = 0; j < this.colIndex; ++j) {
                cells[i][j] = new MergeExcelCell(row.getCell(j).getStringCellValue());
            }
        }
        return cells;
    }

    private void renameTableHeadCells(SXSSFSheet sheet) {
        int headRowSize = this.headRows.size();
        for (int i = 0; i < headRowSize; ++i) {
            SXSSFRow row = sheet.getRow(i + this.filterRows);
            for (int j = 0; j < this.colIndex; ++j) {
                row.getCell(j).setCellValue(this.keyCaptionMap.get(row.getCell(j).getStringCellValue()));
            }
        }
    }

    protected String getTempFilename(String formName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        String currDateTime = dateFormat.format(new Date());
        String userName = RequestContext.get().getUserName();
        return formName + "-" + currDateTime + "-" + userName + ".xlsx";
    }

    public SXSSFWorkbook getWb() {
        return this.wb;
    }

    public void setWb(SXSSFWorkbook wb) {
        this.wb = wb;
    }

    public int getLoopTimes() {
        return this.loopTimes;
    }

    public void setLoopTimes(int loopTimes) {
        this.loopTimes = loopTimes;
    }

    public int getSize() {
        return this.size;
    }

    public FieldFormatContext getFormatContext() {
        return this.formatContext;
    }

    public void setSize(int size) {
        this.size = size;
    }

    private String getNumber(String str) {
        return str.replaceAll("[^0-9\\.]", "");
    }

    private String getDisplayValue(ReportColumn reportColumn, Object value) {
        if ("checkbox".equals(reportColumn.getFieldType()) && value instanceof Boolean) {
            if (reportColumn.getCheckBoxReportShowStyle() == 0) {
                if (((Boolean)value).booleanValue()) {
                    return "\u221a";
                }
                return null;
            }
            if (reportColumn.getCheckBoxReportShowStyle() == 1) {
                if (((Boolean)value).booleanValue()) {
                    return null == reportColumn.getOTitleReport() ? ResManager.loadKDString((String)"\u662f", (String)"GridExcelExporter_0", (String)BOS_FORM_MVC, (Object[])new Object[0]) : reportColumn.getOTitleReport();
                }
                return null == reportColumn.getXTitleReport() ? ResManager.loadKDString((String)"\u5426", (String)"GridExcelExporter_1", (String)BOS_FORM_MVC, (Object[])new Object[0]) : reportColumn.getXTitleReport();
            }
        }
        return StringUtils.isBlank((Object)value) ? null : value.toString();
    }

    private Object getDesensitizeValue(ReportColumn reportColumn, DynamicObject dr, Object value) {
        if (reportColumn == null) {
            return value;
        }
        String operateType = "EXPORT";
        boolean isDesensitizeField = false;
        DynamicProperty thisFieldProp = reportColumn.getFieldProperty();
        if (thisFieldProp != null) {
            isDesensitizeField = PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)thisFieldProp, (String)Lang.get().toString(), (String)operateType, (DynamicObject)dr);
        }
        if (isDesensitizeField) {
            if (value instanceof Object[]) {
                Object[] val = (Object[])value;
                for (int i = 0; i < val.length; ++i) {
                    val[i] = PrivacyCenterUtils.getDesensitizeValue((IDataEntityProperty)thisFieldProp, (String)Lang.get().toString(), (String)operateType, (DynamicObject)dr, (Object)val[i]);
                }
            } else {
                value = PrivacyCenterUtils.getDesensitizeValue((IDataEntityProperty)thisFieldProp, (String)Lang.get().toString(), (String)operateType, (DynamicObject)dr, (Object)value);
            }
        }
        return value;
    }

    private List<AbstractColumnDesc> getColumnDesc(List<IColumn> cols) {
        ArrayList<AbstractColumnDesc> columns = new ArrayList<AbstractColumnDesc>(cols.size());
        for (IColumn col : cols) {
            ReportColumn reportColumn;
            DynamicProperty fieldProperty;
            if (!(col instanceof ReportColumn) || !(((ReportColumn)col).getFieldProperty() instanceof FlexProp) || !((fieldProperty = (reportColumn = (ReportColumn)col).getFieldProperty()) instanceof FlexProp)) continue;
            columns.add((AbstractColumnDesc)new FlexColumnDesc(col.getFieldKey(), (IDataEntityProperty)fieldProperty, (IDataEntityProperty)fieldProperty, ((FlexProp)fieldProperty).getBasePropertyKey()));
        }
        return columns;
    }

    private void addMergedRegion(IColumn col, Object value, SXSSFCell cell) {
        if (!CollectionUtils.isEmpty(this.mergeColumnRules)) {
            int rowIndex = cell.getRowIndex();
            for (MergeColumnRule rule : this.mergeColumnRules) {
                rule.addMergedRegion(col.getFieldKey(), value, rowIndex, cell.getColumnIndex(), this.sheet);
            }
        }
    }
}

