/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.report.ReportByBatchTaskResult;
import kd.bos.entity.report.ReportException;
import kd.bos.entity.report.ReportResultLimit;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.export.ExportProgressImpl;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.schedule.executor.AbstractTask;

public class ReportExportDataTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ReportExportDataTask.class);
    public static final String CUSTPARAM_CONTEXT = "requestcontext";
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    public static final String CUSTPARAM_PARENTPAGEID = "parentpageid";
    private static final String REPORT_LIST_AP = "reportlistap";
    private ExportProgress exportProgress;
    private Map<String, Object> params = new HashMap<String, Object>();
    private IFormView parentView;

    public ExportProgress getExportProgress() {
        if (this.exportProgress == null) {
            this.exportProgress = new ExportProgressImpl(this.taskId);
        }
        return this.exportProgress;
    }

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        boolean stopExport;
        IFormView formView;
        if (params != null) {
            this.params.putAll(params);
            Object context = params.get(CUSTPARAM_CONTEXT);
            if (StringUtils.isNotBlank((Object)context)) {
                RequestContext reqctx = context instanceof RequestContext ? (RequestContext)context : (RequestContext)((JSONObject)context).toJavaObject(RequestContext.class);
                RequestContext.set((RequestContext)reqctx);
            }
        }
        if ((formView = this.getParentView()) == null || !(formView instanceof IReportView)) {
            this.getExportProgress().fail(ResManager.loadKDString((String)"\u7236\u5217\u8868\u5df2\u7ecf\u5173\u95ed\uff0c\u65e0\u6cd5\u83b7\u53d6\u9700\u8981\u5bfc\u51fa\u7684\u5355\u636e", (String)"ReportExportDataTask_0", (String)BOS_FORM_MVC, (Object[])new Object[0]));
            return;
        }
        try {
            AbstractReportListModel reportModel;
            ReportByBatchTaskResult reportTaskResult;
            ReportList reportList = this.getReportList();
            if (reportList == null) {
                return;
            }
            int total = reportList.getTotalRecords();
            ReportView reportView = (ReportView)formView;
            reportView.setExportProgress(this.getExportProgress());
            this.getExportProgress().feedbackProgress(total, 0);
            String url = reportList.exportExcel();
            boolean largeData = reportView.isLargeData();
            if (largeData && (reportTaskResult = (ReportByBatchTaskResult)(reportModel = (AbstractReportListModel)reportList.getReportModel()).getReportTaskResult()) != null) {
                total = reportTaskResult.getBatchLoadInfo().getEstimateTotalRowCount();
            }
            if (!(stopExport = this.isStopExport(reportView))) {
                this.embeddedPermission(url, params);
                ReportResultLimit limit = reportList.getReportCache().getReportResultLimit(reportView.getPageId(), reportList.getKey());
                if (limit != null && limit.getLimitCount() != 0 && limit.getLimitCount() < total) {
                    total = limit.getLimitCount();
                }
                this.getExportProgress().feedbackProgress(total, total);
                this.getExportProgress().feedbackFileUrl(url);
                ReportException exception = reportList.getReportCache().getException(reportView.getPageId());
                if (exception != null && StringUtils.isNotBlank((CharSequence)exception.getContent())) {
                    HashMap<String, Object> data = new HashMap<String, Object>(4);
                    data.put("messageType", exception.getShowType().getType());
                    data.put("message", exception.getContent());
                    this.getExportProgress().feedbackCustData(data);
                    reportList.getReportCache().clearExceptionMsg(reportView.getPageId());
                }
            }
        }
        catch (KDBizException e) {
            this.getExportProgress().fail(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error("Failed to export. Please check log to analysis", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\uff0c%s", (String)"ReportExportDataTask_1", (String)BOS_FORM_MVC, (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            this.getExportProgress().complete();
            formView.getPageCache().put("isReportExporting", "false");
            formView.getPageCache().put("isStopExport", "false");
            formView.getPageCache().saveChanges();
            ReportTaskParam taskParam = ((ReportView)formView).getReportCache().getReportTaskParam(formView.getPageId(), REPORT_LIST_AP);
            if (taskParam != null && taskParam.isRelease()) {
                ((ReportView)formView).getReportCache().clear(formView.getPageId(), REPORT_LIST_AP);
            }
        }
        if (stopExport) {
            log.info("The export has been terminated and the export results are not returned to the frontend");
            this.stop();
        }
    }

    private ReportList getReportList() {
        IFormView pView = this.getParentView();
        if (pView instanceof ReportView) {
            return (ReportList)pView.getControl(REPORT_LIST_AP);
        }
        return null;
    }

    private IFormView getParentView() {
        if (this.parentView == null) {
            String parentPageId = (String)this.params.get(CUSTPARAM_PARENTPAGEID);
            if (StringUtils.isBlank((CharSequence)parentPageId)) {
                return null;
            }
            this.parentView = SessionManager.getCurrent().getView(parentPageId);
        }
        return this.parentView;
    }

    private boolean isStopExport(ReportView reportView) {
        DistributeSessionlessCache pageCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        String isStopExport = (String)pageCache.get(CacheKeyUtil.getAcctId() + ".pagecache." + reportView.getPageId(), "isStopExport");
        return "true".equals(isStopExport);
    }

    private void embeddedPermission(String url, Map<String, Object> params) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            DistributeSessionlessCache distributeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
            String[] tempFile = url.split("id=");
            String[] attachFile = url.split("attachId=");
            if (tempFile.length > 1) {
                HashMap<String, Object> refEntitiyMap = new HashMap<String, Object>(2);
                String tempFileId = tempFile[1];
                refEntitiyMap.put("entityNum", params.get("entitynumber"));
                refEntitiyMap.put("appId", params.get("appId"));
                refEntitiyMap.put("permissionItemId", params.get("permissionItemId"));
                distributeCache.put("ReportTempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
            } else if (attachFile.length > 1) {
                HashMap<String, Object> refEntitiyMap = new HashMap<String, Object>(2);
                String attachId = attachFile[1];
                refEntitiyMap.put("logEntityNum", "report_export");
                refEntitiyMap.put("entityNum", params.get("entitynumber"));
                refEntitiyMap.put("permissionItemId", params.get("permissionItemId"));
                distributeCache.put(attachId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 28800);
            }
        }
    }
}

