/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.IColumn;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.report.ReportColumn;
import kd.bos.mvc.export.RptColExcelExporter;

class RptBoolColExcelExporter
extends RptColExcelExporter {
    private static final String BOS_FORM_MVC = "bos-form-mvc";

    public RptBoolColExcelExporter(IColumn column) {
        super(column);
    }

    @Override
    protected Object formatValue(DynamicObject rowData, NumberFormatProvider numberFormatProvider, Object value) {
        return this.getDisplayValue(this.getReportColumn(), value);
    }

    private String getDisplayValue(ReportColumn reportColumn, Object value) {
        if ("checkbox".equals(reportColumn.getFieldType()) && value instanceof Boolean) {
            if (reportColumn.getCheckBoxReportShowStyle() == 0) {
                if (((Boolean)value).booleanValue()) {
                    return "\u221a";
                }
                return null;
            }
            if (reportColumn.getCheckBoxReportShowStyle() == 1) {
                if (((Boolean)value).booleanValue()) {
                    return null == reportColumn.getOTitleReport() ? ResManager.loadKDString((String)"\u662f", (String)"GridExcelExporter_0", (String)BOS_FORM_MVC, (Object[])new Object[0]) : reportColumn.getOTitleReport();
                }
                return null == reportColumn.getXTitleReport() ? ResManager.loadKDString((String)"\u5426", (String)"GridExcelExporter_1", (String)BOS_FORM_MVC, (Object[])new Object[0]) : reportColumn.getXTitleReport();
            }
        }
        return StringUtils.isBlank((Object)value) ? null : value.toString();
    }
}

