/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.IColumn;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FormulaProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.report.ReportColumn;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.RptColExcelExporter;

class RptDecimalColExcelExporter
extends RptColExcelExporter {
    private static final String CELLSTYLE_ALIGN_DEFAULT = "default";
    private static final Log log = LogFactory.getLog(RptDecimalColExcelExporter.class);
    private Pattern pattern;

    public RptDecimalColExcelExporter(IColumn column) {
        super(column);
    }

    private NumberPrecision getNumberPrecision(DynamicObject rowData, NumberFormatProvider numberFormatProvider) {
        NumberPrecision numberPrecision = null;
        if (numberFormatProvider != null) {
            try {
                numberPrecision = numberFormatProvider.getFormatPrecision(this.getReportColumn().getFieldProperty().getName(), rowData);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return numberPrecision;
    }

    @Override
    protected Object formatValue(DynamicObject rowData, NumberFormatProvider numberFormatProvider, Object value) {
        block16: {
            ReportColumn reportCol = this.getReportColumn();
            boolean noDisplayScaleZero = reportCol.isNoDisplayScaleZero();
            NumberPrecision numberPrecision = this.getNumberPrecision(rowData, numberFormatProvider);
            Object srcValue = rowData.get(reportCol.getFieldKey());
            DynamicProperty fieldProperty = reportCol.getFieldProperty();
            int precision = 0;
            if (fieldProperty instanceof AmountProp) {
                AmountProp amountProp = (AmountProp)reportCol.getFieldProperty();
                precision = this.getAmountPrecision(rowData, amountProp);
            } else if (fieldProperty instanceof QtyProp || srcValue instanceof BigDecimal) {
                DecimalProp decimalProp = (DecimalProp)reportCol.getFieldProperty();
                precision = this.getDecimalPrecision(rowData, decimalProp);
            }
            if (value != null) {
                if (value instanceof Object[]) {
                    Object[] val = (Object[])value;
                    srcValue = val[1];
                } else if (fieldProperty instanceof FormulaProp) {
                    srcValue = value;
                }
                if (srcValue == null || srcValue.toString().startsWith("0E-")) {
                    srcValue = new BigDecimal(0);
                }
                try {
                    boolean isFormulaField;
                    String plainString;
                    if (numberPrecision == null) {
                        BigDecimal bd = new BigDecimal(srcValue.toString());
                        numberPrecision = new NumberPrecision(bd);
                    }
                    numberPrecision.setPrecision(precision);
                    String string = plainString = srcValue instanceof BigDecimal ? ((BigDecimal)srcValue).toPlainString() : srcValue.toString();
                    if (!this.checkIsNumric(plainString)) {
                        value = srcValue.toString();
                        break block16;
                    }
                    if (this.isDecimalTooBig(numberPrecision.getResult().setScale(precision, 4).toPlainString())) {
                        value = numberPrecision.getResult().setScale(precision, 4).toPlainString();
                        break block16;
                    }
                    value = numberPrecision.getResult().doubleValue();
                    if (noDisplayScaleZero) {
                        int scale = numberPrecision.getResult().setScale(numberPrecision.getPrecision(), RoundingMode.HALF_UP).stripTrailingZeros().scale();
                        numberPrecision.setPrecision(scale);
                    }
                    if (isFormulaField = "formula".equalsIgnoreCase(reportCol.getFieldType())) {
                        this.cellStyle = this.getFormulaStyle(CELLSTYLE_ALIGN_DEFAULT);
                        this.indexOldStyle = 1;
                        break block16;
                    }
                    this.cellStyle = this.getDecimalStyle(numberPrecision.getPrecision(), CELLSTYLE_ALIGN_DEFAULT);
                    this.indexOldStyle = 2;
                }
                catch (Exception e) {
                    value = srcValue.toString();
                }
            } else {
                this.cellStyle = this.getCommonStyle();
                this.indexOldStyle = 3;
            }
        }
        return value;
    }

    private boolean checkIsNumric(String str) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile("-?[0-9]+.?[0-9]*");
        }
        Matcher m = this.pattern.matcher(str);
        return m.matches();
    }

    private boolean isDecimalTooBig(String decimalStr) {
        int j;
        int i = decimalStr.lastIndexOf(46);
        if (i >= 0) {
            for (j = decimalStr.length() - 1; j > i && decimalStr.charAt(j) == '0'; --j) {
            }
        }
        if (decimalStr.startsWith("-")) {
            --j;
        }
        return j > 15;
    }

    private int getAmountPrecision(DynamicObject dr, AmountProp prop) {
        String precisionField = "amtprecision";
        if (prop instanceof PriceProp) {
            precisionField = "priceprecision";
        }
        int minimumFractionDigits = prop.getScale();
        minimumFractionDigits = prop instanceof PriceProp ? Integer.parseInt(String.valueOf(FmtInfoUtils.getMainCurrencyFmt().get("pp"))) : Integer.parseInt(String.valueOf(FmtInfoUtils.getMainCurrencyFmt().get("ap")));
        if (prop.getControlPropName() != null) {
            IDataEntityType dt = prop.getParent();
            DynamicObject currency = null;
            if (dt instanceof SubEntryType) {
                try {
                    currency = (DynamicObject)dr.get(dt.getParent().getName() + "." + dt.getName() + "." + prop.getControlPropName());
                }
                catch (OrmException e) {
                    try {
                        currency = (DynamicObject)dr.get(dt.getParent().getName() + "." + prop.getControlPropName());
                    }
                    catch (OrmException e2) {
                        currency = (DynamicObject)dr.get(prop.getControlPropName());
                    }
                }
            } else if (dt instanceof EntryType) {
                try {
                    currency = (DynamicObject)dr.get(dt.getName() + "." + prop.getControlPropName());
                }
                catch (OrmException e) {
                    currency = (DynamicObject)dr.get(prop.getControlPropName());
                }
            } else {
                try {
                    currency = (DynamicObject)dr.get(prop.getControlPropName());
                }
                catch (KDException e) {
                    currency = null;
                }
            }
            if (currency != null) {
                try {
                    minimumFractionDigits = currency.getInt(precisionField);
                }
                catch (KDException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return minimumFractionDigits;
    }

    private int getDecimalPrecision(DynamicObject dr, DecimalProp prop) {
        int minimumFractionDigits = prop.getScale();
        if (prop.getControlPropName() != null && prop instanceof QtyProp) {
            IDataEntityType dt = prop.getParent();
            DynamicObject unit = null;
            if (dt instanceof SubEntryType) {
                try {
                    unit = (DynamicObject)dr.get(dt.getParent().getName() + "." + dt.getName() + "." + prop.getControlPropName());
                }
                catch (OrmException e) {
                    try {
                        unit = (DynamicObject)dr.get(dt.getParent().getName() + "." + prop.getControlPropName());
                    }
                    catch (OrmException e2) {
                        unit = (DynamicObject)dr.get(prop.getControlPropName());
                    }
                }
            } else if (dt instanceof EntryType) {
                try {
                    unit = (DynamicObject)dr.get(dt.getName() + "." + prop.getControlPropName());
                }
                catch (OrmException e) {
                    unit = (DynamicObject)dr.get(prop.getControlPropName());
                }
            } else {
                try {
                    unit = (DynamicObject)dr.get(prop.getControlPropName());
                }
                catch (OrmException e) {
                    unit = null;
                }
            }
            if (unit != null) {
                try {
                    minimumFractionDigits = unit.getInt("precision");
                }
                catch (KDException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return minimumFractionDigits;
    }
}

