/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ICallParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.ControlViewProxy;
import kd.bos.form.control.EmbedSubEntryGrid;
import kd.bos.form.control.EmbedSubEntryViewProxy;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.CallParameter;
import kd.bos.mvc.form.CallParameterCollection;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

@SdkPublic
public class ClientViewProxy
implements IClientViewProxy {
    public static final String FS_DISABLED = "disabled";
    public static final String FS_VISIBLE = "visible";
    private static final Log log = LogFactory.getLog(ClientViewProxy.class);
    private static final String FIELDSTATES = "fieldstates";
    private static final String SET_FOCUS = "setFocus";
    private static final String ACTION = "action";
    private static final String ACTON_NAME = "actonName";
    private static final String ACTON_ARG = "actonArg";
    private static final String SPAN_TYPE_CLIENTVIEW = "clientview";
    private static final String SPAN_PARAM_ACTION = "action";
    private static final String SPAN_PARAM_PARAMS = "params";
    private static final String SPAN_PARAM_KEY = "key";
    private static final String SPAN_PARAM_PROP = "property";
    private static final String SPAN_PARAM_ENTRYKEY = "entryKey";
    private static final String SPAN_PARAM_RESULT = "result";
    private Map<String, Object> controlViewStates;
    private List<Map<String, Object>> _controlsState;
    private List<CallParameter> _methodCalls;
    private Map<String, CallParameter> _mergeMethodCalls;
    private List<CallParameter> _premethodCalls;
    private List<Map<String, Object>> _ruleActions;
    private Map<String, Map<Object, List<Object>>> _entryDataRows;
    private List<Object> _actions = new ArrayList<Object>();
    private Map<String, Map<String, Object>> _dctactions;
    private Map<String, Map<String, Object>> _dctControlsStates;
    private Map<String, Object> _focusControl;
    private IPageCache pageCache;
    private Map<String, Object> _lockStates;
    private Map<String, Object> _visibleStates;
    private List<CallParameter> lockStates1;
    private List<CallParameter> visibleStates1;
    private Set<String> noRepeatNotifications = new HashSet<String>(10);
    private List<CallParameter> mustInputStates;
    private Set<String> stopUpdateCellEntrys = new HashSet<String>();
    private Set<String> stopSelectRowEntrys = new HashSet<String>();
    private List<CallParameter> flexSplitLockStates = new ArrayList<CallParameter>();
    private Map<String, Map<String, Object>> controlMetaState;
    private static final String CONTROLMETASTATE = "controlMetaState";
    private transient Set<String> lazySummaryGrid = new HashSet<String>();
    private Map<Class<?>, ControlViewProxy> controlViewProxy = new HashMap(10);
    private boolean privateNewRowAutoFocus;
    static final String CONTROL_STATES = "controlstates";

    public ClientViewProxy(IPageCache pageCache) {
        this(pageCache, null);
    }

    public ClientViewProxy(IPageCache pageCache, IFormView formView) {
        this.pageCache = pageCache;
        this.controlViewStates = new CaseInsensitiveMap();
        this._lockStates = new HashMap<String, Object>();
        this._visibleStates = new HashMap<String, Object>();
        this.setNewRowAutoFocus(true);
        this.resetActions();
        this.innerLoadViewStates();
        this.innerLoadControlMetaState();
        this.initControlViewProxy(formView);
    }

    public final void resetActions() {
        this._controlsState = new ArrayList<Map<String, Object>>();
        this._methodCalls = new ArrayList<CallParameter>();
        this._mergeMethodCalls = new LinkedHashMap<String, CallParameter>();
        this.lockStates1 = new ArrayList<CallParameter>();
        this.visibleStates1 = new ArrayList<CallParameter>();
        this._premethodCalls = new ArrayList<CallParameter>();
        this._dctControlsStates = new CaseInsensitiveMap();
        this._dctactions = new HashMap<String, Map<String, Object>>();
        this._focusControl = null;
        this._entryDataRows = null;
        this._ruleActions = new ArrayList<Map<String, Object>>();
        this.flexSplitLockStates = new ArrayList<CallParameter>();
        this.noRepeatNotifications = new HashSet<String>(3);
        this.mustInputStates = new ArrayList<CallParameter>();
        this.controlViewProxy.values().forEach(ControlViewProxy::resetActions);
    }

    public final void setFocus(Map<String, Object> para) {
        this._focusControl = para;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)SET_FOCUS);){
                span.addLocaleTag(SPAN_PARAM_PARAMS, para);
            }
        }
    }

    public final void removeAction(String actionName) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"removeAction");){
            Map<String, Object> action;
            if (span.isRealtime()) {
                span.addTag("action", actionName);
            }
            if ((action = this._dctactions.get(actionName)) != null) {
                this._dctactions.remove(actionName);
                this._actions.remove(action);
            }
            if ("ShowNotificationMsg".equals(actionName)) {
                this.noRepeatNotifications.clear();
            }
        }
    }

    public final void addAction(String actionName, Object param) {
        List<Object> paras;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"addAction");){
                span.addTag("action", actionName);
                span.addLocaleTag(SPAN_PARAM_PARAMS, param);
            }
        }
        Map<String, Object> action = null;
        if (this._dctactions.containsKey(actionName)) {
            action = this._dctactions.get(actionName);
            if (actionName.equalsIgnoreCase("setFormTitle") || actionName.equalsIgnoreCase("setInnerTitle")) {
                this.setFormOrInnerTitle(actionName, param);
                return;
            }
        }
        if (action == null) {
            action = new HashMap<String, Object>();
            this._dctactions.put(actionName, action);
            action.put("a", actionName);
            this._actions.add(action);
        }
        if (!action.containsKey("p")) {
            paras = new ArrayList();
            action.put("p", paras);
        } else {
            paras = (List)action.get("p");
        }
        if (param instanceof List) {
            List p = (List)param;
            for (int i = 0; i < p.size(); ++i) {
                paras.add(p.get(i));
            }
        } else {
            paras.add(param);
        }
        this.cacheLockState(actionName, param);
    }

    public final void addAction(String actionName, Object param, String callbackid) {
        if (StringUtils.isBlank((CharSequence)callbackid)) {
            this.addAction(actionName, param);
        } else {
            ArrayList<HashMap<String, String>> newparam = null;
            HashMap<String, String> jcallback = new HashMap<String, String>();
            jcallback.put("callbackid", callbackid);
            if (param == null) {
                ArrayList<HashMap<String, String>> p = new ArrayList<HashMap<String, String>>();
                p.add(jcallback);
                newparam = p;
            } else if (param instanceof CallParameterCollection) {
                ArrayList<HashMap<String, String>> p = new ArrayList<HashMap<String, String>>();
                p.add(jcallback);
                p.addAll((List)param);
                newparam = p;
            } else if (param instanceof List) {
                ((List)param).add(0, jcallback);
                newparam = param;
            } else if (param instanceof Map) {
                ((Map)param).put("callbackid", callbackid);
                newparam = param;
            } else {
                ArrayList<Object> pp = new ArrayList<Object>();
                pp.add(jcallback);
                pp.add(param);
                newparam = pp;
            }
            this.addAction(actionName, newparam);
        }
    }

    private final void addAction(String actionName, Object param, boolean isMerge) {
        List<Object> paras;
        if (isMerge) {
            this.addAction(actionName, param);
            return;
        }
        HashMap<String, Object> action = null;
        if (actionName.equalsIgnoreCase("setFormTitle") || actionName.equalsIgnoreCase("setInnerTitle")) {
            this.setFormOrInnerTitle(actionName, param);
            return;
        }
        if (action == null) {
            action = new HashMap<String, Object>();
            action.put("a", actionName);
            this._actions.add(action);
        }
        if (!action.containsKey("p")) {
            paras = new ArrayList();
            action.put("p", paras);
        } else {
            paras = (List)action.get("p");
        }
        if (param instanceof List) {
            List p = (List)param;
            for (int i = 0; i < p.size(); ++i) {
                paras.add(p.get(i));
            }
        } else {
            paras.add(param);
        }
        if ("InvokeControlMethod".equals(actionName)) {
            this.cacheLockState("InvokeControlMethod", paras);
        }
    }

    public final List<Object> getActionResult() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"getActionResult");){
            this.queueExistsActions();
            this.saveViewStates();
            ArrayList<Object> acts = new ArrayList<Object>();
            acts.addAll(this._actions);
            this._actions.clear();
            if (span.isRealtime()) {
                span.addLocaleTag("actions", acts);
            }
            ArrayList<Object> arrayList = acts;
            return arrayList;
        }
    }

    private void queueExistsActions() {
        if (!this._premethodCalls.isEmpty()) {
            this.addAction("InvokeControlMethod", this._premethodCalls);
        }
        if (!this._controlsState.isEmpty()) {
            this.addAction("u", this._controlsState);
        }
        if (!this.controlViewProxy.isEmpty()) {
            this.controlViewProxy.values().forEach(o -> {
                List controlsState = o.getControlsState();
                if (controlsState != null && !controlsState.isEmpty()) {
                    this.addAction("u", controlsState);
                }
            });
        }
        if (!this._methodCalls.isEmpty() || !this._mergeMethodCalls.isEmpty()) {
            for (CallParameter cp : this._mergeMethodCalls.values()) {
                this._methodCalls.add(cp);
            }
            this.addAction("InvokeControlMethod", this._methodCalls, false);
        }
        if (!this.lockStates1.isEmpty()) {
            this.addAction("InvokeControlMethod", this.lockStates1, false);
        }
        if (!this.flexSplitLockStates.isEmpty()) {
            this.addAction("InvokeControlMethod", this.flexSplitLockStates, false);
        }
        if (!this.visibleStates1.isEmpty()) {
            this.addAction("InvokeControlMethod", this.visibleStates1, false);
        }
        if (!this._ruleActions.isEmpty()) {
            this.addAction("callClientAction", this._ruleActions);
        }
        if (this._focusControl != null) {
            this.addAction(SET_FOCUS, this._focusControl);
        }
        if (!this.mustInputStates.isEmpty()) {
            this.addAction("InvokeControlMethod", this.mustInputStates, false);
        }
        this.resetActions();
    }

    private void setFormOrInnerTitle(String actionName, Object param) {
        Map<String, Object> action = null;
        if (this._dctactions.containsKey(actionName)) {
            action = this._dctactions.get(actionName);
            ArrayList<Object> paras = new ArrayList<Object>();
            if (param instanceof List) {
                List list = (List)param;
                for (Object it : list) {
                    paras.add(it);
                }
            } else {
                paras.add(param);
            }
            paras.add(param);
            action.put("p", paras);
        }
    }

    private Map<String, Object> getControlState(String key) {
        Map<String, Object> controlState = null;
        controlState = this._dctControlsStates.get(key);
        if (controlState == null) {
            controlState = new HashMap<String, Object>();
            controlState.put("k", key);
            this._dctControlsStates.put(key, controlState);
            this._controlsState.add(controlState);
        }
        return controlState;
    }

    private Map<String, Object> getEntryField(String entryKey, String fldKey, int rowIndex) {
        String key = entryKey + "." + rowIndex + "." + fldKey;
        Map<String, Object> field = this._dctControlsStates.get(key);
        if (field == null) {
            Map<String, Object> entry = this.getControlState(entryKey);
            if (!entry.containsKey(FIELDSTATES)) {
                entry.put(FIELDSTATES, new ArrayList());
            }
            List entryfieldStates = (List)entry.get(FIELDSTATES);
            field = new HashMap<String, Object>();
            field.put("k", fldKey);
            field.put("r", rowIndex);
            this._dctControlsStates.put(key, field);
            entryfieldStates.add(field);
        }
        return field;
    }

    public void postBack(String key, Object state) {
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"postBack");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addLocaleTag("state", state);
            }
        }
        this.controlViewStates.put(key, state);
    }

    public Object getViewState(String key) {
        Object result = this.controlViewStates.get(key);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"getViewState");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addLocaleTag(SPAN_PARAM_RESULT, result);
            }
        }
        return result;
    }

    public Object getLockState(String key) {
        Object result = this._lockStates.get(key);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"getLockState");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addLocaleTag(SPAN_PARAM_RESULT, result);
            }
        }
        return result;
    }

    public void setLockState(String key, Object value) {
        HashSet<Integer> rows;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"setLockState");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addLocaleTag(SPAN_PARAM_PARAMS, value);
            }
        }
        String policy = (String)((Map)value).get("o");
        String k = (String)((Map)value).get("k");
        Integer r = (Integer)((Map)value).get("r");
        boolean l = (Boolean)((Map)value).get("l");
        Map policyMap = null;
        CallParameter para = null;
        for (CallParameter callParameter : this.lockStates1) {
            if (!key.equals(callParameter.getkey())) continue;
            para = callParameter;
            break;
        }
        if (para == null) {
            para = new CallParameter();
            ArrayList args = new ArrayList();
            para.setargs(new Object[]{args});
            para.setkey(key);
            para.setmethodname("lock");
            this.lockStates1.add(para);
        }
        List lockStates = (List)para.getargs()[0];
        for (Map p : lockStates) {
            if (!p.get("o").equals(policy)) continue;
            policyMap = p;
            break;
        }
        if (policyMap == null) {
            policyMap = new HashMap<String, String>();
            policyMap.put("o", policy);
            policyMap.put("v", new ArrayList());
            lockStates.add(policyMap);
        }
        List list = (List)policyMap.get("v");
        Map<String, Object> fieldMap = null;
        for (Map map : list) {
            String kString = (String)map.get("k");
            boolean bl = (Boolean)map.get("l");
            if (!StringUtils.equals((CharSequence)kString, (CharSequence)k) || bl == l) continue;
            fieldMap = map;
            break;
        }
        if (fieldMap == null) {
            fieldMap = new HashMap<String, Object>();
            fieldMap.put("k", k);
            fieldMap.put("l", !l);
            fieldMap.put("r", new HashSet());
            list.add(fieldMap);
        }
        if ((rows = (HashSet<Integer>)fieldMap.get("r")) == null) {
            rows = new HashSet<Integer>();
            fieldMap.put("r", rows);
        }
        rows.add(r);
    }

    /*
     * WARNING - void declaration
     */
    public void setFlexSplitLockState(String key, Object value) {
        void var8_16;
        Set set;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"setFlexSplitLockState");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addLocaleTag(SPAN_PARAM_PARAMS, value);
            }
        }
        Set k = (Set)((Map)value).get("k");
        Integer r = (Integer)((Map)value).get("r");
        if (r == -1) {
            this.flexSplitLockStates.removeIf(callParameter -> key.equals(callParameter.getkey()));
            return;
        }
        CallParameter para = null;
        Map<String, Serializable> rowMap = null;
        for (CallParameter callParameter2 : this.flexSplitLockStates) {
            if (!key.equals(callParameter2.getkey())) continue;
            para = callParameter2;
            break;
        }
        if (para == null) {
            para = new CallParameter();
            ArrayList args = new ArrayList();
            para.setargs(new Object[]{args});
            para.setkey(key);
            para.setmethodname("unlockCells");
            this.flexSplitLockStates.add(para);
        }
        List lockStates = (List)para.getargs()[0];
        for (Map p : lockStates) {
            if (!p.get("r").equals(r)) continue;
            rowMap = p;
            break;
        }
        if (rowMap == null) {
            rowMap = new LinkedHashMap();
            rowMap.put("k", new HashSet());
            rowMap.put("r", r);
            lockStates.add(rowMap);
        }
        if ((set = (Set)rowMap.get("k")) == null) {
            HashSet hashSet = new HashSet();
            rowMap.put("k", hashSet);
        }
        var8_16.addAll(k);
    }

    public Object getVisibleState(String key) {
        Object result = this._visibleStates.get(key);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"getVisibleState");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addLocaleTag(SPAN_PARAM_RESULT, result);
            }
        }
        return result;
    }

    public void setVisibleState(String key, Object value) {
        ArrayList visibleMap;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"setVisibleState");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addLocaleTag(SPAN_PARAM_PARAMS, value);
            }
        }
        String policy = (String)((Map)value).get("o");
        List k = (List)((Map)value).get("k");
        Object row = ((Map)value).get("r");
        boolean vi = (Boolean)((Map)value).get("vi");
        CallParameter para = null;
        for (CallParameter cp : this.visibleStates1) {
            if (!key.equals(cp.getkey())) continue;
            para = cp;
            break;
        }
        if (para == null) {
            para = new CallParameter();
            ArrayList args = new ArrayList();
            para.setargs(new Object[]{args});
            para.setkey(key);
            para.setmethodname(FS_VISIBLE);
            this.visibleStates1.add(para);
        }
        List visibleStates = (List)para.getargs()[0];
        Map<String, Object> policyMap = null;
        for (Object p : visibleStates) {
            String string = (String)p.get("o");
            if (!StringUtils.equals((CharSequence)string, (CharSequence)policy)) continue;
            policyMap = p;
            break;
        }
        if (policyMap == null) {
            policyMap = new HashMap<String, Object>();
            policyMap.put("o", policy);
            policyMap.put("v", new ArrayList());
            visibleStates.add(policyMap);
        }
        if ((visibleMap = (ArrayList)policyMap.get("v")) == null) {
            visibleMap = new ArrayList(10);
        }
        if (row == null) {
            for (Map map : visibleMap) {
                List list = (List)map.get("k");
                if (list == null || k == null) continue;
                list.removeAll(k);
            }
            List props = null;
            for (Map map : visibleMap) {
                boolean bl = (Boolean)map.get("vi");
                if (bl != vi) continue;
                props = (List)map.get("k");
                break;
            }
            if (props == null) {
                props = new ArrayList();
                HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
                hashMap.put("k", (Serializable)((Object)props));
                hashMap.put("vi", Boolean.valueOf(vi));
                visibleMap.add(hashMap);
            }
            if (k != null) {
                props.addAll(k);
            }
        } else {
            HashMap<String, Map> tempKeyMap = new HashMap<String, Map>(16);
            for (Map map : visibleMap) {
                String kString = (String)map.get("k");
                tempKeyMap.put(kString, map);
            }
            for (String string : k) {
                HashSet<Integer> rows;
                boolean v;
                HashMap<String, Object> fieldMap = (HashMap<String, Object>)tempKeyMap.get(string);
                boolean newKeyMap = true;
                if (fieldMap != null && (v = ((Boolean)fieldMap.get("vi")).booleanValue()) == vi) {
                    newKeyMap = false;
                }
                if (newKeyMap) {
                    fieldMap = new HashMap<String, Object>();
                    fieldMap.put("k", string);
                    fieldMap.put("vi", vi);
                    fieldMap.put("r", new HashSet());
                    visibleMap.add(fieldMap);
                }
                if ((rows = (HashSet<Integer>)fieldMap.get("r")) == null) {
                    rows = new HashSet<Integer>();
                    fieldMap.put("r", rows);
                }
                rows.add((Integer)row);
            }
        }
    }

    public void clearControlsState() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"clearControlsState");){
            if (this.controlViewStates.size() > 0) {
                this.controlViewStates = new CaseInsensitiveMap();
                this.saveViewStates();
            }
        }
    }

    public void addRuleAction(String ruleActionId, int index) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("r", index);
        map.put("ai", ruleActionId);
        this._ruleActions.add(map);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"addRuleAction");){
                span.addTag("ai", ruleActionId);
                span.addTag("r", String.valueOf(index));
            }
        }
    }

    public final void preInvokeControlMethod(String key, String methodName, Object ... parameters) {
        CallParameter tempVar = new CallParameter();
        tempVar.setargs(parameters);
        tempVar.setkey(key);
        tempVar.setmethodname(methodName);
        CallParameter para = tempVar;
        this._premethodCalls.add(para);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"preInvokeControlMethod");){
                span.addLocaleTag(SPAN_PARAM_PARAMS, (Object)para);
            }
        }
    }

    public final boolean getNewRowAutoFocus() {
        return this.privateNewRowAutoFocus;
    }

    public final void setNewRowAutoFocus(boolean value) {
        this.privateNewRowAutoFocus = value;
    }

    public void clearEntryRowActions(String entryKey) {
        HashSet<String> clearActionName = new HashSet<String>(6);
        clearActionName.add("insertRow");
        clearActionName.add("appendRows");
        clearActionName.add("deleteRows");
        clearActionName.add("deleteRow");
        clearActionName.add("moveDown");
        clearActionName.add("moveUp");
        clearActionName.add("setTop");
        clearActionName.add("setBottom");
        for (int i = this._methodCalls.size() - 1; i >= 0; --i) {
            CallParameter callParameter = this._methodCalls.get(i);
            if (!StringUtils.equals((CharSequence)callParameter.getkey(), (CharSequence)entryKey) || !clearActionName.contains(callParameter.getmethodname())) continue;
            this._methodCalls.remove(i);
        }
    }

    public final void appendRow(String entryKey, List<Object> rowData) {
        List<List<Object>> rows;
        Map data;
        Map<String, Object> entryState;
        if (this.isStopUpdateCell(entryKey)) {
            return;
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"appendRow");){
                span.addTag(SPAN_PARAM_KEY, entryKey);
                span.addLocaleTag(SPAN_PARAM_PARAMS, rowData);
            }
        }
        if ((entryState = this._dctControlsStates.get(entryKey)) != null && (data = (Map)entryState.get("data")) != null) {
            List rows2 = (List)data.get("rows");
            int seq = (Integer)rowData.get(1);
            int pageRows = (Integer)data.get("pagerows");
            int pageIndex = (Integer)data.get("pageindex");
            boolean isSplitPage = (Boolean)data.get("isSplitPage");
            if (isSplitPage) {
                if ((pageIndex - 1) * pageRows < seq && seq <= pageIndex * pageRows) {
                    if (rows2.size() >= seq - (pageIndex - 1) * pageRows) {
                        rows2.set(seq - (pageIndex - 1) * pageRows - 1, rowData);
                    } else {
                        rows2.add(rowData);
                    }
                }
            } else {
                rows2.add(rowData);
            }
            Map<Object, List<Object>> entryRows = this.getEntryRows(entryKey);
            entryRows.put(seq - 1, rowData);
            return;
        }
        String methodName = this.getNewRowAutoFocus() ? "appendRows" : "appendRowsNoFocus";
        CallParameter para = this.getCallParameterFirst(this._methodCalls, entryKey, methodName);
        if (para == null) {
            rows = new ArrayList<List<Object>>();
            rows.add(rowData);
            CallParameter tempVar = new CallParameter();
            tempVar.setargs(new Object[]{rows});
            tempVar.setkey(entryKey);
            tempVar.setmethodname(methodName);
            this.fillEntryPr(tempVar);
            para = tempVar;
            this._methodCalls.add(para);
        } else {
            rows = (List)para.getargs()[0];
            rows.add(rowData);
        }
        Map<Object, List<Object>> entryRows = this.getEntryRows(entryKey);
        int seq = (Integer)rowData.get(1);
        entryRows.put(seq - 1, rowData);
    }

    public final void insertRow(String entryKey, int row, List<Object> rowData) {
        this.insertRow(entryKey, row, rowData, false);
    }

    public final void insertRow(String entryKey, int row, List<Object> rowData, boolean insertBehind) {
        List<List<Object>> rows;
        if (this.isStopUpdateCell(entryKey)) {
            return;
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"insertRow");){
                span.addTag(SPAN_PARAM_KEY, entryKey);
                span.addTag("index", String.valueOf(row));
                span.addLocaleTag(SPAN_PARAM_PARAMS, rowData);
            }
        }
        Map<Object, List<Object>> entryRows = this.getEntryRows(entryKey);
        CallParameter para = this.getCallParameterFirst(this._methodCalls, entryKey, "insertRow");
        if (para == null) {
            rows = new ArrayList<List<Object>>();
            rows.add(rowData);
            CallParameter tempVar = new CallParameter();
            tempVar.setargs(new Object[]{row, rows, insertBehind});
            tempVar.setkey(entryKey);
            tempVar.setmethodname("insertRow");
            this.fillEntryPr(tempVar);
            para = tempVar;
            this._methodCalls.add(para);
        } else {
            rows = (List)para.getargs()[1];
            rows.add(rowData);
        }
        Object rowKey = rowData.get(0);
        entryRows.put(rowKey, rowData);
    }

    public final void updateEntryRowData(String entryKey, int row, List<Object> rowData) {
        if (this.isStopUpdateCell(entryKey)) {
            return;
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"updateEntryRowData");){
                span.addTag(SPAN_PARAM_ENTRYKEY, entryKey);
                span.addTag("row", String.valueOf(row));
                span.addLocaleTag(SPAN_PARAM_PARAMS, rowData);
            }
        }
        Map<Object, List<Object>> entryRows = this.getEntryRows(entryKey);
        Object rowKey = rowData.get(0);
        entryRows.put(rowKey, rowData);
    }

    @Deprecated
    public void deleteRows(String entrykey, int[] rows) {
        this.deleteRows(entrykey, rows, rows.length);
    }

    public void deleteRows(String entrykey, int[] rows, int currRowsCount) {
        this.invokeControlMethod(entrykey, "deleteRows", new Object[]{rows});
        if (this.isStopSelectRow(entrykey)) {
            return;
        }
        int minIndex = 0;
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] >= rows[minIndex]) continue;
            minIndex = i;
        }
        int iFocusIndex = -1;
        if (rows[minIndex] > 0) {
            iFocusIndex = rows[minIndex] - 1;
        } else if (rows[minIndex] == 0 && currRowsCount > 0) {
            iFocusIndex = 0;
        }
        this.invokeControlMethod(entrykey, "selectRows", iFocusIndex);
        this.getEntryState(entrykey).selectRow(iFocusIndex);
        this.getEntryState(entrykey).setFocusRow(iFocusIndex);
        this.queueExistsActions();
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"deleteRows");){
                span.addTag(SPAN_PARAM_ENTRYKEY, entrykey);
                span.addLocaleTag("rows", (Object)rows);
                span.addLocaleTag("currRowCount", (Object)currRowsCount);
            }
        }
    }

    public void focusCell(String entryKey, int rowIndex, String colKey) {
        this.invokeControlMethod(entryKey, SET_FOCUS, rowIndex, colKey);
        this.getEntryState(entryKey).setFocusRow(rowIndex);
    }

    public void moveUp(String entrykey, int[] rows) {
        AbstractGrid.GridState state = this.getEntryState(entrykey);
        ArrayList selRows = (ArrayList)state.get("selRows");
        boolean bAllowMove = true;
        for (int i = 0; i < selRows.size(); ++i) {
            if ((Integer)selRows.get(i) > 0) continue;
            bAllowMove = false;
            break;
        }
        if (bAllowMove) {
            this.invokeControlMethod(entrykey, "moveUp", new Object[]{rows});
            state.moveUp();
        }
        this.invokeControlMethod(entrykey, "selectRows", new Object[]{state.getSelectedRows()});
    }

    public void moveDown(String entrykey, int[] rows, int rowCount) {
        AbstractGrid.GridState state = this.getEntryState(entrykey);
        ArrayList selRows = (ArrayList)state.get("selRows");
        boolean bAllowMove = true;
        for (int i = 0; i < selRows.size(); ++i) {
            if ((Integer)selRows.get(i) < rowCount - 1) continue;
            bAllowMove = false;
            break;
        }
        if (bAllowMove) {
            this.invokeControlMethod(entrykey, "moveDown", new Object[]{rows});
            state.moveDown();
        }
        this.invokeControlMethod(entrykey, "selectRows", new Object[]{state.getSelectedRows()});
    }

    public void moveBottom(String entrykey, int[] rows, int rowCount) {
        AbstractGrid.GridState state = this.getEntryState(entrykey);
        this.invokeControlMethod(entrykey, "setBottom", new Object[]{rows});
        state.moveBottom(rowCount);
        this.invokeControlMethod(entrykey, "selectRows", new Object[]{state.getSelectedRows()});
    }

    public void moveTop(String entrykey, int[] rows, int rowCount) {
        AbstractGrid.GridState state = this.getEntryState(entrykey);
        this.invokeControlMethod(entrykey, "setTop", new Object[]{rows});
        state.moveTop();
        this.invokeControlMethod(entrykey, "selectRows", new Object[]{state.getSelectedRows()});
    }

    private List<Object> getEntryRow(String entrykey, int rowIndex) {
        Map objData;
        Object rowData;
        Object data;
        Map<Object, List<Object>> entryRows = this.getEntryRows(entrykey);
        List<Object> row = null;
        row = entryRows.get(rowIndex);
        if (row != null) {
            return row;
        }
        Map<String, Object> entryState = null;
        entryState = this._dctControlsStates.get(entrykey);
        if (entryState != null && (data = entryState.get("data")) != null && (rowData = (objData = (Map)data).get("rows")) != null) {
            List entryData = (List)rowData;
            if (rowIndex >= 0 && rowIndex < entryData.size()) {
                for (int i = 0; i < entryData.size(); ++i) {
                    int index;
                    List rowObj;
                    List list = rowObj = entryData.get(i) == null ? null : (List)entryData.get(i);
                    if (rowObj == null || rowObj.isEmpty()) continue;
                    int n = index = rowObj.get(0) == null ? -1 : (Integer)rowObj.get(0);
                    if (rowIndex != index) continue;
                    return rowObj;
                }
                return null;
            }
        }
        return null;
    }

    private Map<Object, List<Object>> getEntryRows(String entryKey) {
        HashMap entryRows = null;
        if (this._entryDataRows == null) {
            this._entryDataRows = new CaseInsensitiveMap();
        }
        if ((entryRows = (HashMap)this._entryDataRows.get(entryKey)) == null) {
            entryRows = new HashMap();
            this._entryDataRows.put(entryKey, entryRows);
        }
        return entryRows;
    }

    public final void invokeControlMethod(String key, String methodName, Object ... parameters) {
        CallParameter tempVar = new CallParameter();
        tempVar.setargs(parameters);
        tempVar.setkey(key);
        tempVar.setmethodname(methodName);
        this.fillEntryPr(tempVar);
        if (this.isMerge(tempVar)) {
            String ind = key + "|" + methodName + "|" + parameters.length;
            this._mergeMethodCalls.put(ind, tempVar);
        } else {
            this._methodCalls.add(tempVar);
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"invokeControlMethod");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addLocaleTag("methodName", (Object)methodName);
                span.addLocaleTag(SPAN_PARAM_PARAMS, (Object)parameters);
            }
        }
    }

    private boolean isMerge(CallParameter tempVar) {
        String methodname = tempVar.getmethodname();
        return methodname.equals("setSelectedDataInfo") || methodname.equals(SET_FOCUS);
    }

    public final void removeInvokeControlMethod(String key, String methodName) {
        List<CallParameter> paras = this.getCallParameters(this._methodCalls, key, methodName);
        for (CallParameter para : paras) {
            this._methodCalls.remove(para);
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"removeInvokeControlMethod");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addLocaleTag("methodName", (Object)methodName);
            }
        }
    }

    public final void removeInvokeControlMethod(Predicate<ICallParameter> predicate) {
        this._methodCalls.removeIf(predicate);
    }

    private CallParameter getCallParameterFirst(List<CallParameter> calls, String key, String methodName) {
        for (CallParameter para : calls) {
            if (!para.getkey().equalsIgnoreCase(key) || !para.getmethodname().equals(methodName)) continue;
            return para;
        }
        return null;
    }

    private List<CallParameter> getCallParameters(List<CallParameter> calls, String key, String methodName) {
        CallParameterCollection ret = new CallParameterCollection();
        for (CallParameter para : calls) {
            if (!para.getkey().equalsIgnoreCase(key) || !para.getmethodname().equals(methodName)) continue;
            ret.add(para);
        }
        return ret;
    }

    public void setFieldProperty(String key, String property, Object v) {
        this.getControlState(key).put(property, v);
        if ("st".equals(property)) {
            this.setControlMetaState(key, "st", v);
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"setFieldProperty");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addTag(SPAN_PARAM_PROP, property);
                span.addLocaleTag(SPAN_PARAM_PARAMS, v);
            }
        }
    }

    public void setEntryFieldProperty(String entryKey, String key, String property, Object v) {
        this.getEntryField(entryKey, key, -1).put(property, v);
        if ("st".equals(property)) {
            this.setControlMetaState(key, "st", v);
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"setEntryFieldProperty");){
                span.addTag(SPAN_PARAM_ENTRYKEY, entryKey);
                span.addTag(SPAN_PARAM_KEY, key);
                span.addTag(SPAN_PARAM_PROP, property);
                span.addLocaleTag(SPAN_PARAM_PARAMS, v);
            }
        }
    }

    public void setEntryProperty(String key, String property, Object v) {
        this.getControlState(key).put(property, v);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"setEntryProperty");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addTag(SPAN_PARAM_PROP, property);
                span.addLocaleTag(SPAN_PARAM_PARAMS, v);
            }
        }
    }

    public void setEntryFieldValue(AbstractGrid grid, String key, int rowIndex, Object v) {
        if (this.isStopUpdateCell(grid.getKey())) {
            return;
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"setEntryFieldValue");){
                span.addTag(SPAN_PARAM_ENTRYKEY, grid.getKey());
                span.addTag(SPAN_PARAM_KEY, key);
                span.addTag("row", String.valueOf(rowIndex));
                span.addLocaleTag("val", v);
            }
        }
        List<Object> rowData = this.getEntryRow(grid.getKey(), rowIndex);
        String lkey = key;
        Map dataIndex = null;
        if (grid instanceof EntryGrid) {
            dataIndex = ((EntryGrid)grid).getDataIndex();
        }
        if (rowData != null && dataIndex != null) {
            Integer colIndex = (Integer)dataIndex.get(lkey);
            if (colIndex != null) {
                rowData.set(colIndex, v);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("Key:").append(lkey).append(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230,dataIndex\u4e2dKey\u6e05\u5355", (String)"ClientViewProxy_0", (String)"bos-form-mvc", (Object[])new Object[0])).append("[");
                for (String keyStr : dataIndex.keySet()) {
                    sb.append(keyStr).append(",");
                }
                sb.append("]");
                log.info(sb.toString());
            }
        } else {
            this.queueExistsActions();
            this.getEntryField(grid.getKey(), lkey, rowIndex).put("v", v);
        }
    }

    public void stopUpdateGridCell(String entryKey, boolean isStop) {
        if (StringUtils.isNotBlank((CharSequence)entryKey)) {
            if (isStop) {
                this.stopUpdateCellEntrys.add(entryKey);
            } else {
                this.stopUpdateCellEntrys.remove(entryKey);
            }
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"stopUpdateGridCell");){
                span.addTag(SPAN_PARAM_KEY, entryKey);
                span.addLocaleTag(SPAN_PARAM_PARAMS, (Object)isStop);
            }
        }
    }

    private boolean isStopUpdateCell(String entryKey) {
        return this.stopUpdateCellEntrys.contains(entryKey);
    }

    public boolean isState(String entryKey, String state) {
        if ("StopUpdateCell".equals(state)) {
            return this.stopUpdateCellEntrys.contains(entryKey);
        }
        if ("StopSelectRow".equals(state)) {
            return this.stopSelectRowEntrys.contains(entryKey);
        }
        return false;
    }

    public void stopSelectGridRow(String entryKey, boolean isStop) {
        if (StringUtils.isNotBlank((CharSequence)entryKey)) {
            if (isStop) {
                this.stopSelectRowEntrys.add(entryKey);
            } else {
                this.stopSelectRowEntrys.remove(entryKey);
            }
        }
    }

    private boolean isStopSelectRow(String entryKey) {
        return this.stopSelectRowEntrys.contains(entryKey);
    }

    public void updateCellFmt(String entryGridKey, String fieldKey, int rowIndex) {
        HashMap<Integer, List<String>> rowsFmtMapping = new HashMap<Integer, List<String>>(16);
        rowsFmtMapping.put(rowIndex, Collections.singletonList(fieldKey));
        this.updateCellFmt(entryGridKey, rowsFmtMapping);
    }

    public void updateCellFmt(String entryGridKey, Map<Integer, List<String>> rowsFmtMapping) {
        if (this.isStopUpdateCell(entryGridKey)) {
            return;
        }
        ArrayList<Object[]> fmt = new ArrayList<Object[]>();
        for (Map.Entry<Integer, List<String>> mapping : rowsFmtMapping.entrySet()) {
            List<Object> rowData = this.getEntryRow(entryGridKey, mapping.getKey());
            if (rowData != null) continue;
            fmt.add(new Object[]{mapping.getValue(), mapping.getKey()});
        }
        if (!fmt.isEmpty()) {
            this.invokeControlMethod(entryGridKey, "updateCellFmt", fmt);
        }
    }

    public AbstractGrid.GridState getEntryState(String entryKey) {
        HashMap state = (HashMap)this.getViewState(entryKey);
        if (state == null) {
            state = new HashMap();
            this.controlViewStates.put(entryKey, state);
        }
        return new AbstractGrid.GridState(entryKey, state);
    }

    public TreeView.TreeState getTreeState(String treeKey) {
        HashMap state = (HashMap)this.getViewState(treeKey);
        if (state == null) {
            state = new HashMap();
            this.controlViewStates.put(treeKey, state);
        }
        return new TreeView.TreeState(treeKey, state);
    }

    public FilterGrid.FilterGridState getFilterGridState(String filterGridKey) {
        FilterCondition filterCondition = null;
        if (this.getViewState(filterGridKey) != null) {
            String filterConditionString = SerializationUtils.toJsonString((Object)this.getViewState(filterGridKey));
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionString, FilterCondition.class);
        } else {
            if (filterCondition == null) {
                filterCondition = new FilterCondition();
            }
            this.controlViewStates.put(filterGridKey, filterCondition);
        }
        return new FilterGrid.FilterGridState(filterGridKey, filterCondition);
    }

    public void loadViewStates() {
        this.innerLoadViewStates();
    }

    private void innerLoadViewStates() {
        String states = this.pageCache.get(CONTROL_STATES);
        this.controlViewStates = StringUtils.isBlank((CharSequence)states) ? new CaseInsensitiveMap() : (Map)SerializationUtils.fromJsonString((String)states, CaseInsensitiveMap.class);
    }

    private void saveViewStates() {
        String states = this.pageCache.get(CONTROL_STATES);
        if (StringUtils.isBlank((CharSequence)states) && this.controlViewStates.size() == 0) {
            return;
        }
        this.pageCache.put(CONTROL_STATES, SerializationUtils.toJsonString(this.controlViewStates));
    }

    public void setNumFmtInfo(String propName, Map<String, Object> info) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        map.put(propName, info);
        this.addAction("setNumFmtInfos", map);
    }

    public void setNumFmtInfos(Map<String, Object> infos) {
        this.addAction("setNumFmtInfos", infos);
    }

    public void setTimeZone(String propName, Map<String, Object> info) {
        ArrayList<Object> para = new ArrayList<Object>(2);
        para.add(propName);
        para.add(info);
        this.addAction("setTimeZone", para);
    }

    public void setTimeZones(Map<String, Object> infos) {
        this.addAction("setTimeZones", infos);
    }

    public AbstractGrid.GridState selectRows(String entryKey, int[] selRows, int focusRow) {
        this.removeInvokeControlMethod(entryKey, "selectRows");
        this.invokeControlMethod(entryKey, "selectRows", new Object[]{selRows});
        AbstractGrid.GridState entryState = this.getEntryState(entryKey);
        entryState.selectRow(selRows);
        int oldfocusRow = entryState.getFocusRow();
        if (oldfocusRow != focusRow) {
            entryState.setFocusRow(focusRow);
        }
        this.invokeControlMethod(entryKey, SET_FOCUS, focusRow);
        this.controlViewStates.put(entryKey, entryState.getState());
        return entryState;
    }

    public TreeView.TreeState checkNodes(String treeKey, List<TreeNode> nodes) {
        ArrayList idList = new ArrayList(nodes.size());
        nodes.forEach(node -> idList.add(node.getId()));
        this.invokeControlMethod(treeKey, "checkNodes", idList);
        TreeView.TreeState treeState = this.getTreeState(treeKey);
        treeState.check(SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(nodes), Map.class));
        this.saveViewStates();
        return treeState;
    }

    public TreeView.TreeState checkNodesWithoutChild(String treeKey, List<TreeNode> nodes) {
        TreeView.TreeState treeState = this.getTreeState(treeKey);
        treeState.check(SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(nodes), Map.class));
        this.saveViewStates();
        return treeState;
    }

    public Map<String, Object> getControlMetaState(String key) {
        return this.controlMetaState.get(key);
    }

    public void setControlMetaState(String key, String property, Object meta) {
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"setControlMetaState");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addTag(SPAN_PARAM_PROP, property);
                span.addLocaleTag("meta", meta);
            }
        }
        if (key == null) {
            return;
        }
        Map<String, Object> stringObjectMap = this.controlMetaState.get(key);
        if (ObjectUtils.isEmpty(stringObjectMap)) {
            stringObjectMap = new HashMap<String, Object>();
        }
        stringObjectMap.put(property, meta);
        this.controlMetaState.put(key, stringObjectMap);
        this.pageCache.put(CONTROLMETASTATE, SerializationUtils.toJsonString(this.controlMetaState));
    }

    private void batchSetControlMetaState(String key, String property, Object meta) {
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"batchSetControlMetaState");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addTag(SPAN_PARAM_PROP, property);
                span.addLocaleTag("meta", meta);
            }
        }
        if (key == null) {
            return;
        }
        Map<String, Object> stringObjectMap = this.controlMetaState.get(key);
        if (ObjectUtils.isEmpty(stringObjectMap)) {
            stringObjectMap = new HashMap<String, Object>();
        }
        stringObjectMap.put(property, meta);
        this.controlMetaState.put(key, stringObjectMap);
    }

    private void innerLoadControlMetaState() {
        String state = this.pageCache.get(CONTROLMETASTATE);
        this.controlMetaState = state != null ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)state, Map.class) : new HashMap<String, Map<String, Object>>();
    }

    public void loadControlMetaState() {
        this.innerLoadControlMetaState();
    }

    private void initControlViewProxy(IFormView formView) {
        EmbedSubEntryViewProxy viewProxy = new EmbedSubEntryViewProxy((IClientViewProxy)this, formView);
        this.addControlViewProxy(EmbedSubEntryGrid.class, (ControlViewProxy)viewProxy);
    }

    private void fillEntryPr(CallParameter callParameter) {
        String key = callParameter.getkey();
        Integer[] currentEntryPr = new Integer[1];
        this.controlViewProxy.values().forEach(o -> {
            if (o instanceof EmbedSubEntryViewProxy) {
                currentEntryPr[0] = ((EmbedSubEntryViewProxy)o).getCurrentEntryPr(key);
            }
        });
        if (currentEntryPr[0] != null) {
            callParameter.setPr(currentEntryPr[0]);
        }
    }

    void addControlViewProxy(Class<?> clazz, ControlViewProxy controlViewProxy) {
        this.controlViewProxy.put(clazz, controlViewProxy);
    }

    public <T> T getControlViewProxy(Class<?> clazz) {
        return (T)this.controlViewProxy.get(clazz);
    }

    private void cacheLockState(String actionName, Object param) {
        try {
            switch (actionName) {
                case "setFormStatus": 
                case "setBillStatus": {
                    this.setControlMetaState("status", "status", param);
                    break;
                }
                case "setEnable": {
                    Map paramMap = (Map)param;
                    String[] keys = (String[])paramMap.get("keys");
                    Boolean enable = (Boolean)paramMap.get("enable");
                    for (String key : keys) {
                        this.batchSetControlMetaState(key, "lockControl", enable);
                    }
                    this.pageCache.put(CONTROLMETASTATE, SerializationUtils.toJsonString(this.controlMetaState));
                    break;
                }
                case "updateControlMetadata": {
                    HashMap paramItemMap;
                    if (!(param instanceof List)) break;
                    List paramList = (List)param;
                    String fieldKey = (String)paramList.get(0);
                    Object paramListItem = paramList.get(1);
                    if (paramListItem instanceof HashMap && (paramItemMap = (HashMap)paramListItem).containsKey("l")) {
                        Integer lockValue = (Integer)paramItemMap.get("l");
                        this.setControlMetaState(fieldKey, "l", lockValue);
                    }
                    break;
                }
                case "setColProp": 
                case "InvokeControlMethod": {
                    if (!(param instanceof List)) break;
                    List paramList = (List)param;
                    for (Object listItem : paramList) {
                        Object[] args;
                        CallParameter callParameter;
                        if (!(listItem instanceof CallParameter) || !"setColProp".equals((callParameter = (CallParameter)listItem).getmethodname()) || (args = callParameter.getargs()) == null || args.length < 3) continue;
                        this.setControlMetaState(String.valueOf(args[0]), String.valueOf(args[1]), args[2]);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addLazySummaryGrid(String s) {
        this.lazySummaryGrid.add(s);
    }

    public Set<String> getLazySummaryGrid() {
        return this.lazySummaryGrid;
    }

    public void setClientLocalStorage(String key, String value) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(key, value);
        this.addAction("setLocalStorage", param);
    }

    public void getClientLocalStorage(String key, String callbackid) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("name", callbackid);
        HashMap actions = new HashMap(16);
        HashMap<String, String> action = new HashMap<String, String>();
        action.put(ACTON_NAME, "getLocalStorage");
        action.put(ACTON_ARG, key);
        actions.put("_LocalStorage_", action);
        param.put("action", actions);
        this.addAction("addClientCallBack", param);
    }

    public void getClientLocalStorage(String key) {
        this.getClientLocalStorage(key, key);
    }

    public void addNotificationMsg(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return;
        }
        int paraHashcode = param.toString().hashCode();
        String uniqueKey = (paraHashcode ^ paraHashcode >>> 16) + "-" + param.getOrDefault("content", "").toString().length();
        if (this.noRepeatNotifications.add(uniqueKey)) {
            this.addAction("ShowNotificationMsg", param);
        }
    }

    public void setMustInputState(String key, Object value) {
        HashSet<Integer> rows;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_CLIENTVIEW, (String)"setMustInputState");){
                span.addTag(SPAN_PARAM_KEY, key);
                span.addLocaleTag(SPAN_PARAM_PARAMS, value);
            }
        }
        String policy = (String)((Map)value).get("o");
        String k = (String)((Map)value).get("k");
        Integer r = (Integer)((Map)value).get("r");
        boolean mi = (Boolean)((Map)value).get("mi");
        Map policyMap = null;
        CallParameter para = null;
        for (CallParameter callParameter : this.mustInputStates) {
            if (!key.equals(callParameter.getkey())) continue;
            para = callParameter;
            break;
        }
        if (para == null) {
            para = new CallParameter();
            ArrayList args = new ArrayList();
            para.setargs(new Object[]{args});
            para.setkey(key);
            para.setmethodname("setMustInput");
            this.mustInputStates.add(para);
        }
        List mustInputStates = (List)para.getargs()[0];
        for (Map p : mustInputStates) {
            if (!p.get("o").equals(policy)) continue;
            policyMap = p;
            break;
        }
        if (policyMap == null) {
            policyMap = new HashMap<String, String>();
            policyMap.put("o", policy);
            policyMap.put("v", new ArrayList());
            mustInputStates.add(policyMap);
        }
        List list = (List)policyMap.get("v");
        Map<String, Object> fieldMap = null;
        for (Map map : list) {
            String kString = (String)map.get("k");
            boolean bmi = (Boolean)map.get("mi");
            if (!StringUtils.equals((CharSequence)kString, (CharSequence)k) || bmi != mi) continue;
            fieldMap = map;
            break;
        }
        if (fieldMap == null) {
            fieldMap = new HashMap<String, Object>();
            fieldMap.put("k", k);
            fieldMap.put("mi", mi);
            fieldMap.put("r", new HashSet());
            list.add(fieldMap);
        }
        if ((rows = (HashSet<Integer>)fieldMap.get("r")) == null) {
            rows = new HashSet<Integer>();
            fieldMap.put("r", rows);
        }
        rows.add(r);
    }
}

