/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AbstractGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class FormDataModel
extends AbstractFormDataModel {
    private boolean isCacheExpireAfter;

    public FormDataModel(String entityName, String pageId, Map<Class<?>, Object> services) {
        super(entityName, pageId, services);
    }

    public FormDataModel(String entityName, String pageId, Map<Class<?>, Object> services, String appId, String permissionItem) {
        super(entityName, pageId, services, appId, permissionItem);
    }

    public void setCacheExpireAfter(boolean value) {
        this.isCacheExpireAfter = value;
    }

    public void updateCache() {
        super.updateCache();
        if (this.isCacheExpireAfter) {
            this.isCacheExpireAfter = false;
            this.cacheExpireAfter(CacheKeyUtil.getPageCacheKeyTimeout());
        }
    }

    AbstractGrid.GridState getGridState(String entryKey) {
        IClientViewProxy viewProxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        if (viewProxy == null) {
            return new AbstractGrid.GridState(entryKey, new HashMap());
        }
        return viewProxy.getEntryState(entryKey);
    }

    protected Map<String, Object> getEntryState(String entryKey) {
        return this.getGridState(entryKey).getState();
    }

    protected void setEntryGridState(String entryKey, Map<String, Object> state) {
        this.getGridState(entryKey).setState(state);
    }

    public void setEntryCurrentRowIndex(String entryKey, int row, boolean sendClientAction) {
        super.setEntryCurrentRowIndex(entryKey, row, sendClientAction);
        IClientViewProxy proxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        proxy.selectRows(entryKey, new int[]{row}, row);
    }

    @KSMethod
    public void fillReferenceData(Object[] dataEntitys, IDataEntityType dataEntityType) {
        BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)dataEntityType);
    }

    @KSMethod
    public String getCurrUserSetting(String key) {
        return UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)key);
    }

    public boolean setCurrUserSetting(long userID, String key, String setting) {
        return UserConfigServiceHelper.setSetting((long)userID, (String)key, (String)setting);
    }

    @KSMethod
    public DynamicObject loadReferenceData(DynamicObjectType dt, Object pkValue) {
        Map<Object, DynamicObject> teMap = this.loadReferenceDataBatch(dt, new Object[]{pkValue});
        return teMap.get(pkValue);
    }

    @KSMethod
    public Map<Object, DynamicObject> loadReferenceDataBatch(DynamicObjectType dt, Object[] pkValues) {
        return BusinessDataReader.loadFromCache((Object[])pkValues, (DynamicObjectType)dt);
    }

    @KSMethod
    public Map<Object, DynamicObject> loadReferenceDataBatch(DynamicObjectType dt, List<QFilter> qFilters) {
        if (dt == null) {
            return new HashMap<Object, DynamicObject>();
        }
        return BusinessDataServiceHelper.loadFromCache((DynamicObjectType)dt, (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    @KSMethod
    public <T> Map<String, Object> getCompanyfromOrg(T org) {
        return OrgServiceHelper.getCompanyfromOrg(org);
    }

    @KSMethod
    public Map<String, Object> getOrgbyYzjorgId(String yzjorgId) {
        return OrgServiceHelper.getOrgbyYzjorgId((String)yzjorgId);
    }
}

