/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.DefaultDefValueProvider;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgRelationConfig;
import kd.bos.entity.property.org.OrgRelationItem;
import kd.bos.entity.property.org.OrgRelationItemOrg;
import kd.bos.entity.property.org.OrgRelationItemType;
import kd.bos.form.IFormView;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class FormDefValueProvider
extends DefaultDefValueProvider {
    private static final String TRACETYPE_FORMDEFVALUEPROVIDER = "FormDefValueProvider";
    private static final String ORGRELATIONITEM_TYPE_ORGUNIT2ADMIN = "orgunit2admin";
    private static final String BOS_BILLPARAMETER_BOSCARRYADMINORG = "boscarryadminorg";
    private IFormView view;
    private Map<String, Object> relationOrgValues = new HashMap<String, Object>(8);

    public FormDefValueProvider(IFormView view) {
        this.view = view;
    }

    public Object getOrgDefValue(IDataModel model, OrgProp fieldProp, ChangeData o) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_FORMDEFVALUEPROVIDER, (String)"getOrgDefValue");){
            Object orgDefValue = null;
            List orgRelation = fieldProp.getOrgRelation();
            if (orgRelation == null || orgRelation.isEmpty()) {
                Object object = orgDefValue;
                return object;
            }
            OrgRelationItem orgRelationItem = (OrgRelationItem)orgRelation.get(0);
            if (orgRelationItem == null) {
                Object object = orgDefValue;
                return object;
            }
            if (!this.isCarryOrgDefValue(orgRelationItem, model.getDataEntityType().getName())) {
                Object var9_13 = null;
                return var9_13;
            }
            OrgRelationItemOrg orgRelationItemOrg = orgRelationItem.getOrg();
            if (orgRelationItemOrg == null) {
                Object object = orgDefValue;
                return object;
            }
            String originOrgId = orgRelationItemOrg.getNumber();
            int index = -1;
            if (o != null) {
                index = o.getRowIndex();
            }
            if (span.isRealtime()) {
                span.addTag("originOrgId", originOrgId);
                span.addTag("orgProp.name", fieldProp.getName());
                span.addTag("index", String.valueOf(index));
                span.addLocaleTag("orgRelation", (Object)SerializationUtils.toJsonString((Object)orgRelation));
                span.addLocaleTag("orgProp", (Object)fieldProp);
            }
            if (StringUtils.isNotBlank((CharSequence)originOrgId)) {
                OrgProp prop = (OrgProp)model.getProperty(originOrgId);
                if (prop == null) {
                    this.view.showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u59d4\u6258\u5173\u7cfb\u4e2d\u5173\u8054\u7684%3$s(%4$s)\u4e0d\u5b58\u5728\uff0c\u8bf7\u66f4\u6b63\u59d4\u6258\u5173\u7cfb\u914d\u7f6e", (String)"FormDefValueProvider_1", (String)"bos-form-mvc", (Object[])new Object[0]), fieldProp.getDisplayName(), fieldProp.getName(), orgRelationItem.getOrg().getName(), originOrgId));
                    Object object = orgDefValue;
                    return object;
                }
                IDataEntityType parentDes = prop.getParent();
                IDataEntityType parentSrc = fieldProp.getParent();
                Object dyn = null;
                if (parentDes instanceof EntryType && parentSrc instanceof EntryType && ((EntryType)parentDes).getName().equals(((EntryType)parentSrc).getName())) {
                    if (index == -1) {
                        index = model.getEntryCurrentRowIndex(((EntryType)parentDes).getName());
                    }
                    dyn = o != null && o.getDataEntity() != null ? o.getDataEntity().get(originOrgId) : model.getValue(originOrgId, index);
                } else if (parentDes instanceof MainEntityType && parentSrc instanceof MainEntityType) {
                    dyn = model.getValue(originOrgId);
                } else if (parentDes instanceof MainEntityType && parentSrc instanceof EntryType) {
                    dyn = model.getValue(originOrgId);
                } else if (parentDes instanceof EntryType && parentSrc instanceof SubEntryType) {
                    if (index == -1) {
                        index = model.getEntryCurrentRowIndex(((EntryType)parentDes).getName());
                    }
                    dyn = model.getValue(originOrgId, index);
                }
                if (dyn != null) {
                    orgDefValue = ((DynamicObject)dyn).get("id");
                }
            }
            Object object = orgDefValue = this.getOrgDefValueByRelation(orgDefValue, orgRelationItem.getType(), orgRelationItem.getDirect().getIndex());
            return object;
        }
    }

    private Object getOrgDefValueByRelation(Object orgDefValue, OrgRelationItemType orgRelationItemType, String directViewType) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_FORMDEFVALUEPROVIDER, (String)"getOrgDefValueByRelation");){
            if (orgDefValue == null) {
                Object object = orgDefValue;
                return object;
            }
            OrgRelationParam relationParam = new OrgRelationParam();
            relationParam.setNumber(orgRelationItemType.getNumber());
            relationParam.setToViewType(orgRelationItemType.getTotype());
            relationParam.setFromViewType(orgRelationItemType.getFromtype());
            relationParam.setDirectViewType(directViewType);
            relationParam.setOrgId(((Long)orgDefValue).longValue());
            String paramStr = SerializationUtils.toJsonString((Object)relationParam);
            Object relationOrgValue = this.relationOrgValues.get(paramStr);
            if (relationOrgValue != null) {
                Object object = relationOrgValue;
                return object;
            }
            long orgForFormDefValue = OrgUnitServiceHelper.getOrgForFormDefValue((OrgRelationParam)relationParam);
            this.relationOrgValues.put(paramStr, orgForFormDefValue);
            if (span.isRealtime()) {
                span.addTag("directViewType", directViewType);
                span.addTag("orgDefValue", String.valueOf(orgDefValue));
                span.addTag("orgRelationItemType.number", orgRelationItemType.getNumber());
                span.addTag("orgRelationItemType.totype", orgRelationItemType.getTotype());
                span.addTag("orgRelationItemType.fromtype", orgRelationItemType.getFromtype());
                span.addTag("orgForFormDefValue", String.valueOf(orgForFormDefValue));
                span.addLocaleTag("OrgRelationItemType", (Object)orgRelationItemType);
            }
            Long l = orgForFormDefValue;
            return l;
        }
    }

    public Object getOrgDefValue(IDataModel model, OrgProp fieldProp) {
        return this.getOrgDefValue(model, fieldProp, null);
    }

    public Object getOrgDefValueByConfig(IDataModel model, OrgProp fieldProp) {
        OrgRelationConfig item;
        Object orgDefValue = null;
        Map map = EntityMetadataCache.getPrincipalRelation((String)model.getDataEntityType().getName());
        if (map != null && map.get(fieldProp.getName()) != null && (item = (OrgRelationConfig)map.get(fieldProp.getName())) != null) {
            String originOrgId = item.getPrincipal().getNumber();
            if (StringUtils.isNotBlank((CharSequence)originOrgId)) {
                OrgProp prop = (OrgProp)model.getProperty(originOrgId);
                IDataEntityType parentDes = prop.getParent();
                IDataEntityType parentSrc = fieldProp.getParent();
                Object dyn = null;
                if (parentDes instanceof EntryType && parentSrc instanceof EntryType && ((EntryType)parentDes).getName().equals(((EntryType)parentSrc).getName())) {
                    int row = model.getEntryCurrentRowIndex(((EntryType)parentDes).getName());
                    dyn = model.getValue(originOrgId, row);
                } else if (parentDes instanceof MainEntityType && parentSrc instanceof MainEntityType) {
                    dyn = model.getValue(originOrgId);
                } else if (parentDes instanceof MainEntityType && parentSrc instanceof EntryType) {
                    dyn = model.getValue(originOrgId);
                } else if (parentDes instanceof EntryType && parentSrc instanceof SubEntryType) {
                    int row = model.getEntryCurrentRowIndex(((EntryType)parentDes).getName());
                    dyn = model.getValue(originOrgId, row);
                }
                if (dyn != null) {
                    orgDefValue = ((DynamicObject)dyn).get("id");
                }
            }
            orgDefValue = this.getOrgDefValueByRelation(orgDefValue, item.getType(), item.getDirect().getIndex());
        }
        return orgDefValue;
    }

    public String getAppId(IDataModel model) {
        String appId = null;
        if (this.view != null && this.view.getFormShowParameter() != null) {
            appId = this.view.getFormShowParameter().getAppId();
            if (StringUtils.isNotBlank((CharSequence)appId)) {
                if (appId.equalsIgnoreCase("bos")) {
                    String appNumber = model.getDataEntityType().getBizAppNumber();
                    appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
                } else {
                    appId = AppMetadataCache.getAppInfo((String)appId).getId();
                }
            } else if (this.view.getFormShowParameter().getFormConfig() != null) {
                appId = this.view.getFormShowParameter().getFormConfig().getAppId();
            }
        }
        if (StringUtils.isBlank(appId)) {
            appId = super.getAppId(model);
        }
        return appId;
    }

    private boolean isCarryOrgDefValue(OrgRelationItem orgRelationItem, String formId) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_FORMDEFVALUEPROVIDER, (String)"isCarryOrgDefValue");){
            DynamicObject billParamObj;
            boolean isCarry = true;
            if (orgRelationItem.getType() != null && ORGRELATIONITEM_TYPE_ORGUNIT2ADMIN.equals(orgRelationItem.getType().getNumber()) && (billParamObj = ParameterReader.getBillParameter((String)formId)) != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)BOS_BILLPARAMETER_BOSCARRYADMINORG)) {
                isCarry = billParamObj.getBoolean(BOS_BILLPARAMETER_BOSCARRYADMINORG);
            }
            if (span.isRealtime()) {
                span.addLocaleTag("isCarry", (Object)isCarry);
            }
            boolean bl = isCarry;
            return bl;
        }
    }
}

