/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.property.FieldRuleArgs;
import kd.bos.entity.property.IFieldRuleHandle;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.rule.BR;
import kd.bos.entity.rule.IRuleCompariseon;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.metadata.kflow.enums.RuleType;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FormRuleContainer
extends RuleContainer<FormRuleExecuteContext> {
    private static final String TRACE_TYPE_RULE = "formrule";
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private IFormView view;
    private Map<String, List<AbstractRule>> allEntityRules;

    public FormRuleContainer(IFormView view) {
        this.view = view;
    }

    protected IDataModel getModel() {
        return this.view != null ? this.view.getModel() : super.getModel();
    }

    protected Map<String, List<AbstractRule>> getAllEntityRules() {
        if (this.allEntityRules == null) {
            this.allEntityRules = new HashMap<String, List<AbstractRule>>();
            if (this.view.getFormShowParameter().getFormConfig().getRuleCount() > 0) {
                this.allEntityRules = FormMetadataCache.getAllEntityRules((String)this.view.getFormShowParameter().getFormId());
            }
        }
        return this.allEntityRules;
    }

    protected List<AbstractRule> getFieldDependencyRules(IDataEntityProperty raiseProperty, RaiseEventType raiseEventType) {
        IDataEntityType dataEntityType;
        List<AbstractRule> rules = this.getAllRules(null, null);
        for (dataEntityType = raiseProperty.getParent(); dataEntityType != null && !(dataEntityType instanceof MainEntityType); dataEntityType = dataEntityType.getParent()) {
        }
        ArrayList<AbstractRule> fieldRules = new ArrayList<AbstractRule>();
        if (dataEntityType != null) {
            String billStatus = this.view == null || this.view.getFormShowParameter().getStatus() == null ? "" : this.view.getFormShowParameter().getStatus().toString();
            Map fieldsMap = ((MainEntityType)dataEntityType).getAllFields();
            for (Map.Entry fieldEntry : fieldsMap.entrySet()) {
                IDataEntityProperty property = (IDataEntityProperty)fieldEntry.getValue();
                FieldRuleArgs args = new FieldRuleArgs(property.getParent().getName(), property, raiseEventType, (Object)billStatus);
                if (!(property instanceof IFieldRuleHandle)) continue;
                List fieldPropAbR = ((IFieldRuleHandle)property).getFieldRules(args);
                for (AbstractRule abstractRule : fieldPropAbR) {
                    if (!abstractRule.getDepFldSet().contains(raiseProperty.getName())) continue;
                    fieldRules.add(abstractRule);
                }
            }
            Map allEntities = ((MainEntityType)dataEntityType).getAllEntities();
            for (Map.Entry entityTypeEntry : allEntities.entrySet()) {
                EntityType entityType = (EntityType)entityTypeEntry.getValue();
                if (!(entityType instanceof EntryType)) continue;
                EntryType entryType = (EntryType)entityType;
                List entryRules = entryType.getEntryNotMustInputRules(raiseProperty.getParent().getName());
                for (AbstractRule entryRule : entryRules) {
                    if (!entryRule.getDepFldSet().contains(raiseProperty.getName())) continue;
                    fieldRules.add(entryRule);
                }
            }
        }
        for (AbstractRule abstractRule : rules) {
            if (!(abstractRule instanceof BR)) continue;
            String ruleType = ((BR)abstractRule).getRuleType();
            if (RuleType.KFlowRule.name().equals(ruleType)) {
                fieldRules.add(abstractRule);
                continue;
            }
            if (!abstractRule.getDepFldSet().contains(raiseProperty.getName())) continue;
            fieldRules.add(abstractRule);
        }
        return fieldRules;
    }

    protected List<AbstractRule> getFieldDependencyRulesByEntityType(IDataEntityType entity, RaiseEventType raiseEventType) {
        ArrayList<AbstractRule> fieldRules = new ArrayList<AbstractRule>();
        Map fieldsMap = new HashMap(1);
        if (entity instanceof MainEntityType) {
            fieldsMap = ((MainEntityType)entity).getAllFields();
        } else if (entity instanceof EntryType) {
            fieldsMap = ((EntryType)entity).getFields();
        }
        if (!CollectionUtils.isEmpty(fieldsMap)) {
            String billStatus = this.view == null || this.view.getFormShowParameter().getStatus() == null ? "" : this.view.getFormShowParameter().getStatus().toString();
            for (Map.Entry fieldEntry : fieldsMap.entrySet()) {
                IDataEntityProperty property = (IDataEntityProperty)fieldEntry.getValue();
                FieldRuleArgs args = new FieldRuleArgs(property.getParent().getName(), property, raiseEventType, (Object)billStatus);
                if (!(property instanceof IFieldRuleHandle)) continue;
                fieldRules.addAll(((IFieldRuleHandle)property).getFieldRules(args));
            }
        }
        return fieldRules;
    }

    private List<AbstractRule> getAllRules(IDataEntityType entityType, RaiseEventType raiseEventType) {
        Map<String, List<AbstractRule>> allRules = this.getAllEntityRules();
        ArrayList<AbstractRule> rules = new ArrayList<AbstractRule>();
        for (List<AbstractRule> entityRules : allRules.values()) {
            rules.addAll(entityRules);
        }
        return rules;
    }

    protected List<AbstractRule> getEntityDependencyRules(IDataEntityType entity, RaiseEventType raiseEventType) {
        Map<String, List<AbstractRule>> allRules = this.getAllEntityRules();
        List<AbstractRule> rules = allRules.get(entity.getName());
        if (rules == null) {
            rules = new ArrayList<AbstractRule>();
        }
        return rules;
    }

    protected List<AbstractRule> getChildEntityDependencyRules(IDataEntityType entity, RaiseEventType raiseEventType) {
        ArrayList<AbstractRule> rules;
        block4: {
            block3: {
                rules = new ArrayList<AbstractRule>();
                if (entity instanceof SubEntryType) {
                    return rules;
                }
                if (!(entity instanceof EntryType) || !(entity.getParent() instanceof MainEntityType)) break block3;
                MainEntityType mainType = (MainEntityType)entity.getParent();
                for (IDataEntityType entitytype : mainType.getAllEntities().values()) {
                    if (entitytype == null || entitytype.getParent() == null || !StringUtils.equals((CharSequence)entitytype.getParent().getName(), (CharSequence)entity.getName())) continue;
                    rules.addAll(this.getEntityDependencyRules(entitytype, raiseEventType));
                }
                break block4;
            }
            if (!(entity instanceof MainEntityType)) break block4;
            MainEntityType mainType = (MainEntityType)entity;
            for (IDataEntityType entityType : mainType.getAllEntities().values()) {
                if (entityType == null || StringUtils.equals((CharSequence)entityType.getName(), (CharSequence)entity.getName())) continue;
                rules.addAll(this.getEntityDependencyRules(entityType, raiseEventType));
            }
        }
        return rules;
    }

    protected IRuleCompariseon getRuleComparison() {
        return null;
    }

    protected List<RowDataEntity> rebuildRowDataEntities(RaiseEventType raiseEventType, List<AbstractRule> rules, IDataEntityType eventTable, List<RowDataEntity> eventDataEntities) {
        boolean reloadEntryRows = false;
        if (raiseEventType == RaiseEventType.FieldChanged && eventTable instanceof MainEntityType) {
            for (AbstractRule rule : rules) {
                if (StringUtils.equals((CharSequence)eventTable.getName(), (CharSequence)rule.getSource())) continue;
                reloadEntryRows = true;
                break;
            }
        }
        if (!reloadEntryRows) {
            return super.rebuildRowDataEntities(raiseEventType, rules, eventTable, eventDataEntities);
        }
        DynamicObject billObj = this.view.getModel().getDataEntity(true);
        ArrayList<RowDataEntity> list = new ArrayList<RowDataEntity>();
        list.add(new RowDataEntity(0, billObj));
        return list;
    }

    public void raiseInitialized(IDataEntityType dataEntityType, List<RowDataEntity> dataEntities, FormRuleExecuteContext executeContext) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACE_TYPE_RULE, (String)"FormRuleContainer.raiseInitialized");){
            RaiseEventSource s = new RaiseEventSource(RaiseEventType.Initialized, dataEntities, dataEntityType);
            super.raise(s, (RuleExecuteContext)executeContext);
        }
    }

    public void raiseDataChanged(IDataEntityProperty property, List<RowDataEntity> dataEntities, FormRuleExecuteContext executeContext) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACE_TYPE_RULE, (String)"FormRuleContainer.raiseDataChanged");){
            RaiseEventSource s = new RaiseEventSource(RaiseEventType.FieldChanged, dataEntities, property);
            super.raise(s, (RuleExecuteContext)executeContext);
        }
    }

    public void raiseItemAdded(IDataEntityType dataEntityType, List<RowDataEntity> dataEntities, FormRuleExecuteContext executeContext) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACE_TYPE_RULE, (String)"FormRuleContainer.raiseItemAdded");){
            RaiseEventSource s = new RaiseEventSource(RaiseEventType.ItemAdded, dataEntities, dataEntityType);
            super.raise(s, (RuleExecuteContext)executeContext);
        }
    }
}

