/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IDefValueProvider;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.operate.interaction.KDAfterExecuteOperationException;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.AbstractFormView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CloseCallBackWraper;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICtsyShowParameter;
import kd.bos.form.IFormDataBinder;
import kd.bos.form.IFormUpdateViewService;
import kd.bos.form.IFormUserConfig;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.IPrivacyService;
import kd.bos.form.OperateParameter;
import kd.bos.form.ShowType;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.flex.IFlexEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.IFormMutexService;
import kd.bos.form.operate.IFormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.CtsyListShowParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.cache.RootPageCache;
import kd.bos.mvc.cache.TempShowParamCache;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.mvc.form.DataModelChangeListener;
import kd.bos.mvc.form.FlexModel;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.FormDataBinder;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.mvc.form.FormDefValueProvider;
import kd.bos.mvc.form.FormMutexService;
import kd.bos.mvc.form.FormRuleContainer;
import kd.bos.mvc.form.FormUpdateViewService;
import kd.bos.mvc.form.FormUserConfig;
import kd.bos.mvc.form.IFormController;
import kd.bos.mvc.form.PrivacyService;
import kd.bos.mvc.form.TileTabUtil;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.report.ReportView;
import kd.bos.permission.api.ICorePermissionService;
import kd.bos.permission.api.PermissionService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.IBaseDataService;
import kd.bos.service.IFullTextIndexService;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.filter.FullTextIndexService;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.upload.UploadOption;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class FormView
extends AbstractFormView {
    private static final Log log = LogFactory.getLog((String)"FormView");
    private static final String SPAN_TYPE_NAME = "formview";
    private static final String SPAN_TYPE_OPERATE = "operate";
    private static final String OPERATE_SOURCENAME = "sourceName";
    private static final String OPERATE_SOURCEEVENT = "sourceEvent";
    private static final String SUB_MAIN_TAB = "_submaintab_";
    private static final String MAIN_VIEW_TAB = "tabap";
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private static final String SUBMAINTAB_COUNT = "_submaintab_count_";
    private static final String TABLAYOUT_TABPAGE_PREFIX = "TABLAYOUT_TABPAGE_";
    private static final String BOS_OPEN_DONE = "bos_open_done";
    private FormRoot formRoot;
    private static final String APP_IMAGE_URL = "appImageUrl";
    private Map<String, IFormView> mapFormViews;
    protected Map<String, Object> operateParameters = new HashMap<String, Object>();
    protected FormOperate formOperate;
    private boolean ignorePlugin = false;
    private boolean releasing = false;
    private boolean isDestoryFlag = false;
    private Set<String> rootPageChilds = null;
    private static final String PERM_IGNORE_CHECKAPP = "PERM_IGNORE_CHECKAPP";
    private boolean openDone = true;

    @KSMethod
    public String getFormId() {
        return this.getFormShowParameter().getFormId();
    }

    @KSMethod
    public void cacheFormShowParameter() {
        IPageCache cache = (IPageCache)this.getService(IPageCache.class);
        cache.put(FormShowParameter.class.getSimpleName(), this.getFormShowParameter().toString());
    }

    public void initialize(FormShowParameter formShowParameter) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"FormView.initialize");){
            this.formShowParameter = formShowParameter;
            this.initiService();
        }
    }

    protected void initiService() {
        this.addService(IFormController.class, this.createFormController());
        this.addService(IDataModel.class, this.createDataModel());
        ClientViewProxy clientViewProxy = new ClientViewProxy((IPageCache)this.getService(IPageCache.class), (IFormView)this);
        this.addService(IClientViewProxy.class, clientViewProxy);
        this.addService(RuleContainer.class, (Object)new FormRuleContainer((IFormView)this));
        this.addService(ITimeService.class, new TimeService());
        this.addService(IUserService.class, new UserService());
        this.addService(IFormMutexService.class, new FormMutexService((IFormView)this));
        this.addService(IFormDataBinder.class, this.createFormDataBinder());
        this.addService(IBaseDataService.class, new BaseDataService());
        this.addService(IDefValueProvider.class, (Object)this.createFormDefValueProvider());
        this.initiPluginProxy();
        this.addService(IFullTextIndexService.class, new FullTextIndexService());
        this.addService(IFormUserConfig.class, new FormUserConfig((IFormView)this));
        this.addService(IFormUpdateViewService.class, new FormUpdateViewService((IFormView)this));
        this.addService(IPrivacyService.class, new PrivacyService((IFormView)this));
        this.fireInitialize();
        this.initPluginManager();
        if (!this.releasing) {
            this.refreshIfMeetExpireThreshold();
        }
    }

    protected void refreshIfMeetExpireThreshold() {
        FormShowParameter showParameter = this.getFormShowParameter();
        if (showParameter != null && !this.releasing && showParameter.isMeetExpireThreshold()) {
            showParameter.setCacheExpireTime(System.currentTimeMillis());
            IDataModel model = (IDataModel)this.getService(IDataModel.class);
            if (model instanceof FormDataModel) {
                ((FormDataModel)model).setCacheExpireAfter(true);
            }
            IPageCache pageCache = (IPageCache)this.getService(IPageCache.class);
            pageCache.expireAfter(CacheKeyUtil.getPageCacheKeyTimeout());
            this.cacheFormShowParameter();
            if (showParameter.getPageId().equals(showParameter.getRootPageId())) {
                RootPageCache.refeshChildPageCacheExpire(showParameter.getPageId());
            }
        }
    }

    public String getServiceAppId(String pageId) {
        FormShowParameter showParameter = SessionManager.getCurrent().getFormShowParameter(pageId);
        return showParameter.getServiceAppId();
    }

    protected void fireInitialize() {
        this.getPluginProxy().fireInitialize();
    }

    @KSMethod
    public void activate() {
        Map<String, Object> config = FormConfigFactory.createConfig(this.getFormShowParameter());
        if (this.isShowCancelMessage(config)) {
            return;
        }
        ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("activate", config);
    }

    protected void release() {
        for (Map.Entry entry : this.cacheControls.entrySet()) {
            Control ctl = (Control)entry.getValue();
            ctl.release();
        }
        ((FormDataModel)this.getModel()).release();
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getService(FormViewPluginProxy.class);
        pluginProxy.firePageRelease(new EventObject((Object)this));
        this.services.clear();
    }

    protected void initiPluginProxy() {
        FormViewPluginProxy pluginProxy = this.createPluginProxy();
        this.addService(FormViewPluginProxy.class, pluginProxy);
        if (!this.ignorePlugin) {
            pluginProxy.registerPlugins(this.getFormShowParameter().createPlugin());
        }
        pluginProxy.setView((IFormView)this);
    }

    protected void initPluginManager() {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getService(FormViewPluginProxy.class);
        pluginProxy.initPluginManager((IFormView)this);
    }

    @KSMethod
    public void addPlugin(IFormPlugin plugin) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getService(FormViewPluginProxy.class);
        pluginProxy.registerPlugin(plugin);
        plugin.setView((IFormView)this);
    }

    protected FormController createFormController() {
        return new FormController((IFormView)this);
    }

    protected IDataModel createDataModel() {
        return new FormDataModel(this.getEntityId(), this.getPageId(), this.services, this.getFormShowParameter().getAppId(), "47150e89000000ac");
    }

    protected FormViewPluginProxy createPluginProxy() {
        return new FormViewPluginProxy();
    }

    protected FormDataBinder createFormDataBinder() {
        return new FormDataBinder((IFormView)this);
    }

    protected FormDefValueProvider createFormDefValueProvider() {
        return new FormDefValueProvider((IFormView)this);
    }

    @KSMethod
    public <T extends Control> T getControl(String key) {
        Control ctl;
        Control oldCustCtl = null;
        if (this.customControls.size() > 0 && this.customControls.contains(key.toLowerCase())) {
            ctl = null;
            if (this.cacheControls.isEmpty()) {
                this.getRootControl();
            }
            oldCustCtl = (Control)this.cacheControls.get(key);
        } else {
            ctl = (Control)this.cacheControls.get(key);
        }
        if (ctl != null) {
            return (T)ctl;
        }
        if (this.getPluginProxy() != null) {
            OnGetControlArgs e = new OnGetControlArgs((Object)this, key);
            e.setControl(oldCustCtl);
            this.getPluginProxy().fireOnGetControl(e);
            ctl = e.getControl();
        }
        if (ctl == null) {
            String[] keys;
            Control fe;
            this.getRootControl();
            if (StringUtils.isNotEmpty((CharSequence)key) && key.startsWith("$$") && (fe = (Control)this.cacheControls.get((keys = key.substring(2).split("__"))[0])) instanceof IFlexEdit) {
                ctl = ((IFlexEdit)fe).getFlexControl(keys[1]);
                if (ctl == null) {
                    return null;
                }
                this.cacheControls.put(key, ctl);
                return (T)ctl;
            }
            if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)TABLAYOUT_TABPAGE_PREFIX)) {
                TabPage tabPage = new TabPage();
                tabPage.setKey(key);
                tabPage.setView((IFormView)this);
                return (T)tabPage;
            }
            return (T)((Control)this.cacheControls.get(key));
        }
        this.cacheControls.put(key, ctl);
        return (T)ctl;
    }

    public FormRoot getRootControl() {
        if (this.formRoot == null) {
            this.formRoot = FormMetadataCache.getRootControl((String)this.getFormId());
            if (this.getFormShowParameter() != null && StringUtils.isNotBlank((CharSequence)this.getFormShowParameter().getRootPageId())) {
                List<String> pageIds = RootPageCache.getPageIds(this.getFormShowParameter().getRootPageId());
                this.rootPageChilds = pageIds != null ? new HashSet<String>(pageIds) : new HashSet<String>(0);
            }
            this.cacheControls.clear();
            this.createControlIndex(this.formRoot.getItems());
            this.formRoot.setView((IFormView)this);
            this.rootPageChilds = null;
        }
        return this.formRoot;
    }

    @KSMethod
    public <T extends Control> T getFlexControl(String key, int row) {
        Control ctl = (Control)this.cacheControls.get(key);
        if (ctl != null) {
            return (T)ctl;
        }
        if (key.startsWith("$$")) {
            String[] keys = key.substring(2).split("__");
            Control fe = (Control)this.cacheControls.get(keys[0]);
            if (fe == null) {
                this.getRootControl();
                fe = (Control)this.cacheControls.get(keys[0]);
            }
            if (fe instanceof IFlexEdit) {
                ctl = ((IFlexEdit)fe).getFlexControl(keys[1], row);
                if (ctl == null) {
                    return null;
                }
                this.cacheControls.put(key, ctl);
                return (T)ctl;
            }
        }
        return (T)((Control)this.cacheControls.get(key));
    }

    public void createControlIndex(List<Control> items) {
        for (Control ctl : items) {
            ctl.setView((IFormView)this);
            this.cacheControls.put(ctl.getKey(), ctl);
            if (!(ctl instanceof Container)) continue;
            this.createControlIndex(((Container)ctl).getItems());
        }
    }

    public List<Object> getActionResult() {
        IClientViewProxy service = (IClientViewProxy)this.getService(IClientViewProxy.class);
        if (service != null) {
            this.getPageCache().suspendCommit();
            FormDataModel dataModel = (FormDataModel)((Object)this.getService(IDataModel.class));
            IClientViewProxy proxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
            Set entryGrids = proxy.getLazySummaryGrid();
            for (String gridKey : entryGrids) {
                EntryGrid grid = (EntryGrid)this.getControl(gridKey);
                if (grid == null) continue;
                grid.postLazySummaryAction();
            }
            dataModel.updateCache();
            if (OperationContext.get() != null && "loadData".equals(OperationContext.get().getOpMethod())) {
                this.getPageCache().put(BOS_OPEN_DONE, "true");
            } else if (StringUtils.isBlank((CharSequence)this.getPageCache().get(BOS_OPEN_DONE))) {
                StringBuilder sb = new StringBuilder();
                StackTraceElement[] stes = Thread.currentThread().getStackTrace();
                int size = Math.min(stes.length, 50);
                for (int i = 1; i < size; ++i) {
                    sb.append("\n\tat ").append(stes[i]);
                }
                log.warn(" invalid view pageid:{} called. {}. ", (Object)this.getPageId(), (Object)sb);
            }
            List actionResult = service.getActionResult();
            this.getPageCache().resumeCommit();
            this.getPageCache().saveChanges();
            return actionResult;
        }
        return new ArrayList<Object>(0);
    }

    @KSMethod
    public void updateView() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"FormView.updateView");){
            this.getPluginProxy().fireBeforeBindData(new EventObject((Object)this));
            this.getPageCache().suspendCommit();
            IClientViewProxy proxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
            proxy.clearControlsState();
            ((IFormDataBinder)this.getService(IFormDataBinder.class)).updateView();
            this.getPageCache().resumeCommit();
            IFormUpdateViewService updateService = (IFormUpdateViewService)this.getService(IFormUpdateViewService.class);
            if (updateService != null) {
                updateService.afterUpdateView();
            }
            this.getPluginProxy().fireAfterBindData(new EventObject((Object)this));
            SingleOrgContextHelper.createFormSingleOrgContext((IFormView)this);
            this.hideUnauthorizedControls();
            this.lockUnauthorizedControls();
        }
    }

    @KSMethod
    public void updateView(String key) {
        IFormDataBinder binder = (IFormDataBinder)this.getService(IFormDataBinder.class);
        binder.updateView(key);
    }

    public void updateView(String key, int row) {
        IFormDataBinder binder = (IFormDataBinder)this.getService(IFormDataBinder.class);
        binder.updateView(key, row);
    }

    public void updateView(String key, int row, int parent) {
        IFormDataBinder binder = (IFormDataBinder)this.getService(IFormDataBinder.class);
        binder.updateView(key, row, parent);
    }

    public void scrollIntoView(String key) {
        IClientViewProxy proxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("k", key);
        proxy.addAction("scrollIntoView", params);
    }

    @KSMethod
    public String getEntityId() {
        return this.formShowParameter.getFormConfig().getEntityTypeId();
    }

    @KSMethod
    public OperationResult invokeOperation(String operationKey) {
        OperateOption oprOpt = OperateOption.create();
        oprOpt.setVariableValue("SpecialDataPerm_CurrentAppId", this.getFormShowParameter().getAppId());
        oprOpt.setVariableValue("bos_support_bigdata_aysn", String.valueOf(true));
        if (MutexHelper.isOpenIntentLocks()) {
            oprOpt.setVariableValue("isOpenIntentLocks", String.valueOf(true));
        }
        return this.invokeOperation(operationKey, oprOpt);
    }

    @Deprecated
    @KSMethod
    public OperationResult invokeOperation(String operationKey, OperateParameter operateParameter) {
        OperateOption option = OperateOption.create();
        if (operateParameter != null) {
            option.setVariableValue(OPERATE_SOURCENAME, operateParameter.getSourceName());
            option.setVariableValue(OPERATE_SOURCEEVENT, String.valueOf(operateParameter.getSourceEvent()));
        }
        return this.invokeOperation(operationKey, option);
    }

    @KSMethod
    public OperationResult invokeOperation(String operationKey, OperateOption option) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"FormView.invokeOperation", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            OperationResult result;
            Throwable throwable;
            span.addTag("operationKey", operationKey);
            FormOperate operate = this.getOperation(operationKey);
            operate.setView((IFormView)this);
            OperateOption operateOption = option != null ? option : OperateOption.create();
            Map variables = operateOption.getVariables();
            if (null != variables && !variables.isEmpty() && null == variables.get("ignoreassignperson")) {
                operateOption.setVariableValue("ignoreassignperson", "false");
            }
            if (option == null) {
                option = OperateOption.create();
            }
            if (!option.containsVariable("bos_fromFormViewOp")) {
                option.setVariableValue("bos_fromFormViewOp", "true");
            }
            operate.setOption(operateOption);
            boolean isEmpty = StringUtils.isEmpty((CharSequence)operate.getConfirmMessage());
            if ("delete".equals(operate.getType()) && isEmpty) {
                throwable = null;
                try (EntityTraceSpan span1 = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"FormView.invokeOperation.GUIInteraction");){
                    String message = ResManager.loadKDString((String)"\u5220\u9664\u8be5\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\r\n\u786e\u5b9a\u5220\u9664\uff1f", (String)"FormView_0", (String)BOS_FORM_MVC, (Object[])new Object[0]);
                    operate.setConfirmMessage(message);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            } else if ("delete".equals(operate.getType()) && operate.getConfirmMessage().equals("empty")) {
                operate.setConfirmMessage("");
            }
            operate.getParameter().putAll(this.operateParameters);
            if (option != null && option.containsVariable(OPERATE_SOURCENAME)) {
                operate.getParameter().put(OPERATE_SOURCENAME, operateOption.getVariableValue(OPERATE_SOURCENAME));
                operate.getParameter().put(OPERATE_SOURCEEVENT, operateOption.getVariableValue(OPERATE_SOURCEEVENT));
            }
            if (option != null) {
                option.setVariableValue("mulilangtext.emptyfill.enable", System.getProperty("mulilangtext.emptyfill.enable"));
            }
            log.info("\u6267\u884c\u64cd\u4f5c\uff1a" + operationKey);
            operate.getOption().setVariableValue("bos.catch_after_execute_operation_transaction_exception", "true");
            try (ArchiveRoute mr = ArchiveRoute.mapRoute((String)operateOption.getVariableValue("routeKey", ""), (String)operateOption.getVariableValue("ArchiveKey", ""));){
                try {
                    result = operate.execute();
                }
                catch (KDException ex) {
                    if (ex.getCause() instanceof KDAfterExecuteOperationException) {
                        this.getModel().updateCache();
                        throw ((KDAfterExecuteOperationException)ex.getCause()).getOriginException();
                    }
                    throw ex;
                }
            }
            this.getPageCache().saveChanges();
            throwable = result;
            return throwable;
        }
    }

    protected FormOperate getOperation(String operationKey) {
        if (this.formOperate == null || !this.formOperate.getOperateKey().equalsIgnoreCase(operationKey)) {
            this.formOperate = (FormOperate)FormMetadataCache.getFormOperation((String)this.getEntityId(), (String)operationKey);
            this.formOperate.setEntityId(this.getEntityId());
            this.formOperate.setPageId(this.getPageId());
            if (this.formOperate instanceof IFormOperate) {
                ((IFormOperate)this.formOperate).setViewBillFormId(this.getFormId());
            }
        }
        return this.formOperate;
    }

    @KSMethod
    public void showForm(FormShowParameter param) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"FormView.showForm");){
            this.setReturnData(null);
            TileTabUtil tileTabUtil = new TileTabUtil(this.getMainView(), this.getPageId());
            if (null != param) {
                span.addTag("formId", param.getIdentifyFormId());
                this.convertFormDefaultLayout(param);
                if (StringUtils.isBlank((CharSequence)param.getParentPageId())) {
                    param.setParentPageId(this.getPageId());
                }
                if (StringUtils.isBlank((CharSequence)param.getAppId())) {
                    param.setAppId(this.formShowParameter.getAppId());
                }
                if (this.formShowParameter.getCustomParams().containsKey("checkRightAppId") && !param.getCustomParams().containsKey("checkRightAppId")) {
                    param.getCustomParams().put("checkRightAppId", this.formShowParameter.getCustomParam("checkRightAppId"));
                }
                if (!param.getPageId().equals(param.getRootPageId())) {
                    param.setRootPageId(this.formShowParameter.getRootPageId());
                }
                if (StringUtils.isBlank((CharSequence)param.getParentFormId())) {
                    param.setParentFormId(this.getFormId());
                }
                if (param.getOpenStyle().getClientShowType().equals((Object)ShowType.MainNewTabPage)) {
                    param.setCustomParam("originShowType", (Object)ShowType.MainNewTabPage.getValue());
                    IFormView mainview = this.getMainView();
                    if (mainview == null) {
                        if (this.formShowParameter.getOpenStyle().getShowType() == ShowType.Modal) {
                            param.getOpenStyle().setShowType(ShowType.Modal);
                        } else {
                            param.getOpenStyle().setShowType(ShowType.NonModal);
                        }
                        this.sendShowFormAction(param);
                    } else {
                        boolean parentIsModel = this.isParentModel();
                        if (tileTabUtil.enableTileMenu()) {
                            if (tileTabUtil.isOverMaxTileTabs()) {
                                mainview.showMessage(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u540c\u65f6\u6253\u5f00100\u4e2a\u9875\u9762\u3002", (String)"FormView_7", (String)BOS_FORM_MVC, (Object[])new Object[0]));
                                this.sendFormAction(mainview);
                                return;
                            }
                            if (parentIsModel) {
                                param.getOpenStyle().setShowType(ShowType.Modal);
                            } else if (!mainview.getPageId().equals(this.getPageId())) {
                                param.getOpenStyle().setTargetKey(MAIN_VIEW_TAB);
                                param.getOpenStyle().setShowType(ShowType.NewTabPage);
                            }
                        } else {
                            IFormView appView = SessionManager.getCurrent().getViewNoPlugin(param.getAppId() + mainview.getPageId());
                            ShowType appViewShowType = ShowType.Default;
                            if (appView != null) {
                                appViewShowType = appView.getFormShowParameter().getOpenStyle().getShowType();
                            }
                            if (this.isShowModelType(parentIsModel, appView, appViewShowType)) {
                                param.getOpenStyle().setShowType(ShowType.Modal);
                            } else if (param.getOpenStyle().getShowType() != ShowType.Modal) {
                                Control c = null;
                                if (appView != null) {
                                    c = appView.getControl(SUB_MAIN_TAB);
                                }
                                if (c == null) {
                                    int count;
                                    IPageCache pageCache = (IPageCache)mainview.getService(IPageCache.class);
                                    String _submaintab_count_ = pageCache.get(SUBMAINTAB_COUNT);
                                    int n = count = _submaintab_count_ == null ? 3 : Integer.parseInt(_submaintab_count_);
                                    if (count >= this.getMaxTabs()) {
                                        mainview.showMessage(ResManager.loadKDString((String)"\u5df2\u6253\u5f00\u592a\u591a\u9875\u7b7e\u4e86\uff0c\u8bf7\u5173\u95ed\u90e8\u5206\u9875\u7b7e\u540e\u518d\u8bd5\uff01", (String)"FormView_1", (String)BOS_FORM_MVC, (Object[])new Object[0]));
                                        this.sendFormAction(mainview);
                                        return;
                                    }
                                    pageCache.put(SUBMAINTAB_COUNT, ++count + "");
                                } else if (c instanceof Tab) {
                                    param.getOpenStyle().setTargetKey(SUB_MAIN_TAB);
                                    mainview = appView;
                                }
                                param.getOpenStyle().setShowType(ShowType.NewTabPage);
                            }
                        }
                        param.setCustomParam("mainPageId", (Object)mainview.getPageId());
                        IFormView view = this.getViewNoPlugin(param.getPageId());
                        if (view != null) {
                            this.activate(param.getPageId());
                            return;
                        }
                        if (param.getOpenStyle().getShowType() == ShowType.Modal || tileTabUtil.enableTileMenu() && mainview.getPageId().equals(this.getPageId())) {
                            this.sendShowFormAction(param);
                        } else {
                            mainview.showForm(param);
                            this.sendFormAction(mainview);
                        }
                    }
                } else if (tileTabUtil.isTileTab(param)) {
                    IFormView mainview = this.getMainView();
                    if (tileTabUtil.isOverMaxTileTabs()) {
                        mainview.showMessage(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u540c\u65f6\u6253\u5f00100\u4e2a\u9875\u9762\u3002", (String)"FormView_7", (String)BOS_FORM_MVC, (Object[])new Object[0]));
                        this.sendFormAction(mainview);
                        return;
                    }
                    param.getOpenStyle().setTargetKey(MAIN_VIEW_TAB);
                    mainview.showForm(param);
                    this.sendFormAction(mainview);
                } else {
                    this.sendShowFormAction(param);
                }
            }
        }
    }

    protected int getMaxTabs() {
        return 8;
    }

    protected boolean isShowModelType(boolean parentIsModel, IFormView appView, ShowType appViewShowType) {
        return parentIsModel || appView == null || appViewShowType == ShowType.Modal;
    }

    private void activate(String pageId) {
        ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("activate", (Object)pageId);
    }

    private boolean isParentModel() {
        boolean isModel = false;
        FormShowParameter parenShowParameter = this.getFormShowParameter();
        HashSet<String> pageIdSet = new HashSet<String>(8);
        int size = 0;
        while (parenShowParameter != null) {
            ++size;
            if (parenShowParameter.getOpenStyle().getShowType().compareTo((Enum)ShowType.Modal) == 0) {
                isModel = true;
                break;
            }
            if (size >= 30) {
                log.info("FormView\u5224\u65ad\u7236\u9875\u9762\u63a5\u53e3\uff0c\u5faa\u73af\u8c03\u7528\u8d85\u8fc730\u6b21\u8df3\u51fa\u5faa\u73af\uff0cFormShowParameter\u53c2\u6570\uff1a{}", (Object)parenShowParameter.toString());
                break;
            }
            if (parenShowParameter.getParentPageId() == null) {
                parenShowParameter = null;
                continue;
            }
            if (!pageIdSet.add(parenShowParameter.getParentPageId())) {
                log.info("FormView\u5224\u65ad\u7236\u9875\u9762\u63a5\u53e3\uff0c\u51fa\u73b0\u91cd\u590d\u7684pageId\u8df3\u51fa\u5faa\u73af\uff0cFormShowParameter\u53c2\u6570\uff1a{}", (Object)parenShowParameter.toString());
                break;
            }
            parenShowParameter = SessionManager.getCurrent().getFormShowParameter(parenShowParameter.getParentPageId());
        }
        return isModel;
    }

    public IFormView getMainView() {
        return SessionManager.getCurrent().getMainView(this.formShowParameter.getRootPageId());
    }

    private void sendShowFormAction(FormShowParameter param) {
        Object caption;
        if (EntityTracer.isRealtime()) {
            EntityTracer.addLocaleTag((String)"showParameter", (Object)param);
        }
        if (param.isSendToClient()) {
            String cacheId = TempShowParamCache.put(param);
            ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("showFormByClient", (Object)cacheId);
            return;
        }
        if (param.getOpenStyle().getClientShowType().equals((Object)ShowType.InCurrentForm)) {
            Object appImageUrl = this.getFormShowParameter().getCustomParam(APP_IMAGE_URL);
            if (param.getCustomParam(APP_IMAGE_URL) == null && appImageUrl != null) {
                param.setCustomParam(APP_IMAGE_URL, appImageUrl);
            }
        } else if (param.getOpenStyle().getClientShowType().equals((Object)ShowType.ReplaceHomePage)) {
            param.setRootPageId(param.getPageId());
        }
        Map<String, Object> config = null;
        if (param instanceof ICtsyShowParameter && !CtsyListShowParameter.isSelfTenant((ICtsyShowParameter)((ICtsyShowParameter)param))) {
            config = this.getCtsyFormConfig(param);
        } else {
            FormShowParameter rpcFormShowParameter;
            config = FormConfigFactory.createConfig(param);
            if (param.getFormConfig() == null && (rpcFormShowParameter = SessionManager.getCurrent().getFormShowParameter(param.getPageId())) != null) {
                param = rpcFormShowParameter;
            }
        }
        if (this.isShowCancelMessage(config)) {
            return;
        }
        IFormView mainView = this.getMainView();
        boolean isHomepageForm = false;
        if (mainView != null && mainView.getFormShowParameter() != null) {
            isHomepageForm = "home_page".equals(mainView.getFormShowParameter().getFormId());
        }
        if (isHomepageForm && StringUtils.equals((CharSequence)SUB_MAIN_TAB, (CharSequence)param.getOpenStyle().getTargetKey()) && ShowType.NewTabPage == param.getOpenStyle().getShowType()) {
            String pageId = param.getPageId();
            String appId = param.getAppId();
            String method = "addVirtualTab";
            HashMap<String, Object> parentMap = new HashMap<String, Object>();
            parentMap.put("methodname", method);
            parentMap.put("key", "homepagetabap");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("pageId", pageId);
            params.put("appId", appId);
            Object caption2 = config.get("caption");
            if (OperationStatus.ADDNEW.equals((Object)this.getStatus()) && caption2 != null) {
                if (caption2 instanceof LocaleString) {
                    params.put("tabName", ((LocaleString)caption2).toString());
                } else if (caption2 instanceof Map) {
                    params.put("tabName", LocaleString.fromMap((Map)((Map)caption2)).toString());
                }
            } else {
                params.put("tabName", "");
            }
            ArrayList<HashMap<String, String>> argList = new ArrayList<HashMap<String, String>>();
            argList.add(params);
            parentMap.put("args", argList);
            ((IClientViewProxy)mainView.getService(IClientViewProxy.class)).addAction("InvokeControlMethod", parentMap);
            this.sendFormAction(mainView);
        }
        if (param != null && param.getCustomParam("originShowType") != null) {
            config.put("originShowType", param.getCustomParam("originShowType"));
        }
        if (param.getOpenStyle().getClientShowType().equals((Object)ShowType.NewWindow) || param.getOpenStyle().getClientShowType().equals((Object)ShowType.IFrame)) {
            PageCache pageCache = new PageCache(param.getPageId());
            pageCache.put("formconfig", SerializationUtils.toJsonString(config));
            if (param.getOpenStyle().getClientShowType().equals((Object)ShowType.NewWindow)) {
                ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("openWindow", config);
            } else {
                ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("showForm", config);
            }
        } else if (param.getOpenStyle().getClientShowType().equals((Object)ShowType.NewBrowserPage)) {
            StringBuilder sb = new StringBuilder();
            sb.append("?formId=").append(param.getFormId());
            if (param instanceof BillShowParameter) {
                BillShowParameter billParam = (BillShowParameter)param;
                if (!ObjectUtils.isEmpty((Object)billParam.getPkId())) {
                    sb.append("&pkId=").append(billParam.getPkId());
                }
            } else if (param instanceof ListShowParameter) {
                ListShowParameter listShowParameter = (ListShowParameter)param;
                sb.append("&type=list").append("&billFormId=").append(listShowParameter.getBillFormId());
            }
            this.openUrl(sb.toString());
        } else if (param.getOpenStyle().getClientShowType().equals((Object)ShowType.ReplaceHomePage)) {
            config.putAll(FormConfigFactory.createRootPageConfigInfo());
            ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("showForm", config);
        } else {
            ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("showForm", config);
        }
        if (param.getOpenStyle().getClientShowType().equals((Object)ShowType.InCurrentForm) && (caption = config.get("caption")) instanceof LocaleString) {
            this.setFormTitle((LocaleString)caption);
        }
    }

    @KSMethod
    public void close() {
        if (this.getFormShowParameter().isRuntimeMetaChanged()) {
            this.onClose();
            return;
        }
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"FormView.close");){
            BeforeClosedEvent e = new BeforeClosedEvent((Object)this);
            this.getPluginProxy().fireBeforeClosed(e);
            if (e.isCancel()) {
                return;
            }
            this.onClose();
        }
    }

    protected void onClose() {
        this.closeClientForm();
    }

    private void closeClientForm() {
        IFormView mainview;
        FormShowParameter param = this.getFormShowParameter();
        if (param.getOpenStyle().getShowType().equals((Object)ShowType.NewTabPage) && (mainview = this.getMainView()) != null && param.getOpenStyle().getShowType() != ShowType.Modal) {
            Control c;
            IFormView parentView = SessionManager.getCurrent().getViewNoPlugin(this.formShowParameter.getParentPageId());
            Control control = c = parentView == null ? null : parentView.getControl(SUB_MAIN_TAB);
            if (c instanceof Tab) {
                param.getOpenStyle().setTargetKey(SUB_MAIN_TAB);
                mainview = parentView;
            } else if (c == null) {
                IPageCache pageCache = (IPageCache)mainview.getService(IPageCache.class);
                String _submaintab_count_ = pageCache.get(SUBMAINTAB_COUNT);
                int count = _submaintab_count_ == null ? 3 : Integer.parseInt(_submaintab_count_);
                pageCache.put(SUBMAINTAB_COUNT, --count + "");
            }
        }
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put("pageId", this.getPageId());
        if (this.getPageId().startsWith("root")) {
            if (this.getPageId().equals(param.getRootPageId())) {
                ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("closeBrowserPage", arg);
            } else {
                ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            }
        } else {
            ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("closeWindow", arg);
        }
        FormShowParameter parentViewParameter = SessionManager.getCurrent().getFormShowParameter(this.formShowParameter.getParentPageId());
        CloseCallBackWraper closeCallBackWraper = this.getCloseCallBackWraper();
        if (this.interceptCtsyReturnToParentData(closeCallBackWraper)) {
            return;
        }
        if (parentViewParameter != null && closeCallBackWraper != null) {
            SessionManager.getCurrent().commitCache();
            List acts = (List)DispatchServiceHelper.invokeBOSService((String)parentViewParameter.getServiceAppId(), (String)"FormService", (String)"closeCallBack", (Object[])new Object[]{closeCallBackWraper});
            this.sendFormAction(closeCallBackWraper.getPageId(), acts);
        }
    }

    protected CloseCallBackWraper getCloseCallBackWraper() {
        CloseCallBack closeCallBack = this.formShowParameter.getCloseCallBack();
        if (closeCallBack == null) {
            return null;
        }
        CloseCallBackWraper closeCallBackWraper = new CloseCallBackWraper(this.formShowParameter.getParentPageId(), closeCallBack, null, false);
        closeCallBackWraper.setReturnData(this.returnToParentData);
        return closeCallBackWraper;
    }

    @KSMethod
    public IFormView getView(String pageId) {
        IFormView view = null;
        if (this.mapFormViews != null) {
            view = this.mapFormViews.get(pageId);
            if (view != null) {
                return view;
            }
        } else {
            this.mapFormViews = new HashMap<String, IFormView>();
        }
        try {
            view = SessionManager.getCurrent().getView(pageId);
        }
        catch (KDException e) {
            IFormView newView;
            if (e.getErrorCode().getCode().equals("bos.grayMetaNotFound")) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7a97\u4f53%1$s\u4e2d\u83b7\u53d6view\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"FormView_3", (String)BOS_FORM_MVC, (Object[])new Object[]{this.getFormId(), e.getMessage()});
                log.error(msg, (Throwable)e);
                ErrorCode errorCode = new ErrorCode(e.getErrorCode().getCode(), msg + "\uff1a" + e.getMessage());
                throw new KDException(errorCode, e.getMessage(), (Throwable)e);
            }
            if (e.getErrorCode().getCode().equals("bos.createPluginError") && (newView = this.getViewNoPlugin(pageId)) != null) {
                String appId = this.formShowParameter.getServiceAppId();
                String newAppId = newView.getFormShowParameter().getServiceAppId();
                if (StringUtils.isNotBlank((CharSequence)appId) && !appId.equals(newAppId)) {
                    String msg = ResManager.loadKDString((String)"\u8de8\u670d\u52a1\u5668\u8282\u70b9\u5b9e\u4f8b\u5316\u63d2\u4ef6\u5931\u8d25\uff0c\u8bf7\u4f7f\u7528\u65b9\u6cd5getViewNoPlugin\u6765\u83b7\u53d6view", (String)"FormView_6", (String)BOS_FORM_MVC, (Object[])new Object[0]);
                    log.error(msg, (Throwable)e);
                    ErrorCode errorCode = new ErrorCode(e.getErrorCode().getCode(), msg + "\uff1a" + e.getMessage());
                    throw new KDException(errorCode, e.getMessage(), (Throwable)e);
                }
            }
            throw e;
        }
        if (view != null) {
            if (this.getPageId().equals(view.getFormShowParameter().getParentPageId())) {
                ((FormView)view).setParentView((IFormView)this);
            }
            this.mapFormViews.put(pageId, view);
        }
        return view;
    }

    @KSMethod
    public IFormView getViewNoPlugin(String pageId) {
        IFormView view = null;
        try {
            view = SessionManager.getCurrent().getViewNoPlugin(pageId);
        }
        catch (KDException e) {
            if (e.getErrorCode().getCode().equals("bos.grayMetaNotFound")) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7a97\u4f53%1$s\u4e2d\u83b7\u53d6view\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"FormView_3", (String)BOS_FORM_MVC, (Object[])new Object[]{this.getFormId(), e.getMessage()});
                this.showErrorNotification(msg);
                log.error(msg, (Throwable)e);
                return null;
            }
            throw e;
        }
        if (view != null && this.getPageId().equals(view.getFormShowParameter().getParentPageId())) {
            ((FormView)view).setParentView((IFormView)this);
        }
        return view;
    }

    public boolean existView(String pageId) {
        if (this.rootPageChilds != null) {
            return this.rootPageChilds.contains(pageId);
        }
        return SessionManager.getCurrent().existView(pageId);
    }

    protected void setParentView(IFormView formView) {
        this.parentView = formView;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "-" + this.getFormShowParameter().getFormId() + "-" + this.getFormShowParameter().getPageId();
    }

    public IDataModel createFlexModel(IDataModel flexModel, MainEntityType met) {
        if (flexModel == null) {
            flexModel = new FlexModel(met);
        } else {
            ((FlexModel)((Object)flexModel)).updateCache();
            ((FlexModel)((Object)flexModel)).setEntityType(met);
        }
        ((FlexModel)((Object)flexModel)).setPageId(this.getPageId());
        ((FlexModel)((Object)flexModel)).setServices(this.services);
        ((FlexModel)((Object)flexModel)).addDataModelChangeListener(new DataModelChangeListener((IFormView)this));
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getService(FormViewPluginProxy.class);
        for (IFormPlugin plugin : pluginProxy.getPlugIns()) {
            ((FlexModel)((Object)flexModel)).addDataModelChangeListener((IDataModelChangeListener)plugin);
        }
        return flexModel;
    }

    public void showUpload(UploadOption option, String callbackButtonKey) {
        IClientViewProxy proxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageId", this.getPageId());
        params.put("key", callbackButtonKey);
        if (option != null) {
            params.put("multiple", option.isMultiple());
            params.put("title", option.getTitle());
            params.put("suffix", option.getSuffix());
            if (option.getLimitSize() <= 0L) {
                params.put("limitSize", Integer.MAX_VALUE);
            } else {
                params.put("limitSize", option.getLimitSize());
            }
            if (option.getLimitCount() > 0) {
                params.put("limitCount", option.getLimitCount());
            }
            if (option.getUrl() != null) {
                params.put("url", option.getUrl());
            }
        }
        proxy.addAction("getCustomerFile", params);
    }

    public void setIgnorePlugin(boolean value) {
        this.ignorePlugin = value;
    }

    public void setReleasing(boolean releasing) {
        this.releasing = releasing;
    }

    public boolean isDestory() {
        return this.isDestoryFlag;
    }

    public void setDestory(boolean isDestoryFlag) {
        this.isDestoryFlag = isDestoryFlag;
    }

    public void sendWebSocketAction(String actionName, Object param, List<String> userIds) {
        PushServiceHelper.sendWebSocketAction((String)actionName, (Object)param, userIds);
    }

    private void convertFormDefaultLayout(FormShowParameter parameter) {
        if (!(parameter instanceof BillShowParameter) && !(parameter instanceof ListShowParameter) || parameter instanceof ICtsyShowParameter) {
            return;
        }
        String formID = parameter.getFormId();
        if (parameter instanceof ListShowParameter) {
            formID = ((ListShowParameter)parameter).getBillFormId();
        }
        if (parameter instanceof MobileBillShowParameter) {
            if (!formID.endsWith("_mob")) {
                return;
            }
            FormConfig mobileConfig = FormMetadataCache.getFormConfig((String)formID);
            formID = mobileConfig.getEntityTypeId();
        }
        if (formID == null) {
            return;
        }
        FormConfig config = FormMetadataCache.getFormConfig((String)formID);
        if (!formID.equals(config.getEntityTypeId())) {
            return;
        }
        if (!("bill".equals(config.getModelType()) || "base".equals(config.getModelType()) || "mobilebill".equals(config.getModelType()) || "mobileform".equals(config.getModelType()))) {
            return;
        }
        BillEntityType entityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)formID);
        if (StringUtils.isNotEmpty((CharSequence)entityType.getDefaultPageSetting())) {
            String layoutId;
            Map map = (Map)SerializationUtils.fromJsonString((String)entityType.getDefaultPageSetting(), Map.class);
            parameter.setCustomParam("DefaultLayout", (Object)true);
            if (parameter instanceof BillShowParameter) {
                String billKey = "pcbill";
                if (parameter instanceof MobileBillShowParameter) {
                    billKey = "mbbill";
                }
                if (!"".equals(layoutId = (String)map.get(billKey))) {
                    parameter.setFormId(layoutId);
                }
            }
            if (parameter instanceof ListShowParameter) {
                String listKey = "pclist";
                if (parameter instanceof MobileListShowParameter) {
                    listKey = "mblist";
                }
                if (!"".equals(layoutId = (String)map.get(listKey))) {
                    ((ListShowParameter)parameter).setBillFormId(layoutId);
                }
            }
        }
    }

    private void hideUnauthorizedControls() {
        Map<String, Boolean> perItemMap = this.getAllPerItems();
        if (perItemMap == null || perItemMap.isEmpty()) {
            return;
        }
        ArrayList<String> perItems = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : perItemMap.entrySet()) {
            Boolean hasRight = entry.getValue();
            if (hasRight == null || hasRight.booleanValue()) continue;
            perItems.add(entry.getKey());
        }
        if (!perItems.isEmpty()) {
            this.setPermission(false, perItems);
        }
    }

    private void lockUnauthorizedControls() {
        if (this instanceof ListView || this instanceof ReportView) {
            return;
        }
        try (EntityTraceSpan span = EntityTracer.create((String)"FormView", (String)"setPermission2Front");){
            ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
            String appId = this.getFormShowParameter().getAppId();
            Long userId = RequestContext.get().getCurrUserId();
            String formNum = this.getEntityId();
            HashMap customParams = new HashMap();
            customParams.putAll(this.getFormShowParameter().getCustomParams());
            span.addTag("userId", String.valueOf(userId));
            span.addTag("appId", appId);
            span.addTag("formId", formNum);
            Set mulBaseKeys = permissionService.getMulBdPropKeysByHasSetDataRule(userId.longValue(), appId, formNum, customParams);
            span.addLocaleTag("result", (Object)mulBaseKeys);
            if (mulBaseKeys != null && !mulBaseKeys.isEmpty()) {
                IClientViewProxy proxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
                HashMap<String, Object> configMap = new HashMap<String, Object>();
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formNum);
                HashSet<String> entryFields = new HashSet<String>();
                HashSet<String> mainFields = new HashSet<String>();
                for (String fieldKey : mulBaseKeys) {
                    IDataEntityProperty property = mainEntityType.findProperty(fieldKey);
                    if (property.getParent() instanceof EntryType) {
                        entryFields.add(fieldKey);
                        continue;
                    }
                    mainFields.add(fieldKey);
                }
                this.lockMulBaseKeys(1, configMap, mainFields);
                this.lockMulBaseKeys(2, configMap, entryFields);
                HashMap<String, Object> paraMap = new HashMap<String, Object>();
                paraMap.put("config", configMap);
                paraMap.put("pageId", this.getPageId());
                proxy.addAction("setPageConfig", paraMap);
            }
        }
    }

    private void lockMulBaseKeys(int type, Map<String, Object> configMap, Set<String> mulBaseKeys) {
        if (mulBaseKeys.isEmpty()) {
            return;
        }
        HashMap<String, Set<String>> mulbasedataMap = new HashMap<String, Set<String>>();
        mulbasedataMap.put("unauthorizedList", mulBaseKeys);
        HashMap<String, HashMap<String, Set<String>>> fieldConMap = new HashMap<String, HashMap<String, Set<String>>>();
        fieldConMap.put("mulbasedata", mulbasedataMap);
        if (type == 1) {
            configMap.put("fieldcon", fieldConMap);
        } else {
            configMap.put("grid", fieldConMap);
        }
    }

    private void setPermission(Boolean value, List<String> perItems) {
        HashMap<String, Object> permissionMap = new HashMap<String, Object>();
        permissionMap.put("perValue", value);
        permissionMap.put("perItems", perItems.toArray());
        this.getClientProxy().addAction("setPermission", permissionMap);
    }

    private Map<String, Boolean> getAllPerItems() {
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String formNum = this.getEntityId();
        if (this instanceof ListView) {
            formNum = ((ListView)this).getBillFormId();
        }
        String appId = this.getFormShowParameter().getCheckRightAppId();
        Object customParam = this.getFormShowParameter().getCustomParam(PERM_IGNORE_CHECKAPP);
        if (StringUtils.isBlank((CharSequence)appId) || Boolean.TRUE.equals((Boolean)customParam)) {
            appId = "";
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (service == null) {
            return new HashMap<String, Boolean>();
        }
        return service.getHasPermItems(Long.valueOf(userId), appId, formNum);
    }

    private Map<String, Object> getCtsyFormConfig(FormShowParameter param) {
        Map config = param.createClientConfig(new HashMap(0));
        IPageCache cache = SessionManager.getCurrent().getPageCache(param.getPageId());
        RootPageCache.addPageId(param.getRootPageId(), param.getPageId());
        param.setCacheExpireTime(System.currentTimeMillis());
        cache.put(FormShowParameter.class.getSimpleName(), param.toString());
        cache.saveChanges();
        return config;
    }

    private boolean interceptCtsyReturnToParentData(CloseCallBackWraper closeCallBackWraper) {
        int actionIdLength;
        String[] actionIds;
        CloseCallBack closeCallBack;
        if (closeCallBackWraper != null && !(this.getFormShowParameter() instanceof ICtsyShowParameter) && (closeCallBack = closeCallBackWraper.getCloseCallBack()) != null && StringUtils.isNotEmpty((CharSequence)closeCallBack.getActionId()) && "CtsyList".equals((actionIds = closeCallBack.getActionId().split("\\$"))[(actionIdLength = actionIds.length) - 1]) && actionIdLength >= 4) {
            SessionManager.getCurrent().commitCache();
            if (this.returnToParentData != null) {
                HashMap<String, String> arg = new HashMap<String, String>(3);
                arg.put("pageId", closeCallBackWraper.getPageId());
                arg.put("ctsyReturnToParentData", SerializationUtils.toJsonString((Object)this.returnToParentData));
                arg.put("ctsyReturnToParentDataClassName", this.returnToParentData.getClass().getName());
                this.getClientProxy().addAction("ctsyReturnToParentData", arg);
            }
            return true;
        }
        return false;
    }

    private boolean isShowCancelMessage(Map<String, Object> config) {
        if (config.get("cancel") != null) {
            String msg;
            if (config.get("cancelFormShowParameter") instanceof String && StringUtils.isNotEmpty((CharSequence)((String)config.get("cancelFormShowParameter")))) {
                String cancelFormShowParameter = (String)config.get("cancelFormShowParameter");
                this.showForm(FormShowParameter.fromJsonString((String)cancelFormShowParameter));
                return true;
            }
            String string = msg = config.get("cancelMessage") == null ? "" : (String)config.get("cancelMessage");
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.showErrorNotification(msg);
            }
            return true;
        }
        return false;
    }
}

