/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MobLocation;
import kd.bos.form.field.CityORMUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class MobLocationProvider {
    private static final Log log = LogFactory.getLog(MobLocationProvider.class);
    private static String mobLocationKey = "moblocation";

    private MobLocationProvider() {
    }

    private static String getCityId(String city) {
        QFilter[] qfs = new QFilter[]{new QFilter("name", "=", (Object)city), new QFilter("enable", "=", (Object)"1"), new QFilter("iscity", "=", (Object)"1")};
        DynamicObjectCollection cities = CityORMUtil.getCityLists((QFilter[])qfs);
        if (cities.isEmpty()) {
            log.info(String.format("mobileformview - > setLocation : fullcity %s not find", city));
        } else {
            for (DynamicObject dynamicObject : cities) {
                String simplespell = dynamicObject.get("simplespell").toString();
                if (simplespell == null) continue;
                String currentCityId = dynamicObject.getPkValue().toString();
                log.info(String.format("mobileformview - > setLocation : cityId = %s ", currentCityId));
                return currentCityId;
            }
        }
        String newCity = city;
        if (city.endsWith(ResManager.loadKDString((String)"\u5e02", (String)"MobLocationProvider_0", (String)"bos-form-mvc", (Object[])new Object[0]))) {
            newCity = city.substring(0, city.length() - 1);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("name", "=", (Object)newCity), new QFilter("enable", "=", (Object)"1"), new QFilter("iscity", "=", (Object)"1")};
        cities = CityORMUtil.getCityLists((QFilter[])qFilters);
        if (cities.isEmpty()) {
            log.info(String.format("mobileformview - > setLocation : city %s not find", newCity));
            return null;
        }
        for (DynamicObject dynamicObject : cities) {
            String simplespell = dynamicObject.get("simplespell").toString();
            if (simplespell == null) continue;
            String currentCityId = dynamicObject.getPkValue().toString();
            log.info(String.format("mobileformview - > setLocation : cityId = %s ", currentCityId));
            return currentCityId;
        }
        return null;
    }

    public static void setLocation(Map<String, String> list) {
        log.info(String.format("mobileformview - > setLocation , params = %s", SerializationUtils.toJsonString(list)));
        MobLocation mobLocation = MobLocationProvider.getMobLocation();
        String city = list.get("city");
        if (StringUtils.isBlank((CharSequence)city)) {
            log.info(String.format("mobileformview - > setLocation : city is empty, params -> %s", SerializationUtils.toJsonString(list)));
            return;
        }
        if (mobLocation != null && StringUtils.isNotBlank((CharSequence)mobLocation.getCityId()) && city.equalsIgnoreCase(mobLocation.getCity())) {
            list.put("cityId", mobLocation.getCityId());
        } else {
            String newCityId = MobLocationProvider.getCityId(city);
            if (StringUtils.isNotBlank((CharSequence)newCityId)) {
                list.put("cityId", newCityId);
            } else {
                return;
            }
        }
        UserConfigServiceHelper.setSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)mobLocationKey, (String)SerializationUtils.toJsonString(list));
    }

    public static MobLocation getMobLocation() {
        String setting = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)mobLocationKey);
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            return (MobLocation)SerializationUtils.fromJsonString((String)setting, MobLocation.class);
        }
        return null;
    }

    public static long getCurrentCityId() {
        MobLocation mobLocation = MobLocationProvider.getMobLocation();
        if (mobLocation != null && StringUtils.isNotBlank((CharSequence)mobLocation.getCityId())) {
            Long cityId = Long.parseLong(mobLocation.getCityId());
            DynamicObject cityDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_admindivision", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cityId), new QFilter("enable", "=", (Object)"1"), new QFilter("iscity", "=", (Object)"1")});
            if (cityDy != null) {
                return cityId;
            }
            UserConfigServiceHelper.clearSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)mobLocationKey);
        }
        return 0L;
    }
}

