/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.privacy.IPrivacyDataPermissionService;
import kd.bos.db.privacy.IPrivacyEncryptService;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.IPrivacyService;
import kd.bos.lang.Lang;
import kd.bos.privacy.DesensitizeField;

public class PrivacyService
implements IPrivacyService {
    private Map<String, String> desensitizeFieldMap;
    private IFormView view;
    private static final String DESENSITIZE_FIELD = "desensitizeField";

    public PrivacyService(IFormView view) {
        this.view = view;
        this.innerLoadDesensitizeFieldMap(view);
    }

    private void innerLoadDesensitizeFieldMap(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String state = pageCache.get(DESENSITIZE_FIELD);
        this.desensitizeFieldMap = state != null ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)state, Map.class) : new HashMap<String, String>();
    }

    public void setDesensitizeField(String fieldfKey, DesensitizeField desensitizeField) {
        boolean isDesen;
        if (desensitizeField == null) {
            return;
        }
        String entityNumber = desensitizeField.getEntityNumber();
        String propName = desensitizeField.getPropName();
        if (entityNumber == null || propName == null) {
            return;
        }
        String localeId = desensitizeField.getLocalId() != null ? desensitizeField.getLocalId() : Lang.get().toString();
        String operateType = desensitizeField.getOperateType() != null ? desensitizeField.getOperateType() : "FORM";
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        IDataEntityProperty desenProp = mainEntityType.findProperty(propName);
        IPrivacyEncryptService service = PrivacyDataCenterManager.getEncryptService();
        if ((PrivacyDataCenterManager.isEnable() || desenProp != null) && (isDesen = desenProp instanceof TextProp && ((TextProp)desenProp).isPassword() ? false : ("FORM".equals(operateType) && desenProp instanceof ILocaleProperty ? service.isDesensitizeField(entityNumber, propName) : service.isDesensitizeField(entityNumber, propName, localeId, (Object)desensitizeField.getDynamicObject())))) {
            IPrivacyDataPermissionService permissionService = PrivacyDataCenterManager.getPermissionService();
            String strategy = permissionService.getDesensitizeStrategy(entityNumber, propName, operateType, (Object)desensitizeField.getDynamicObject());
            if ("PLAINTEXT".equals(strategy)) {
                isDesen = false;
            }
            if (isDesen) {
                this.desensitizeFieldMap.put(fieldfKey, entityNumber);
                IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
                pageCache.put(DESENSITIZE_FIELD, SerializationUtils.toJsonString(this.desensitizeFieldMap));
            }
        }
    }

    public IDataEntityProperty getDesenProp(String fieldKey) {
        if (this.view == null || this.desensitizeFieldMap == null) {
            return null;
        }
        IDataEntityProperty desenProp = null;
        String entityNumber = this.desensitizeFieldMap.get(fieldKey);
        if (entityNumber != null) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            desenProp = mainEntityType.findProperty(fieldKey);
        }
        return desenProp;
    }
}

