/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IUpdateView;
import kd.bos.form.BinderMap;
import kd.bos.form.BindingContext;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;

public class UpdateViewService
implements IUpdateView {
    private boolean hasBinderMap;
    private BinderMap binderMap;
    private IFormView view;

    public UpdateViewService(IFormView view) {
        this.view = view;
        this.setHasBinderMap(view.getFormShowParameter().getFormConfig().isHasBinderMap());
    }

    public boolean isHasBinderMap() {
        return this.hasBinderMap;
    }

    private void setHasBinderMap(boolean hasBinderMap) {
        this.hasBinderMap = hasBinderMap;
    }

    public void updateView(IDataEntityProperty property, DynamicObject dataEntity, int rowIndex, int parentRowIndex) {
        List<FieldEdit> edits = this.getFieldEdits(property.getName());
        if (edits.size() > 0) {
            this.bindEditData(null, dataEntity, rowIndex, parentRowIndex, edits);
            this.updateChildren(property.getName(), dataEntity, rowIndex, parentRowIndex);
        }
    }

    private void bindEditData(String parentPropName, DynamicObject dataEntity, int rowIndex, int parentRowIndex, List<FieldEdit> edits) {
        for (FieldEdit edit : edits) {
            if (edit.getProperty().getParent() instanceof SubEntryType) {
                IDataEntityType subEntryType = edit.getProperty().getParent();
                int parentCurrRow = this.view.getModel().getEntryCurrentRowIndex(subEntryType.getParent().getName());
                if (parentPropName != null && subEntryType.getProperties().get((Object)parentPropName) == null) {
                    parentRowIndex = rowIndex;
                    rowIndex = -1;
                }
                if (parentCurrRow != parentRowIndex) continue;
                this.bindEntryFields(subEntryType, edit, rowIndex);
                continue;
            }
            if (edit.getProperty().getParent() instanceof EntryType) {
                IDataEntityType entryType = edit.getProperty().getParent();
                this.bindEntryFields(entryType, edit, rowIndex);
                continue;
            }
            edit.bindData(new BindingContext((Object)dataEntity, rowIndex));
        }
    }

    private void bindEntryFields(IDataEntityType entryType, FieldEdit edit, int rowIndex) {
        if (rowIndex == -1) {
            DynamicObjectCollection rows = this.view.getModel().getEntryEntity(entryType.getName());
            int i = 0;
            for (DynamicObject row : rows) {
                edit.bindData(new BindingContext((Object)row, i++));
            }
        } else {
            BindingContext bindingContext = new BindingContext((Object)this.view.getModel().getEntryRowEntity(entryType.getName(), rowIndex), rowIndex);
            edit.bindData(bindingContext);
        }
    }

    private <T extends Control> List<T> getChildEdits(String propertyName) {
        List sf;
        if (this.isHasBinderMap() && this.binderMap == null) {
            this.binderMap = (BinderMap)FormMetadataCache.getControl((String)this.view.getFormShowParameter().getFormId(), (String)"_bindermap_");
        }
        ArrayList<Control> fes = new ArrayList<Control>();
        if (this.binderMap != null && (sf = (List)this.binderMap.getMap().get(propertyName.toLowerCase() + ".child")) != null) {
            for (String key : sf) {
                if (this.view.getControl(key) == null) continue;
                fes.add(this.view.getControl(key));
            }
        }
        return fes;
    }

    private void updateChildren(String propertyName, DynamicObject dataEntity, int rowIndex, int parentRowIndex) {
        List<FieldEdit> edits = this.getChildEdits(propertyName);
        if (edits.isEmpty()) {
            return;
        }
        this.bindEditData(propertyName, dataEntity, rowIndex, parentRowIndex, edits);
    }

    private List<FieldEdit> getFieldEdits(String propertyName) {
        List sf;
        if (this.isHasBinderMap() && this.binderMap == null) {
            this.binderMap = (BinderMap)FormMetadataCache.getControl((String)this.view.getFormShowParameter().getFormId(), (String)"_bindermap_");
        }
        ArrayList<FieldEdit> fes = new ArrayList<FieldEdit>();
        Control ctl = this.view.getControl(propertyName);
        if (ctl instanceof FieldEdit && StringUtils.equalsIgnoreCase((CharSequence)((FieldEdit)ctl).getFieldKey(), (CharSequence)propertyName)) {
            fes.add((FieldEdit)ctl);
        }
        if (this.binderMap != null && (sf = (List)this.binderMap.getMap().get(propertyName.toLowerCase())) != null) {
            for (String key : sf) {
                ctl = this.view.getControl(key);
                if (!(ctl instanceof FieldEdit)) continue;
                fes.add((FieldEdit)ctl);
            }
        }
        return fes;
    }
}

