/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.mvc.list.DispatchResult;
import kd.bos.mvc.list.JobContext;
import kd.bos.mvc.list.ListAsyncQueryContext;
import kd.bos.mvc.list.ListDispatcherContext;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.server.JobDispatcherProxy;

abstract class AbstractDispatcher {
    private ListDispatcherContext listDispatcherContext;
    private ListAsyncQueryContext listAsyncQueryContext;
    private JobInfo job;

    abstract String getTaskClassName();

    abstract String getJobName();

    AbstractDispatcher(ListDispatcherContext listDispatcherContext) {
        this.listDispatcherContext = listDispatcherContext;
        this.listAsyncQueryContext = new ListAsyncQueryContext(listDispatcherContext.getPageId());
    }

    ListDispatcherContext getListDispatcherContext() {
        return this.listDispatcherContext;
    }

    ListAsyncQueryContext getListAsyncQueryContext() {
        return this.listAsyncQueryContext;
    }

    abstract List<DispatchResult> dispatch();

    void assembleSumQueryBuilder(QueryBuilder sumQueryBuilder, JobContext jobContext) {
    }

    String getJobPostName(JobContext jobContext) {
        return "";
    }

    String createJob(JobContext jobContext) {
        this.job = new JobInfo();
        String taskId = String.valueOf(DB.genGlobalLongId());
        this.job.setTaskId(taskId);
        this.job.setJobType(JobType.REALTIME);
        String jobName = this.getJobName() + this.listDispatcherContext.getEntityName();
        String jobPostName = this.getJobPostName(jobContext);
        if (StringUtils.isNotBlank((CharSequence)jobPostName)) {
            jobName = jobName + "_" + jobPostName;
        }
        this.job.setName(jobName);
        this.job.setTaskClassname(this.getTaskClassName());
        this.job.setRunByUserId(RequestContext.get().getCurrUserId());
        this.job.setRunByOrgId(RequestContext.get().getOrgId());
        this.job.setAppId(this.listDispatcherContext.getAppId());
        QueryBuilder sumQueryBuilder = this.createSumQueryBuilder();
        this.assembleSumQueryBuilder(sumQueryBuilder, jobContext);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("rootPageId", this.listDispatcherContext.getRootPageId());
        params.put("pageId", this.listDispatcherContext.getPageId());
        params.put("controlKey", PageRowCacheUtils.getControlKey());
        params.put("appId", this.listDispatcherContext.getAppId());
        params.put("mainOrgId", this.listDispatcherContext.getMainOrgId() == null ? "" : this.listDispatcherContext.getMainOrgId().toString());
        this.job.setParams(params);
        this.listAsyncQueryContext.cacheQueryBuilder(taskId, sumQueryBuilder);
        this.listAsyncQueryContext.cacheEntityType(taskId, this.listDispatcherContext.getEntityType());
        this.listAsyncQueryContext.cacheQFilters(taskId, this.listDispatcherContext.getFilters());
        return taskId;
    }

    void dispatchJob() {
        this.job.setTenantId(RequestContext.get().getTenantId());
        if (StringUtils.isBlank((CharSequence)this.job.getId())) {
            long jobId = DB.genLongId((String)"T_SCH_JOB");
            this.job.setId(String.valueOf(jobId));
        }
        JobDispatcherProxy jobDispatcher = new JobDispatcherProxy();
        jobDispatcher.dispatch(this.job);
    }

    private QueryBuilder createSumQueryBuilder() {
        QueryBuilder sumQueryBuilder = new QueryBuilder();
        sumQueryBuilder.setEntityName(this.listDispatcherContext.getEntityName());
        sumQueryBuilder.setTimeOutSecends(this.listDispatcherContext.getTimeOutSecends());
        return sumQueryBuilder;
    }
}

