/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.list.GroupByField;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.mvc.list.AbstractDispatcher;
import kd.bos.mvc.list.DispatchResult;
import kd.bos.mvc.list.GroupByDispatchResult;
import kd.bos.mvc.list.GroupByDispatcherContext;
import kd.bos.mvc.list.GroupByJobContext;
import kd.bos.mvc.list.JobContext;
import kd.bos.mvc.list.SumFieldsGrouper;

class GroupByDispatcher
extends AbstractDispatcher {
    GroupByDispatcher(GroupByDispatcherContext groupByDispatcherContext) {
        super(groupByDispatcherContext);
    }

    @Override
    String getTaskClassName() {
        return "kd.bos.mvc.list.SumGroupTask";
    }

    @Override
    String getJobName() {
        return "ListGroupBySumAmount";
    }

    @Override
    void assembleSumQueryBuilder(QueryBuilder sumQueryBuilder, JobContext jobContext) {
        super.assembleSumQueryBuilder(sumQueryBuilder, jobContext);
        GroupByField groupByField = ((GroupByJobContext)jobContext).getGroupByField();
        sumQueryBuilder.setGroupBySumFields(groupByField.getSums());
        sumQueryBuilder.setGroupBy(this.convertToORMName(groupByField.getGroupBy()));
    }

    private String convertToORMName(String groupBy) {
        FilterField filterField = FilterField.create((MainEntityType)this.getListDispatcherContext().getEntityType(), (String)groupBy);
        if (filterField != null) {
            return filterField.getFullFieldName();
        }
        return groupBy;
    }

    @Override
    List<DispatchResult> dispatch() {
        List<GroupByField> groupByFields = new SumFieldsGrouper(this.getListDispatcherContext().getEntityType(), ((GroupByDispatcherContext)this.getListDispatcherContext()).getSumFields()).groupBy();
        ArrayList<DispatchResult> dispatchResults = new ArrayList<DispatchResult>(groupByFields.size());
        for (GroupByField groupByField : groupByFields) {
            if (groupByField.getGroupBy() == null) continue;
            String taskId = this.createJob(new GroupByJobContext(this.getListAsyncQueryContext(), groupByField));
            dispatchResults.add(new GroupByDispatchResult(taskId, groupByField));
            this.getListAsyncQueryContext().cacheGroupByTask(PageRowCacheUtils.getControlKey(), this.convertToORMName(groupByField.getGroupBy()), taskId);
            this.dispatchJob();
        }
        return dispatchResults;
    }

    @Override
    String getJobPostName(JobContext jobContext) {
        return ((GroupByJobContext)jobContext).getGroupByField().getGroupBy();
    }
}

