/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.orm.query.QFilter;

class ListAsyncQueryContext {
    private String pageId;
    private static DistributeSessionlessCache pageCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ListAsyncQueryContext", new DistributeCacheHAPolicy(true, true));
    private QueryBuilder queryBuilder;
    private MainEntityType mainEntityType;

    ListAsyncQueryContext(String pageId) {
        this.pageId = pageId;
    }

    private String getQueryBuilderKey(String key) {
        return String.format("%s.%s.%s", RequestContext.get().getAccountId(), key, "laq_qb");
    }

    void cacheQueryBuilder(String key, QueryBuilder queryBuilder) {
        String qbStr = SerializationUtils.serializeToBase64((Object)queryBuilder);
        pageCache.put(this.getQueryBuilderKey(key), (Object)qbStr);
        this.queryBuilder = queryBuilder;
    }

    QueryBuilder getQueryBuilder(String key) {
        if (this.queryBuilder != null) {
            return this.queryBuilder;
        }
        String qbStr = (String)pageCache.get(this.getQueryBuilderKey(key));
        if (StringUtils.isNotBlank((CharSequence)qbStr)) {
            this.queryBuilder = (QueryBuilder)SerializationUtils.deSerializeFromBase64((String)qbStr);
        }
        return this.queryBuilder;
    }

    private String getEntityTypeKey(String key) {
        return String.format("%s.%s.%s", RequestContext.get().getAccountId(), key, "laq_ey");
    }

    void cacheEntityType(String key, MainEntityType mainEntityType) {
        String entityTypeStr = SerializationUtils.serializeToBase64((Object)mainEntityType);
        pageCache.put(this.getEntityTypeKey(key), (Object)entityTypeStr);
        this.mainEntityType = mainEntityType;
    }

    MainEntityType getEntityType(String key) {
        if (this.mainEntityType != null) {
            return this.mainEntityType;
        }
        String entityTypeStr = (String)pageCache.get(this.getEntityTypeKey(key));
        if (StringUtils.isNotBlank((CharSequence)entityTypeStr)) {
            this.mainEntityType = (MainEntityType)SerializationUtils.deSerializeFromBase64((String)entityTypeStr);
        }
        return this.mainEntityType;
    }

    private String getQFiltersKey(String key) {
        return String.format("%s.%s.%s", RequestContext.get().getAccountId(), key, "lsq_qf");
    }

    void cacheQFilters(String key, QFilter[] qFilters) {
        ArrayList<String> qfiltersStrList = new ArrayList<String>(qFilters.length);
        for (QFilter filter : qFilters) {
            qfiltersStrList.add(filter.toSerializedString());
        }
        pageCache.put(this.getQFiltersKey(key), (Object)SerializationUtils.toJsonString(qfiltersStrList));
    }

    QFilter[] getQFilters(String key) {
        String qfiltersStr = (String)pageCache.get(this.getQFiltersKey(key));
        if (StringUtils.isNotBlank((CharSequence)qfiltersStr)) {
            List qfiltersStrList = SerializationUtils.fromJsonStringToList((String)qfiltersStr, String.class);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(qfiltersStrList.size());
            for (String qfilters : qfiltersStrList) {
                if (!StringUtils.isNotBlank((CharSequence)qfilters)) continue;
                qFilters.add(QFilter.fromSerializedString((String)qfilters));
            }
            return qFilters.toArray(new QFilter[0]);
        }
        return new QFilter[0];
    }

    private String getSumTaskKey(String preKey) {
        return this.pageId + "_" + preKey + "_sumtask";
    }

    void cacheSumTask(String preKey, String taskId) {
        pageCache.put(this.getSumTaskKey(preKey), (Object)taskId);
    }

    String getSumTask(String preKey) {
        return (String)pageCache.get(this.getSumTaskKey(preKey));
    }

    private String getGroupbyTaskKey(String preKey, String key) {
        return this.pageId + "_" + preKey + "_groupbytask_" + key;
    }

    void cacheGroupByTask(String preKey, String key, String taskId) {
        pageCache.put(this.getGroupbyTaskKey(preKey, key), (Object)taskId);
    }

    String getGroupbyTask(String preKey, String key) {
        return (String)pageCache.get(this.getGroupbyTaskKey(preKey, key));
    }

    void remove(String key) {
        pageCache.remove(this.getEntityTypeKey(key));
        pageCache.remove(this.getQFiltersKey(key));
        pageCache.remove(this.getQueryBuilderKey(key));
    }
}

