/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.mvc.list.MainOrgFilterResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.DimensionPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;

final class MainOrgFilterUtil {
    private MainOrgFilterUtil() {
    }

    static MainOrgFilterResult getMainOrgQFilter(MainEntityType entityType, MainOrgProp mainOrgProp, String dimFldKey, String dimAssistFidKey, boolean isDim, String entityTypeId, String appId, boolean isNotExistsOrNoLimit, List<Long> selectedMainOrgIds, ControlFilter dimAssistControlFilter) {
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        QFilter mainOrgFilter = null;
        if (isNotExistsOrNoLimit) {
            List mainOrgIds;
            if (!isDim) {
                mainOrgIds = PermissionFilterUtil.getMainOrgIds((MainEntityType)entityType, (String)entityType.getName(), (String)appId);
                mainOrgFilter = new QFilter(mainOrgProp.getName(), "in", (Object)mainOrgIds);
            } else {
                DimensionPermOrgResult hasPermDimObjResult = permissionService.getAllPermDimObj(Long.valueOf(RequestContext.get().getCurrUserId()), appId, entityTypeId, "47150e89000000ac");
                if (hasPermDimObjResult.getMainDimension().hasAllOrgPerm() || hasPermDimObjResult.getAssistDimension().hasAllOrgPerm()) {
                    return new MainOrgFilterResult(null, mainOrgFilter, false);
                }
                mainOrgIds = hasPermDimObjResult.getMainDimension().getHasPermOrgs();
                mainOrgFilter = MainOrgFilterUtil.getOrDimMainOrgQFilter(dimFldKey, dimAssistFidKey, mainOrgIds, hasPermDimObjResult);
            }
            return new MainOrgFilterResult(mainOrgIds, mainOrgFilter, true);
        }
        List<Long> mainOrgIds = selectedMainOrgIds;
        List<Long> selectmainOrgIds = selectedMainOrgIds;
        mainOrgFilter = !isDim ? new QFilter(mainOrgProp.getName(), "in", selectmainOrgIds) : MainOrgFilterUtil.getAndDimMainOrgQFilter(dimFldKey, dimAssistFidKey, selectmainOrgIds, dimAssistControlFilter);
        return new MainOrgFilterResult(mainOrgIds, mainOrgFilter, false);
    }

    private static QFilter getAndDimMainOrgQFilter(String dimFldKey, String dimAssistFidKey, List<Long> selectmainOrgIds, ControlFilter dimAssistControlFilter) {
        QFilter mainOrgFilter = new QFilter(dimFldKey, "in", selectmainOrgIds);
        if (StringUtils.isNotBlank((CharSequence)dimAssistFidKey) && !"null".equals(dimAssistFidKey) && dimAssistControlFilter != null) {
            List values = dimAssistControlFilter.getValue();
            ArrayList dimAssistValueObjs = new ArrayList(values);
            dimAssistValueObjs.remove("");
            if (!CollectionUtils.isEmpty(dimAssistValueObjs)) {
                List dimAssistValues = dimAssistValueObjs.stream().map(p -> Long.valueOf((String)p)).collect(Collectors.toList());
                mainOrgFilter = mainOrgFilter.and(new QFilter(dimAssistFidKey, "in", dimAssistValues));
            }
        }
        return mainOrgFilter;
    }

    private static QFilter getOrDimMainOrgQFilter(String dimFldKey, String dimAssistFidKey, List<Long> mainOrgIds, DimensionPermOrgResult hasPermDimObjResult) {
        QFilter mainOrgFilter = new QFilter(dimFldKey, "in", mainOrgIds);
        if (StringUtils.isNotBlank((CharSequence)dimAssistFidKey) && !"null".equals(dimAssistFidKey)) {
            mainOrgFilter = mainOrgFilter.or(new QFilter(dimAssistFidKey, "in", (Object)hasPermDimObjResult.getAssistDimension().getHasPermOrgs()));
        }
        return mainOrgFilter;
    }
}

