/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IJoinProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.DynamicTextListField;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.filter.ListSysPublicParameter;
import kd.bos.lang.Lang;
import kd.bos.list.QueryBuilderSelectFields;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.BillListContext;
import kd.bos.mvc.list.QueryBuilderContext;
import kd.bos.orm.query.QFilter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class QueryBuilderFactory {
    private static final Log log = LogFactory.getLog(QueryBuilderFactory.class);
    private boolean isDefaultOrder;
    private List<ListField> listFields = new ArrayList<ListField>();
    private List<ListField> pkFields = new ArrayList<ListField>();
    private List<ListField> keyFields = new ArrayList<ListField>();
    private EntityType entityType;
    private List<QFilter> qFilters = new ArrayList<QFilter>();
    private ListUserOption listUserOption;
    boolean isNeedResum;
    private String orderByExpr;
    private int maxReturnData;
    private int start;
    private int limit;
    private static final String BASE_TREE_TPL = "b0d31cea000001ac";
    private BillListContext billListContext;
    private boolean isSelectedAllRowsFlag;
    private boolean isRegisterProperty;
    private EntityType fullEntityType;
    private QueryBuilderSelectFields queryBuilderSelectFields;

    public boolean isDefaultOrder() {
        return this.isDefaultOrder;
    }

    public void setDefaultOrder(boolean isDefaultOrder) {
        this.isDefaultOrder = isDefaultOrder;
    }

    public List<ListField> getListFields() {
        return this.listFields;
    }

    public List<ListField> getPKFields() {
        return this.pkFields;
    }

    public void setPKFields(List<ListField> pkFields) {
        this.pkFields = pkFields;
    }

    public final List<ListField> getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(List<ListField> keyFields) {
        this.keyFields = keyFields;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setQFilters(List<QFilter> qFilters) {
        this.qFilters = qFilters;
    }

    public List<QFilter> getQFilters() {
        return this.qFilters;
    }

    public void setListUserOption(ListUserOption listUserOption) {
        this.listUserOption = listUserOption;
    }

    protected void setNeedResum(boolean isNeedResum) {
        this.isNeedResum = isNeedResum;
    }

    public String getOrderByExpr() {
        return this.orderByExpr;
    }

    public void setOrderByExpr(String orderByExpr) {
        this.orderByExpr = orderByExpr;
    }

    public int getMaxReturnData() {
        return this.maxReturnData;
    }

    public void setMaxReturnData(int maxReturnData) {
        this.maxReturnData = maxReturnData;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    void setBillListContext(BillListContext billListContext) {
        this.billListContext = billListContext;
    }

    public boolean isSelectedAllRows() {
        return this.isSelectedAllRowsFlag;
    }

    public void setSelectedAllRows(boolean isSelectedAllRows) {
        this.isSelectedAllRowsFlag = isSelectedAllRows;
    }

    public QueryBuilderFactory(List<ListField> listFields, EntityType entityType, boolean isRegisterProperty) {
        this.listFields = listFields;
        HashSet<String> selectFields = new HashSet<String>(16);
        for (ListField listField : listFields) {
            selectFields.add(listField.getListFieldKey());
        }
        for (ListField listField : this.getKeyFields()) {
            selectFields.add(listField.getListFieldKey());
        }
        for (ListField listField : this.getKeyFields()) {
            selectFields.add(listField.getListFieldKey());
        }
        this.fullEntityType = entityType;
        this.addNameVersionControlFields(this.fullEntityType, selectFields::add);
        this.entityType = !(entityType instanceof QueryEntityType) ? entityType.getSubEntityType(selectFields) : entityType;
        this.isRegisterProperty = isRegisterProperty;
        this.queryBuilderSelectFields = new QueryBuilderSelectFields(this.getEntityType());
    }

    private void addNameVersionControlFields(EntityType entityType, Consumer<String> addFunc) {
        String dateField;
        if (entityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(dateField = ((MainEntityType)entityType).getVersionControl()))) {
            addFunc.accept(dateField);
        }
    }

    public static QueryBuilder createQueryBuilder(IListDataProvider provider, int start, int limit, boolean isCustomListDataProvider) {
        BillListContext billListContext = new BillListContext();
        billListContext.setSelectedAllRows(false);
        return QueryBuilderFactory.createQueryBuilder(provider, start, limit, new QueryBuilderContext(isCustomListDataProvider, billListContext));
    }

    public static QueryBuilder createQueryBuilder(IListDataProvider provider, int start, int limit, boolean isCustomListDataProvider, boolean isSelectedAllRows) {
        BillListContext billListContext = new BillListContext();
        billListContext.setSelectedAllRows(isSelectedAllRows);
        return QueryBuilderFactory.createQueryBuilder(provider, start, limit, new QueryBuilderContext(isCustomListDataProvider, billListContext));
    }

    public static QueryBuilder createQueryBuilder(IListDataProvider provider, int start, int limit, boolean isCustomListDataProvider, boolean isSelectedAllRows, boolean isDefaultOrder) {
        BillListContext billListContext = new BillListContext();
        billListContext.setSelectedAllRows(isSelectedAllRows);
        billListContext.setDefaultOrder(isDefaultOrder);
        return QueryBuilderFactory.createQueryBuilder(provider, start, limit, new QueryBuilderContext(isCustomListDataProvider, billListContext));
    }

    public static QueryBuilder createQueryBuilder(IListDataProvider provider, int start, int limit, QueryBuilderContext queryBuilderContext) {
        QueryBuilderFactory queryBuilderFactory = new QueryBuilderFactory(provider.getListFields(), provider.getEntityType(), !queryBuilderContext.isCustomListDataProvider());
        queryBuilderFactory.setBillListContext(queryBuilderContext.getBillListContext());
        queryBuilderFactory.setKeyFields(provider.getKeyFields());
        queryBuilderFactory.setPKFields(provider.getPKFields());
        queryBuilderFactory.setQFilters(provider.getQFilters());
        queryBuilderFactory.setStart(start);
        queryBuilderFactory.setLimit(limit);
        queryBuilderFactory.setMaxReturnData(provider.getMaxReturnData());
        queryBuilderFactory.setNeedResum(provider.isNeedResum());
        queryBuilderFactory.setListUserOption(provider.getListUserOption());
        queryBuilderFactory.setOrderByExpr(provider.getOrderByExpr());
        queryBuilderFactory.setSelectedAllRows(queryBuilderContext.getBillListContext().isSelectedAllRows());
        queryBuilderFactory.setDefaultOrder(queryBuilderContext.getBillListContext().isDefaultOrder());
        QueryBuilder queryBuilder = queryBuilderFactory.createQueryBuilder();
        provider.setVisibleSelectFieldList(queryBuilder.getVisibleSelectFieldList());
        return queryBuilder;
    }

    public QueryBuilder createQueryBuilder() {
        ArrayList<String> selectFields = new ArrayList<String>(10);
        ArrayList<String> sortFields = new ArrayList<String>(10);
        ArrayList<ListField> visibleSelectFieldList = new ArrayList<ListField>(10);
        ArrayList<ListField> summaryFields = new ArrayList<ListField>(10);
        ArrayList<ListField> myPKFields = new ArrayList<ListField>(10);
        ArrayList<ListField> decimalFields = new ArrayList<ListField>(10);
        ArrayList<ListField> selectFieldList = new ArrayList<ListField>(10);
        ArrayList<ListField> sortFieldList = new ArrayList<ListField>(10);
        HashSet<String> entityNames = new HashSet<String>();
        MainEntityType dt = new MainEntityType();
        dt.setName("QueryObject");
        String seqField = null;
        List<ListField> mixedSelectFieldList = this.splitListFields(visibleSelectFieldList);
        List expandListFields = EntityTypeUtil.expandListFields(mixedSelectFieldList);
        this.addNameVersionControlFields(this.fullEntityType, dateField -> {
            dt.setVersionControl(dateField);
            ListField field = new ListField(dateField);
            field.setFieldName(dt.getVersionControl());
            expandListFields.add(field);
        });
        for (ListField listField : expandListFields) {
            if (this.pkFields.contains(listField) && !this.isSelectedAllRowsFlag || listField.isListBusinessField()) {
                if (!listField.isListBusinessField()) continue;
                visibleSelectFieldList.add(listField);
                continue;
            }
            if (listField.isSeq()) {
                seqField = this.isRegisterProperty ? this.registerProperty((DynamicObjectType)dt, listField) : listField.getFieldName();
                visibleSelectFieldList.add(listField);
                continue;
            }
            if (selectFieldList.contains(listField)) continue;
            selectFieldList.add(listField);
            if (!listField.isVisible()) continue;
            this.registerListField(selectFields, sortFields, visibleSelectFieldList, summaryFields, decimalFields, sortFieldList, entityNames, (DynamicObjectType)dt, listField);
        }
        this.buildSelectPKFields(selectFields, visibleSelectFieldList, myPKFields, (DynamicObjectType)dt);
        for (ListField listField : selectFieldList) {
            if (listField.isSeq() || listField.isVisible() || !entityNames.contains(listField.getEntityName())) continue;
            this.registerListField(selectFields, sortFields, visibleSelectFieldList, summaryFields, decimalFields, sortFieldList, entityNames, (DynamicObjectType)dt, listField);
        }
        String orderBy = this.buildOrderBy(selectFields, sortFields, sortFieldList, entityNames);
        this.sortByList(visibleSelectFieldList);
        QueryBuilder queryBuilder = new QueryBuilder(summaryFields, String.join((CharSequence)",", selectFields), this.qFilters.toArray(new QFilter[0]), orderBy, this.start, this.limit, (IDataEntityType)this.entityType, visibleSelectFieldList);
        this.buildQueryBuilder(queryBuilder, myPKFields, decimalFields, (DynamicObjectType)dt, seqField);
        return queryBuilder;
    }

    private void sortByList(List<ListField> visibleSelectFieldList) {
        Collections.sort(visibleSelectFieldList, (o1, o2) -> {
            int io1 = this.listFields.indexOf(o1);
            int io2 = this.listFields.indexOf(o2);
            if (io1 == -1) {
                return 1;
            }
            if (io2 == -1) {
                return -1;
            }
            return io1 - io2;
        });
    }

    private List<ListField> splitListFields(List<ListField> visibleSelectFieldList) {
        ArrayList<ListField> selectFieldList = new ArrayList<ListField>();
        for (ListField listField : this.listFields) {
            if (listField instanceof DynamicTextListField) {
                if (!listField.isVisible()) continue;
                selectFieldList.add(listField);
                visibleSelectFieldList.add(listField);
                continue;
            }
            selectFieldList.add(listField);
        }
        return selectFieldList;
    }

    private void registerListField(List<String> selectFields, List<String> sortFields, List<ListField> visibleSelectFieldList, List<ListField> summaryFields, List<ListField> decimalFields, List<ListField> sortFieldList, Set<String> entityNames, DynamicObjectType dt, ListField listField) {
        String fieldName = this.getFieldName(dt, listField);
        if (!visibleSelectFieldList.contains(listField)) {
            visibleSelectFieldList.add(listField);
        }
        if (fieldName != null) {
            FilterField filterField;
            if (!selectFields.contains(fieldName)) {
                selectFields.add(fieldName);
            }
            if (StringUtils.isNotEmpty((CharSequence)listField.getEntityName())) {
                entityNames.add(listField.getEntityName());
            }
            if (listField.getSummary() == 1 && !summaryFields.contains(listField)) {
                ISimpleProperty prop;
                boolean isSummaryField = true;
                if (listField.getSrcFieldProp() instanceof ISimpleProperty && ((prop = (ISimpleProperty)listField.getSrcFieldProp()).isEncrypt() || PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)prop, (String)Lang.get().toString(), (String)"FORM", null) || PrivacyCenterUtils.isEncryptField((IDataEntityProperty)prop))) {
                    log.info("\u52a0\u5bc6\u548c\u8131\u654f\u5b57\u6bb5\u4e0d\u53c2\u4e0e\u5408\u8ba1\uff0cprop is {}", (Object)prop.getName());
                    isSummaryField = false;
                }
                if (isSummaryField) {
                    summaryFields.add(listField);
                }
            }
            if ((filterField = this.collectSortFieldList(sortFields, sortFieldList, listField, fieldName)) != null && filterField.getFieldProp() instanceof DecimalProp && !decimalFields.contains(listField)) {
                decimalFields.add(listField);
            }
        }
    }

    private FilterField collectSortFieldList(List<String> sortFields, List<ListField> sortFieldList, ListField listField, String fieldName) {
        FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)this.getEntityType()), (String)listField.getListFieldKey());
        if (!(filterField == null || filterField.isFieldPropAliasEmpty() || listField.getSortType() == null || listField.getSortType() == SortType.NotOrder || sortFields.contains(fieldName) || filterField.isDesenAndNoSearch() || filterField.isEncryptField() || this.getEntityType() instanceof QueryEntityType && filterField.getLatestParent() instanceof MulBasedataProp)) {
            sortFieldList.add(listField);
        }
        return filterField;
    }

    private String buildOrderBy(List<String> selectFields, List<String> sortFields, List<ListField> sortFieldList, Set<String> entityNames) {
        for (ListField listField : sortFieldList) {
            if (!entityNames.contains(listField.getEntityName()) || !selectFields.contains(this.getPropName(listField))) continue;
            sortFields.add(String.format("%s %s", listField.getFieldName(), listField.getSortType().name()));
        }
        return this.buildOrderBy(sortFields, entityNames);
    }

    private String getPropName(ListField listField) {
        IDataEntityProperty srcFieldProp = this.queryBuilderSelectFields.getSrcFieldProp(listField);
        return this.queryBuilderSelectFields.getPropName(listField, srcFieldProp);
    }

    private void buildSelectPKFields(List<String> selectFields, List<ListField> selectFieldList, List<ListField> myPKFields, DynamicObjectType dt) {
        List validPkFields = EntityTypeUtil.getValidPkFields((EntityType)this.getEntityType(), selectFieldList);
        for (ListField listField : validPkFields) {
            String fieldName = this.getFieldName(dt, listField);
            if (fieldName == null) continue;
            if (!selectFieldList.contains(listField)) {
                selectFieldList.add(listField);
            }
            if (!myPKFields.contains(listField)) {
                myPKFields.add(listField);
            }
            if (selectFields.contains(fieldName)) continue;
            selectFields.add(fieldName);
        }
    }

    private String getFieldName(DynamicObjectType dt, ListField listField) {
        String fieldName = null;
        if (this.isRegisterProperty) {
            fieldName = this.registerProperty(dt, listField);
        } else {
            IDataEntityProperty srcFieldProp = QueryBuilderSelectFields.getSelectProp((EntityType)this.entityType, (String)listField.getFieldName());
            if (!QueryBuilderSelectFields.isNotValidField((ListField)listField, (IDataEntityProperty)srcFieldProp)) {
                fieldName = listField.getFieldName();
            }
        }
        return fieldName;
    }

    private BillListContext getOrCreateBillListContext() {
        if (this.billListContext == null) {
            this.billListContext = new BillListContext();
        }
        return this.billListContext;
    }

    private void buildQueryBuilder(QueryBuilder queryBuilder, List<ListField> myPKFields, List<ListField> decimalFields, DynamicObjectType dt, String seqField) {
        queryBuilder.setNeedResum(this.getOrCreateBillListContext().isNeedResum());
        queryBuilder.setDecimalFields(decimalFields);
        queryBuilder.setEntityName(this.entityType.getName());
        queryBuilder.setEntityType((IDataEntityType)this.fullEntityType);
        queryBuilder.setPkFields(myPKFields);
        queryBuilder.setSeqField(seqField);
        queryBuilder.setReturnEntityType(dt);
        queryBuilder.setFilters(this.qFilters.toArray(new QFilter[0]));
        queryBuilder.setMergeRow(this.getOrCreateBillListContext().getListUserOption().isMergeRow());
        queryBuilder.setMaxReturnData(this.getOrCreateBillListContext().getMaxReturnData());
        queryBuilder.setSelectedAllRows(this.getOrCreateBillListContext().isSelectedAllRows());
        queryBuilder.setRouteKey(this.getOrCreateBillListContext().getRouteKey());
        queryBuilder.setAchiveKey(this.getOrCreateBillListContext().getAchiveKey());
        queryBuilder.setGroupBySumFields(this.getOrCreateBillListContext().getGroupBySumFields());
        queryBuilder.setTimeOutSecends(this.getOrCreateBillListContext().getTimeOutSecends());
    }

    private String buildOrderBy(List<String> sortFields, Set<String> entityNames) {
        String orderBy = String.join((CharSequence)",", sortFields);
        if (!this.billListContext.isDefaultOrderByForce() && StringUtils.isNotBlank((CharSequence)this.orderByExpr)) {
            String[] splits = this.orderByExpr.split(",");
            ArrayList<String> validOrderByList = new ArrayList<String>();
            for (String orderField : splits) {
                FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)this.fullEntityType), (String)orderField.trim().split(" ")[0].trim());
                if (filterField != null && !filterField.isFieldPropAliasEmpty() && entityNames.contains(filterField.getSrcFieldProp().getParent().getName())) {
                    validOrderByList.add(orderField);
                    continue;
                }
                if (filterField == null || filterField.isFieldPropAliasEmpty() || !(this.getEntityType() instanceof QueryEntityType)) continue;
                validOrderByList.add(orderField);
            }
            if (!validOrderByList.isEmpty()) {
                orderBy = String.join((CharSequence)",", validOrderByList);
            }
        } else if (StringUtils.isBlank((CharSequence)orderBy) && this.isDefaultOrder && !(this.getEntityType() instanceof QueryEntityType)) {
            orderBy = this.buildDefaultOrderBy(entityNames);
        } else if (StringUtils.isBlank((CharSequence)orderBy) && !this.isDefaultOrder && this.getEntityType() instanceof BillEntityType && !(this.getEntityType() instanceof BasedataEntityType) && this.getPKFields().size() > 1) {
            orderBy = "id desc";
        }
        return orderBy;
    }

    private String buildDefaultOrderBy(Set<String> entityNames) {
        String entryEntityName;
        IDataEntityProperty findProperty;
        String orderBy = "";
        if (this.fullEntityType instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)this.fullEntityType;
            Map enableF7SchemeMap = (Map)ListSysPublicParameter.loadCustom((String)"enableBasedataOrderById");
            orderBy = enableF7SchemeMap != null && "1".equals(enableF7SchemeMap.getOrDefault("enableBasedataOrderById", "0")) ? String.format("%s desc", basedataEntityType.getPrimaryKey().getName()) : String.format("%s", basedataEntityType.getNumberProperty());
        } else if (this.fullEntityType instanceof BillEntityType && StringUtils.isNotEmpty((CharSequence)((BillEntityType)this.fullEntityType).getBillNo())) {
            BillEntityType billEntityType = (BillEntityType)this.fullEntityType;
            orderBy = String.format("%s desc", billEntityType.getPrimaryKey().getName());
        }
        if (StringUtils.isEmpty((CharSequence)orderBy)) {
            orderBy = this.fullEntityType.getPrimaryKey().getName();
        }
        if (this.getPKFields().size() > 1 && StringUtils.isNotBlank((CharSequence)orderBy) && (findProperty = this.fullEntityType.findProperty(entryEntityName = this.getPKFields().get(1).getFieldName().split("\\.")[0])) instanceof EntryProp && StringUtils.isNotEmpty((CharSequence)((EntryProp)findProperty).getItemType().getAlias()) && entityNames.contains(entryEntityName)) {
            orderBy = orderBy + "," + entryEntityName + ".seq";
        }
        if (this.getPKFields().size() > 2 && StringUtils.isNotBlank((CharSequence)orderBy)) {
            entryEntityName = this.getPKFields().get(1).getFieldName().split("\\.")[0];
            String subEntryEntityName = this.getPKFields().get(2).getFieldName().split("\\.")[1];
            IDataEntityProperty findProperty2 = this.fullEntityType.findProperty(subEntryEntityName);
            if (findProperty2 instanceof EntryProp && StringUtils.isNotEmpty((CharSequence)((EntryProp)findProperty2).getItemType().getAlias()) && entityNames.contains(entryEntityName)) {
                orderBy = orderBy + "," + entryEntityName + "." + subEntryEntityName + ".seq";
            }
        }
        return orderBy;
    }

    private String registerProperty(DynamicObjectType dt, ListField listField) {
        IDataEntityProperty srcFieldProp = this.queryBuilderSelectFields.getSrcFieldProp(listField);
        if (srcFieldProp == null) {
            return null;
        }
        String propName = this.queryBuilderSelectFields.getPropName(listField, srcFieldProp);
        if (srcFieldProp instanceof ISimpleProperty) {
            return this.registerProperty(dt, listField, (ISimpleProperty)srcFieldProp, propName);
        }
        if (srcFieldProp instanceof IComplexProperty) {
            return this.registerProperty(dt, listField, (IComplexProperty)srcFieldProp, propName);
        }
        if (srcFieldProp instanceof ICollectionProperty) {
            return this.registerProperty(dt, listField, (ICollectionProperty)srcFieldProp, propName);
        }
        return null;
    }

    private String registerJoinProperty(DynamicObjectType dt, ListField listField, IComplexProperty srcFieldProp, String fieldName) {
        int index;
        String key;
        IDataEntityType complexType = srcFieldProp.getComplexType();
        IDataEntityProperty property = QueryBuilderSelectFields.getSelectProp((EntityType)((EntityType)complexType), (String)(key = fieldName.substring(index = fieldName.indexOf(".") + 1)));
        if (property instanceof IComplexProperty) {
            return this.registerJoinProperty(dt, listField, (IComplexProperty)property, key);
        }
        String propName = this.queryBuilderSelectFields.getPropName(listField, property);
        return this.registerProperty(dt, listField, (ISimpleProperty)property, propName);
    }

    private String registerProperty(DynamicObjectType dt, ListField listField, ICollectionProperty srcFieldProp, String propName) {
        DynamicProperty p = dt.getProperty(propName);
        if (p == null) {
            MulBasedataProp baseProp = (MulBasedataProp)TypesContainer.createInstance(srcFieldProp.getClass());
            baseProp.setItemType(srcFieldProp.getItemType());
            baseProp.setAlias(srcFieldProp.getAlias());
            baseProp.setName(propName);
            p = baseProp;
            dt.registerCollectionProperty((DynamicCollectionProperty)baseProp);
        }
        listField.setFieldProp((IDataEntityProperty)p);
        listField.setSrcFieldProp((IDataEntityProperty)srcFieldProp);
        return propName;
    }

    private String registerProperty(DynamicObjectType dt, ListField listField, IComplexProperty srcFieldProp, String propName) {
        if (srcFieldProp instanceof IJoinProperty) {
            return this.registerJoinProperty(dt, listField, srcFieldProp, listField.getFieldName());
        }
        DynamicProperty p = dt.getProperty(propName);
        if (p == null) {
            String refIdPropName = (this.getEntityType() instanceof QueryEntityType ? propName : srcFieldProp.getName()) + "_Id";
            Object propInstance = TypesContainer.createInstance(srcFieldProp.getClass());
            if (propInstance instanceof RefBillProp) {
                RefBillProp refBillProp = (RefBillProp)propInstance;
                refBillProp.setName(propName);
                refBillProp.setDbIgnore(true);
                refBillProp.setRefIdPropName(refIdPropName);
                refBillProp.setComplexType(srcFieldProp.getComplexType());
                dt.addProperty((DynamicProperty)refBillProp);
                p = refBillProp;
                DynamicSimpleProperty refIdProp = (DynamicSimpleProperty)EntityItemTypes.clone((IDataEntityProperty)((RefBillProp)srcFieldProp).getRefIdProp());
                refBillProp.setRefIdProp((IDataEntityProperty)refIdProp);
                dt.registerSimpleProperty(refIdProp);
            } else {
                BasedataProp baseProp = (BasedataProp)propInstance;
                baseProp.setName(propName);
                baseProp.setDbIgnore(true);
                baseProp.setRefIdPropName(refIdPropName);
                if (baseProp instanceof ItemClassProp) {
                    FilterField itemTypeFld;
                    String itemTypePropName = ((ItemClassProp)srcFieldProp).getTypePropName();
                    if (StringUtils.isNotBlank((CharSequence)itemTypePropName) && (itemTypeFld = FilterField.create((MainEntityType)((MainEntityType)this.entityType), (String)itemTypePropName)) != null) {
                        itemTypePropName = itemTypeFld.getFullFieldName();
                    }
                    ((ItemClassProp)baseProp).setTypePropName(itemTypePropName);
                } else {
                    baseProp.setComplexType(srcFieldProp.getComplexType());
                }
                if (baseProp instanceof FlexProp) {
                    ((FlexProp)baseProp).setFlexTypeId(((FlexProp)srcFieldProp).getFlexTypeId());
                    ((FlexProp)baseProp).setBasePropertyKey(((FlexProp)srcFieldProp).getBasePropertyKey());
                    ((FlexProp)baseProp).setDisplayProp(((FlexProp)srcFieldProp).getDisplayProp());
                }
                dt.addProperty((DynamicProperty)baseProp);
                p = baseProp;
                DynamicSimpleProperty refIdProp = (DynamicSimpleProperty)EntityItemTypes.clone((IDataEntityProperty)((BasedataProp)srcFieldProp).getRefIdProp());
                refIdProp.setName(refIdPropName);
                baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
                dt.registerSimpleProperty(refIdProp);
            }
        }
        listField.setFieldProp((IDataEntityProperty)p);
        listField.setSrcFieldProp((IDataEntityProperty)srcFieldProp);
        return propName;
    }

    private String registerProperty(DynamicObjectType dt, ListField listField, ISimpleProperty srcFieldProp, String propName) {
        DynamicProperty sp = dt.getProperty(propName);
        if (sp == null) {
            DynamicSimpleProperty property;
            Class<String> propertyType = srcFieldProp.getPropertyType();
            if (propertyType == ILocaleString.class) {
                propertyType = String.class;
            }
            if (srcFieldProp instanceof ItemClassTypeProp) {
                ItemClassTypeProp newProp = new ItemClassTypeProp();
                ItemClassTypeProp srcProp = (ItemClassTypeProp)srcFieldProp;
                newProp.setBaseEntityIds(srcProp.getBaseEntityIds());
                newProp.setComboItems(srcProp.getComboItems());
                newProp.getItemTypes().putAll(srcProp.getItemTypes());
                newProp.setName(propName);
                property = newProp;
            } else {
                property = new DynamicSimpleProperty(propName, propertyType, null);
            }
            if (this.pkFields.get(0).getFieldName().equalsIgnoreCase(listField.getFieldName())) {
                property.setPrimaryKey(true);
            }
            property.setDbType(srcFieldProp.getDbType());
            sp = dt.registerSimpleProperty(property);
        }
        listField.setFieldProp((IDataEntityProperty)sp);
        listField.setSrcFieldProp((IDataEntityProperty)srcFieldProp);
        for (ListField pkField : this.pkFields) {
            if (!propName.equalsIgnoreCase(pkField.getFieldName())) continue;
            pkField.setFieldProp((IDataEntityProperty)sp);
            pkField.setSrcFieldProp((IDataEntityProperty)srcFieldProp);
            break;
        }
        for (ListField keyField : this.keyFields) {
            if (!propName.equalsIgnoreCase(keyField.getFieldName())) continue;
            keyField.setFieldProp((IDataEntityProperty)sp);
            keyField.setSrcFieldProp((IDataEntityProperty)srcFieldProp);
            break;
        }
        return propName;
    }
}

