/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.filter.QFilterDto;
import kd.bos.entity.list.IQuery;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.list.query.QueryFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TreeListModel
implements ITreeModel {
    private static final String SPAN_TYPE_NAME = "list";
    private String pageId;
    private TreeNode rootNode;
    private String rootNodeCacheKey;
    private IPageCache pageCache;
    private int defaultQueryLevel = 1;
    private boolean rootVisable = true;
    private boolean nodeClickExpand = true;
    private String textFormat = "{name}";
    private EntityType dataEntityType;
    private Object currentNodeId;
    private Object updateNodeId;
    private List<QFilter> treeFilter = new ArrayList<QFilter>(10);
    private List<QFilter> treeListFilter = new ArrayList<QFilter>();
    private Map<String, Object> queryParas = new HashMap<String, Object>();
    ListViewPluginProxy proxy;
    public static final String rootNodeId = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    public boolean gobackToRoot = true;

    public List<QFilter> getTreeListFilter() {
        if (this.treeListFilter.isEmpty()) {
            String treeFilterStr = this.pageCache.get("treelistmodel.treeListFilter");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            if (!StringUtils.isBlank((CharSequence)treeFilterStr)) {
                List qFilterDto = SerializationUtils.fromJsonStringToList((String)treeFilterStr, QFilterDto.class);
                for (QFilterDto filterDto : qFilterDto) {
                    qFilters.add(QFilter.fromSerializedString((String)filterDto.getFilter()));
                }
            }
            return qFilters;
        }
        return this.treeListFilter;
    }

    public void setTreeListFilter(List<QFilter> treeListFilter) {
        ArrayList<QFilterDto> filters = new ArrayList<QFilterDto>(10);
        for (QFilter qFilter : treeListFilter) {
            filters.add(new QFilterDto(qFilter.toSerializedString()));
        }
        this.pageCache.put("treelistmodel.treeListFilter", SerializationUtils.toJsonString(filters));
        this.treeListFilter = treeListFilter;
    }

    public TreeListModel(String pageId, EntityType dataEntityType) {
        this.pageId = pageId;
        this.dataEntityType = dataEntityType;
        this.rootNodeCacheKey = String.format("%s.root", pageId);
    }

    public TreeNode getRoot() {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        String rootNodeStr = this.pageCache.get(this.rootNodeCacheKey);
        if (StringUtils.isNotBlank((CharSequence)rootNodeStr)) {
            this.rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        }
        return this.rootNode;
    }

    public void setRoot(TreeNode root) {
        this.rootNode = root;
        this.pageCache.put(this.rootNodeCacheKey, SerializationUtils.toJsonString((Object)root));
    }

    public boolean isRootVisable() {
        return this.rootVisable;
    }

    public void setRootVisable(boolean rootVisable) {
        this.rootVisable = rootVisable;
    }

    public Object getCurrentNodeId() {
        if (this.currentNodeId == null) {
            this.currentNodeId = this.pageCache.get(String.format("%s.currentnodeid", this.pageId));
        }
        return this.currentNodeId;
    }

    public void setCurrentNodeId(Object currentNodeId) {
        this.currentNodeId = currentNodeId;
        this.updateNodeId = currentNodeId;
        this.pageCache.put(String.format("%s.currentnodeid", this.pageId), currentNodeId.toString());
    }

    public boolean isNodeClickExpand() {
        return this.nodeClickExpand;
    }

    public void setNodeClickExpand(boolean nodeClickExpand) {
        this.nodeClickExpand = nodeClickExpand;
    }

    public int getDefaultQueryLevel() {
        return this.defaultQueryLevel;
    }

    public void setDefaultQueryLevel(int defaultQueryLevel) {
        this.defaultQueryLevel = defaultQueryLevel;
    }

    public String getTextFormat() {
        return this.textFormat;
    }

    public void setTextFormat(String textFormat) {
        this.textFormat = textFormat;
    }

    public List<QFilter> getTreeFilter() {
        return this.treeFilter;
    }

    public void setTreeFilter(List<QFilter> treeFilter) {
        this.treeFilter = treeFilter;
    }

    public TreeNode createRootNode() {
        TreeNode node = new TreeNode();
        node.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TreeListModel_0", (String)"bos-form-mvc", (Object[])new Object[0]));
        node.setId(rootNodeId);
        node.setParentid("");
        node.addChildren(new ArrayList());
        node.setIsOpened(true);
        this.setCurrentNodeId(rootNodeId);
        return node;
    }

    public TreeNode refreshNode(Object nodeId) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"TreeListModel.refreshNode");){
            List<TreeNode> list;
            span.addTag("nodeId", String.valueOf(nodeId));
            TreeNode node = this.getNode(nodeId);
            if (node == null) {
                TreeNode treeNode = node;
                return treeNode;
            }
            String customTreeFilter = this.pageCache.get("customTreeFilter");
            if (StringUtils.isNotBlank((CharSequence)customTreeFilter)) {
                List qFilterDtos = SerializationUtils.fromJsonStringToList((String)customTreeFilter, QFilterDto.class);
                for (QFilterDto qFilterDto : qFilterDtos) {
                    this.treeFilter.add(QFilter.fromSerializedString((String)qFilterDto.getFilter()));
                }
            }
            ArrayList<QFilterDto> filters = new ArrayList<QFilterDto>(this.treeFilter.size());
            for (QFilter qFilter : this.treeFilter) {
                filters.add(new QFilterDto(qFilter.toSerializedString()));
            }
            this.pageCache.put("treeFilter", SerializationUtils.toJsonString(filters));
            RefreshNodeEvent e = new RefreshNodeEvent((Object)this, nodeId);
            if (this.proxy != null) {
                this.proxy.fireRefreshNode(e);
            }
            if ((list = e.getChildNodes()) == null) {
                list = this.getChildNodes(nodeId, node.getLongNumber());
            }
            if (list.size() > 0) {
                node.setChildren(list);
            } else {
                node.setChildren(null);
            }
            this.pageCache.put(this.rootNodeCacheKey, SerializationUtils.toJsonString((Object)this.rootNode));
            TreeNode treeNode = node;
            return treeNode;
        }
    }

    public Map<String, TreeNode> refreshNodes(List<Object> nodeIds) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"TreeListModel.refreshNode");){
            RefreshNodeEvent e = new RefreshNodeEvent((Object)this, nodeIds);
            this.proxy.fireRefreshNode(e);
            HashMap<String, TreeNode> map = new HashMap<String, TreeNode>();
            this.pageCache.put(this.rootNodeCacheKey, SerializationUtils.toJsonString((Object)this.rootNode));
            HashMap<String, TreeNode> hashMap = map;
            return hashMap;
        }
    }

    private TreeNode getNode(Object nodeId) {
        if (this.getRoot() == null) {
            return this.createRootNode();
        }
        return this.getRoot().getTreeNode(nodeId.toString());
    }

    private List<TreeNode> getChildNodes(Object parentId, String longNumber) {
        GroupProp group = this.getGroupProp();
        if (group == null || parentId == null) {
            return new ArrayList<TreeNode>();
        }
        IQuery query = QueryFactory.createQuery();
        if (this.isRootNode(parentId)) {
            List list = query.getGroupNodes(group, this.getTreeFilter(), this.textFormat, null, null, this.queryParas);
            for (TreeNode treeNode : list) {
                treeNode.setParentid(parentId.toString());
            }
            return list;
        }
        boolean existParentFiled = false;
        for (IDataEntityProperty prop : group.getEntityType().getProperties()) {
            if (!(prop.getParent() instanceof MainEntityType) || !(prop instanceof ParentBasedataProp)) continue;
            existParentFiled = true;
            break;
        }
        if (!existParentFiled) {
            return new ArrayList<TreeNode>();
        }
        return query.getGroupNodes(group, this.getTreeFilter(), this.textFormat, parentId, longNumber, this.queryParas);
    }

    public void addNode(Object currNodeId, TreeNode newNode) {
        TreeNode currNode = this.rootNode.getTreeNode(currNodeId.toString());
        currNode.addChild(newNode);
        this.pageCache.put(this.rootNodeCacheKey, SerializationUtils.toJsonString((Object)this.rootNode));
    }

    public void deleteNode(TreeNode node, boolean includeChild) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"TreeListModel.deleteNode");){
            this.removeNodeFromRoot(node, includeChild);
            this.pageCache.put(this.rootNodeCacheKey, SerializationUtils.toJsonString((Object)this.rootNode));
        }
    }

    public void deleteNodes(List<String> nodeIds, boolean includeChild) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"TreeListModel.deleteNodes");){
            for (String nodeId : nodeIds) {
                TreeNode node = this.rootNode.getTreeNode(nodeId);
                this.removeNodeFromRoot(node, includeChild);
            }
            this.pageCache.put(this.rootNodeCacheKey, SerializationUtils.toJsonString((Object)this.rootNode));
        }
    }

    private void removeNodeFromRoot(TreeNode node, boolean includeChild) {
        String parentId = node.getParentid();
        TreeNode parentNode = StringUtils.isBlank((CharSequence)parentId) ? this.rootNode : this.rootNode.getTreeNode(parentId);
        if (includeChild) {
            if ("0".equals(parentId)) {
                this.rootNode.deleteChildNode(node.getId());
            } else {
                parentNode.deleteChildNode(node.getId());
            }
        } else {
            List list = node.getChildren();
            if (list == null || list.size() == 0) {
                parentNode.deleteChildNode(node.getId());
            }
        }
        if (node.getId() != null && node.getId().equals(this.getCurrentNodeId())) {
            this.setCurrentNodeId(parentId);
        }
    }

    public QFilter getListFilter() {
        if (this.currentNodeId == null) {
            return null;
        }
        BuildTreeListFilterEvent args = new BuildTreeListFilterEvent((Object)this, this.currentNodeId);
        this.proxy.fireBuildTreeListFilter(args);
        if (args.isCancel()) {
            this.pageCache.put("isCacel", "true");
            if (!args.getFilters().isEmpty()) {
                return (QFilter)args.getFilters().get(0);
            }
            return null;
        }
        this.pageCache.put("isCacel", "false");
        GroupProp prop = this.getGroupProp();
        List filters = args.getFilters();
        if (prop != null && !this.isRootNode(this.currentNodeId)) {
            Class pkClass = prop.getDynamicComplexPropertyType().getPrimaryKey().getPropertyType();
            boolean number = pkClass == Integer.TYPE || pkClass == Integer.class || pkClass == Long.TYPE || pkClass == Long.class;
            String currNodeId = number ? Long.valueOf(Long.parseLong(String.valueOf(this.currentNodeId))) : this.currentNodeId.toString();
            filters.add(new QFilter(prop.getName(), "=", (Object)currNodeId));
        }
        return this.joinAllQFiltersToAnd(filters);
    }

    private QFilter joinAllQFiltersToAnd(List<QFilter> qfilters) {
        List newQfilters = qfilters.stream().distinct().collect(Collectors.toList());
        QFilter qfilter = null;
        for (QFilter filter : newQfilters) {
            if (qfilter == null) {
                qfilter = filter;
                continue;
            }
            qfilter.and(filter);
        }
        return qfilter;
    }

    public IOperationResult deleteGroup(Object[] nodeIds) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"TreeListModel.deleteGroup");){
            OperationResult operationResult;
            GroupProp prop = this.getGroupProp();
            if (prop.isCustom()) {
                BaseDataServiceHelper helper = new BaseDataServiceHelper();
                IOperationResult iOperationResult = helper.deleteFormGroup(nodeIds, prop);
                return iOperationResult;
            }
            String entityNumber = prop.getBaseEntityId();
            List operateList = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
            String operationKey = "";
            for (Map map : operateList) {
                String type = (String)map.get("type");
                String key = (String)map.get("key");
                if (!"delete".equals(type) || !StringUtils.isNotBlank((CharSequence)key)) continue;
                operationKey = key;
                break;
            }
            if (StringUtils.isNotBlank((CharSequence)operationKey)) {
                operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])nodeIds, (OperateOption)OperateOption.create());
                return operationResult;
            }
            OperationResult result = new OperationResult();
            result.setSuccess(false);
            result.setMessage(String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u57fa\u7840\u8d44\u6599%s\u6ca1\u6709\u914d\u7f6e\u5220\u9664\u64cd\u4f5c\u3002", (String)"TreeListModel_1", (String)"bos-form-mvc", (Object[])new Object[0]), entityNumber));
            operationResult = result;
            return operationResult;
        }
    }

    public boolean treeNodeUpdate(Object currentId, Object newParentId, GroupProp groupProp) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"TreeListModel.treeNodeUpdate");){
            if (StringUtils.isNotBlank((Object)newParentId) && StringUtils.isNotBlank((Object)currentId)) {
                BaseDataServiceHelper helper = new BaseDataServiceHelper();
                boolean bl = helper.treeNodeUpdate(currentId, newParentId, groupProp);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public void setCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    private IPageCache getCache() {
        if (this.pageCache == null) {
            this.pageCache = new PageCache(this.pageId);
        }
        return this.pageCache;
    }

    public GroupProp getGroupProp() {
        for (IDataEntityProperty prop : this.dataEntityType.getProperties()) {
            if (!(prop instanceof GroupProp)) continue;
            return (GroupProp)prop;
        }
        return null;
    }

    private boolean isRootNode(Object nodeId) {
        if (this.getRoot() == null) {
            return false;
        }
        return this.getRoot().getId().compareTo(nodeId.toString()) == 0;
    }

    public void setPluginProxy(ListViewPluginProxy proxy) {
        this.proxy = proxy;
    }

    public Map<String, Object> getQueryParas() {
        return this.queryParas;
    }

    public void setQueryParas(Map<String, Object> queryParas) {
        this.queryParas = queryParas;
    }

    public boolean isGobackToRoot() {
        return this.gobackToRoot;
    }

    public void setGobackToRoot(boolean gobackToRoot) {
        this.gobackToRoot = gobackToRoot;
    }

    public void addNodes(Object currNodeId, List<TreeNode> newNodeList) {
        TreeNode currNode = this.rootNode.getTreeNode(currNodeId.toString());
        for (TreeNode treeNode : newNodeList) {
            currNode.addChild(treeNode);
        }
        this.pageCache.put(this.rootNodeCacheKey, SerializationUtils.toJsonString((Object)this.rootNode));
    }
}

