/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.list.column.ComboSearchValue;
import kd.bos.list.column.CompareSearchValue;
import kd.bos.list.column.ListColumnCompare;
import kd.bos.list.column.ListColumnCompareService;
import kd.bos.list.column.ListColumnCompares;
import kd.bos.list.column.ListColumnMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.utils.DbTypeConverter;

final class ApproverListColumnCompareServiceImpl
implements ListColumnCompareService {
    private static final Log log = LogFactory.getLog(ApproverListColumnCompareServiceImpl.class);
    private static final String COMPARETYPE_EQ = "1301";
    private static final String COMPARETYPE_LIKE = "1302";

    ApproverListColumnCompareServiceImpl() {
    }

    public ListColumnCompares getListColumnCompares(ListColumnMeta listColumnMeta) {
        ArrayList<ListColumnCompare> columnComboItems = new ArrayList<ListColumnCompare>(10);
        columnComboItems.add(new ListColumnCompare(COMPARETYPE_LIKE, new LocaleString(ResManager.loadKDString((String)"\u5305\u542b", (String)"ApproverListColumnCompareServiceImpl_0", (String)"bos-form-mvc", (Object[])new Object[0]))));
        return new ListColumnCompares(columnComboItems);
    }

    public QFilter search(ComboSearchValue searchValue) {
        CompareSearchValue cv = (CompareSearchValue)searchValue;
        List values = cv.getValues();
        if (CollectionUtils.isEmpty((Collection)values)) {
            return null;
        }
        String compareId = cv.getCompareId();
        String entityId = searchValue.getEntityId();
        Set<Object> businesskeys = this.queryBusinesskeyToWf(entityId, values, compareId);
        if (CollectionUtils.isEmpty(businesskeys)) {
            int dbType = this.getEntityDbType(entityId);
            return new QFilter("id", "=", DbTypeConverter.safeConvert((int)dbType, (Object)"-1"));
        }
        if (COMPARETYPE_EQ.equals(compareId) || COMPARETYPE_LIKE.equals(compareId)) {
            return new QFilter("id", "in", businesskeys);
        }
        return null;
    }

    private Set<Object> queryBusinesskeyToWf(String entityId, List<String> usernames, String compareId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select top 100000 twt.fbusinesskey ", new Object[0]);
        sqlBuilder.append("from t_wf_task twt ", new Object[0]);
        sqlBuilder.append("inner join t_wf_participant twp on twt.fid = twp.ftaskid ", new Object[0]);
        sqlBuilder.append("inner join t_wf_participant_l twpl on twp.fid = twpl.fid ", new Object[0]);
        sqlBuilder.append("where twt.fentitynumber = ? ", new Object[]{entityId});
        sqlBuilder.append("and twpl.flocaleid = ? ", new Object[]{Locale.getDefault().toString()});
        if (COMPARETYPE_EQ.equals(compareId)) {
            List<Long> userIds = this.convertToLongUserId(usernames);
            if (CollectionUtils.isEmpty(userIds)) {
                sqlBuilder.appendIn("and twpl.fusername", usernames.toArray());
            } else {
                sqlBuilder.append("and ( ", new Object[0]);
                sqlBuilder.appendIn("twp.fuserid", userIds == null ? null : userIds.toArray());
                sqlBuilder.appendIn("or twpl.fusername", usernames.toArray());
                sqlBuilder.append(") ", new Object[0]);
            }
            sqlBuilder.append("order by twt.fid desc ", new Object[0]);
        } else if (COMPARETYPE_LIKE.equals(compareId)) {
            sqlBuilder.append("and twpl.fusername like ?", new Object[]{new SqlParameter(":fusername", 12, (Object)("%" + usernames.get(0) + "%"))});
        } else {
            return null;
        }
        Set results = null;
        try {
            int dbType = this.getEntityDbType(entityId);
            results = (Set)DB.query((DBRoute)DBRoute.workflow, (SqlBuilder)sqlBuilder, rs -> {
                HashSet<Object> idSet = new HashSet<Object>(16);
                while (rs.next()) {
                    idSet.add(DbTypeConverter.safeConvert((int)dbType, (Object)rs.getString("fbusinesskey")));
                }
                return idSet;
            });
        }
        catch (Exception e) {
            String msg = String.format("The query process according to the current approver condition is abnormal,error:%s;  sql:%s", e.getMessage(), sqlBuilder);
            log.error(msg, (Throwable)e);
        }
        return results;
    }

    private int getEntityDbType(String entityId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        return entityType.getPrimaryKey().getDbType();
    }

    private List<Long> convertToLongUserId(List<String> usernames) {
        ArrayList<Long> userIds = new ArrayList<Long>(usernames.size());
        for (String username : usernames) {
            try {
                userIds.add(Long.parseLong(username));
            }
            catch (Exception e) {
                return null;
            }
        }
        return userIds;
    }
}

