/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.report.listener;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportException;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.mvc.report.ReportView;
import kd.bos.mvc.report.listener.ReportProgressListenerBase;

public class LargeDataExportProgressListener
extends ReportProgressListenerBase
implements ProgresssListener {
    public LargeDataExportProgressListener(ReportView view) {
        this.view = view;
    }

    public void onProgress(ProgressEvent evt) {
        if (!this.isExportProgressing()) {
            return;
        }
        ProgressBar bar = (ProgressBar)this.view.getControl("progressbarap");
        int progress = this.getProgress();
        if (progress >= 100) {
            String downloadUrl = this.getReportCache().getDownloadUrl(this.getPageId());
            ReportException exception = this.getReportCache().getException(this.getPageId());
            if (StringUtils.isNotBlank((CharSequence)downloadUrl)) {
                this.view.download(downloadUrl);
            }
            if (exception != null && StringUtils.isNotBlank((CharSequence)exception.getContent())) {
                if (exception.getShowType() == ReportException.ShowType.SHOW_NOTIFICATION_MSG) {
                    this.view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u62a5\u8868\u5bfc\u51fa\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790: %s", (String)"LargeDataExportProgressListener_1", (String)"bos-form-mvc", (Object[])new Object[0]), exception.getContent()));
                } else {
                    this.view.showMessage(exception.getContent());
                }
                this.getReportCache().clearExceptionMsg(this.getPageId());
                this.view.getPageCache().put("isReportSearching", "false");
            } else if (StringUtils.isNotBlank((CharSequence)downloadUrl)) {
                this.view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"LargeDataExportProgressListener_0", (String)"bos-form-mvc", (Object[])new Object[0]));
            }
            evt.setProgress(100);
            bar.stop();
            this.view.setVisible(false, new String[]{"progressbarap"});
        } else {
            evt.setProgress(progress);
        }
    }
}

