/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.extplugin.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.extplugin.PluginFilter;
import kd.bos.extplugin.PluginProvider;
import kd.bos.extplugin.internal.LoadingExtPluginContext;
import kd.bos.extplugin.internal.PluginLogable;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.sdk.kingscript.mixture.ScriptImplement;
import kd.sdk.kingscript.mixture.ScriptImplementFactory;

public final class PluginDBProvider
implements PluginProvider,
PluginLogable {
    private static final boolean ignorePluginConfigError = Boolean.parseBoolean(System.getProperty("bos.form.plugin.ignore_plugin_config_error", "true"));
    private static final Log LOG = LogFactory.getLog(PluginDBProvider.class);
    private static final String aop_table = "t_sys_pluginAOP";
    private static final String ENTITY_BIZEXT_PLUGIN_BIND = "bos_bizextpluginbind";
    private static final String FIELD_BIZEXT_POINT_NUMBER = "number";
    private static final String ENTRY_BIZEXT_PLUGINS = "entryentity";
    private static final String FIELD_PLUGINS_ENABLE = "pluginenable";
    private static final String FIELD_PLUGINS_SYSDISABLE = "pluginissysdisable";
    private static final String FIELD_PLUGINS_CLASS = "pluginclass";
    private static final PluginDBProvider ROOT = new PluginDBProvider();
    private static final Map<String, PluginDBProvider> accountProviderMap = new ConcurrentHashMap<String, PluginDBProvider>();
    private static DynamicObjectType simplePluginbindType;
    private static String subEntityTypeStr;

    public static PluginDBProvider get() {
        RequestContext rc = RequestContext.get();
        if (rc == null || rc.getAccountId() == null) {
            return ROOT;
        }
        PluginDBProvider sp = accountProviderMap.get(rc.getAccountId());
        if (sp == null) {
            sp = accountProviderMap.computeIfAbsent(rc.getAccountId(), k -> new PluginDBProvider());
        }
        return sp;
    }

    private PluginDBProvider() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Class<?>> getPluginClasses(String extCase, PluginFilter filter) {
        ArrayList<String[]> classList = new ArrayList<String[]>(4);
        try {
            EntityTraceSpan span = EntityTracer.create((String)this.getClass().getSimpleName(), (String)"getPluginClasses", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
            Object object = null;
            try {
                Map<Object, DynamicObject> defs;
                span.addLocaleTag("extCase", (Object)extCase);
                try (Iterator<Map.Entry<Object, DynamicObject>> ctx = LoadingExtPluginContext.setupLoad();){
                    defs = this.loadFromCache(extCase, filter);
                }
                if (defs == null || defs.isEmpty()) {
                    span.addLocaleTag("extcase.size", (Object)0);
                    ctx = Collections.emptyList();
                    return ctx;
                }
                span.addLocaleTag("extcase.size", (Object)defs.size());
                for (Map.Entry<Object, DynamicObject> entry : defs.entrySet()) {
                    DynamicObject def = entry.getValue();
                    String interfaceName = def.getString("interface");
                    DynamicObjectCollection plugins = def.getDynamicObjectCollection(ENTRY_BIZEXT_PLUGINS);
                    span.addLocaleTag(interfaceName + " - plugins.size", (Object)plugins.size());
                    for (DynamicObject plugin : plugins) {
                        String enable = plugin.getString(FIELD_PLUGINS_ENABLE);
                        boolean isSysDisable = plugin.getBoolean(FIELD_PLUGINS_SYSDISABLE);
                        String pluginType = plugin.getString("plugintype");
                        String fullName = plugin.getString(FIELD_PLUGINS_CLASS);
                        span.addLocaleTag(fullName + " - enable", (Object)enable);
                        span.addLocaleTag(fullName + " - sysEnable", (Object)(!isSysDisable ? 1 : 0));
                        span.addLocaleTag(fullName + " - pluginType", (Object)pluginType);
                        if (!StringUtils.equals((CharSequence)enable, (CharSequence)"0") && !isSysDisable && StringUtils.isNotBlank((CharSequence)fullName)) {
                            classList.add(new String[]{pluginType, interfaceName, fullName});
                            span.addLocaleTag(fullName + " - selected", (Object)true);
                            continue;
                        }
                        span.addLocaleTag(fullName + " - selected", (Object)false);
                    }
                }
            }
            catch (Throwable defs) {
                object = defs;
                throw defs;
            }
            finally {
                if (span != null) {
                    if (object != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        span.close();
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = "load plugin class config failed: " + e.getMessage();
            log.error(msg, (Throwable)e);
            if (!ignorePluginConfigError) {
                throw ExceptionUtil.asRuntimeException((String)msg, (Throwable)e);
            }
            return Collections.emptyList();
        }
        ArrayList ret = new ArrayList();
        for (String[] item : classList) {
            try {
                String pluginType = item[0];
                String interfaceName = item[1];
                String clsName = item[2];
                switch (pluginType) {
                    case "1": {
                        throw new UnsupportedOperationException("Unsupported pluginType: " + pluginType);
                    }
                    case "2": {
                        Class cls = interfaceName.contains("/") ? ScriptImplement.class : Class.forName(interfaceName);
                        ret.add(ScriptImplementFactory.defineInterface((String)clsName, (Class[])new Class[]{cls}));
                        break;
                    }
                    default: {
                        ret.add(Class.forName(clsName));
                        break;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                String msg = "load plugin class failed: " + e.getMessage();
                log.error(msg, (Throwable)e);
                if (ignorePluginConfigError) continue;
                throw ExceptionUtil.asRuntimeException((String)msg, (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    public List<String> getAOPClassNames() {
        HashSet set = new HashSet();
        String sql = "SELECT FAOPClass FROM t_sys_pluginAOP";
        for (Account account : AccountUtils.getAllAccountsOfCurrentEnv()) {
            RequestContext rc = RequestContext.create();
            rc.setAccountId(account.getAccountId());
            rc.setTenantId(account.getTenantId());
            RequestContext.set((RequestContext)rc);
            try {
                ThreadLifeCycleManager.wrapCallable(() -> DB.query((DBRoute)DBRoute.basedata, (String)sql, rs -> {
                    while (rs.next()) {
                        set.add(rs.getString(1));
                    }
                    return null;
                })).call();
            }
            catch (Exception e) {
                String msg = "load plugin aop class config failed: " + e.getMessage();
                log.error(msg, (Throwable)e);
                if (ignorePluginConfigError) continue;
                throw ExceptionUtil.asRuntimeException((String)msg, (Throwable)e);
            }
        }
        return new ArrayList<String>(set);
    }

    private Map<Object, DynamicObject> loadFromCache(String extCase, PluginFilter filter) {
        QFilter[] def_filters = new QFilter[]{new QFilter(FIELD_BIZEXT_POINT_NUMBER, "=", (Object)extCase)};
        DynamicObjectType type = this.getSimplePluginbindType();
        ArrayList idList = new ArrayList();
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        Object[] pks = cacheManager.getCachePks(def_filters);
        if (pks == null) {
            SqlBuilder builder = new SqlBuilder();
            Object[] params = new SqlParameter[]{new SqlParameter(":fnumber", 12, (Object)extCase)};
            builder.append("select fid from t_meta_bizextcase where fnumber = ?", params);
            try (DataSet ds = DB.queryDataSet((String)"PluginDBProvider.filter", (DBRoute)DBRoute.meta, (SqlBuilder)builder);){
                ds.forEach(row -> idList.add(row.get(0)));
            }
            pks = idList.toArray();
            cacheManager.putCachePks(def_filters, pks);
        }
        return BusinessDataReader.loadFromCache((Object[])pks, (DynamicObjectType)type);
    }

    private DynamicObjectType getSimplePluginbindType() {
        if (simplePluginbindType == null) {
            try {
                simplePluginbindType = (DynamicObjectType)EntityItemTypes.fromJsonString((String)subEntityTypeStr);
            }
            catch (Exception e) {
                log.info("PluginDBProvider.getSysEntityType error, msg is " + e.getMessage(), (Object)e);
                return EntityMetadataCache.getDataEntityType((String)ENTITY_BIZEXT_PLUGIN_BIND);
            }
        }
        return simplePluginbindType;
    }

    static {
        subEntityTypeStr = "{\n  \"DBRouteKey\": \"sys.meta\",\n  \"Properties\": [\n    {\"_Type_\": \"LongProp\"},\n    {\"_Type_\": \"TextProp\", \"Alias\": \"fnumber\", \"MustInput\": true, \"DisplayName\": {\"zh_CN\": \"number\"}, \"Features\": 217, \"MaxLenth\": 200, \"Name\": \"number\"},\n    {\"_Type_\": \"BigIntProp\", \"Precision\": 18, \"Alias\": \"fmasterid\", \"DisplayName\": {\"zh_CN\": \"masterid\"}, \"Features\": 217, \"Scale\": 0, \"Sys\": true, \"Name\": \"masterid\"},\n    {\"_Type_\": \"TextProp\", \"Alias\": \"finterface\", \"MustInput\": true, \"DisplayName\": {\"zh_CN\": \"interface\"}, \"Features\": 219, \"MaxLenth\": 200, \"Name\": \"interface\"},\n    {\n      \"_Type_\": \"EntryProp\",\n      \"ItemType\": {\n        \"_Type_\": \"EntryType\",\n        \"Alias\": \"t_meta_bizextplugin\",\n        \"DBRouteKey\": \"sys.meta\",\n        \"DisplayName\": {\"zh_CN\": \"entryentity\"},\n        \"Properties\": [\n          {\"_Type_\": \"LongProp\", \"Alias\": \"FEntryId\"}, \n          {\"_Type_\": \"IntegerProp\",\"Alias\": \"FSeq\",\"DisplayName\": {\"zh_CN\": \"seq\"},\"Sys\": true,\"Name\": \"seq\"}, \n          {\"_Type_\": \"TextProp\", \"Alias\": \"fpluginclass\", \"DisplayName\": {\"zh_CN\": \"pluginclass\"}, \"Features\": 219, \"MaxLenth\": 200, \"Name\": \"pluginclass\"},\n          {\"DefValue\": false, \"_Type_\": \"BooleanProp\", \"Alias\": \"fissysdisable\", \"DisplayName\": {\"zh_CN\": \"pluginissysdisable\"}, \"Features\": 219, \"Name\": \"pluginissysdisable\"},\n          {\"DefValue\": \"1\", \"_Type_\": \"BillStatusProp\", \"TableGroup\": \"S\", \"Alias\": \"fenable\", \"DisplayName\": {\"zh_CN\": \"pluginenable\"}, \"Features\": 217, \"Name\": \"pluginenable\"},\n          {\"DefValue\": \"0\", \"_Type_\": \"ComboProp\", \"Alias\": \"ftype\", \"DisplayName\": {\"zh_CN\": \"plugintype\"}, \"Features\": 219, \"Name\": \"plugintype\"}\n        ],\n        \"ExtendName\": \"entryentity\",\n        \"Name\": \"entryentity\"\n      },\n      \"DisplayName\": {\"zh_CN\": \"entryentity\"},\n      \"Name\": \"entryentity\"\n    }\n  ],\n  \"Name\": \"bos_bizextpluginbind\",\n  \"_Type_\": \"BasedataEntityType\",\n  \"Alias\": \"t_meta_bizextcase\",\n  \"DisplayName\": {\"zh_CN\": \"bos_bizextpluginbind\"},\n  \"ExtendName\": \"bos_bizextpluginbind[entryentity.seq,entryentity.pluginclass,entryentity.pluginenable,entryentity.pluginissysdisable,entryentity.plugintype,interface,masterid,number]\"\n}";
    }
}

