/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.javacode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kd.bos.javacode.entity.GroupInfogForPackage;
import kd.bos.javacode.entity.PackageInfoForFileInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AnalysisXmlforgroupInfo {
    private static final Log logger = LogFactory.getLog(AnalysisXmlforgroupInfo.class);
    private static DocumentBuilderFactory dbFactory;
    private static DocumentBuilder db;
    private static Document document;
    private static List<GroupInfogForPackage> infos;
    public static final String APPGROUPFILE = "D:\\testfile\\appforgroup.xml";

    public static List<GroupInfogForPackage> getGroupInfopackage(String fileName) throws SAXException, IOException {
        document = db.parse(fileName);
        HashMap<String, String> properties = new HashMap<String, String>(16);
        HashSet<String> propname = new HashSet<String>(16);
        NodeList propertyList = document.getElementsByTagName("property");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            Node node = propertyList.item(i);
            NamedNodeMap propertydNodeMap = node.getAttributes();
            String name = propertydNodeMap.getNamedItem("name").getTextContent();
            propname.add(name);
            String value = propertydNodeMap.getNamedItem("value").getTextContent();
            properties.put(name, value);
        }
        NodeList groupList = document.getElementsByTagName("group");
        infos = new ArrayList<GroupInfogForPackage>();
        for (int j = 0; j < groupList.getLength(); ++j) {
            GroupInfogForPackage groupInfogForPackage = new GroupInfogForPackage();
            Node node2 = groupList.item(j);
            NamedNodeMap groupdNodeMap = node2.getAttributes();
            String group = groupdNodeMap.getNamedItem("name").getTextContent();
            groupInfogForPackage.setName(group);
            NodeList gList = node2.getChildNodes();
            ArrayList<PackageInfoForFileInfo> packageInfos = new ArrayList<PackageInfoForFileInfo>(10);
            for (int k = 1; k < gList.getLength(); k += 2) {
                PackageInfoForFileInfo packageInfo = new PackageInfoForFileInfo();
                Node gnode = gList.item(k);
                NamedNodeMap pkNodeMap = gnode.getAttributes();
                String packagename = pkNodeMap.getNamedItem("name").getTextContent();
                packageInfo.setName(packagename);
                NodeList pList = gnode.getChildNodes();
                ArrayList<Map<String, String>> fileInfos = new ArrayList<Map<String, String>>(10);
                for (int l = 1; l < pList.getLength(); l += 2) {
                    HashMap<String, String> fileInfo = new HashMap<String, String>();
                    Node pNode = pList.item(l);
                    NamedNodeMap fileNodeMap = pNode.getAttributes();
                    String filedir = fileNodeMap.getNamedItem("dir").getTextContent();
                    String beforefiledir = fileNodeMap.getNamedItem("beforedir").getTextContent();
                    for (String p : propname) {
                        if (filedir.contains(p)) {
                            filedir = filedir.replace("${" + p + "}", (CharSequence)properties.get(p));
                        }
                        if (!beforefiledir.contains(p)) continue;
                        beforefiledir = beforefiledir.replace("${" + p + "}", (CharSequence)properties.get(p));
                    }
                    fileInfo.put(beforefiledir, filedir);
                    fileInfos.add(fileInfo);
                }
                packageInfo.setFileset(fileInfos);
                packageInfos.add(packageInfo);
            }
            groupInfogForPackage.setPackageInfos(packageInfos);
            infos.add(groupInfogForPackage);
        }
        return infos;
    }

    public static void main(String[] args) {
        String fileName = APPGROUPFILE;
        try {
            List<GroupInfogForPackage> list = AnalysisXmlforgroupInfo.getGroupInfopackage(fileName);
            for (GroupInfogForPackage groupInfogForPackage : list) {
                logger.info((Object)groupInfogForPackage);
            }
        }
        catch (Exception e) {
            logger.info((Object)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\u8bfb\u53d6\u5931\u8d25");
        }
    }

    static {
        try {
            dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            db = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

