/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.toolkit.utils;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import kd.bos.toolkit.utils.SerializationUtils;
import kd.bos.toolkit.utils.StringUtils;
import kd.bos.unittest.build.HttpClientKeepCookiesUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpUtils {
    private static final String ACCOUNT_ID = "accountId";
    private static final String USERTYPE = "usertype";
    private static Log logger = LogFactory.getLog(HttpUtils.class);

    public static boolean doLogin(HttpClientKeepCookiesUtils httpObj, String url, String appId, String appSecuret, String tenantId, String accountId, String user, String usertype, String appLang) throws IOException {
        String apptoken = HttpUtils.doGetAppToken(httpObj, url, appId, appSecuret, tenantId, accountId, appLang);
        boolean bRet = false;
        if (apptoken == null) {
            logger.error((Object)"app_token is null");
            return bRet;
        }
        String strLoginCheckApiUrl = url + "api/login.do";
        HashMap<String, String> body = new HashMap<String, String>();
        if (tenantId != null) {
            body.put("tenantid", tenantId);
        }
        if (user != null) {
            body.put("user", user);
        }
        if (accountId != null) {
            body.put(ACCOUNT_ID, accountId);
        }
        if (apptoken != null) {
            body.put("apptoken", apptoken);
        }
        if (usertype != null) {
            body.put(USERTYPE, usertype);
        } else {
            body.put(USERTYPE, "Mobile");
        }
        String loginBody = SerializationUtils.toJsonString(body);
        logger.info((Object)("\u51c6\u5907\u767b\u5f55\u670d\u52a1(ApiUrl:" + StringUtils.filterLog(strLoginCheckApiUrl) + ")," + StringUtils.filterLog(loginBody)));
        bRet = httpObj.login(strLoginCheckApiUrl, loginBody);
        logger.info((Object)("\u767b\u5f55\u670d\u52a1\u8fd4\u56de\u81f3\uff1a" + StringUtils.filterLog(httpObj.getLoginResult())));
        if (!bRet) {
            logger.error((Object)StringUtils.filterLog(httpObj.getLoginResult()));
        }
        return bRet;
    }

    public static String doGetAppToken(HttpClientKeepCookiesUtils httpObj, String url, String appId, String appSecuret, String tenantId, String accountId, String appLang) throws IOException {
        String strApiUrl = url + "api/getAppToken.do";
        HashMap<String, String> body = new HashMap<String, String>();
        if (appId != null) {
            body.put("appId", appId);
        } else {
            body.put("appId", "unittest");
        }
        if (appSecuret != null) {
            body.put("appSecuret", appSecuret);
        } else {
            body.put("appSecuret", "Kingdee@2018");
        }
        if (tenantId != null) {
            body.put("tenantid", tenantId);
        }
        if (accountId != null) {
            body.put(ACCOUNT_ID, accountId);
        }
        if (appLang != null) {
            body.put("language", appLang);
        } else {
            body.put("language", "zh_CN");
        }
        String loginBody = SerializationUtils.toJsonString(body);
        logger.info((Object)("\u51c6\u5907\u767b\u5f55\u670d\u52a1\u524d\u83b7\u53d6AppToken.(ApiUrl:" + StringUtils.filterLog(strApiUrl) + ")," + StringUtils.filterLog(loginBody)));
        String bRet = httpObj.postJson(strApiUrl, null, loginBody);
        logger.info((Object)("\u83b7\u53d6AppToken\u8fd4\u56de\u503c\uff1a" + StringUtils.filterLog(bRet)));
        String app_token = null;
        try {
            Map mapRet = (Map)SerializationUtils.fromJsonString(bRet, Map.class);
            if (mapRet.get("state").equals("success")) {
                Map mapRetData = (Map)mapRet.get("data");
                app_token = (String)mapRetData.get("app_token");
            } else {
                logger.error((Object)("\u83b7\u53d6AppToken\u5931\u8d25\uff0c\u8fd4\u56de\u503c\uff1a" + StringUtils.filterLog(bRet)));
            }
        }
        catch (Exception e) {
            logger.error((Object)("getAppToken.do\u8c03\u7528\u5931\u8d25\uff0c\u8fd4\u56de\u503c\uff1a" + StringUtils.filterLog(bRet)));
            throw new RuntimeException(e);
        }
        return app_token;
    }

    public static String DoDeployWebApi(CommandLine cmd) {
        String ret = null;
        HttpClientKeepCookiesUtils httpObj = new HttpClientKeepCookiesUtils();
        try {
            String language;
            String appSecuret;
            String hostUrl = cmd.getOptionValue("hostUrl");
            if (!hostUrl.endsWith("/")) {
                hostUrl = hostUrl + "/";
            }
            String user = cmd.getOptionValue("userId");
            String accountId = cmd.getOptionValue(ACCOUNT_ID);
            String tenantId = cmd.getOptionValue("tenantId");
            String usertype = cmd.getOptionValue(USERTYPE);
            String appId = cmd.getOptionValue("appNumber");
            if (HttpUtils.doLogin(httpObj, hostUrl, appId, appSecuret = cmd.getOptionValue("appPwd"), tenantId, accountId, user, usertype, language = cmd.getOptionValue("appLang"))) {
                String htype = cmd.getOptionValue("htype");
                String params = cmd.getOptionValue("params");
                String suburl = cmd.getOptionValue("suburl");
                if (htype.equalsIgnoreCase("get")) {
                    ret = HttpUtils.DoGetDeploy(httpObj, hostUrl, cmd, params, suburl);
                } else if (htype.equalsIgnoreCase("post")) {
                    ret = HttpUtils.DoPostDeploy(httpObj, hostUrl, cmd, params, suburl);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    private static String DoGetDeploy(HttpClientKeepCookiesUtils httpObj, String hostUrl, CommandLine cmd, String params, String suburl) throws IOException {
        String strDoDeploy = hostUrl + suburl + "?body=" + URLEncoder.encode(params) + "&access_token=" + httpObj.getAccessToken();
        HashMap<String, String> head = new HashMap<String, String>();
        head.put("Content-Type", "Application/Json;charset=utf-8");
        logger.info((Object)("\u8bf7\u6c42API\uff1a" + StringUtils.filterLog(strDoDeploy)));
        String ret = httpObj.get(strDoDeploy, head);
        logger.info((Object)("\u8fd4\u56de\u7ed3\u679c\uff1a" + StringUtils.filterLog(ret)));
        return ret;
    }

    private static String DoPostDeploy(HttpClientKeepCookiesUtils httpObj, String hostUrl, CommandLine cmd, String params, String suburl) throws IOException {
        String strDoDeploy = hostUrl + suburl + "?access_token=" + httpObj.getAccessToken();
        HashMap<String, String> head = new HashMap<String, String>();
        head.put("Content-Type", "Application/Json;charset=utf-8");
        logger.info((Object)("\u8bf7\u6c42API\uff1a" + StringUtils.filterLog(strDoDeploy)));
        String ret = httpObj.postJson(strDoDeploy, head, params);
        logger.info((Object)("\u8fd4\u56de\u7ed3\u679c\uff1a" + StringUtils.filterLog(ret)));
        return ret;
    }
}

