/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.toolkit.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SerializationUtils {
    private static ObjectMapper omap;
    private static ObjectMapper omap2;
    private static final Log logger;

    public static <T> T fromJsonString(String content, Class<?> valueType) {
        try {
            return (T)omap.readValue(content, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<? extends Object> fromJsonStringToList(String content, Class<?> itemType) {
        JavaType valueType = omap.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{itemType});
        try {
            return (List)omap.readValue(content, valueType);
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJsonString(Object o) {
        return SerializationUtils.toJsonString(o, true);
    }

    public static String toJsonString(Object o, boolean inclusionNON_NULL) {
        String result = null;
        ObjectMapper om = inclusionNON_NULL ? omap2 : omap;
        try {
            result = om.writeValueAsString(o);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String intArrayToString(byte[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(array.length * 3);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static byte[] stringToIntArray(String arrayString) {
        ArrayList<Byte> list = new ArrayList<Byte>(Math.max(arrayString.length() / 3, 1));
        for (String item : arrayString.split("[,]", -1)) {
            list.add(Byte.parseByte(item));
        }
        byte[] rets = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            rets[i] = (Byte)list.get(i);
        }
        return rets;
    }

    public static byte[] toByte(Object o) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream baos = null;
        byte[] bytes = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            bytes = baos.toByteArray();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return bytes;
    }

    public static Object fromByte(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = null;
        bais = new ByteArrayInputStream(bytes);
        Object obRet = null;
        ObjectInputStream ois = new ObjectInputStream(bais);
        obRet = ois.readObject();
        return obRet;
    }

    static {
        logger = LogFactory.getLog(SerializationUtils.class);
        omap = new ObjectMapper();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"){
            private static final long serialVersionUID = 1L;
            private SimpleDateFormat shortSDF = new SimpleDateFormat("yyyy-MM-dd");

            @Override
            public Date parse(String source) throws ParseException {
                if (source == null) {
                    return null;
                }
                if (source.length() <= 10) {
                    return this.shortSDF.parse(source);
                }
                return super.parse(source);
            }
        };
        omap.setDateFormat((DateFormat)sdf);
        omap.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        omap2 = new ObjectMapper();
        omap2.setDateFormat((DateFormat)sdf);
        omap2.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        omap2.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

