/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.toolkit.utils;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringUtils {
    private static final Log logger = LogFactory.getLog(StringUtils.class);
    private static final String[] empty_string_array = new String[0];
    private static final char DOT = '.';
    private static final String KONG = "";

    private StringUtils() {
    }

    public static boolean isEmpty(String string) {
        return StringUtils.isNull(string) || StringUtils.isBlank(string);
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static String getEmpty() {
        return KONG;
    }

    public static boolean isNull(String string) {
        return string == null;
    }

    public static boolean isNotNull(String string) {
        return !StringUtils.isNull(string);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(Object cs) {
        return cs == null ? true : StringUtils.isBlank(cs.toString());
    }

    public static boolean isNumericString(String str) {
        boolean isNumericString = false;
        if (str != null) {
            isNumericString = true;
            for (int i = 0; i < str.length(); ++i) {
                if (Character.isDigit(str.charAt(i))) continue;
                isNumericString = false;
                break;
            }
        }
        return isNumericString;
    }

    public static boolean isNumeric(String str) {
        int last;
        int index;
        boolean isNumeric = false;
        if (str != null && (index = str.indexOf(46)) == (last = str.lastIndexOf(46))) {
            String tempString = str.replace(".", KONG);
            isNumeric = StringUtils.isNumericString(tempString);
        }
        return isNumeric;
    }

    public static String trim(String string) {
        if (StringUtils.isNull(string)) {
            return StringUtils.getEmpty();
        }
        return string.trim();
    }

    public static String[] split(String value, boolean withoutEmpty, char ... delim) {
        String[] stringArray;
        if (value == null || value.length() == 0) {
            if (withoutEmpty) {
                return empty_string_array;
            }
            return new String[]{KONG};
        }
        if (delim.length > 0) {
            ArrayList<String> ret = new ArrayList<String>();
            String split = KONG + delim;
            char[] chs = value.toCharArray();
            StringBuilder token = new StringBuilder();
            int n = chs.length;
            for (int i = 0; i < n; ++i) {
                char ch = chs[i];
                if (split.indexOf(ch) != -1) {
                    if (withoutEmpty) {
                        String s = token.toString().trim();
                        if (s.length() > 0) {
                            ret.add(s);
                        }
                    } else {
                        ret.add(token.toString());
                    }
                    token.setLength(0);
                    continue;
                }
                token.append(ch);
            }
            if (split.indexOf(chs[chs.length - 1]) != -1) {
                if (!withoutEmpty) {
                    ret.add(KONG);
                }
            } else if (withoutEmpty) {
                String s = token.toString().trim();
                if (s.length() > 0) {
                    ret.add(s);
                }
            } else {
                ret.add(token.toString());
            }
            return ret.toArray(new String[ret.size()]);
        }
        String tempV = null;
        if (withoutEmpty) {
            tempV = value.trim();
        }
        if (tempV == null || tempV.length() == 0) {
            stringArray = empty_string_array;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = tempV;
        }
        return stringArray;
    }

    public static String filterLog(String content) {
        ArrayList<String> filterList = new ArrayList<String>(10);
        filterList.add("%0d");
        filterList.add("%0D");
        filterList.add("%0a");
        filterList.add("%0A");
        filterList.add("\r");
        filterList.add("\n");
        for (String item : filterList) {
            content = content.replace(item, KONG);
        }
        return content;
    }
}

