/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.build;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.toolkit.utils.HttpUtils;
import kd.bos.toolkit.utils.SerializationUtils;
import kd.bos.toolkit.utils.StringUtils;
import kd.bos.unittest.coverage.APPCodeCoverageReturnData;
import kd.bos.unittest.coverage.UnitCaseReportViewByGroudNameBean;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class APPCodeCoverageDataToWebApiServer {
    private static final Log logger = LogFactory.getLog(APPCodeCoverageDataToWebApiServer.class);

    public static void main(String[] args) throws ParseException, IOException {
        Options options = new Options();
        options.addOption("hostUrl", true, "");
        options.addOption("tenantId", true, "");
        options.addOption("userId", true, "");
        options.addOption("appId", true, "");
        options.addOption("accountId", true, "");
        options.addOption("usertype", true, "");
        options.addOption("htype", true, "");
        options.addOption("appNumber", true, "");
        options.addOption("appPwd", true, "");
        options.addOption("html", true, "");
        options.addOption("suburl", true, "");
        options.addOption("datetime", true, "");
        options.addOption("featurename", true, "");
        options.addOption("params", true, "");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        String html = cmd.getOptionValue("html");
        String featureInfo = cmd.getOptionValue("featurename");
        String appId = cmd.getOptionValue("appId");
        logger.info((Object)StringUtils.filterLog("\u4f20\u5165\u53c2\u6570\uff1a" + SerializationUtils.toJsonString(args)));
        logger.info((Object)("1\u3001\u5f00\u59cb\u89e3\u6790" + html + "\u6587\u4ef6\uff0c\u83b7\u53d6\u4ee3\u7801\u8986\u76d6\u7387\u7edf\u8ba1\u4fe1\u606f\u3002"));
        List<UnitCaseReportViewByGroudNameBean> datas = APPCodeCoverageDataToWebApiServer.analysisHtmlToObject(html, featureInfo, appId);
        logger.info((Object)("2\u3001\u89e3\u6790\u540e\u6570\u636e" + Arrays.toString(datas.toArray())));
        for (UnitCaseReportViewByGroudNameBean data : datas) {
            APPCodeCoverageReturnData appData = new APPCodeCoverageReturnData();
            appData.setData(data);
            String strdata = SerializationUtils.toJsonString(appData);
            logger.info((Object)"\u5f00\u59cb\u4e0a\u4f20\u7edf\u8ba1\u4fe1\u606f\u5230\u670d\u52a1\u5668");
            int length = args.length;
            String[] argsNew = new String[length + 2];
            System.arraycopy(args, 0, argsNew, 0, length);
            argsNew[argsNew.length - 2] = "-params";
            argsNew[argsNew.length - 1] = strdata;
            cmd = parser.parse(options, argsNew);
            String ret = HttpUtils.DoDeployWebApi(cmd);
            Map retApi = (Map)SerializationUtils.fromJsonString(ret, Map.class);
            if (retApi.get("success").equals("true")) {
                logger.info((Object)("\u606d\u559c,\u4e0a\u4f20\u6570\u636e\u6210\u529f,\u8fd4\u56de\u503c\uff1a" + StringUtils.filterLog(ret)));
                continue;
            }
            if (retApi.get("data") != null) {
                if (((Map)retApi.get("data")).get("success").equals(Boolean.TRUE)) {
                    logger.info((Object)("\u606d\u559c,\u4e0a\u4f20\u6570\u636e\u6210\u529f,\u8fd4\u56de\u503c\uff1a" + StringUtils.filterLog(ret)));
                    continue;
                }
                logger.error((Object)("\u4e0a\u4f20\u6570\u636e\u5931\u8d25\uff0c\u9519\u8bef\u5185\u5bb9\uff1a" + StringUtils.filterLog(ret)));
                System.exit(1);
                continue;
            }
            logger.error((Object)("\u4e0a\u4f20\u6570\u636e\u5931\u8d25\uff0c\u9519\u8bef\u5185\u5bb9\uff1a" + StringUtils.filterLog(ret)));
            System.exit(1);
        }
    }

    public static List<UnitCaseReportViewByGroudNameBean> analysisHtmlToObject(String html, String featureInfo, String appId) throws IOException {
        Elements docTbodyTrList;
        Element tableEle;
        Elements docTbodys;
        ArrayList<UnitCaseReportViewByGroudNameBean> groudInfos = new ArrayList<UnitCaseReportViewByGroudNameBean>();
        File input = new File(html);
        Document doc = Jsoup.parse((File)input, (String)"UTF-8");
        Elements docTable = doc.getElementsByTag("table");
        if (!(docTable.isEmpty() || (docTbodys = (tableEle = (Element)docTable.get(0)).getElementsByTag("tbody")).isEmpty() || (docTbodyTrList = ((Element)docTbodys.get(0)).getElementsByTag("tr")).isEmpty())) {
            for (Element docTbody_Tr : docTbodyTrList) {
                UnitCaseReportViewByGroudNameBean groudInfo = new UnitCaseReportViewByGroudNameBean();
                groudInfo.setFeatureName(featureInfo);
                groudInfo.setName("");
                groudInfo.setAppId(appId);
                groudInfo.setCodecoverline(0L);
                groudInfo.setCodeline(0L);
                groudInfo.setCoverage("");
                Elements docTbodyTrTdList = docTbody_Tr.getElementsByTag("td");
                if (!docTbodyTrTdList.isEmpty()) {
                    if (!StringUtils.isEmpty(((Element)docTbodyTrTdList.get(0)).text())) {
                        groudInfo.setName(((Element)docTbodyTrTdList.get(0)).text());
                    } else {
                        groudInfo.setName("\u672a\u77e5\u7ec4\u540d");
                    }
                    String missed = ((Element)docTbodyTrTdList.get(7)).text().replace(",", "");
                    String lines = ((Element)docTbodyTrTdList.get(8)).text().replace(",", "");
                    groudInfo.setCodeline(Integer.parseInt(lines));
                    groudInfo.setCodecoverline(Long.parseLong(lines) - Long.parseLong(missed));
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setMaximumFractionDigits(2);
                    String rate = numberFormat.format((Float.parseFloat(lines) - Float.parseFloat(missed)) / Float.parseFloat(lines) * 100.0f);
                    groudInfo.setCoverage(rate);
                }
                groudInfos.add(groudInfo);
            }
        }
        return groudInfos;
    }
}

