/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.toolkit.utils.HttpUtils;
import kd.bos.toolkit.utils.SerializationUtils;
import kd.bos.toolkit.utils.StringUtils;
import kd.bos.unittest.build.HttpClientKeepCookiesUtils;
import kd.bos.unittest.coverage.AllUnitCaseReportViewByGroudNameBean;
import kd.bos.unittest.coverage.UnitCaseReportViewByGroudNameBean;
import kd.bos.unittest.coverage.UnittestReportData;
import kd.bos.unittest.unit.XmlHelper;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ExecutionDataToWebApiServer {
    private static final Log logger = LogFactory.getLog(ExecutionDataToWebApiServer.class);

    public static void main(String[] args) throws ParseException, IOException {
        Options options = new Options();
        options.addOption("hostUrl", true, "");
        options.addOption("tenantId", true, "");
        options.addOption("userId", true, "");
        options.addOption("appId", true, "");
        options.addOption("accountId", true, "");
        options.addOption("usertype", true, "");
        options.addOption("appNumber", true, "");
        options.addOption("appPwd", true, "");
        options.addOption("appLang", true, "");
        options.addOption("params", true, "");
        options.addOption("htype", true, "");
        options.addOption("html", true, "");
        options.addOption("suburl", true, "");
        options.addOption("txtpath", true, "");
        options.addOption("txtfilter", true, "");
        options.addOption("appgroupxmlpath", true, "appNameToID.xml");
        options.addOption("datetime", true, "");
        options.addOption("unitRepotUrl", true, "\u5355\u5143\u6d4b\u8bd5\u62a5\u544a\u5e73\u53f0\u5730\u5740");
        options.addOption("coverType", true, "junit/ui");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        String html = cmd.getOptionValue("html");
        String unitRepotUrl = cmd.getOptionValue("unitRepotUrl");
        String coverType = cmd.getOptionValue("coverType");
        String feature = cmd.getOptionValue("txtfilter");
        logger.info((Object)StringUtils.filterLog("\u4f20\u5165\u53c2\u6570\uff1a" + SerializationUtils.toJsonString(args)));
        logger.info((Object)("1\u3001\u5f00\u59cb\u89e3\u6790" + html + "\u6587\u4ef6\uff0c\u83b7\u53d6\u4ee3\u7801\u8986\u76d6\u7387\u7edf\u8ba1\u4fe1\u606f\u3002"));
        AllUnitCaseReportViewByGroudNameBean data = ExecutionDataToWebApiServer.analysisHtmlToObject(html);
        data.setCoverType(coverType);
        data.setFeature(feature);
        String strdata = SerializationUtils.toJsonString(data);
        logger.info((Object)("\u89e3\u6790html\u540e\u7684\u7ed3\u679c\u5185\u5bb9\uff1a" + strdata));
        String txtpath = cmd.getOptionValue("txtpath");
        String txtfilter = cmd.getOptionValue("txtfilter");
        logger.info((Object)("2\u3001\u5f00\u59cb\u89e3\u6790" + txtpath + "\u8def\u5f84\u4e0b\u540d\u79f0\u5305\u542b" + txtfilter + "\u7684\u6587\u4ef6\uff0c\u83b7\u53d6\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b\u7edf\u8ba1\u4fe1\u606f\u3002"));
        HashMap<String, UnitCaseReportViewByGroudNameBean> mapRet = new HashMap();
        try {
            String appGroupXmlPath = cmd.getOptionValue("appgroupxmlpath");
            XmlHelper xml = new XmlHelper(appGroupXmlPath);
            Map<String, Object> appList = xml.xmlToAppList();
            mapRet = ExecutionDataToWebApiServer.analysisTxtsToObject(txtpath, txtfilter, appList);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        logger.info((Object)("\u89e3\u6790txt\u540e\u7684\u7ed3\u679c\u5185\u5bb9\uff1a" + SerializationUtils.toJsonString(mapRet)));
        logger.info((Object)"3\u3001\u5f00\u59cb\u5408\u5e76html&txt\u89e3\u6790\u7684\u7ed3\u679c");
        ExecutionDataToWebApiServer.mergeAnalysis(data, mapRet);
        String datetime = cmd.getOptionValue("datetime");
        if (datetime != null && !datetime.isEmpty()) {
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date date = sDateFormat.parse(datetime);
                data.setReportdatetime(date);
            }
            catch (Exception e) {
                logger.warn((Object)("\u81ea\u5b9a\u4e49\u62a5\u544a\u65e5\u671f\u5931\u6548\uff0c\u9519\u8bef\u539f\u56e0 \uff1a" + e.getMessage()));
            }
        }
        logger.info((Object)("\u5408\u5e76\u540e\u7684\u7ed3\u679c\u5185\u5bb9\uff1a" + SerializationUtils.toJsonString(data)));
        UnittestReportData report = new UnittestReportData();
        report.setData(data);
        String strReport = SerializationUtils.toJsonString(report);
        logger.info((Object)("\u7edf\u8ba1\u5e76\u7ec4\u88c5\u62a5\u544a\u4fe1\u606f\u5b8c\u6bd5,\u5185\u5bb9\uff1a" + strReport));
        int length = args.length;
        String[] argsNew = new String[length + 2];
        System.arraycopy(args, 0, argsNew, 0, length);
        argsNew[argsNew.length - 2] = "-params";
        argsNew[argsNew.length - 1] = strReport;
        cmd = parser.parse(options, argsNew);
        logger.info((Object)"\u5f00\u59cb\u4e0a\u4f20\u7edf\u8ba1\u4fe1\u606f\u5230\u670d\u52a1\u5668");
        String ret = HttpUtils.DoDeployWebApi(cmd);
        Map retApi = (Map)SerializationUtils.fromJsonString(ret, Map.class);
        if ("true".equals(retApi.get("success"))) {
            logger.info((Object)("\u606d\u559c,\u4e0a\u4f20\u6570\u636e\u6210\u529f,\u8fd4\u56de\u503c\uff1a" + StringUtils.filterLog(ret)));
        } else if (retApi.get("data") != null) {
            if (((Map)retApi.get("data")).get("success").equals(Boolean.TRUE)) {
                logger.info((Object)("\u606d\u559c,\u4e0a\u4f20\u6570\u636e\u6210\u529f,\u8fd4\u56de\u503c\uff1a" + StringUtils.filterLog(ret)));
            } else {
                logger.error((Object)("\u4e0a\u4f20\u6570\u636e\u5931\u8d25\uff0c\u9519\u8bef\u5185\u5bb9\uff1a" + StringUtils.filterLog(ret)));
                System.exit(1);
            }
        } else {
            logger.error((Object)("\u4e0a\u4f20\u6570\u636e\u5931\u8d25\uff0c\u9519\u8bef\u5185\u5bb9\uff1a" + StringUtils.filterLog(ret)));
            System.exit(1);
        }
        if (StringUtils.isNotEmpty(unitRepotUrl)) {
            try {
                logger.info((Object)"\u5f00\u59cb\u4e0a\u4f20\u8986\u76d6\u7387\u5230\u5355\u5143\u6d4b\u8bd5\u62a5\u544a\u5e73\u53f0");
                HttpClientKeepCookiesUtils httpClientKeepCookiesUtils = new HttpClientKeepCookiesUtils();
                HashMap<String, String> header = new HashMap<String, String>();
                String s = httpClientKeepCookiesUtils.postJson(unitRepotUrl, header, strdata);
                logger.info((Object)("\u4e0a\u4f20\u8986\u76d6\u7387\u5230\u5355\u5143\u6d4b\u8bd5\u62a5\u544a\u5e73\u53f0\u8fd4\u56de\uff1a" + StringUtils.filterLog(s)));
            }
            catch (Exception e) {
                logger.error((Object)("\u4e0a\u4f20\u5355\u5143\u6d4b\u8bd5\u62a5\u544a\u5e73\u53f0\u5931\u8d25\uff0c\u9519\u8bef\u5185\u5bb9:" + e));
            }
        }
    }

    public static AllUnitCaseReportViewByGroudNameBean analysisHtmlToObject(String html) throws IOException {
        AllUnitCaseReportViewByGroudNameBean tempTotal = new AllUnitCaseReportViewByGroudNameBean();
        File input = new File(html);
        Document doc = Jsoup.parse((File)input, (String)"UTF-8");
        Elements docTable = doc.getElementsByTag("table");
        if (!docTable.isEmpty()) {
            Elements docTbodyTrList;
            Elements docTbodys;
            Elements docTfootsTrList;
            Element tableEle = (Element)docTable.get(0);
            Elements docTfoots = tableEle.getElementsByTag("tfoot");
            if (!docTfoots.isEmpty() && !(docTfootsTrList = ((Element)docTfoots.get(0)).getElementsByTag("tr")).isEmpty()) {
                tempTotal.setAlldefinedcase(0L);
                tempTotal.setAllpassrate("0");
                tempTotal.setAlltimespend("0");
                tempTotal.setAllcase(0L);
                tempTotal.setAllcodeline(0L);
                tempTotal.setAllcodecoverline(0L);
                tempTotal.setAllcoverage("0");
                tempTotal.setAllMethods(0L);
                tempTotal.setAllCoveredMethods(0L);
                tempTotal.setAllMethodCoverageRatio("0");
                tempTotal.setAllBranchesCoverageRatio("0");
                tempTotal.setReportdatetime(new Date());
                Elements docTfootsTrTdList = ((Element)docTfootsTrList.get(0)).getElementsByTag("td");
                if (!docTfootsTrTdList.isEmpty()) {
                    String missed = ((Element)docTfootsTrTdList.get(7)).text().replace(",", "");
                    String lines = ((Element)docTfootsTrTdList.get(8)).text().replace(",", "");
                    tempTotal.setAllcodeline(Integer.parseInt(lines));
                    tempTotal.setAllcodecoverline(Long.parseLong(lines) - Long.parseLong(missed));
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setMaximumFractionDigits(2);
                    String rate = numberFormat.format((Float.parseFloat(lines) - Float.parseFloat(missed)) / Float.parseFloat(lines) * 100.0f);
                    tempTotal.setAllcoverage(rate);
                    String missedMethods = ((Element)docTfootsTrTdList.get(9)).text().replace(",", "");
                    String allMethods = ((Element)docTfootsTrTdList.get(10)).text().replace(",", "");
                    tempTotal.setAllMethods(Integer.parseInt(allMethods));
                    tempTotal.setAllCoveredMethods(Long.parseLong(allMethods) - Long.parseLong(missedMethods));
                    String methodRatio = numberFormat.format((Float.parseFloat(allMethods) - Float.parseFloat(missedMethods)) / Float.parseFloat(allMethods) * 100.0f);
                    tempTotal.setAllMethodCoverageRatio(methodRatio);
                    tempTotal.setAllBranchesCoverageRatio(ExecutionDataToWebApiServer.getBranchCoverage(docTfootsTrTdList));
                }
            }
            if (!(docTbodys = tableEle.getElementsByTag("tbody")).isEmpty() && !(docTbodyTrList = ((Element)docTbodys.get(0)).getElementsByTag("tr")).isEmpty()) {
                for (Element docTbodyTr : docTbodyTrList) {
                    UnitCaseReportViewByGroudNameBean temp = new UnitCaseReportViewByGroudNameBean();
                    temp.setCases(0L);
                    temp.setPassrate("0");
                    temp.setTimespend(0L);
                    temp.setDefinedcases(0L);
                    temp.setSuccesscases(0L);
                    temp.setCodecoverline(0L);
                    temp.setCoveredMethods(0L);
                    temp.setBranchCoverageRatio("0");
                    Elements docTbodyTrTdList = docTbodyTr.getElementsByTag("td");
                    if (docTbodyTrTdList.isEmpty()) continue;
                    if (!StringUtils.isEmpty(((Element)docTbodyTrTdList.get(0)).text())) {
                        temp.setName(((Element)docTbodyTrTdList.get(0)).text());
                    } else {
                        temp.setName("\u672a\u77e5\u7ec4\u540d");
                    }
                    temp.setBranchCoverageRatio(ExecutionDataToWebApiServer.getBranchCoverage(docTbodyTrTdList));
                    String missed = ((Element)docTbodyTrTdList.get(7)).text().replace(",", "");
                    String lines = ((Element)docTbodyTrTdList.get(8)).text().replace(",", "");
                    temp.setCodeline(Integer.parseInt(lines));
                    temp.setCodecoverline(Long.parseLong(lines) - Long.parseLong(missed));
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setMaximumFractionDigits(2);
                    String rate = "0";
                    if (!"0".equals(lines)) {
                        rate = numberFormat.format((Float.parseFloat(lines) - Float.parseFloat(missed)) / Float.parseFloat(lines) * 100.0f);
                    }
                    temp.setCoverage(rate);
                    String missedMethods = ((Element)docTbodyTrTdList.get(9)).text().replace(",", "");
                    String allMethods = ((Element)docTbodyTrTdList.get(10)).text().replace(",", "");
                    temp.setMethods(Integer.parseInt(allMethods));
                    temp.setCoveredMethods(Long.parseLong(allMethods) - Long.parseLong(missedMethods));
                    if (!"0".equals(allMethods)) {
                        rate = numberFormat.format((Float.parseFloat(allMethods) - Float.parseFloat(missedMethods)) / Float.parseFloat(allMethods) * 100.0f);
                    }
                    temp.setMethodCoverageRatio(rate);
                    tempTotal.getGroupentity().add(temp);
                }
            }
        }
        logger.info((Object)((Element)docTable.get(0)).toString());
        return tempTotal;
    }

    private static String getBranchCoverage(Elements elements) {
        String branchesCoverage = ((Element)elements.get(4)).text().replace(",", "").replace("%", "");
        return "n/a".equals(branchesCoverage) ? "0" : branchesCoverage;
    }

    public static Map<String, UnitCaseReportViewByGroudNameBean> analysisTxtsToObject(String txtpath, String txtfilter, Map<String, Object> appList) {
        HashMap<String, UnitCaseReportViewByGroudNameBean> mapRet = new HashMap<String, UnitCaseReportViewByGroudNameBean>();
        File fd = new File(txtpath);
        if (fd.exists()) {
            if (fd.isDirectory()) {
                FilenameFilter filter = (dir, name) -> name.contains(txtfilter) && name.endsWith(".txt");
                File[] files = fd.listFiles(filter);
                for (File fl : files) {
                    ExecutionDataToWebApiServer.analysisTxtsToObject(fl, mapRet, appList);
                }
                for (Map.Entry entry : mapRet.entrySet()) {
                    UnitCaseReportViewByGroudNameBean bean = (UnitCaseReportViewByGroudNameBean)entry.getValue();
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setMaximumFractionDigits(2);
                    String rate = "0.00";
                    if (bean.getSuccesscases() > 0L) {
                        rate = numberFormat.format((float)bean.getSuccesscases() / (float)bean.getCases() * 100.0f);
                    }
                    bean.setPassrate(rate);
                }
            } else {
                logger.error((Object)(txtpath + " \u4e0d\u662f\u76ee\u5f55"));
            }
        } else {
            logger.error((Object)(txtpath + " \u76ee\u5f55\u4e0d\u5b58\u5728"));
        }
        return mapRet;
    }

    public static void mergeAnalysis(AllUnitCaseReportViewByGroudNameBean data, Map<String, UnitCaseReportViewByGroudNameBean> mapRet) {
        List<UnitCaseReportViewByGroudNameBean> groupList = data.getGroupentity();
        long allTimespend = 0L;
        for (UnitCaseReportViewByGroudNameBean groupFromHtml : groupList) {
            String groupName = groupFromHtml.getName();
            UnitCaseReportViewByGroudNameBean groupFromTxt = mapRet.get(groupName);
            if (groupFromTxt == null) continue;
            groupFromHtml.setCases(groupFromTxt.getCases());
            groupFromHtml.setDefinedcases(groupFromTxt.getDefinedcases());
            groupFromHtml.setSuccesscases(groupFromTxt.getSuccesscases());
            groupFromHtml.setPassrate(groupFromTxt.getPassrate());
            groupFromHtml.setTimespend(groupFromTxt.getTimespend());
            data.setAllcase(data.getAllcase() + groupFromTxt.getCases());
            data.setAlldefinedcase(data.getAlldefinedcase() + groupFromTxt.getDefinedcases());
            data.setAllsuccesscase(data.getAllsuccesscase() + groupFromTxt.getSuccesscases());
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            String rate = "0.00";
            if (data.getAllsuccesscase() > 0L) {
                rate = numberFormat.format((float)data.getAllsuccesscase() / (float)data.getAllcase() * 100.0f);
            }
            data.setAllpassrate(rate);
            allTimespend += groupFromTxt.getTimespend();
        }
        data.setAlltimespend(String.valueOf(allTimespend));
    }

    private static void analysisTxtsToObject(File file, Map<String, UnitCaseReportViewByGroudNameBean> mapRet, Map<String, Object> appList) {
        logger.info((Object)("\u5f00\u59cb\u89e3\u6790txt\u6587\u4ef6\uff1a " + file.getPath()));
        String txt = ExecutionDataToWebApiServer.getDatafromFile(file.getPath());
        if (txt.isEmpty()) {
            logger.error((Object)("\u6587\u4ef6\uff1a" + file.getPath() + "\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u89e3\u6790"));
        } else {
            try {
                List jsonTxt = (List)SerializationUtils.fromJsonString(txt, List.class);
                for (Map map : jsonTxt) {
                    UnitCaseReportViewByGroudNameBean bean;
                    String appid = (String)map.get("appid");
                    String groupName = (String)appList.get(appid);
                    if (groupName == null) {
                        groupName = "\u672a\u77e5\u7ec4";
                    }
                    if ((bean = mapRet.get(groupName)) == null) {
                        bean = new UnitCaseReportViewByGroudNameBean();
                        mapRet.put(groupName, bean);
                    }
                    bean.setCases(bean.getCases() + (long)((Integer)map.get("fucSum")).intValue());
                    if (map.get("status").equals(0)) {
                        bean.setSuccesscases(bean.getSuccesscases() + (long)((Integer)map.get("fucSum")).intValue());
                    } else {
                        List rstList = (List)map.get("testCaseResults");
                        int i = 0;
                        for (Map map1 : rstList) {
                            if (!map1.get("completed").equals(Boolean.TRUE)) continue;
                            ++i;
                        }
                        bean.setSuccesscases(bean.getSuccesscases() + (long)i);
                    }
                    bean.setTimespend(bean.getTimespend() + (long)((Integer)map.get("consumeTime")).intValue());
                }
                logger.info((Object)("\u5b8c\u6210\u89e3\u6790txt\u6587\u4ef6\uff1a " + file.getPath()));
            }
            catch (Exception e) {
                logger.error((Object)("\u89e3\u6790\u5931\u8d25txt\u6587\u4ef6\uff1a " + file.getPath()));
                logger.error((Object)e.getMessage());
                e.getStackTrace();
            }
        }
        ExecutionDataToWebApiServer.analysisStatisticsToObject(file, mapRet, appList);
    }

    private static void analysisStatisticsToObject(File file, Map<String, UnitCaseReportViewByGroudNameBean> mapRet, Map<String, Object> appList) {
        String filename = file.getPath() + ".statistics";
        logger.info((Object)("\u5f00\u59cb\u89e3\u6790statistics\u6587\u4ef6\uff1a " + filename));
        String txt = ExecutionDataToWebApiServer.getDatafromFile(filename);
        if (txt.isEmpty()) {
            logger.error((Object)("\u6587\u4ef6\uff1a" + filename + "\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u89e3\u6790"));
        } else {
            try {
                List jsonTxt = (List)SerializationUtils.fromJsonString(txt, List.class);
                for (Map map : jsonTxt) {
                    UnitCaseReportViewByGroudNameBean bean;
                    String appid = (String)map.get("appid");
                    String groupName = (String)appList.get(appid);
                    if (groupName == null) {
                        groupName = "\u672a\u77e5\u7ec4";
                    }
                    if ((bean = mapRet.get(groupName)) == null) {
                        bean = new UnitCaseReportViewByGroudNameBean();
                        mapRet.put(groupName, bean);
                    }
                    bean.setDefinedcases(bean.getDefinedcases() + Long.parseLong((String)map.get("appCaseNumber")));
                }
                logger.info((Object)("\u5b8c\u6210\u89e3\u6790statistics\u6587\u4ef6\uff1a " + filename));
            }
            catch (Exception e) {
                logger.error((Object)("\u89e3\u6790\u5931\u8d25statistics\u6587\u4ef6\uff1a " + filename));
                logger.error((Object)e.getMessage());
            }
        }
    }

    private static String getDatafromFile(String fileName) {
        StringBuilder laststr = new StringBuilder();
        try (FileInputStream fileInputStream = new FileInputStream(fileName);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                laststr.append(tempString);
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        return laststr.toString();
    }
}

