/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.build;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.toolkit.utils.SerializationUtils;
import kd.bos.toolkit.utils.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientKeepCookiesUtils {
    private static PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private static RequestConfig requestConfig;
    private CookieStore cookieStore = null;
    private String access_token;
    private String loginRet;

    private void setAccessToken(String access_token) {
        this.access_token = access_token;
    }

    public CloseableHttpClient getConnection() {
        return HttpClients.custom().setDefaultCookieStore(this.cookieStore).build();
    }

    private void setCookieStore(HttpResponse httpResponse, String hostip) {
        this.cookieStore = new BasicCookieStore();
        Header ck = httpResponse.getLastHeader("Set-Cookie");
        if (ck == null) {
            ck = httpResponse.getLastHeader("Cookie");
        }
        if (ck != null) {
            String setCookie = ck.getValue();
            String jSessionId = setCookie.substring("KERPSESSIONID=".length(), setCookie.indexOf(59));
            BasicClientCookie cookie = new BasicClientCookie("KERPSESSIONID", jSessionId);
            cookie.setVersion(0);
            cookie.setDomain(hostip);
            cookie.setPath("/");
            this.cookieStore.addCookie((Cookie)cookie);
        }
    }

    public boolean login(String loginUrl, Map<String, Object> body) throws IOException {
        boolean bRet = false;
        this.loginRet = this.post(loginUrl, null, body);
        Map mapRet = (Map)SerializationUtils.fromJsonString(this.loginRet, Map.class);
        if (mapRet.get("state").equals("success")) {
            bRet = true;
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String url, String body) throws IOException {
        boolean bRet = false;
        String data = "";
        RequestBuilder rb = RequestBuilder.post();
        try (CloseableHttpResponse response = null;
             CloseableHttpClient client = this.getConnection();){
            rb.setUri(url);
            rb.setConfig(requestConfig);
            StringEntity bodyEntity = new StringEntity(body, ContentType.APPLICATION_JSON);
            rb.setEntity((HttpEntity)bodyEntity);
            HttpUriRequest reqMethod = rb.build();
            response = client.execute(reqMethod);
            HttpEntity resEntity = response.getEntity();
            data = EntityUtils.toString((HttpEntity)resEntity);
            if (data.isEmpty()) {
                data = response.toString();
            }
            this.loginRet = data;
        }
        Map mapRet = (Map)SerializationUtils.fromJsonString(this.loginRet, Map.class);
        if (mapRet.get("state").equals("success")) {
            this.setAccessToken(this.getAccessToken());
            bRet = true;
        }
        return bRet;
    }

    public String getLoginResult() {
        return this.loginRet;
    }

    public String getAccessToken() {
        Map mapRet = (Map)SerializationUtils.fromJsonString(this.loginRet, Map.class);
        return (String)((Map)mapRet.get("data")).get("access_token");
    }

    public String startAllUnittestCase(String apiUrl) throws IOException {
        String sRet = this.post(apiUrl, null, null);
        return sRet;
    }

    public String doPost(String apiUrl) throws IOException {
        String sRet = this.post(apiUrl, null, null);
        return sRet;
    }

    public void loginOut(String apiUrl) throws IOException {
        this.post(apiUrl, null, null);
    }

    /*
     * Loose catch block
     */
    public String post(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        String data = "";
        try (CloseableHttpResponse response = null;){
            try (CloseableHttpClient client = this.getConnection();){
                HttpUriRequest reqMethod;
                HttpEntity resEntity;
                RequestBuilder rb = RequestBuilder.post();
                rb.setUri(url);
                rb.setConfig(requestConfig);
                if (header != null && header.size() != 0) {
                    for (Map.Entry<String, String> entry : header.entrySet()) {
                        rb.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                if (!StringUtils.isBlank(this.access_token)) {
                    if (body == null) {
                        body = new HashMap<String, Object>();
                    }
                    body.put("access_token", this.access_token);
                }
                if (body != null && body.size() != 0) {
                    Set<Map.Entry<String, Object>> entrySet = body.entrySet();
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(10);
                    for (Map.Entry<String, Object> entry : entrySet) {
                        params.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
                    }
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
                    rb.setEntity((HttpEntity)entity);
                }
                if ((data = EntityUtils.toString((HttpEntity)(resEntity = (response = client.execute(reqMethod = rb.build())).getEntity()))).isEmpty()) {
                    data = response.toString();
                }
                String string = data;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public String postJson(String url, Map<String, String> header, String body) throws IOException {
        String data = "";
        try (CloseableHttpResponse response = null;){
            try (CloseableHttpClient client = this.getConnection();){
                HttpUriRequest reqMethod;
                HttpEntity resEntity;
                RequestBuilder rb = RequestBuilder.post();
                rb.setUri(url);
                rb.setConfig(requestConfig);
                if (header != null && header.size() != 0) {
                    for (Map.Entry<String, String> entry : header.entrySet()) {
                        rb.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                if (body != null) {
                    StringEntity bodyEntity = new StringEntity(body, ContentType.APPLICATION_JSON);
                    rb.setEntity((HttpEntity)bodyEntity);
                }
                if ((data = EntityUtils.toString((HttpEntity)(resEntity = (response = client.execute(reqMethod = rb.build())).getEntity()))).isEmpty()) {
                    data = response.toString();
                }
                String string = data;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String url, Map<String, String> header) throws IOException {
        String data = "";
        HttpGet get = new HttpGet(url);
        CloseableHttpResponse response = null;
        CloseableHttpClient client = this.getConnection();
        try {
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    get.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = client.execute((HttpUriRequest)get)).getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                data = EntityUtils.toString((HttpEntity)resEntity);
            }
            String string = data;
            return string;
        }
        finally {
            if (response != null) {
                response.close();
            }
            get.releaseConnection();
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetHtml(String url, Map<String, String> header) throws IOException {
        String data = "";
        HttpGet get = new HttpGet(url);
        CloseableHttpResponse response = null;
        CloseableHttpClient client = this.getConnection();
        try {
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    get.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = client.execute((HttpUriRequest)get)).getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                data = EntityUtils.toString((HttpEntity)resEntity);
            }
            RequestBuilder rb = RequestBuilder.post();
            rb.setUri(url);
            this.setCookieStore((HttpResponse)response, rb.getUri().getHost());
            String string = data;
            return string;
        }
        finally {
            if (response != null) {
                response.close();
            }
            get.releaseConnection();
            client.close();
        }
    }

    static {
        connectionManager.setDefaultMaxPerRoute(800);
        connectionManager.setMaxTotal(1000);
        requestConfig = RequestConfig.custom().setSocketTimeout(1800000).setConnectTimeout(30000).setConnectionRequestTimeout(1800000).build();
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig);
    }
}

