/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.build;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kd.bos.toolkit.utils.HttpUtils;
import kd.bos.toolkit.utils.SerializationUtils;
import kd.bos.toolkit.utils.StringUtils;
import kd.bos.unittest.coverage.AllUnitCaseReportViewByGroudNameBean;
import kd.bos.unittest.coverage.UnitCaseReportViewByGroudNameBean;
import kd.bos.unittest.coverage.UnittestReportData;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ParseFrontEndCoverageDataToWebApiServer {
    private static final Log logger = LogFactory.getLog(ParseFrontEndCoverageDataToWebApiServer.class);
    public static final String URL_DEV = "http://nexterp.git.kingdee.com/bos-dev-platform/dev/index.html";
    public static final String URL_MASTER = "http://nexterp.git.kingdee.com/bos-dev-platform/master/index.html";
    public static final String URL_BASELINE = "http://nexterp.git.kingdee.com/bos-dev-platform/baseline/index.html";
    public static final String API_DEV = "/kapi/sys/ut_coverage_dev_feature/save";
    public static final String API_MASTER = "/kapi/sys/ut_coverage_patch_feature/save";
    public static final String API_BASELINE = "/kapi/sys/baseline_coverage/save";

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        DefaultParser parser = new DefaultParser();
        Options options = ParseFrontEndCoverageDataToWebApiServer.settingOptions();
        CommandLine cmd = parser.parse(options, args);
        if (!ParseFrontEndCoverageDataToWebApiServer.checkParam(cmd)) {
            System.exit(1);
        }
        logger.info((Object)StringUtils.filterLog("\u4f20\u5165\u53c2\u6570\uff1a" + SerializationUtils.toJsonString(args)));
        ParseFrontEndCoverageDataToWebApiServer.parseDataAndUpload(args, cmd, options);
        long end = System.currentTimeMillis();
        logger.info((Object)("\u6267\u884c\u5b8c\u6bd5\uff0c\u6d88\u8017\u65f6\u95f4\uff1a" + (end - start) / 1000L));
        System.exit(0);
    }

    private static void parseDataAndUpload(String[] args, CommandLine cmd, Options options) throws ParseException {
        int length = args.length + 4;
        String[] argsNew = Arrays.copyOf(args, length);
        String parseUrl = cmd.getOptionValue("parseUrl");
        logger.info((Object)("1\u3001\u5f00\u59cb\u89e3\u6790" + parseUrl + "\u6587\u4ef6\uff0c\u83b7\u53d6\u4ee3\u7801\u8986\u76d6\u7387\u7edf\u8ba1\u4fe1\u606f\u3002"));
        AllUnitCaseReportViewByGroudNameBean reportView = ParseFrontEndCoverageDataToWebApiServer.parseOfflineHtml(parseUrl);
        UnittestReportData report = new UnittestReportData();
        report.setData(reportView);
        String strReport = SerializationUtils.toJsonString(report);
        argsNew[length - 4] = "-params";
        argsNew[length - 3] = strReport;
        argsNew[length - 2] = "-suburl";
        argsNew[length - 1] = cmd.getOptionValue("suburl");
        DefaultParser parser = new DefaultParser();
        cmd = parser.parse(options, argsNew);
        logger.info((Object)("2\u3001\u5f00\u59cb\u4e0a\u4f20\u4ee3\u7801\u8986\u76d6\u7387\u7edf\u8ba1\u4fe1\u606f\uff1a " + strReport));
        ParseFrontEndCoverageDataToWebApiServer.uploadData(cmd);
    }

    private static Options settingOptions() {
        Options options = new Options();
        options.addOption("hostUrl", true, "");
        options.addOption("tenantId", true, "");
        options.addOption("userId", true, "");
        options.addOption("appId", true, "");
        options.addOption("accountId", true, "");
        options.addOption("usertype", true, "");
        options.addOption("appNumber", true, "");
        options.addOption("appPwd", true, "");
        options.addOption("appLang", true, "");
        options.addOption("params", true, "");
        options.addOption("htype", true, "");
        options.addOption("html", true, "");
        options.addOption("suburl", true, "");
        options.addOption("txtpath", true, "");
        options.addOption("txtfilter", true, "");
        options.addOption("appgroupxmlpath", true, "appNameToID.xml");
        options.addOption("datetime", true, "");
        options.addOption("parseUrl", true, "");
        return options;
    }

    private static boolean checkParam(CommandLine cmd) {
        String appPwd;
        String appNumber;
        String accountId;
        String userId;
        String tenantId;
        String parseUrl;
        String suburl;
        boolean ret = true;
        StringBuilder sb = new StringBuilder();
        String hostUrl = cmd.getOptionValue("hostUrl");
        if (StringUtils.isEmpty(hostUrl)) {
            sb.append("hostUrl,");
        }
        if (StringUtils.isEmpty(suburl = cmd.getOptionValue("suburl"))) {
            sb.append("suburl,");
        }
        if (StringUtils.isEmpty(parseUrl = cmd.getOptionValue("parseUrl"))) {
            sb.append("parseUrl,");
        }
        if (StringUtils.isEmpty(tenantId = cmd.getOptionValue("tenantId"))) {
            sb.append("tenantId,");
        }
        if (StringUtils.isEmpty(userId = cmd.getOptionValue("userId"))) {
            sb.append("userId,");
        }
        if (StringUtils.isEmpty(accountId = cmd.getOptionValue("accountId"))) {
            sb.append("accountId,");
        }
        if (StringUtils.isEmpty(appNumber = cmd.getOptionValue("appNumber"))) {
            sb.append("appNumber,");
        }
        if (StringUtils.isEmpty(appPwd = cmd.getOptionValue("appPwd"))) {
            sb.append("appPwd,");
        }
        if (sb.length() > 0) {
            sb.insert(0, "\u53c2\u6570");
            sb.append("\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            logger.error((Object)sb.toString());
            ret = false;
        }
        return ret;
    }

    private static AllUnitCaseReportViewByGroudNameBean parseOfflineHtml(String localPath) {
        try {
            File input = new File(localPath);
            Document doc = Jsoup.parse((File)input, (String)"UTF-8");
            return ParseFrontEndCoverageDataToWebApiServer.parseHandle(doc);
        }
        catch (Exception e) {
            logger.error((Object)"\u89e3\u6790\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static AllUnitCaseReportViewByGroudNameBean parseOnlineHtml(String url) {
        try {
            Document doc = Jsoup.connect((String)url).timeout(10000).get();
            return ParseFrontEndCoverageDataToWebApiServer.parseHandle(doc);
        }
        catch (Exception e) {
            logger.error((Object)"\u89e3\u6790\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static AllUnitCaseReportViewByGroudNameBean parseHandle(Document doc) {
        Elements padels = doc.getElementsByClass("pad1");
        Element el = (Element)padels.get(0);
        Elements pad1yels = el.getElementsByClass("pad1y");
        Element statementsDiv = (Element)pad1yels.get(0);
        Element branchesDiv = (Element)pad1yels.get(1);
        Element functionsDiv = (Element)pad1yels.get(2);
        Element linesDiv = (Element)pad1yels.get(3);
        Elements statementsSpans = statementsDiv.getElementsByTag("span");
        String statementsCoverage = ((Element)statementsSpans.get(0)).text();
        String statementsValue = ((Element)statementsSpans.get(2)).text();
        String[] statementsarr = statementsValue.split("/");
        AllUnitCaseReportViewByGroudNameBean tempTotal = new AllUnitCaseReportViewByGroudNameBean();
        tempTotal.setAlldefinedcase(0L);
        tempTotal.setAllpassrate("0");
        tempTotal.setAlltimespend("0");
        tempTotal.setAllcase(0L);
        tempTotal.setReportdatetime(new Date());
        Elements branchesSpans = branchesDiv.getElementsByTag("span");
        String branchesCoverage = ((Element)branchesSpans.get(0)).text();
        String branchesValue = ((Element)branchesSpans.get(2)).text();
        String[] branchesarr = branchesValue.split("/");
        Elements functionsSpans = functionsDiv.getElementsByTag("span");
        String functionsCoverage = ((Element)functionsSpans.get(0)).text();
        String functionsValue = ((Element)functionsSpans.get(2)).text();
        String[] functionsarr = functionsValue.split("/");
        Elements linesSpans = linesDiv.getElementsByTag("span");
        String linesCoverage = ((Element)linesSpans.get(0)).text();
        String linesValue = ((Element)linesSpans.get(2)).text();
        String[] linesarr = linesValue.split("/");
        long codeline = Long.parseLong(linesarr[1]);
        long coverline = Long.parseLong(linesarr[0]);
        long codeMethod = Long.parseLong(functionsarr[1]);
        long coverMethods = Long.parseLong(functionsarr[0]);
        String linesCoverageNum = linesCoverage.replace("%", "");
        String functionsCoverageNum = functionsCoverage.replace("%", "");
        String branchesCoverageNum = branchesCoverage.replace("%", "");
        tempTotal.setAllcodeline(codeline);
        tempTotal.setAllcodecoverline(coverline);
        tempTotal.setAllcoverage(linesCoverageNum);
        tempTotal.setAllMethods(codeMethod);
        tempTotal.setAllCoveredMethods(coverMethods);
        tempTotal.setAllMethodCoverageRatio(functionsCoverageNum);
        tempTotal.setAllBranchesCoverageRatio(branchesCoverageNum);
        UnitCaseReportViewByGroudNameBean tempItem = new UnitCaseReportViewByGroudNameBean();
        tempItem.setCases(0L);
        tempItem.setPassrate("0");
        tempItem.setTimespend(0L);
        tempItem.setDefinedcases(0L);
        tempItem.setSuccesscases(0L);
        tempItem.setName("\u524d\u7aef\u6280\u672f\u9879\u76ee\u7ec4");
        tempItem.setBranchCoverageRatio(branchesCoverageNum);
        tempItem.setCodeline(codeline);
        tempItem.setCodecoverline(coverline);
        tempItem.setCoverage(linesCoverageNum);
        tempItem.setMethods(codeMethod);
        tempItem.setCoveredMethods(coverMethods);
        tempItem.setMethodCoverageRatio(functionsCoverageNum);
        tempTotal.getGroupentity().add(tempItem);
        return tempTotal;
    }

    private static void uploadData(CommandLine cmd) {
        try {
            String ret = HttpUtils.DoDeployWebApi(cmd);
            Map retApi = (Map)SerializationUtils.fromJsonString(ret, Map.class);
            if ("true".equals(retApi.get("success"))) {
                logger.info((Object)("\u606d\u559c,\u4e0a\u4f20\u6570\u636e\u6210\u529f,\u8fd4\u56de\u503c\uff1a" + StringUtils.filterLog(ret)));
            } else if (retApi.get("data") != null) {
                if (((Map)retApi.get("data")).get("success").equals(Boolean.TRUE)) {
                    logger.info((Object)("\u606d\u559c,\u4e0a\u4f20\u6570\u636e\u6210\u529f,\u8fd4\u56de\u503c\uff1a" + StringUtils.filterLog(ret)));
                } else {
                    logger.error((Object)("\u4e0a\u4f20\u6570\u636e\u5931\u8d25\uff0c\u9519\u8bef\u5185\u5bb9\uff1a" + StringUtils.filterLog(ret)));
                    System.exit(1);
                }
            } else {
                logger.error((Object)("\u4e0a\u4f20\u6570\u636e\u5931\u8d25\uff0c\u9519\u8bef\u5185\u5bb9\uff1a" + StringUtils.filterLog(ret)));
                System.exit(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u4e0a\u4f20\u5931\u8d25\uff01", (Throwable)e);
            System.exit(1);
        }
    }
}

