/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.build;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.toolkit.utils.FileUtils;
import kd.bos.toolkit.utils.HttpUtils;
import kd.bos.toolkit.utils.SerializationUtils;
import kd.bos.toolkit.utils.StringUtils;
import kd.bos.unittest.build.HttpClientKeepCookiesUtils;
import kd.bos.unittest.ret.TestObjectResult;
import kd.bos.unittest.smoke.task.ITask;
import kd.bos.unittest.smoke.task.SmokeRunAppCasesTask;
import kd.bos.unittest.smoke.task.SmokeRunCasesTask;
import kd.bos.unittest.smoke.task.SmokeRunUnitCasesTask;
import kd.bos.unittest.smoke.task.TaskManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WholeSystemTest {
    private static final String OPTION_HOST_URL = "hostUrl";
    private static final String OPTION_TENANT_ID = "tenantId";
    private static final String OPTION_USER_ID = "userId";
    private static final String OPTION_APP_ID = "appId";
    private static final String OPTION_IS_ALL_CASES = "isAllCases";
    private static final String OPTION_RUN_THREADS = "runThreads";
    private static final String SYSTEM_LINE_SEPARATOR = "line.separator";
    private static final String OPTION_APP_NUMBER = "appNumber";
    private static String hostUrl;
    private static String logPath;
    private static String formCoverPath;
    private static final Log logger;

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void startAllUnittest(String[] args) {
        String outResult = "";
        String formCoverResult = "";
        List<Map<String, Object>> lstResult = Collections.synchronizedList(new ArrayList());
        List<String> lstResultWithOutCaseResult = Collections.synchronizedList(new ArrayList());
        HttpClientKeepCookiesUtils obj = new HttpClientKeepCookiesUtils();
        ObjectMapper mapper = new ObjectMapper();
        boolean isAllCases = false;
        try {
            String language;
            String appSecuret;
            Options options = new Options();
            options.addOption("logFile", true, "");
            options.addOption(OPTION_HOST_URL, true, "");
            options.addOption(OPTION_TENANT_ID, true, "");
            options.addOption(OPTION_USER_ID, true, "");
            options.addOption(OPTION_APP_ID, true, "");
            options.addOption("accountId", true, "");
            options.addOption("usertype", true, "");
            options.addOption(OPTION_APP_NUMBER, true, "");
            options.addOption("appPwd", true, "");
            options.addOption("appLang", true, "");
            options.addOption(OPTION_IS_ALL_CASES, true, "");
            options.addOption("runCaseType", true, "");
            options.addOption(OPTION_RUN_THREADS, true, "");
            options.addOption("appExcludes", true, "");
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(options, args);
            if (!WholeSystemTest.doCheckParams(cmd)) {
                return;
            }
            hostUrl = cmd.getOptionValue(OPTION_HOST_URL);
            formCoverPath = logPath + ".statistics";
            logger.info((Object)("\u4f20\u5165\u7684\u53c2\u6570:" + StringUtils.filterLog(Arrays.toString(args)) + System.getProperty(SYSTEM_LINE_SEPARATOR, "\n")));
            if (!hostUrl.endsWith("/")) {
                hostUrl = hostUrl + "/";
            }
            String strLoginOutApiUrl = hostUrl + "auth/logout.do?redirect=../index.html?";
            String strLoginUrl = hostUrl + "auth/login.do";
            String user = cmd.getOptionValue(OPTION_USER_ID);
            String accountId = cmd.getOptionValue("accountId");
            String tenantId = cmd.getOptionValue(OPTION_TENANT_ID);
            String usertype = cmd.getOptionValue("usertype");
            String appId = cmd.getOptionValue(OPTION_APP_NUMBER);
            boolean bRet = HttpUtils.doLogin(obj, hostUrl, appId, appSecuret = cmd.getOptionValue("appPwd"), tenantId, accountId, user, usertype, language = cmd.getOptionValue("appLang"));
            if (bRet) {
                ArrayList<ITask> lstTask;
                String strOpInfo;
                logger.info((Object)"\u767b\u5f55\u6210\u529f~");
                String caseIdsMap = null;
                if (cmd.getOptionValue(OPTION_IS_ALL_CASES) != null) {
                    isAllCases = Boolean.parseBoolean(cmd.getOptionValue(OPTION_IS_ALL_CASES));
                }
                if (isAllCases) {
                    caseIdsMap = WholeSystemTest.getAllCases(obj, hostUrl, cmd);
                    strOpInfo = "\u8fd4\u56de\u6240\u6709\u7684\u6d4b\u8bd5\u7528\u4f8b\u7ed3\u679c\uff1a";
                } else {
                    caseIdsMap = WholeSystemTest.getPublishedCases(obj, hostUrl, cmd);
                    strOpInfo = "\u8fd4\u56de\u5df2\u53d1\u5e03\u7684\u6d4b\u8bd5\u7528\u4f8b\u7ed3\u679c\uff1a";
                }
                if (caseIdsMap.length() > 20480) {
                    logger.info((Object)(strOpInfo + "Result(\u5185\u5bb9\u8fc7\u5927\uff0c\u8d85\u8fc720K\u3002\u6b64\u5904\u53ea\u5c55\u793a\u524d20K\u6570\u636e):" + StringUtils.filterLog(caseIdsMap.substring(0, 20480))));
                } else {
                    logger.info((Object)StringUtils.filterLog(strOpInfo + caseIdsMap));
                }
                List lstCaseIds = (List)mapper.readValue(caseIdsMap, List.class);
                Object para = null;
                if (lstCaseIds != null && lstCaseIds.size() > 0) {
                    para = (List)((Map)lstCaseIds.get(0)).get("p");
                }
                if (para != null) {
                    logger.error((Object)StringUtils.filterLog(para.toString()));
                    return;
                }
                String appExcludes = cmd.getOptionValue("appExcludes");
                if (appExcludes != null && !StringUtils.isBlank(appExcludes)) {
                    String[] excludeApps = StringUtils.split(appExcludes, true, ',');
                    List<String> lstExcludeApps = Arrays.asList(excludeApps);
                    Iterator it = lstCaseIds.iterator();
                    while (it.hasNext()) {
                        Object caseMap = (Map)it.next();
                        String appnumber = (String)caseMap.get("appnumber");
                        if (!lstExcludeApps.contains(appnumber)) continue;
                        it.remove();
                    }
                }
                logger.info((Object)("\u83b7\u53d6\u5df2\u53d1\u5e03\u7684\u6d4b\u8bd5\u7528\u4f8b  " + lstCaseIds.size() + "\u4e2a. \u5e76\u5f00\u59cb\u5faa\u73af\u6267\u884c\u7528\u4f8b"));
                int i = 0;
                String runCaseType = cmd.getOptionValue("runCaseType");
                if (runCaseType == null) {
                    runCaseType = "multibyapp";
                }
                if ("single".equals(runCaseType)) {
                    for (Object caseMap : lstCaseIds) {
                        ++i;
                        String caseId = (String)caseMap.get("number");
                        String caseName = (String)caseMap.get("name");
                        Object v = caseMap.get("appnumber");
                        String appId1 = "bos";
                        if (v != null) {
                            appId1 = (String)v;
                        }
                        String threadinfo = Thread.currentThread().getName();
                        String msg = String.format("%s (%s/%s):", threadinfo, i, lstCaseIds.size());
                        String startCaseApiUrl = hostUrl + "unittest/testByCaseId.do?caseId=" + caseId + "&appId=" + appId1.toLowerCase();
                        WholeSystemTest.doOneTestCaseByCaseInfo((Map<String, Object>)caseMap, startCaseApiUrl, msg, lstResult, lstResultWithOutCaseResult, obj, hostUrl);
                    }
                } else if ("multibyapp".equals(runCaseType)) {
                    HashMap mapAppCases = new HashMap();
                    for (Map caseMap : lstCaseIds) {
                        void var32_49;
                        ++i;
                        String appNumber = (String)caseMap.get("appnumber");
                        List list = (List)mapAppCases.get(appNumber);
                        if (list == null) {
                            ArrayList arrayList = new ArrayList();
                            mapAppCases.put(appNumber, arrayList);
                        }
                        var32_49.add(caseMap);
                    }
                    logger.info((Object)"\u6240\u6709\u7528\u4f8b\u6309\u5e94\u7528\u5206\u7ec4...");
                    lstTask = new ArrayList<ITask>(10);
                    int runThreads = null == cmd.getOptionValue(OPTION_RUN_THREADS) ? 5 : Integer.parseInt(cmd.getOptionValue(OPTION_RUN_THREADS));
                    for (Map.Entry entry : mapAppCases.entrySet()) {
                        if (((List)entry.getValue()).toString().length() > 20480) {
                            logger.info((Object)StringUtils.filterLog((String)entry.getKey() + ":" + ((List)entry.getValue()).toString().substring(0, 20480)));
                        } else {
                            logger.info((Object)StringUtils.filterLog((String)entry.getKey() + ":" + entry.getValue()));
                        }
                        if (entry.getKey() == null) continue;
                        SmokeRunAppCasesTask caseTask = new SmokeRunAppCasesTask((List)entry.getValue(), lstResult, lstResultWithOutCaseResult, obj, hostUrl);
                        lstTask.add(caseTask);
                    }
                    if (lstTask.size() > 0) {
                        if (lstTask.size() > runThreads) {
                            TaskManager.execute(lstTask, runThreads);
                        } else {
                            TaskManager.execute(lstTask, lstTask.size());
                        }
                    }
                } else if ("multi".equals(runCaseType)) {
                    int runThreads = null == cmd.getOptionValue(OPTION_RUN_THREADS) ? 10 : Integer.parseInt(cmd.getOptionValue(OPTION_RUN_THREADS));
                    lstTask = new ArrayList(10);
                    for (Map caseMap : lstCaseIds) {
                        SmokeRunCasesTask smokeRunCasesTask = new SmokeRunCasesTask(caseMap, ++i, lstCaseIds.size(), lstResult, lstResultWithOutCaseResult, obj, hostUrl);
                        lstTask.add(smokeRunCasesTask);
                    }
                    if (lstTask.size() > 0) {
                        if (lstTask.size() > runThreads) {
                            TaskManager.execute(lstTask, runThreads);
                        } else {
                            TaskManager.execute(lstTask, lstTask.size());
                        }
                    }
                } else if ("multibyunit".equals(runCaseType)) {
                    HashMap mapUnitCases = new HashMap();
                    for (Map caseMap : lstCaseIds) {
                        void var32_55;
                        ++i;
                        String unitid = (String)caseMap.get("unitid");
                        List list = (List)mapUnitCases.get(unitid);
                        if (list == null) {
                            ArrayList arrayList = new ArrayList();
                            mapUnitCases.put(unitid, arrayList);
                        }
                        var32_55.add(caseMap);
                    }
                    logger.info((Object)"\u6240\u6709\u7528\u4f8b\u6309\u5e94\u7528\u5355\u5143\u5206\u7ec4...");
                    lstTask = new ArrayList(10);
                    int runThreads = null == cmd.getOptionValue(OPTION_RUN_THREADS) ? 5 : Integer.parseInt(cmd.getOptionValue(OPTION_RUN_THREADS));
                    for (Map.Entry entry : mapUnitCases.entrySet()) {
                        if (((List)entry.getValue()).toString().length() > 20480) {
                            logger.info((Object)StringUtils.filterLog((String)entry.getKey() + ":" + ((List)entry.getValue()).toString().substring(0, 20480)));
                        } else {
                            logger.info((Object)StringUtils.filterLog((String)entry.getKey() + ":" + entry.getValue()));
                        }
                        if (entry.getKey() == null) continue;
                        SmokeRunUnitCasesTask caseTask = new SmokeRunUnitCasesTask((List)entry.getValue(), lstResult, lstResultWithOutCaseResult, obj, hostUrl);
                        lstTask.add(caseTask);
                    }
                    if (lstTask.size() > 0) {
                        if (lstTask.size() > runThreads) {
                            TaskManager.execute(lstTask, runThreads);
                        } else {
                            TaskManager.execute(lstTask, lstTask.size());
                        }
                    }
                }
                formCoverResult = WholeSystemTest.getAppStatics(obj, hostUrl, cmd, mapper.writeValueAsString(lstResultWithOutCaseResult));
                obj.loginOut(strLoginOutApiUrl);
                logger.info((Object)("\u6240\u6709\u64cd\u4f5c\u5168\u90e8\u6267\u884c\u5b8c\u6210\u5f00\u59cb\u6ce8\u9500\u767b\u5f55, ApiUrl:" + strLoginOutApiUrl));
            }
        }
        catch (ParseException e) {
            outResult = "\u6b63\u786e\u53c2\u6570\u683c\u5f0f\uff1a-logFile $logfile -hostUrl $ierpurl -tenantId $tenantid -accountId $accountid -userId $user -appNumber \"unittest\" -appPwd \"1234567\"";
            logger.error((Object)outResult);
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            outResult = e.getMessage();
            logger.error((Object)outResult, (Throwable)e);
        }
        finally {
            try {
                FileUtils.logToTxt(logPath, mapper.writeValueAsString(lstResult));
                FileUtils.logToTxt(formCoverPath, formCoverResult);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String getTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    public static void doOneTestCaseByCaseInfo(Map<String, Object> caseMap, String startCaseApiUrl, String msg, List<Map<String, Object>> lstResult, List<String> lstResultWithOutCaseResult, HttpClientKeepCookiesUtils obj, String hostUrl) throws IOException {
        String caseId = (String)caseMap.get("number");
        String caseName = (String)caseMap.get("name");
        Date startTime = new Date();
        try {
            String caseRet = obj.doPost(startCaseApiUrl);
            if (caseRet.length() > 20480) {
                logger.info((Object)(msg + "\u8fd4\u56de\u7ed3\u679c: " + caseId + ", Result(\u5185\u5bb9\u8fc7\u5927\uff0c\u8d85\u8fc720K\u3002\u6b64\u5904\u53ea\u5c55\u793a\u524d20K\u6570\u636e):" + StringUtils.filterLog(caseRet.substring(0, 20480))));
            } else {
                logger.info((Object)StringUtils.filterLog(msg + "\u8fd4\u56de\u7ed3\u679c: " + caseId + ", Result:" + caseRet));
            }
            List lstRet = null;
            try {
                ObjectMapper mapper = new ObjectMapper();
                lstRet = (List)mapper.readValue(caseRet, List.class);
                List lstRetTemp = null;
                if (((Map)lstRet.get(0)).get("p") != null) {
                    logger.error((Object)String.format("\u8fdc\u7a0b\u8c03\u7528\u6267\u884c\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b(%s)\u5931\u8d25,HTTP\u6b63\u5e38\u8fd4\u56de\u5e76\u6293\u53d6\u5230\u670d\u52a1\u7aef\u9519\u8bef\u4fe1\u606f\uff1a%s,HTTP\u8fd4\u56de\u7ed3\u679c\uff1a%s", caseId, StringUtils.filterLog(((Map)lstRet.get(0)).get("p").toString()), StringUtils.filterLog(caseRet)));
                } else {
                    lstRetTemp = lstRet;
                }
                lstResult.addAll(lstRetTemp);
                for (Map ret : lstRet) {
                    HashMap mapApp = new HashMap();
                    mapApp.putAll(ret);
                    mapApp.remove("testCaseResults");
                    mapApp.remove("message");
                    lstResultWithOutCaseResult.add(mapper.writeValueAsString(mapApp));
                }
            }
            catch (Exception e) {
                TestObjectResult testResult = new TestObjectResult();
                testResult.setStartTime(startTime);
                testResult.setCompleted(false);
                testResult.setStatus(1);
                testResult.setEndTime(new Date());
                testResult.setName(caseName);
                testResult.setAppname((String)caseMap.get("subsysname"));
                testResult.setAppid((String)caseMap.get("appid"));
                testResult.setSubSystemId((String)caseMap.get("appid"));
                testResult.setMessage(String.format("\u8fdc\u7a0b\u8c03\u7528\u6267\u884c\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b(%s)\u5931\u8d25,HTTP\u6b63\u5e38\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f(%s)," + System.getProperty(SYSTEM_LINE_SEPARATOR) + "%s" + System.getProperty(SYSTEM_LINE_SEPARATOR) + ",HTTP\u8fd4\u56de\u7ed3\u679c\uff1a%s", caseId, e.getMessage(), WholeSystemTest.getTrace(e), caseRet));
                logger.error((Object)String.format("\u8fdc\u7a0b\u8c03\u7528\u6267\u884c\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b(%s)\u5931\u8d25,HTTP\u6b63\u5e38\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f(%s)," + System.getProperty(SYSTEM_LINE_SEPARATOR) + "%s" + System.getProperty(SYSTEM_LINE_SEPARATOR) + ",HTTP\u8fd4\u56de\u7ed3\u679c\uff1a%s", caseId, e.getMessage(), WholeSystemTest.getTrace(e), StringUtils.filterLog(caseRet)));
                String ret = SerializationUtils.toJsonString(testResult);
                Map retMap = (Map)SerializationUtils.fromJsonString(ret, Map.class);
                lstResult.add(retMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)StringUtils.filterLog("caseId=(" + caseId + ")"));
            logger.error((Object)e.getMessage(), (Throwable)e);
            TestObjectResult testResult = new TestObjectResult();
            testResult.setStartTime(startTime);
            testResult.setCompleted(false);
            testResult.setStatus(1);
            testResult.setEndTime(new Date());
            testResult.setName(caseName);
            testResult.setAppname((String)caseMap.get("subsysname"));
            testResult.setAppid((String)caseMap.get("appid"));
            testResult.setSubSystemId((String)caseMap.get("appid"));
            testResult.setMessage(String.format("\u8fdc\u7a0b\u8c03\u7528\u6267\u884c\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b(%s)\u5931\u8d25,HTTP\u5f02\u5e38\uff0c\u9519\u8bef\u5185\u5bb9\uff1a%s" + System.getProperty(SYSTEM_LINE_SEPARATOR) + "%s", caseId, e.getMessage(), WholeSystemTest.getTrace(e)));
            logger.error((Object)StringUtils.filterLog(String.format("\u8fdc\u7a0b\u8c03\u7528\u6267\u884c\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b(%s)\u5931\u8d25,HTTP\u5f02\u5e38\uff0c\u9519\u8bef\u5185\u5bb9\uff1a%s", caseId, e.getMessage())));
            String ret = SerializationUtils.toJsonString(testResult);
            Map retMap = (Map)SerializationUtils.fromJsonString(ret, Map.class);
            lstResult.add(retMap);
        }
    }

    private static String getAppStatics(HttpClientKeepCookiesUtils httpObj, String hostUrl, CommandLine cmd, String ret) throws IOException {
        String formCoverResult = "";
        String strGetAppStaticsApiUrl = hostUrl + "unittest/getAppStaticsByResult.do";
        String apps = "";
        if (null != cmd.getOptionValue(OPTION_APP_ID)) {
            apps = cmd.getOptionValue(OPTION_APP_ID);
        }
        logger.info((Object)("\u5f00\u59cb\u7edf\u8ba1APP\u7ed3\u679c(ApiUrl:" + strGetAppStaticsApiUrl));
        HashMap<String, Object> hM = new HashMap<String, Object>();
        hM.put("ret", ret);
        hM.put("apps", apps);
        formCoverResult = httpObj.post(hostUrl + "unittest/getAppStaticsByResult.do", null, hM);
        logger.info((Object)("\u8fd4\u56de\u7edf\u8ba1APP\u7ed3\u679c:\n" + StringUtils.filterLog(formCoverResult)));
        return formCoverResult;
    }

    private static boolean doCheckParams(CommandLine cmd) {
        boolean bRet = true;
        logPath = cmd.getOptionValue("logFile");
        String hostUrl = cmd.getOptionValue(OPTION_HOST_URL);
        String user = cmd.getOptionValue(OPTION_USER_ID);
        String tenantId = cmd.getOptionValue(OPTION_TENANT_ID);
        if (logPath == null || hostUrl == null || tenantId == null || user == null) {
            logger.error((Object)("\u4f20\u5165\u7684\u53c2\u6570\u5f02\u5e38:" + Arrays.toString(cmd.getArgs())));
            String outResult = "\u6b63\u786e\u53c2\u6570\u683c\u5f0f\uff1a-logFile <\u65e5\u5fd7\u6587\u4ef6> -hostUrl <\u670d\u52a1\u5730\u5740> -tenantId <\u79df\u6237ID> -userId <\u7528\u6237\u8d26\u53f7(\u5982\u624b\u673a\u53f7\uff1a17299999999)> -password<\u7528\u6237\u5bc6\u7801> -appId <\u5e94\u7528ID(\u591a\u4e2a\u5e94\u7528','\u9694\u5f00)> -accountId <\u8d26\u5957ID> -logintype <\u767b\u5f55\u65b9\u5f0f\uff0c\u4e91\u4e4b\u5bb6\u3001\u91d1\u8776\u4e91>";
            logger.error((Object)outResult);
            bRet = false;
        }
        return bRet;
    }

    private static String getAllCases(HttpClientKeepCookiesUtils httpObj, String hostUrl, CommandLine cmd) throws IOException {
        String apps = "";
        if (null != cmd.getOptionValue(OPTION_APP_ID)) {
            apps = cmd.getOptionValue(OPTION_APP_ID);
        }
        String strGetAllUnittestCaseApiUrl = hostUrl + "unittest/getAllCasdIdByApp.do?apps=" + apps;
        HashMap<String, Object> body = null;
        if (apps.isEmpty()) {
            strGetAllUnittestCaseApiUrl = hostUrl + "unittest/getAllCaseId.do";
            logger.info((Object)("\u8bfb\u53d6\u6240\u6709\u5e94\u7528\u7684\u6d4b\u8bd5\u7528\u4f8b(ApiUrl:" + strGetAllUnittestCaseApiUrl + ")"));
        } else {
            body = new HashMap<String, Object>();
            body.put("apps", apps);
            strGetAllUnittestCaseApiUrl = hostUrl + "unittest/getAllCasdIdByApp.do";
            logger.info((Object)("\u8bfb\u53d6\u6307\u5b9a\u5e94\u7528(" + apps + ")\u7684\u6d4b\u8bd5\u7528\u4f8b(ApiUrl:" + strGetAllUnittestCaseApiUrl + ")"));
        }
        String caseIdsMap = httpObj.post(strGetAllUnittestCaseApiUrl, null, body);
        return caseIdsMap;
    }

    private static String getPublishedCases(HttpClientKeepCookiesUtils httpObj, String hostUrl, CommandLine cmd) throws IOException {
        String apps = "";
        if (null != cmd.getOptionValue(OPTION_APP_ID)) {
            apps = cmd.getOptionValue(OPTION_APP_ID);
        }
        String strGetAllUnittestCaseApiUrl = hostUrl + "unittest/getPublishedCasdIdByApp.do?apps=" + apps;
        HashMap<String, Object> body = null;
        if (apps.isEmpty()) {
            strGetAllUnittestCaseApiUrl = hostUrl + "unittest/getPublishedCaseId.do";
            logger.info((Object)("\u8bfb\u53d6\u6240\u6709\u5e94\u7528\u5df2\u53d1\u5e03\u7684\u6d4b\u8bd5\u7528\u4f8b(ApiUrl:" + strGetAllUnittestCaseApiUrl + ")"));
        } else {
            body = new HashMap<String, Object>();
            body.put("apps", apps);
            strGetAllUnittestCaseApiUrl = hostUrl + "unittest/getPublishedCasdIdByApp.do";
            logger.info((Object)("\u8bfb\u53d6\u6307\u5b9a\u5e94\u7528(" + apps + ")\u5df2\u53d1\u5e03\u7684\u6d4b\u8bd5\u7528\u4f8b(ApiUrl:" + strGetAllUnittestCaseApiUrl + ")"));
        }
        String caseIdsMap = httpObj.post(strGetAllUnittestCaseApiUrl, null, body);
        return caseIdsMap;
    }

    static {
        logger = LogFactory.getLog(WholeSystemTest.class);
    }
}

