/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.toolkit.utils.StringUtils;
import kd.bos.unittest.coverage.GeneralCommadServer;
import kd.bos.unittest.coverage.KdExecutionDataWriter;
import kd.bos.unittest.coverage.agent.rt.internal.core.runtime.IKdRemoteCommandVisitor;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdTcpConnection;
import kd.bos.unittest.coverage.task.ExecutionDataTaskManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;

public final class ExecutionDataGeneralCommadServer {
    private static final Log logger = LogFactory.getLog(ExecutionDataGeneralCommadServer.class);
    private ConcurrentMap<String, KdTcpConnection> clusterConns;
    private ConcurrentMap<String, Map<String, String>> clusterConnsInfo = new ConcurrentHashMap<String, Map<String, String>>();
    private CommandLine cmdparams;
    private ServerSocket serverSocket;

    public ExecutionDataGeneralCommadServer(CommandLine cmdparams, ConcurrentMap<String, KdTcpConnection> clustermap) {
        this.cmdparams = cmdparams;
        this.clusterConns = clustermap;
    }

    private void startHeartBeatServer() {
        new ScheduledThreadPoolExecutor(1).scheduleAtFixedRate(() -> {
            try {
                logger.info((Object)"ji");
                if (this.clusterConns != null) {
                    for (KdTcpConnection tcpConnection : this.clusterConns.values()) {
                        logger.info((Object)("before heart beat" + tcpConnection.getSocket().getRemoteSocketAddress()));
                        if (tcpConnection.getSocket().isClosed()) continue;
                        tcpConnection.doGeneralCommand("heart", "heart beat");
                        logger.info((Object)"after heart beat");
                    }
                } else {
                    logger.info((Object)"\u6682\u65f6\u6ca1\u6709\u8fde\u63a5\u5ba2\u6237\u7aef\uff0c\u4e0d\u53d1\u9001\u5fc3\u8df3");
                }
            }
            catch (IOException e) {
                logger.info((Object)"\u53d1\u9001\u5fc3\u8df3\u5931\u8d25");
            }
        }, 0L, 10L, TimeUnit.MINUTES);
    }

    public void startup() throws IOException {
        this.serverSocket = this.createServerSocket();
        logger.info((Object)"\u542f\u52a8\u5fc3\u8df3\u670d\u52a1");
        this.startHeartBeatServer();
        logger.info((Object)"\u542f\u52a8\u96c6\u7fa4\u670d\u52a1\u5668ExecutionDataGeneralCommadServer\u76d1\u542c\u4e2d...");
        while (!this.serverSocket.isClosed()) {
            Thread worker = new Thread(new WorkHadle(this, this.serverSocket.accept()));
            worker.start();
        }
        logger.info((Object)"\u5173\u95ed\u96c6\u7fa4\u670d\u52a1\u5668ExecutionDataGeneralCommadServer\u670d\u52a1\u5173\u95ed\u9000\u51fa");
    }

    public void shutdown() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            logger.info((Object)e.getMessage());
        }
    }

    protected ServerSocket createServerSocket() throws IOException {
        InetAddress inetAddr = this.getInetAddress(this.cmdparams.getOptionValue("ip"));
        return new ServerSocket(Integer.parseInt(this.cmdparams.getOptionValue("port")), 1, inetAddr);
    }

    protected InetAddress getInetAddress(String address) throws UnknownHostException {
        if ("*".equals(address)) {
            return null;
        }
        return InetAddress.getByName(address);
    }

    public static String lastIndexOf(String src, String sub, int lin) {
        String lastString = src;
        if (lin <= 0) {
            return lastString;
        }
        int index = src.lastIndexOf(sub);
        if (index <= 0) {
            return lastString;
        }
        lastString = src.substring(0, index);
        lastString = ExecutionDataGeneralCommadServer.lastIndexOf(lastString, sub, lin - 1);
        return lastString;
    }

    public static void main(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("path", true, "");
        options.addOption("port", true, "");
        options.addOption("ip", true, "");
        options.addOption("servername", true, "");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        logger.info((Object)String.format("\u4f20\u5165\u53c2\u6570\uff1apath=%s,ip=%s,port=%s,servername=%s", cmd.getOptionValue("path"), cmd.getOptionValue("ip"), cmd.getOptionValue("port"), cmd.getOptionValue("servername")));
        try {
            ConcurrentHashMap<String, KdTcpConnection> mapConn = new ConcurrentHashMap<String, KdTcpConnection>();
            new Thread(() -> {
                try {
                    new ExecutionDataGeneralCommadServer(cmd, mapConn).startup();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }).start();
            GeneralCommadServer cmdServer = new GeneralCommadServer(cmd, mapConn);
            cmdServer.startup();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private static class WorkHadle
    implements Runnable,
    IKdRemoteCommandVisitor,
    ISessionInfoVisitor,
    IExecutionDataVisitor {
        private final Socket socket;
        private KdTcpConnection connection = null;
        private ExecutionDataGeneralCommadServer sup;
        private ExecutionDataWriter fileWriter = null;
        private String sessionId;

        WorkHadle(ExecutionDataGeneralCommadServer sup, Socket socket) {
            this.socket = socket;
            this.sup = sup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                logger.info((Object)("\u96c6\u7fa4\u63a5\u5165\u5ba2\u6237\u7aef " + this.socket.getRemoteSocketAddress() + "\uff0c\u7b49\u5f85\u8bf7\u6c42..."));
                this.connection = new KdTcpConnection(this.socket, null);
                this.connection.setRemoteCommandVisitor(this);
                this.connection.init();
                this.connection.setSessionInfoVisitor(this);
                this.connection.setExecutionDataVisitor(this);
                this.connection.run();
            }
            catch (IOException e) {
                try {
                    if (!this.sessionId.isEmpty()) {
                        List<String> lstTaskIds = ExecutionDataTaskManager.getAllTaskIdsWithSessionId(this.sessionId);
                        for (String taskid : lstTaskIds) {
                            ExecutionDataTaskManager.addTaskErrorMsg(taskid, e.getMessage());
                        }
                    }
                    logger.error((Object)e.getMessage());
                    e.getStackTrace();
                }
                catch (Throwable throwable) {
                    this.sup.clusterConns.remove(this.sessionId);
                    String serviceName = ExecutionDataGeneralCommadServer.lastIndexOf(this.sessionId, "-", 2);
                    Map nodeInfo = (Map)this.sup.clusterConnsInfo.get(serviceName);
                    if (nodeInfo != null) {
                        if (nodeInfo.isEmpty()) {
                            this.sup.clusterConnsInfo.remove(serviceName);
                        } else {
                            nodeInfo.remove(this.sessionId);
                        }
                    }
                    if (!this.sessionId.isEmpty()) {
                        List<String> lstTaskIds = ExecutionDataTaskManager.getAllTaskIdsWithSessionId(this.sessionId);
                        for (String taskid : lstTaskIds) {
                            ExecutionDataTaskManager.finishTask(taskid);
                        }
                    }
                    logger.info((Object)("\u8bf7\u6c42\u5904\u7406\u7ed3\u675f\uff0c\u7ed3\u675f\u5de5\u4f5c\u7ebf\u7a0b socket " + this.socket.getRemoteSocketAddress()));
                    throw throwable;
                }
                this.sup.clusterConns.remove(this.sessionId);
                String serviceName = ExecutionDataGeneralCommadServer.lastIndexOf(this.sessionId, "-", 2);
                Map nodeInfo = (Map)this.sup.clusterConnsInfo.get(serviceName);
                if (nodeInfo != null) {
                    if (nodeInfo.isEmpty()) {
                        this.sup.clusterConnsInfo.remove(serviceName);
                    } else {
                        nodeInfo.remove(this.sessionId);
                    }
                }
                if (!this.sessionId.isEmpty()) {
                    List<String> lstTaskIds = ExecutionDataTaskManager.getAllTaskIdsWithSessionId(this.sessionId);
                    Iterator iterator = lstTaskIds.iterator();
                    while (iterator.hasNext()) {
                        String taskid = (String)iterator.next();
                        ExecutionDataTaskManager.finishTask(taskid);
                    }
                }
                logger.info((Object)("\u8bf7\u6c42\u5904\u7406\u7ed3\u675f\uff0c\u7ed3\u675f\u5de5\u4f5c\u7ebf\u7a0b socket " + this.socket.getRemoteSocketAddress()));
            }
            this.sup.clusterConns.remove(this.sessionId);
            String serviceName = ExecutionDataGeneralCommadServer.lastIndexOf(this.sessionId, "-", 2);
            Map nodeInfo = (Map)this.sup.clusterConnsInfo.get(serviceName);
            if (nodeInfo != null) {
                if (nodeInfo.isEmpty()) {
                    this.sup.clusterConnsInfo.remove(serviceName);
                } else {
                    nodeInfo.remove(this.sessionId);
                }
            }
            if (!this.sessionId.isEmpty()) {
                List<String> lstTaskIds = ExecutionDataTaskManager.getAllTaskIdsWithSessionId(this.sessionId);
                for (String taskid : lstTaskIds) {
                    ExecutionDataTaskManager.finishTask(taskid);
                }
            }
            logger.info((Object)("\u8bf7\u6c42\u5904\u7406\u7ed3\u675f\uff0c\u7ed3\u675f\u5de5\u4f5c\u7ebf\u7a0b socket " + this.socket.getRemoteSocketAddress()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitClassExecution(ExecutionData data) {
            ExecutionDataWriter executionDataWriter = this.fileWriter;
            synchronized (executionDataWriter) {
                this.fileWriter.visitClassExecution(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitSessionInfo(SessionInfo info) {
            String nodeName = "";
            nodeName = info.getId();
            OutputStream outputStream = null;
            try {
                String serviceName = ExecutionDataGeneralCommadServer.lastIndexOf(info.getId(), "-", 2);
                String index = (String)((Map)this.sup.clusterConnsInfo.get(serviceName)).get(info.getId());
                String fileName = "";
                fileName = this.sup.cmdparams.getOptionValue("path") + '/' + WorkHadle.getFileName(nodeName);
                if (index.length() > 0) {
                    StringBuilder sb = new StringBuilder(fileName);
                    sb.insert(fileName.indexOf(46), "_" + index);
                    fileName = sb.toString();
                }
                logger.info((Object)String.format("Retrieving execution Data for session,\u914d\u7f6e\u81ea\u52a8\u8bbf\u95ee\u6587\u4ef6 %s", StringUtils.filterLog(fileName)));
                outputStream = new FileOutputStream(FilenameUtils.getName((String)fileName), false);
                ExecutionDataWriter executionDataWriter = this.fileWriter = new KdExecutionDataWriter(outputStream);
                synchronized (executionDataWriter) {
                    this.fileWriter.visitSessionInfo(info);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        @Override
        public void visitDumpCommand(boolean dump, boolean reset) throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void generalCommand(String type, String cmdcontent) {
            if ("shake".equals(type)) {
                logger.info((Object)("\u96c6\u7fa4\u5ba2\u6237\u7aef(" + this.getSocketInfo(this.socket) + ")\u524d\u6765\u63e1\u624b\u6210\u529f\uff1atype:" + StringUtils.filterLog(type) + ",sessionId:" + StringUtils.filterLog(cmdcontent)));
                this.sessionId = cmdcontent;
                this.sup.clusterConns.put(cmdcontent, this.connection);
                String serviceName = ExecutionDataGeneralCommadServer.lastIndexOf(this.sessionId, "-", 2);
                HashMap<String, String> nodeIndexInfo = (HashMap<String, String>)this.sup.clusterConnsInfo.get(serviceName);
                if (nodeIndexInfo == null) {
                    nodeIndexInfo = new HashMap<String, String>();
                    nodeIndexInfo.put(cmdcontent, "0");
                } else {
                    int index = this.sessionId.indexOf(36);
                    String s = this.sessionId.substring(index, this.sessionId.length());
                    nodeIndexInfo.put(cmdcontent, s);
                }
                this.sup.clusterConnsInfo.put(serviceName, nodeIndexInfo);
            } else if ("dumpdone".equals(type)) {
                try {
                    ((KdExecutionDataWriter)this.fileWriter).close();
                    logger.info((Object)"\u751f\u6210.exec\u6587\u4ef6\u5b8c\u6bd5");
                }
                catch (IOException e) {
                    ExecutionDataTaskManager.addTaskErrorMsg(cmdcontent, e.getMessage());
                    logger.error((Object)e.getMessage());
                }
                finally {
                    ExecutionDataTaskManager.finishTask(cmdcontent);
                }
            }
        }

        public String getSocketInfo(Socket socket) {
            return String.format("Ip(port):%s", socket.getRemoteSocketAddress());
        }

        private static String getFileName(String nodeName) {
            String serviceName = ExecutionDataGeneralCommadServer.lastIndexOf(nodeName, "-", 2);
            String filename = serviceName + ".exec";
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream("server.properties"));){
                Properties prop = new Properties();
                prop.load(in);
                for (String key : prop.stringPropertyNames()) {
                    if (!serviceName.equals(key)) continue;
                    filename = prop.getProperty(key);
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            return filename;
        }
    }
}

