/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import kd.bos.toolkit.utils.StringUtils;
import kd.bos.unittest.coverage.KdExecutionDataWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.core.runtime.RemoteControlReader;
import org.jacoco.core.runtime.RemoteControlWriter;

public final class ExecutionDataServer {
    private static final Log logger = LogFactory.getLog(ExecutionDataServer.class);
    private static String serverName = "ExecutionDataServer";
    private static String path = "/home/opadmin/crp/unittest/exec";
    private static boolean bQuit = false;

    private static void printLog(String msg) {
        logger.info((Object)(serverName + ": " + msg));
    }

    public static void main(String[] args) throws IOException, ParseException {
        Options options = new Options();
        options.addOption("path", true, "");
        options.addOption("port", true, "");
        options.addOption("ip", true, "");
        options.addOption("servername", true, "");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        serverName = cmd.getOptionValue("servername");
        path = cmd.getOptionValue("path");
        try (ServerSocket server = new ServerSocket(Integer.parseInt(cmd.getOptionValue("port")), 0, InetAddress.getByName(cmd.getOptionValue("ip")));){
            ExecutionDataServer.printLog(String.format("\u4f20\u5165\u53c2\u6570\uff1afile=%s,ip=%s,port=%s", cmd.getOptionValue("file"), cmd.getOptionValue("ip"), cmd.getOptionValue("port")));
            while (!bQuit) {
                Handler handler = new Handler(server.accept());
                ExecutionDataServer.printLog("new Handler(server.accept(), fileWriter) & Thread(handler).start();");
                new Thread(handler).start();
            }
        }
    }

    private ExecutionDataServer() {
    }

    private static class Handler
    implements Runnable,
    ISessionInfoVisitor,
    IExecutionDataVisitor {
        private final Socket socket;
        private final RemoteControlReader reader;
        private KdExecutionDataWriter fileWriter = null;
        private String nodeName = "";

        private void log(String msg) {
            logger.info((Object)(StringUtils.filterLog(this.nodeName) + ": " + StringUtils.filterLog(msg)));
        }

        Handler(Socket socket) throws IOException {
            this.socket = socket;
            new RemoteControlWriter(socket.getOutputStream());
            this.reader = new RemoteControlReader(socket.getInputStream());
            this.reader.setSessionInfoVisitor((ISessionInfoVisitor)this);
            this.reader.setExecutionDataVisitor((IExecutionDataVisitor)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ExecutionDataServer.printLog("\u5f00\u59cb\u76d1\u542c\u8bfb\u53d6\u8986\u76d6\u7387\u5e76\u751f\u6210.exec\u6587\u4ef6");
                while (this.reader.read()) {
                }
                this.socket.close();
                KdExecutionDataWriter kdExecutionDataWriter = this.fileWriter;
                synchronized (kdExecutionDataWriter) {
                    this.fileWriter.close();
                }
                this.log("\u751f\u6210.exec\u6587\u4ef6\u5b8c\u6bd5");
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitSessionInfo(SessionInfo info) {
            this.nodeName = info.getId();
            String fileName = path + '/' + Handler.getFileName(this.nodeName);
            this.log(String.format("Retrieving execution Data for session,\u914d\u7f6e\u81ea\u52a8\u8bbf\u95ee\u6587\u4ef6 %s", fileName));
            try (FileOutputStream fos = new FileOutputStream(FilenameUtils.getName((String)fileName), false);){
                KdExecutionDataWriter kdExecutionDataWriter = this.fileWriter = new KdExecutionDataWriter(fos);
                synchronized (kdExecutionDataWriter) {
                    this.fileWriter.visitSessionInfo(info);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitClassExecution(ExecutionData data) {
            KdExecutionDataWriter kdExecutionDataWriter = this.fileWriter;
            synchronized (kdExecutionDataWriter) {
                this.fileWriter.visitClassExecution(data);
            }
        }

        private static String getFileName(String nodeName) {
            String filename = nodeName;
            Properties prop = new Properties();
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream("server.properties"));){
                prop.load(in);
                for (String key : prop.stringPropertyNames()) {
                    if (!nodeName.contains(key)) continue;
                    filename = prop.getProperty(key);
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            return filename;
        }
    }
}

