/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage;

import java.io.IOException;
import java.net.Socket;
import kd.bos.toolkit.utils.StringUtils;
import kd.bos.unittest.coverage.agent.rt.internal.core.runtime.IKdRemoteCommandVisitor;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdTcpConnection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GeneralCommadClient {
    private KdTcpConnection connection;
    private Socket socket;
    private Thread worker;
    private static final Log logger = LogFactory.getLog(GeneralCommadClient.class);
    private static final String TYPE = "type";
    private static final String CONTENT = "content";

    public void startup(CommandLine cmdparams) throws IOException {
        try {
            logger.info((Object)("\u8bf7\u6c42\u63a5\u5165\u6307\u4ee4\u670d\u52a1\u5668" + cmdparams.getOptionValue("ip") + "(" + cmdparams.getOptionValue("port") + ")..."));
            this.socket = this.createSocket(cmdparams);
            this.socket.setSoTimeout(120000);
            logger.info((Object)"\u63a5\u5165\u6307\u4ee4\u670d\u52a1\u5668\u6210\u529f");
            WorkHadle wh = new WorkHadle(this.socket, cmdparams);
            this.worker = new Thread(wh);
            this.worker.setName(this.getClass().getName());
            this.worker.setDaemon(true);
            this.worker.start();
            this.worker.join();
            if (wh.isFailed) {
                System.exit(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException, InterruptedException {
        this.socket.close();
        Socket socket = this.socket;
        synchronized (socket) {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        this.worker.join();
    }

    protected Socket createSocket(CommandLine cmdparams) throws IOException {
        return new Socket(cmdparams.getOptionValue("ip"), Integer.parseInt(cmdparams.getOptionValue("port")));
    }

    public static void main(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("ip", true, "");
        options.addOption("port", true, "");
        options.addOption(TYPE, true, "");
        options.addOption(CONTENT, true, "");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        logger.info((Object)String.format("\u4f20\u5165\u53c2\u6570\uff1aip=%s,port=%s,type=%s,content=%s", cmd.getOptionValue("ip"), cmd.getOptionValue("port"), cmd.getOptionValue(TYPE), cmd.getOptionValue(CONTENT)));
        GeneralCommadClient cmdClient = new GeneralCommadClient();
        try {
            cmdClient.startup(cmd);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
            System.exit(1);
        }
    }

    private static class WorkHadle
    implements Runnable,
    IKdRemoteCommandVisitor {
        private Socket socket;
        private CommandLine cmdparams = null;
        private boolean isFailed = false;
        private String failedMsg;

        WorkHadle(Socket socket, CommandLine cmdparams) {
            this.socket = socket;
            this.cmdparams = cmdparams;
        }

        public boolean isFailed() {
            return this.isFailed;
        }

        public String getFailedMsg() {
            return this.failedMsg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.socket.isClosed()) {
                try {
                    KdTcpConnection connection;
                    Socket socket = this.socket;
                    synchronized (socket) {
                        connection = new KdTcpConnection(this.socket, null);
                    }
                    connection.setRemoteCommandVisitor(this);
                    connection.init();
                    String type = this.cmdparams.getOptionValue(GeneralCommadClient.TYPE);
                    String cmdcontent = this.cmdparams.getOptionValue(GeneralCommadClient.CONTENT);
                    connection.doGeneralCommand(type, cmdcontent);
                    logger.info((Object)("\u5f00\u59cb\u8bf7\u6c42\u83b7\u53d6\u5e94\u7528\u8986\u76d6\u7387\u6570\u636e\u5e76\u751f\u6210\u62a5\u544a,\u53c2\u6570:type:" + type + "," + GeneralCommadClient.CONTENT + ":" + cmdcontent));
                    logger.info((Object)"\u7b49\u5f85\u8bf7\u6c42\u7ed3\u679c\u4e2d...");
                    connection.run();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                }
                finally {
                    logger.info((Object)"\u9000\u51fa\u5de5\u4f5c\u7ebf\u7a0b\u5e76\u5173\u95edsocket");
                    if (this.socket.isClosed()) continue;
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage());
                    }
                }
            }
        }

        @Override
        public void visitDumpCommand(boolean dump, boolean reset) throws IOException {
        }

        @Override
        public void generalCommand(String type, String cmdcontent) throws IOException {
            if (cmdcontent.equals("\u751f\u6210\u62a5\u544a\u6210\u529f")) {
                logger.info((Object)StringUtils.filterLog("\u63a5\u6536\u5230\u8bf7\u6c42\u7ed3\u679c:type:" + type + ", cmdcontent:" + cmdcontent));
            } else {
                logger.error((Object)StringUtils.filterLog("\u63a5\u6536\u5230\u8bf7\u6c42\u7ed3\u679c:type:" + type + ", cmdcontent:" + cmdcontent));
                this.isFailed = true;
                this.failedMsg = cmdcontent;
            }
        }
    }
}

