/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.toolkit.utils.StringUtils;
import kd.bos.unittest.coverage.agent.rt.internal.core.runtime.IKdRemoteCommandVisitor;
import kd.bos.unittest.coverage.agent.rt.internal.output.KdTcpConnection;
import kd.bos.unittest.coverage.task.ExecutionDataTaskManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GeneralCommadServer {
    private KdTcpConnection connection;
    private ServerSocket serverSocket;
    private Map<String, KdTcpConnection> mapConn;
    private CommandLine cmdparams;
    private static final Log logger = LogFactory.getLog(GeneralCommadServer.class);

    public GeneralCommadServer(CommandLine cmdparams, Map<String, KdTcpConnection> mapConn) {
        this.cmdparams = cmdparams;
        this.mapConn = mapConn;
    }

    public void startup() throws IOException {
        this.serverSocket = this.createServerSocket();
        logger.info((Object)"\u542f\u52a8\u6307\u4ee4\u670d\u52a1\u5668GeneralCommandServer\u76d1\u542c\u4e2d...");
        while (!this.serverSocket.isClosed()) {
            Thread worker = new Thread(new WorkHadle(this, this.serverSocket.accept()));
            worker.start();
        }
        logger.info((Object)"\u5173\u95ed\u6307\u4ee4\u670d\u52a1\u5668GeneralCommandServer\u670d\u52a1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        this.serverSocket.close();
        ServerSocket serverSocket = this.serverSocket;
        synchronized (serverSocket) {
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    protected ServerSocket createServerSocket() throws IOException {
        InetAddress inetAddr = this.getInetAddress(this.cmdparams.getOptionValue("ip"));
        return new ServerSocket(Integer.parseInt(this.cmdparams.getOptionValue("port")) + 1, 1, inetAddr);
    }

    protected InetAddress getInetAddress(String address) throws UnknownHostException {
        if ("*".equals(address)) {
            return null;
        }
        return InetAddress.getByName(address);
    }

    public static void main(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("port", true, "");
        options.addOption("ip", true, "");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        logger.info((Object)String.format("\u4f20\u5165\u53c2\u6570\uff1aip=%s,port=%s", cmd.getOptionValue("ip"), cmd.getOptionValue("port")));
        try {
            HashMap<String, KdTcpConnection> mapConn = new HashMap<String, KdTcpConnection>();
            GeneralCommadServer cmdServer = new GeneralCommadServer(cmd, mapConn);
            cmdServer.startup();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private static class WorkHadle
    implements Runnable,
    IKdRemoteCommandVisitor {
        private final Socket socket;
        private KdTcpConnection connection = null;
        private GeneralCommadServer sup;

        WorkHadle(GeneralCommadServer sup, Socket socket) {
            this.socket = socket;
            this.sup = sup;
        }

        @Override
        public void run() {
            try {
                logger.info((Object)("\u63a5\u5165\u6307\u4ee4\u5ba2\u6237\u7aef " + this.socket.getRemoteSocketAddress() + "\uff0c\u7b49\u5f85\u6307\u4ee4\u8bf7\u6c42..."));
                this.connection = new KdTcpConnection(this.socket, null);
                this.connection.setRemoteCommandVisitor(this);
                this.connection.init();
                this.connection.run();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage());
                e.getStackTrace();
            }
            finally {
                logger.info((Object)("\u6307\u4ee4\u8282\u70b9\u8bf7\u6c42\u5904\u7406\u7ed3\u675f\uff0c\u7ed3\u675f\u5de5\u4f5c\u7ebf\u7a0b socket " + this.socket.getRemoteSocketAddress()));
            }
        }

        @Override
        public void visitDumpCommand(boolean dump, boolean reset) throws IOException {
        }

        @Override
        public void generalCommand(String type, String cmdcontent) throws IOException {
            logger.info((Object)("\u6307\u4ee4\u670d\u52a1\u63a5\u6536\u5230\u6307\u4ee4\u8282\u70b9\u7684\u6307\u4ee4\uff1a type:" + StringUtils.filterLog(type) + ", cmdcontent:" + StringUtils.filterLog(cmdcontent)));
            ExecutionDataTaskManager.createTask(this.connection, this.sup.mapConn, cmdcontent);
        }
    }
}

