/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.coverage;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.html.HTMLFormatter;

public class ReportGenerator {
    private final String title;
    private final File executionDataFile;
    private final File classesDirectory;
    private final File sourceDirectory;
    private final File reportDirectory;
    private ExecFileLoader execFileLoader;

    public ReportGenerator(File projectDirectory) {
        this.title = projectDirectory.getName();
        this.executionDataFile = new File(projectDirectory, "KDUnittest.exec");
        this.classesDirectory = new File(projectDirectory, "bin");
        this.sourceDirectory = new File(projectDirectory, "src");
        this.reportDirectory = new File(projectDirectory, "coveragereport");
    }

    public void create() throws IOException {
        this.loadExecutionData();
        IBundleCoverage bundleCoverage = this.analyzeStructure();
        this.createReport(bundleCoverage);
    }

    private void createReport(IBundleCoverage bundleCoverage) throws IOException {
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        IReportVisitor visitor = htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(this.reportDirectory));
        visitor.visitInfo(this.execFileLoader.getSessionInfoStore().getInfos(), this.execFileLoader.getExecutionDataStore().getContents());
        visitor.visitBundle(bundleCoverage, (ISourceFileLocator)new DirectorySourceFileLocator(this.sourceDirectory, "utf-8", 4));
        visitor.visitEnd();
    }

    private void loadExecutionData() throws IOException {
        this.execFileLoader = new ExecFileLoader();
        this.execFileLoader.load(this.executionDataFile);
    }

    private IBundleCoverage analyzeStructure() throws IOException {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.execFileLoader.getExecutionDataStore(), (ICoverageVisitor)coverageBuilder);
        analyzer.analyzeAll(this.classesDirectory);
        return coverageBuilder.getBundle(this.title);
    }

    public static void main(String[] args) throws IOException {
        for (String arg : args) {
            ReportGenerator generator = new ReportGenerator(new File(FilenameUtils.getName((String)arg)));
            generator.create();
        }
    }
}

